<?php
        $cs = Yii::app()->getClientScript();
        $cs->registerScript("updatetextfield", "function updatetextfield(value, from){
            if( from == 'gl' ){
                $('#subledger_name').val('');
                $('#subledger_id').val('');
            }else if( from == 'recon' ){
                $('#rec_st_subledger_id').val('');
                $('#rec_st_subledger_name').val('');
            }
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/core/havesubledger') . "',
                'data' : {'account' : value},
                'success': function(data) { 
                    if( data == 'true' ){
                        if( from == 'gl' ){
                            $('#subledger_name').attr( 'disabled', false );
                            $('#subledger_id').val('');
                        }else if( from == 'recon' ){
                            $('#rec_st_subledger_id').val('');
                            $('#rec_st_subledger_name').attr( 'disabled', false );
                        }
                    }else{
                        if( from == 'gl' ){
                            $('#subledger_name').attr( 'disabled', true );
                            $('#subledger_name').val('');
                            $('#subledger_id').val('');
                        }else if( from == 'recon' ){
                            $('#rec_st_subledger_id').val('');
                            $('#rec_st_subledger_name').val('');
                            $('#rec_st_subledger_name').attr( 'disabled', true );
                        }
                    }
                }
            });
        }", CClientScript::POS_HEAD);
        $cs->registerScript("getSublegders", "function getSublegders(field_id, from)
        {
            var account_id = 0;
            if( from == 'gl' ) {
                account_id = $('#ledger_id').val() 
            }else if( from == 'aging' ){
                account_id = $('#ag_ledger_id').val();
            }else if( from == 'recon_statement' ){
                account_id = $('#rec_st_ledger_id').val();
            }else{
                account_id = $('#st_ledger_id').val();
            }

            if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        if( from == 'gl' ) {
                            $('#subledger_name').val(ui.item.label);
                            $('#subledger_id').val(ui.item.value);
                        }else if( from == 'aging' ){
                            $('#ag_subledger_name').val(ui.item.label);
                            $('#ag_subledger_id').val(ui.item.value);
                        }else if( from == 'recon_statement' ){
                            $('#rec_st_subledger_name').val(ui.item.label);
                            $('#rec_st_subledger_id').val(ui.item.value);
                        }else{
                            $('#st_subledger_name').val(ui.item.label);
                            $('#st_subledger_id').val(ui.item.value);
                        }
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 
        $cs->registerScript("getSublegders_all", "function getSublegders_all(field_id, from)
        {
            var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist_all') . "';
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response, url) },
                focus       : function( event, ui ) {},
                select          : function( event, ui ) {
                    event.preventDefault();
                    $('#sb_subledger_name').val(ui.item.label);
                    $('#sb_subledger_id').val(ui.item.value);
                }
            })
        }", CClientScript::POS_HEAD); 
?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li  class="active"><a href="#gl_tab" data-toggle="tab">GL</a></li>
    <li><a href="#gl_summary_tab" data-toggle="tab">GL Summary</a></li>
    <li><a href="#statement_tab" data-toggle="tab">Statement</a></li>
    <li><a href="#rec_statement_tab" data-toggle="tab">Recon.</a></li>
    <li><a href="#ageing_tab" data-toggle="tab">Aging</a></li>
    <li><a href="#trial_balance" data-toggle="tab">TB</a></li>
    <li><a href="#balance_sheet" data-toggle="tab">BS</a></li>
    <li><a href="#profit_or_loss" data-toggle="tab">P/L</a></li>
    <!-- <li><a href="#cash_in_hand" data-toggle="tab">Cash-in-Hand</a></li> -->
    <li><a href="#vat_report" data-toggle="tab">VAT</a></li>
    <!-- <li><a href="#subledger_wise" data-toggle="tab">SL Report</a></li> -->
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="gl_tab">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('gl_from', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'From')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::textField('gl_to', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::dropdownlist("ledger_id", '',FinanceLegder::getChilds(), array('class'=>'tooltipster', 'data-label' => 'Ledgers' ,'prompt' => '-select-', 'data-search' => true, 'onChange' => 'js:updatetextfield(this.value, "gl")')); //getAll ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::hiddenField("subledger_id"); ?>
                <?php echo CHtml::textField("subledger_name",'',array('data-label'=>'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id, "gl");', 'data-label' => 'Sub ledger' )); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/glreport_pdf&from_date='+$('#gl_from').val()+'&to_date='+$('#gl_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val(), '_blank'); ">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/glreport_excel&from_date='+$('#gl_from').val()+'&to_date='+$('#gl_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="gl_summary_tab">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('gl_summary_to', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'As on date')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::dropdownlist("gl_summary_ledger_id", '',FinanceLegder::getChildswithsubledgers(), array('class'=>'tooltipster', 'data-label' => 'Ledgers' , 'data-search' => true)); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/glsummary_pdf&to_date='+$('#gl_summary_to').val()+'&ledger='+$('#gl_summary_ledger_id').val(), '_blank');">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/glsummary_excel&to_date='+$('#gl_summary_to').val()+'&ledger='+$('#gl_summary_ledger_id').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="statement_tab">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('st_from', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'From')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::textField('st_to', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::dropdownlist("st_ledger_id", '',FinanceLegder::getChildswithsubledgers(), array('class'=>'tooltipster', 'data-label' => 'Ledgers' ,'prompt' => '-select-', 'data-search' => true, 'onChange' => '$("#st_subledger_id").val("");$("#st_subledger_name").val("");')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::hiddenField("st_subledger_id"); ?>
                <?php echo CHtml::textField("st_subledger_name",'',array('data-label'=>'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id, "statement");', 'data-label' => 'Sub ledger' )); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="if( $('#st_ledger_id').val() > 0 && $('#st_subledger_id').val() > 0 ){ window.open($('#liveSite').val()+'index.php?r=finance/vouchers/statement_pdf_as_on_date&ledger='+$('#st_ledger_id').val()+'&subledger='+$('#st_subledger_id').val(), '_blank'); }else{ t8.error('Select all fields!'); } ">AS ON DATE</a>
                <a type="button" class="btn btn-theme" onclick="if( $('#st_ledger_id').val() > 0 && $('#st_subledger_id').val() > 0 ){ window.open($('#liveSite').val()+'index.php?r=finance/vouchers/statement_pdf&from_date='+$('#st_from').val()+'&to_date='+$('#st_to').val()+'&ledger='+$('#st_ledger_id').val()+'&subledger='+$('#st_subledger_id').val(), '_blank'); }else{ t8.error('Select all fields!'); } ">PDF</a>
                <a type="button" class="btn btn-theme" onclick="if( $('#st_ledger_id').val() > 0 && $('#st_subledger_id').val() > 0 ){ window.open($('#liveSite').val()+'index.php?r=finance/vouchers/statement_excel&from_date='+$('#st_from').val()+'&to_date='+$('#st_to').val()+'&ledger='+$('#st_ledger_id').val()+'&subledger='+$('#st_subledger_id').val(), '_blank'); }else{ t8.error('Select all fields!'); } ">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="rec_statement_tab">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('rec_st_from', date('01/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'From')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::textField('rec_st_to', date('t/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::dropdownlist("rec_st_ledger_id", '',FinanceLegder::getChilds(), array('class'=>'tooltipster', 'data-label' => 'Ledgers' ,'prompt' => '-select-', 'data-search' => true, 'onChange' => 'js:updatetextfield(this.value, "recon")')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::hiddenField("rec_st_subledger_id"); ?>
                <?php echo CHtml::textField("rec_st_subledger_name",'',array('data-label'=>'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id, "recon_statement");', 'data-label' => 'Sub ledger' )); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="if( $('#rec_st_ledger_id').val() > 0 && $('#rec_st_subledger_id').val() > 0 ){ window.open($('#liveSite').val()+'index.php?r=finance/vouchers/recon_statement_pdf&from_date='+$('#rec_st_from').val()+'&to_date='+$('#rec_st_to').val()+'&ledger='+$('#rec_st_ledger_id').val()+'&subledger='+$('#rec_st_subledger_id').val(), '_blank'); }else{ t8.error('Select all fields!'); } ">PDF</a>
                <a type="button" class="btn btn-theme" onclick="if( $('#rec_st_ledger_id').val() > 0 && $('#rec_st_subledger_id').val() > 0 ){ window.open($('#liveSite').val()+'index.php?r=finance/vouchers/recon_statement_excel&from_date='+$('#rec_st_from').val()+'&to_date='+$('#rec_st_to').val()+'&ledger='+$('#rec_st_ledger_id').val()+'&subledger='+$('#rec_st_subledger_id').val(), '_blank'); }else{ t8.error('Select all fields!'); } ">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="ageing_tab">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php echo CHtml::textField('ag_to', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo CHtml::dropdownlist("ag_ledger_id", '',FinanceLegder::getAllocatable(), array('class'=>'tooltipster', 'data-label' => 'Ledgers' , 'onChange' => '$("#ag_subledger_id").val("");$("#ag_subledger_name").val("");')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo CHtml::hiddenField("ag_subledger_id"); ?>
                <?php echo CHtml::textField("ag_subledger_name",'',array('data-label'=>'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id, "aging");', 'data-label' => 'Sub ledger' )); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/aging_pdf&to_date='+$('#ag_to').val()+'&ledger='+$('#ag_ledger_id').val()+'&subledger='+$('#ag_subledger_id').val(), '_blank');">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/aging_excel&to_date='+$('#ag_to').val()+'&ledger='+$('#ag_ledger_id').val()+'&subledger='+$('#ag_subledger_id').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="trial_balance">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('tb_to_date', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'As on date')); ?>
            </li>
            <li class="col-sm-6"></li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/trialbalance_pdf&to_date='+$('#tb_to_date').val(), '_blank');">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/trialbalance_excel&to_date='+$('#tb_to_date').val(), '_blank');">XLS</a>
                <!-- <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/trialbalance_pdf_detailed&to_date='+$('#tb_to_date').val(), '_blank');">PDF (Detailed)</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/trialbalance_excel_detailed&to_date='+$('#tb_to_date').val(), '_blank');">XLS (Detailed)</a> -->
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="balance_sheet">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('bl_to_date', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'As on date')); ?>
            </li>
            <li class="col-sm-6"></li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/balancesheet_pdf&to_date='+$('#bl_to_date').val(), '_blank');">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/balancesheet_excel&to_date='+$('#bl_to_date').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="profit_or_loss">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('pl_from', date('01/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'From')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::textField('pl_to', date('t/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/profitorloss_pdf&from_date='+$('#pl_from').val()+'&to_date='+$('#pl_to').val(), '_blank');">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/profitorloss_excel&from_date='+$('#pl_from').val()+'&to_date='+$('#pl_to').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="cash_in_hand">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo CHtml::textField('cash_from', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'From')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::textField('cash_to', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::dropdownlist("cash_ledger_id", '',FinanceLegder::getCash_accounts(), array('class'=>'tooltipster', 'data-label' => 'Ledger')); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/cashreport_pdf&from_date='+$('#cash_from').val()+'&to_date='+$('#cash_to').val()+'&ledger='+$('#cash_ledger_id').val(), '_blank'); ">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/cashreport_excel&from_date='+$('#cash_from').val()+'&to_date='+$('#cash_to').val()+'&ledger='+$('#cash_ledger_id').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="vat_report">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <?php echo CHtml::textField('vat_from', date('01/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'From')); ?>
            </li>
            <li class="col-sm-6">
                <?php echo CHtml::textField('vat_to', date('t/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/vat_pdf&from_date='+$('#vat_from').val()+'&to_date='+$('#vat_to').val(), '_blank');">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/vat_excel&from_date='+$('#vat_from').val()+'&to_date='+$('#vat_to').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
    <div class="tab-pane" id="subledger_wise">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo CHtml::textField('sb_from', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'From')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::textField('sb_to', date('d/m/Y'), array('class' => 'datepicker tooltipster','data-label'=>'To')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo CHtml::hiddenField("sb_subledger_id"); ?>
                <?php echo CHtml::textField("sb_subledger_name",'',array('data-label'=>'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders_all(this.id, "subtype1");', 'data-label' => 'Sub ledger*' )); ?>
            </li>
            <div class="btn-wrap text-center">
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/subledger_summary_pdf&from_date='+$('#sb_from').val()+'&to_date='+$('#sb_to').val()+'&subledger='+$('#sb_subledger_id').val(), '_blank'); ">PDF</a>
                <a type="button" class="btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/vouchers/subledger_summary_excel&from_date='+$('#sb_from').val()+'&to_date='+$('#sb_to').val()+'&subledger='+$('#sb_subledger_id').val(), '_blank');">XLS</a>
            </div>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger"  data-dismiss="modal">Close</button>
</div>