<!DOCTYPE html>
<html>
<head>
    <title><?php echo date('dmYhis'); ?></title>
</head>
<body>
    <div class="">
            <div class="header" style="width:100%;float: left;padding-bottom:10px;">
        <img src="<?php echo  'images/logo/'.Yii::app()->user->pdf_company_logo; ?>"/>
    </div>
            <div class="col-12">
                <div class="h3" style="margin-top: 0;margin-bottom: 0;text-align: center;color: #0000b3;font-size: 18px;">
                    <?php echo 'VAT Report'; ?>
                </div>
            </div>
        <div class="col-5 offset-1" style="color:#101010;">
            <br>
            <table class="table" style="width:100%">
                <tr>
                    <td class="bc-tl">From </td>
                    <td>
                        <?php echo $from_date;?>
                    </td>
                </tr>
                <tr>
                    <td>To</td>
                    <td>
                        <?php echo $to_date;?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <br>
    <u>Total VAT (Assets)</u><br><br>
    <div class="col-md-12">
        <table class="table table-fixed table-bordered table-primary">
            <thead>
                <tr>
                    <th style="width:5%">Date</th>
                    <th style="width:5%">Voucher No</th>
                    <th style="width:5%">Voucher Ref</th>
                    <th style="width:40%">Subledger</th>
                    <th style="width:30%">Narration</th> 
                    <th style="width:10%" class="text-right">Value</th> 
                    <th style="width:10%" class="text-right">VAT</th> 
                </tr>
                
            </thead>
            <?php 
                $from_date = ( count(explode('/',$from_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date)))  : date('Y-m-d');
                $to_date = ( count(explode('/',$to_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date)))  : date('Y-m-d');

                $condition = 'ledger.main_account_type="A" AND ledger.classification="VAT" AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
            
                $items = FinanceVoucherItems::model()->with('parent', 'ledger')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
            
            ?>
                <tbody>       
                    
            <?php
                $total_asset = 0; 
                $total_value = 0;
                foreach ( $items as $each ){  ?>
                        <tr>   
                            <td><?php echo date("d/m/Y",strtotime($each->parent->voucher_date)); ?></td>
                            <td><?php echo $each->parent->fullvoucher; ?></td>
                            <td><?php echo $each->parent->reference_no; ?></td>
                            <td><?php echo $each->get_any_subledger(); ?></td>
                            <td><?php echo $each->narration; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(($each->parent->debit_total*$each->parent->exchange_rate)," "); ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(($each->amount*$each->parent->exchange_rate)," "); ?></td>
                        </tr>
                        <?php 
                            $total_asset += ($each->amount*$each->parent->exchange_rate);
                            $total_value += ($each->parent->debit_total*$each->parent->exchange_rate);
                    } ?>
                        <tr>
                            <td colspan="5" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_value," ");?></b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_asset," ");?></b></td>
                        </tr>
                </tbody>
            </table>
            </div>

            <br>
    <u>Total VAT (Liability)</u><br><br>
    <div class="col-md-12">
        <table class="table table-fixed table-bordered table-primary">
            <thead>
                <tr>
                    <th style="width:5%">Date</th>
                    <th style="width:5%">Voucher No</th>
                    <th style="width:5%">Voucher Ref</th>
                    <th style="width:40%">Subledger</th>
                    <th style="width:30%">Narration</th> 
                    <th style="width:10%" class="text-right">Value</th> 
                    <th style="width:5%" class="text-right">VAT</th> 
                </tr>
                
            </thead>
            <?php 
            
                $condition = 'ledger.main_account_type="L" AND ledger.classification="VAT" AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
            
                $items = FinanceVoucherItems::model()->with('parent', 'ledger')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
            
            ?>
                <tbody>       
                    
            <?php
                $total_value = 0; 
                $total_liability = 0; 

                foreach ( $items as $each ){  ?>
                        <tr>   
                            <td><?php echo date("d/m/Y",strtotime($each->parent->voucher_date)); ?></td>
                            <td><?php echo $each->parent->fullvoucher; ?></td>
                            <td><?php echo $each->parent->reference_no; ?></td>
                            <td><?php echo $each->get_any_subledger(); ?></td>
                            <td><?php echo $each->narration; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(($each->parent->debit_total*$each->parent->exchange_rate)," "); ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(((-1*$each->amount)*$each->parent->exchange_rate)," "); ?></td>
                        </tr>
                        <?php 
                            $total_liability += ($each->amount*$each->parent->exchange_rate);
                            $total_value += ($each->parent->debit_total*$each->parent->exchange_rate);
                    } ?>
                        <tr>
                            <td colspan="5" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_value," ");?></b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency(-1*$total_liability," ");?></b></td>
                        </tr>
                </tbody>
            </table>
            </div>
    
    <htmlpagefooter name="myfooter">
    <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>

    
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
             <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>

