
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPage", "function loadPage(){
        if( $('#product_id').val() > 0 ){
                $('#loader').show();
                jQuery.ajax({
                    'type': 'post',
                    'url': '" . Yii::app()->createUrl('finance/reports/sales_cg_html') . "',
                    'data' : { 'product_id' : $('#product_id').val(), 'from' : $('#from_date').val(), 'to' : $('#to_date').val() },
                    'success': function(data) {
                        $('#data_div').show();
                        $('#pro_div').html(data);
                        $('#loader').hide();
                    }
                });
            }else{
                t8.error('Select Product!');
                $('#product_name').focus();
            }
        }", CClientScript::POS_HEAD);

$cs->registerScript("autoCompleteProduct", "function autoCompleteProduct(field_id)
        {
            var url = '" . Yii::app()->createUrl('quotation/GetProducts') . "';
            $('#'+field_id).autocomplete({
                minLength   : 1,
                source      : function (request, response) { autoCompleteSource(request, response,url) },
                focus       : function( event, ui ) { },
                select      : function( event, ui ) {
                    event.preventDefault();
                    $('#product_id').val(ui.item.value);
                    $('#product_name').val(ui.item.part_number);
                }
            })
        }", CClientScript::POS_HEAD);
?>

<style>
table {
  font-family: arial, sans-serif !important;
  border-collapse: collapse !important;
  width: 100% !important;
}

td, th {
  border: 1px solid #dddddd !important;
  text-align: left !important;
  padding: 8px !important;
}

table th{
	padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #1f67b2;
    color: white;
}

tr:nth-child(even) {
  background-color: #f2f2f2 !important;
}
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('from_date', date('01/m/Y'), array('class' => 'datepicker', 'data-label' => 'From')); ?>
                    </li>
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('to_date', date('t/m/Y'), array('class' => 'datepicker', 'data-label' => 'To')); ?>
                    </li>
                    <li class="col-sm-3">
                         <?php echo CHtml::hiddenField("product_id"); ?>
                        <?php echo CHtml::textField("product_name", '', array('data-label' => 'Product', 'class' => 'tooltipster', 'onKeyup' => 'js:autoCompleteProduct(this.id);')); ?>
                    </li>
                    <div class="btn-wrap text-center">
                        <a type="button" class="btn btn-sm btn-theme" onclick="loadPage();">HTML</a>
                      <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/sales_cg_pdf&from_date='+$('#from_date').val()+'&to_date='+$('#to_date').val()+'&product_id='+$('#product_id').val(), '_blank'); ">PDF</a>
     <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/sales_cg_excel&from_date='+$('#from_date').val()+'&to_date='+$('#to_date').val()+'&product_id='+$('#product_id').val(), '_blank'); ">XLS</a>
                    </div>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:none;" >
             <div class="tab-content">
                    <div class="tab-pane main-li-data active" id="pro_div">
                    </div>
            </div>
        </section>
    </div>
</div>
