<!DOCTYPE html>
<html>
<head>
<style>
.table thead {display: table-header-group;}
</style>
    <title><?php echo date('dmYhis'); ?></title>
</head>
<body>
    <div class="">
        <div class="col-6">
                <div class="input-block">
                    <b><?php echo 'Statement'; ?></b>
                </div>
                    <?php 
                        $ledgerModel = FinanceLegder::model()->findBypk( (int) $ledger );
                        $subledgerModel = FinanceSubledger::model()->findBypk( (int) $subledger );
                    ?>
                    <br>
                    <small><?php echo Ucfirst($type); ?> :</small><br>
                    <b><?php echo strtoupper($subledgerModel->description); ?></b><br>
                    <small><?php echo strtoupper(nl2br($subledgerModel->address)); ?></small><br>
                    <small><?php echo ( $subledgerModel->phone != '' ) ? 'Phone : '.strtoupper($subledgerModel->phone) : ''; ?></small><br>
                
                <br>
                
        </div>
        <div class="col-5 offset-1" style="color:#101010;">
            <div class="text-right">
               <?php $this->renderPartial("//common/header");?>
                <table class="table" style="width:100%">
                <tr>
                    <td class="bc-tl">From </td>
                    <td>
                        <?php echo $from;?>
                    </td>
                </tr>
                <tr>
                    <td>To</td>
                    <td>
                        <?php echo $to;?>
                    </td>
                </tr>
            </table>
            </div>
        </div>
    </div>
    <br>
    <div class="col-md-12">
        <table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable">
            <thead>
				  <tr>
                    <th style="width:10%">Date</th>
                    <th style="width:10%">Type</th>
                    <th style="width:15%">Vo. #</th>
                    <th style="width:15%">Invoice</th>
                    <th style="width:10%">Due Date</th>
                    <th style="width:20%" class="text-right">Amount</th> 
                    <th style="width:10%" class="text-right">Currency</th>  
                     
                </tr>
                
            </thead>
            <?php 
                                $from = ( count(explode('/',$from)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $from)))  : date('Y-m-d');
                                $to = ( count(explode('/',$to)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $to)))  : date('Y-m-d');
                
                                $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from.'" AND "'.$to.'"';
                                $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "'.$from.'"';
                
                                if ( $ledger != '' ) {
                                    $condition .= ' AND t.ledger_id IN('.$ledger .')';
                                    $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger.')';
                                }
                                if( $subledger > 0 ){
                                    $condition .= ' AND t.subledger_id='.$subledger;
                                    $condition_for_opening .= ' AND I.subledger_id='.$subledger;
                                }
                                if ( $brand > 0 ) {
                                    $condition .= ' AND t.brand_id=' . $brand;
                                    $condition_for_opening .= ' AND I.subledger_id=' . $brand;
                                }
                
                                $openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount*I.exchange_rate) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE '.$condition_for_opening.' ')->queryScalar();
                                $items = FinanceVoucherItems::model()->with('parent')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
                
                        
                                if( $type == 'vendor' )
                                    $symbol = ( $openingBalance <= 0 ) ? '' : '(-)';
                                else    
                                    $symbol = ( $openingBalance > 0 ) ? '' : '(-)';

            ?>
                <tbody>       
                        <tr>
                            <td colspan="5" class="text-right"><b>Carrying forward (AED)</b></td>
                            <td class="text-right"><?php echo $symbol.Yii::app()->numberFormatter->formatCurrency(abs($openingBalance)," ");?></td>
                            <td></td>
                        </tr>

            <?php 
            $total_debit = 0;
            $total_credit = 0;
            foreach ( $items as $each ){
                        
                        if( $type == 'vendor' )
                            $symbol = ( $each->amount <= 0 ) ? '' : '(-)';
                        else    
                            $symbol = ( $each->amount > 0 ) ? '' : '(-)';
                        
                     
                     ?>
                        <tr>      
                            <td><?php echo date("d/m/Y",strtotime($each->parent->voucher_date)); ?></td>
                            <td><?php echo $each->parent->vtype->description; ?></td>
                            <td><?php echo $each->parent->fullvoucher; ?></td>
                            <td><?php echo $each->parent->reference_no; ?></td>
                            <td><?php echo date("d/m/Y",strtotime($each->parent->due_date)); ?></td>
                            <td class="text-right"><?php echo $symbol.Yii::app()->numberFormatter->formatCurrency(abs($each->amount)," "); ?></td>
                            <td><?php echo $each->currency_code; ?></td>
                        </tr>
                        <?php } ?>
                </tbody>
            </table>
            </div>
    
   <?php $this->renderPartial("//common/footer");?>
</body>

</html>

