<script src="js/jquery.aCollapTable.js"></script>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPage", "function loadPage(){
            $('#loader').show();
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/reports/gl_cash_html') . "',
                'data' : { 'ledger_id' : $('#ledger_id').val(), 'subledger_id' : $('#subledger_id').val(),'brand' : $('#brand').val(),'employee' : $('#employee').val(), 'from' : $('#fn_report_from').val(), 'to' : $('#fn_report_to').val(), 'currency' : $('#currency').val() },
                'success': function(data) {
                    $('#data_div').show();
                    $('.main-li-data').html(data);
                    $('#loader').hide();
                    $('#gl_table').aCollapTable({
                        startCollapsed: true,
                        addColumn: false,
                        plusButton: '<i class=\"fa fa-plus\"></i>&nbsp;', 
                        minusButton: '<i class=\"fa fa-minus\"></i>&nbsp;' 
                    });
                }
            });
        }", CClientScript::POS_HEAD);
        $cs->registerScript("updatetextfield", "function updatetextfield(value){
            
            $('#subledger_name').val('');
            $('#subledger_id').val('');
        
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/core/havesubledger') . "',
                'data' : {'account' : value},
                'success': function(data) { 
                    if( data == 'true' ){
                        $('#subledger_name').attr( 'disabled', false );
                        $('#subledger_id').val('');
                    }else{
                        $('#subledger_name').attr( 'disabled', true );
                        $('#subledger_name').val('');
                        $('#subledger_id').val('');
                    }
                }
            });
        }", CClientScript::POS_HEAD);
        $cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
           account_id = $('#ledger_id').val();
           $('#subledger_id').val(0);
           if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#subledger_name').val(ui.item.label);
                        $('#subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 

?>

<style>
table {
  font-family: arial, sans-serif !important;
  border-collapse: collapse !important;
  width: 100% !important;
}

td, th {
  border: 1px solid #dddddd !important;
  text-align: left !important;
  padding: 8px !important;
}

table th{
	padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #1f67b2;
    color: white;
}

tr:nth-child(even) {
  background-color: #f2f2f2 !important;
}
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_from', date('01/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'From')); ?>
                    </li>
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_to', date('t/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'To')); ?>
                    </li>
                    <li class="col-sm-3">
                         <?php
                        $fledger=new FinanceLegder();
                        ?>
                        <?php 
//                        $cash_id=FinanceSystemAccountsMapping::getSystemdefault('cash_account');
//                        echo CHtml::hiddenField("ledger_id",$cash_id);
//                        echo CHtml::textField("ledger_name", 'Cash In Hand', array('data-label' => 'Ledger', 'class' => 'tooltipster', 'readonly'=>true)); 
                        echo CHtml::dropdownlist("ledger_id",'', $fledger->getChilds(), array('class' => 'tooltipster', 'data-label' => 'Ledgers', 'data-search' => true, 'onChange' => 'js:updatetextfield(this.value)')); //getAll  ?>
                    </li>
                    <li class="col-sm-3">
                        <?php echo CHtml::hiddenField("subledger_id"); ?>
                        <?php echo CHtml::textField("subledger_name", '', array('data-label' => 'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id);', 'data-label' => 'Sub ledger')); ?>
                    </li>
                    <li class="col-sm-2">
                    <?php echo CHtml::dropDownList("brand", '',ProductClass::getAllProductClass(), array('data-label' => 'Brand', 'class' => 'tooltipster','prompt'=>'-select-')); ?>
                    </li>
                    <li class="col-sm-2">
                        <?php
                        $fsubledger=new FinanceSubledger();
                        ?>
                    <?php echo CHtml::dropDownList("employee", '',$fsubledger->getEmployeeSubledgers(), array('data-label' => 'Employee', 'class' => 'tooltipster','prompt'=>'-select-')); ?>
                    </li>
                    <li class="col-sm-2">
                    <?php 
                    echo CHtml::dropDownList("currency","",MasCurrency::getCurrency(), array('class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'value' => MasCurrency::base_currency_id()));
                    ?> 
                    </li>
                    <!-- <li class="col-sm-2">
                        <?php // echo CHtml::dropdownlist("brand_id", '', FinanceLegder::getChilds(), array('class' => 'tooltipster', 'data-label' => 'Ledgers', 'data-search' => true, 'onChange' => 'js:updatetextfield(this.value)', 'multiple' => true)); //getAll  ?>
                    </li> -->
                    <div class="btn-wrap text-center">
                        <a type="button" class="btn btn-sm btn-theme" onclick="loadPage();">HTML</a>
                        <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/gl_cash_pdf&from_date='+$('#fn_report_from').val()+'&to_date='+$('#fn_report_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val()+'&currency='+$('#currency').val()+'&brand='+$('#brand').val()+'&employee='+$('#employee').val(), '_blank'); ">PDF</a>
                        <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/gl_cash_excel&from_date='+$('#fn_report_from').val()+'&to_date='+$('#fn_report_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val()+'&currency='+$('#currency').val()+'&brand='+$('#brand_id').val()+'&employee='+$('#employee').val(), '_blank');">XLS</a>
                    </div>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:none;" >
                <!-- <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
                    <li class="main-li active"><a href="#gl_tab" data-toggle="tab">General Ledger</a></li>
                </ul> -->
                <div class="tab-content">
                <div class="tab-pane main-li-data active" id="gl_tab">
                </div>
            </div>
        </section>
    </div>
</div>
