
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadSubledger", '
        $(document).ready(function() {
        // data.subledger_type = $("#subledger_type").val();    
        var table_id ="#tbl_fin_subledger";
        var table = $(table_id).DataTable({
            scrollY         : "1000px",
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('finance/core/getsubledgerlist') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);

    $cs->registerScript("updateSubleadgers", "function updateSubleadgers(){
        $('#loader').show();
        jQuery.ajax({
            'type': 'post',
            'url': '" . Yii::app()->createUrl('finance/core/importsystemsubledgers') . "',
            'success': function(data) { 
                t8.success('Done!');
                $('#loader').hide();
                reloadTable('#tbl_fin_subledger');
            }
        });
    }", CClientScript::POS_HEAD);
    $cs->registerScript("deleteSublegder",  "function deleteSublegder(id){
        var r = confirm('Are you sure to delete this?');
            if(r==true)
            {
                jQuery.ajax({
                  'type'  : 'post',
                  'data'  : 'id=' + id,
                  'url'  : $('#liveSite').val()+'index.php?r=finance/core/deletesubledger',
                  'cache': false,
                  'success':function(data){
                    if(data=='fail'){
                        alert('Error while Delete', 'Alert');
                    }else {
                        reloadTable('#tbl_fin_subledger');
                        t8.success('Deleted!');
                    }
                   }
                });
            }
    };", CClientScript::POS_HEAD);

  ?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
             <button class="btn btn-sm btn-theme" title="Subledger Types" onclick="loadPopupModal('finance/core/sublegdertypes','Subledger Types','lg')"><i class="fa fa-cogs"></i></button>
             <button class="btn btn-sm btn-theme" title="Update System subledgers" onclick="updateSubleadgers();"><i class="fa fa-retweet"></i></button>
             <div class="pull-right" style="display: flex;">
                <?php echo CHtml::dropdownlist('subledger_type', '', FinanceSubledgerType::getSystemGeneratedNoSubLedgerType(), array('class' => 'form-control', 'onchange' => 'reloadTable("#tbl_fin_subledger");', 'prompt' => 'All Types')); ?>
            </div>
            <div class="pull-right">
                            <button class="btn btn-sm btn-theme" title="Add New Subledger" onclick="loadPopupModal('finance/core/newsubledger','New Subledger','lg')"><i class="fa fa-plus"></i></button>
                        </div>
                    </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_fin_subledger" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>Account No</th>
                            <th>Description</th>
                            <th>Type</th>
                            <th>Related Ledgers</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
        </div>
    </section>
    
