<?php

/**
 * This is the model class for table "{{finance_legder}}".
 *
 * The followings are the available columns in table '{{finance_legder}}':
 * @property integer $id
 * @property string $account_no
 * @property string $description
 * @property string $type_of_account
 * @property string $main_account_type
 * @property integer $parent_account
 * @property integer $level
 * @property string $sort_order
 * @property string $classification
 * @property string $isParent
 * @property string $haveSubledger
 * @property string $subledger_types
 * @property string $system_generated
 * @property integer $created_by
 * @property string $created_datetime
 */
class FinanceLegder extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance_legder}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('account_no, description, parent_account, level, sort_order, created_by, created_datetime', 'required'),
            array('description', 'unique'),
			array('subledger_types', 'required', 'on' => 'havesublegder' ),
			array('parent_account, level, created_by', 'numerical', 'integerOnly'=>true),
			array('account_no', 'length', 'max'=>20),
			array('description, subledger_types, root, sort_order', 'length', 'max'=>255),
			array('type_of_account, main_account_type, isParent, haveSubledger, system_generated', 'length', 'max'=>1),
			array('classification', 'length', 'max'=>45),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, account_no, description, type_of_account, main_account_type, parent_account, level, sort_order, classification, isParent, haveSubledger, subledger_types, system_generated, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'parent' => array(self::BELONGS_TO, 'FinanceLegder', 'parent_account'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'account_no' => 'Account No',
			'description' => 'Description',
			'type_of_account' => 'Type Of Account',
			'main_account_type' => 'Main Account Type',
			'parent_account' => 'Parent Account',
			'level' => 'Level',
			'sort_order' => 'Sort Order',
			'classification' => 'Classification',
			'isParent' => 'Is Parent',
			'haveSubledger' => 'Have Subledger',
			'subledger_types' => 'Sublegder Types',
			'system_generated' => 'System Generated',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('account_no',$this->account_no,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('type_of_account',$this->type_of_account,true);
		$criteria->compare('main_account_type',$this->main_account_type,true);
		$criteria->compare('parent_account',$this->parent_account);
		$criteria->compare('level',$this->level);
		$criteria->compare('sort_order',$this->sort_order,true);
		$criteria->compare('classification',$this->classification,true);
		$criteria->compare('isParent',$this->isParent,true);
		$criteria->compare('haveSubledger',$this->haveSubledger,true);
		$criteria->compare('subledger_types',$this->subledger_types,true);
		$criteria->compare('system_generated',$this->system_generated,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceLegder the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function getFulldescription(){
		return $this->description.' ('.$this->account_no.') ('.$this->main_account_type.')';
	}

	public function getParent($id){
		return ( $id > 0 ) ? self::model()->findBypk($id)->description : 'N/A';
	}

	public function getAll(){
		return CHtml::listData(self::model()->findAll( array( 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}

	public function getParents(){
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'isParent="Y"', 'order' => 'description ASC' ) ), 'id', 'description');
	}

	public static function getChilds(){
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'isParent="N"', 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}

	public function getChildswithsubledgers(){
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'haveSubledger ="Y" AND isParent="N"', 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}
	
	public function getReceiptAccountNo(){
	    $modelLedger = self::model()->findAll(array('condition' => 'classification="PAYABLE" OR classification="RECEIVABLE"'));
        return CHtml::listData($modelLedger, 'account_no', 'account_no');
	}

	public function getReceivableandpayables(){
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'isParent="N" AND classification IN ("RECEIVABLE", "PAYABLE")', 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}

	public function getCash_accounts(){
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'isParent="N" AND classification IN ("CASH")', 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}

	public function getAllocatable(){
		$debtor = FinanceSystemAccountsMapping::getSystemdefault('debtors'); //debtors
		$creditor = FinanceSystemAccountsMapping::getSystemdefault('creditors'); //creditors
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'id IN ('.$debtor.', '.$creditor.')', 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}

	public function is_subledger_account( $id = 0 ){
		return ( self::model()->findbypk( $id )->haveSubledger == 'Y' ) ? true : false;
	}

	public function getCurrencies(){
		$all =  array(
			'AED' => array('UAE Dirham', '784'),
			'AFA' => array('Afghan Afghani', '971'),
			'AWG' => array('Aruban Florin', '533'),
			'AUD' => array('Australian Dollars', '036'),
			'ARS' => array('Argentine Pes', '032'),
			'AZN' => array('Azerbaijanian Manat', '944'),
			'BSD' => array('Bahamian Dollar', '044'),
			'BDT' => array('Bangladeshi Taka', '050'),
			'BBD' => array('Barbados Dollar', '052'),
			'BYR' => array('Belarussian Rouble', '974'),
			'BOB' => array('Bolivian Boliviano', '068'),
			'BRL' => array('Brazilian Real', '986'),
			'GBP' => array('British Pounds Sterling', '826'),
			'BGN' => array('Bulgarian Lev', '975'),
			'KHR' => array('Cambodia Riel', '116'),
			'CAD' => array('Canadian Dollars', '124'),
			'KYD' => array('Cayman Islands Dollar', '136'),
			'CLP' => array('Chilean Peso', '152'),
			'CNY' => array('Chinese Renminbi Yuan', '156'),
			'COP' => array('Colombian Peso', '170'),
			'CRC' => array('Costa Rican Colon', '188'),
			'HRK' => array('Croatia Kuna', '191'),
			'CPY' => array('Cypriot Pounds', '196'),
			'CZK' => array('Czech Koruna', '203'),
			'DKK' => array('Danish Krone', '208'),
			'DOP' => array('Dominican Republic Peso', '214'),
			'XCD' => array('East Caribbean Dollar', '951'),
			'EGP' => array('Egyptian Pound', '818'),
			'ERN' => array('Eritrean Nakfa', '232'),
			'EEK' => array('Estonia Kroon', '233'),
			'EUR' => array('Euro', '978'),
			'GEL' => array('Georgian Lari', '981'),
			'GHC' => array('Ghana Cedi', '288'),
			'GIP' => array('Gibraltar Pound', '292'),
			'GTQ' => array('Guatemala Quetzal', '320'),
			'HNL' => array('Honduras Lempira', '340'),
			'HKD' => array('Hong Kong Dollars', '344'),
			'HUF' => array('Hungary Forint', '348'),
			'ISK' => array('Icelandic Krona', '352'),
			'INR' => array('Indian Rupee', '356'),
			'IDR' => array('Indonesia Rupiah', '360'),
			'ILS' => array('Israel Shekel', '376'),
			'JMD' => array('Jamaican Dollar', '388'),
			'JPY' => array('Japanese yen', '392'),
			'KZT' => array('Kazakhstan Tenge', '368'),
			'KES' => array('Kenyan Shilling', '404'),
			'KWD' => array('Kuwaiti Dinar', '414'),
			'LVL' => array('Latvia Lat', '428'),
			'LBP' => array('Lebanese Pound', '422'),
			'LTL' => array('Lithuania Litas', '440'),
			'MOP' => array('Macau Pataca', '446'),
			'MKD' => array('Macedonian Denar', '807'),
			'MGA' => array('Malagascy Ariary', '969'),
			'MYR' => array('Malaysian Ringgit', '458'),
			'MTL' => array('Maltese Lira', '470'),
			'BAM' => array('Marka', '977'),
			'MUR' => array('Mauritius Rupee', '480'),
			'MXN' => array('Mexican Pesos', '484'),
			'MZM' => array('Mozambique Metical', '508'),
			'NPR' => array('Nepalese Rupee', '524'),
			'ANG' => array('Netherlands Antilles Guilder', '532'),
			'TWD' => array('New Taiwanese Dollars', '901'),
			'NZD' => array('New Zealand Dollars', '554'),
			'NIO' => array('Nicaragua Cordoba', '558'),
			'NGN' => array('Nigeria Naira', '566'),
			'KPW' => array('North Korean Won', '408'),
			'NOK' => array('Norwegian Krone', '578'),
			'OMR' => array('Omani Riyal', '512'),
			'PKR' => array('Pakistani Rupee', '586'),
			'PYG' => array('Paraguay Guarani', '600'),
			'PEN' => array('Peru New Sol', '604'),
			'PHP' => array('Philippine Pesos', '608'),
			'QAR' => array('Qatari Riyal', '634'),
			'RON' => array('Romanian New Leu', '946'),
			'RUB' => array('Russian Federation Ruble', '643'),
			'SAR' => array('Saudi Riyal', '682'),
			'CSD' => array('Serbian Dinar', '891'),
			'SCR' => array('Seychelles Rupee', '690'),
			'SGD' => array('Singapore Dollars', '702'),
			'SKK' => array('Slovak Koruna', '703'),
			'SIT' => array('Slovenia Tolar', '705'),
			'ZAR' => array('South African Rand', '710'),
			'KRW' => array('South Korean Won', '410'),
			'LKR' => array('Sri Lankan Rupee', '144'),
			'SRD' => array('Surinam Dollar', '968'),
			'SEK' => array('Swedish Krona', '752'),
			'CHF' => array('Swiss Francs', '756'),
			'TZS' => array('Tanzanian Shilling', '834'),
			'THB' => array('Thai Baht', '764'),
			'TTD' => array('Trinidad and Tobago Dollar', '780'),
			'TRY' => array('Turkish New Lira', '949'),
			'USD' => array('US Dollars', '840'),
			'UGX' => array('Ugandian Shilling', '800'),
			'UAH' => array('Ukraine Hryvna', '980'),
			'UYU' => array('Uruguayan Peso', '858'),
			'UZS' => array('Uzbekistani Som', '860'),
			'VEB' => array('Venezuela Bolivar', '862'),
			'VND' => array('Vietnam Dong', '704'),
			'AMK' => array('Zambian Kwacha', '894'),
			'ZWD' => array('Zimbabwe Dollar', '716'),
		);

		$array = array();
		
		foreach( $all as $key => $each ) :
			$array[$key] = $key;
		endforeach;

		return $array;
	}

	public function baseCurrency(){
		return MasCurrency::model()->find(array('condition'=> 'isBaseCurrency="Y"'))->currency_code;
	}

	public function baseCurrency_id(){
		return MasCurrency::model()->find(array('condition'=> 'isBaseCurrency="Y"'))->id;
	}

	public function getBanks(){
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'isParent="N" AND classification IN ("BANK")', 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}
	public function getBankId(){
		return self::model()->find(array('condition' => 'isParent="N" AND classification IN ("BANK")', 'order' => 'description ASC'))->id;
	}
	public function get_first_subledger( $ledger_id=0 ){
		$subledger = array( 'id' => 0, 'description' => null);
		if( self::is_subledger_account( $ledger_id ) ){
			$subledger_types = self::model()->findBypk( $ledger_id )->subledger_types;
			if( count( explode(',', $subledger_types) ) == 1 ){
				$model = FinanceSubledger::model()->find( array( 'condition' => 'subledger_type_id='.(int) $subledger_types ) );
				if( $model->id > 0 ){
					$subledger['id'] = (int) $model->id;
					$subledger['description'] = $model->description;
				}
			}
		}
		return $subledger;
	}

	public function setup_levels(){
		$parentAccount = self::model()->findAll( array( 'condition' => 'level=1' ) );
		foreach( $parentAccount as $each ){
			$haveChild = true;
			$parenIds = $each->id;
			$level = 2;
			while( $haveChild ){
				$count_of_children = 0;
				if( $parenIds != '' )
					$count_of_children = self::model()->count( array( 'condition' => 'parent_account IN('.$parenIds.')' ) );
				if(  $count_of_children > 0 ){
					Yii::app()->db->createCommand('UPDATE {{finance_legder}} SET level='.$level.' WHERE parent_account IN('.$parenIds.')' )->execute();
					$accounIds  = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(id) AS ids FROM {{finance_legder}} WHERE parent_account IN('.$parenIds.')')->queryAll();
					$parenIds = $accounIds[0]['ids'];
					$level++;
				}else	
					$haveChild = false;
			}
		}
	}

	public function findByclass( $class=NULL){
		$response = 0;
		if( $class != NULL ){
			$response =  self::model()->find( array( 'select' => 'id', 'condition' => 'classification="'.$class.'"' ) )->id;
		}
		return (int) $response;
	}

	public static function getExpense_accounts(){
		return CHtml::listData(self::model()->findAll( array( 'condition' => 'isParent="N" AND main_account_type="E"', 'order' => 'description ASC' ) ), 'id', 'Fulldescription');
	}

}
