<?php

class VouchersController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Create', 'Ledgerlist','Subledgerlist', 'Getexchange_rate', 'Savevoucher', 'Updatevoucher', 'Createreceipt', 'Reports',
                    'Glreport_excel', 'Glreport_pdf', 'Trialbalance_excel', 'Trialbalance_pdf', 'Glsummary_excel', 'Statement_excel',
                    'Statement_pdf', 'Glsummary_pdf', 'Balancesheet_excel', 'Balancesheet_pdf', 'Profitorloss_pdf', 'Profitorloss_excel',
                    'Trialbalance_pdf_detailed', 'Trialbalance_excel_detailed', 'Loadtemplate', 'Allocate', 'Getallocationdata',
                    'Saveallocation', 'Aging_excel', 'Aging_pdf', 'Getallocationdata_for_receipt', 'Savereceiptvoucher', 'Cashreport_pdf', 'Cashreport_excel',
                    'Vat_pdf', 'Vat_excel', 'Createexpense', 'Subledgerlist_all', 'Subledger_summary_pdf', 'Subledger_summary_excel', 'Statement_pdf_as_on_date',
                    'Recon_statement_pdf', 'Getorders', 'Postvoucher','AllocateVoucher','Vehicle_list','Add_payment','Add_receipt','GetallocationdataFromReceipt',
                    'GetallocationdataFromPayment'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionCreate() 
    {
		$id = (int) Yii::app()->request->getParam('id');
		
		$voucher_type = (int) Yii::app()->request->getParam('voucher_type');
		$date = Yii::app()->request->getParam('date');

		$model = new FinanceVoucherHead;
		if( $id > 0 ){
			$model = $model->findBypk( $id );
			$model->voucher_date = date('d/m/Y', strtotime( $model->voucher_date ));
		}else{
			$model->voucher_type = (  $voucher_type > 0 ) ? $voucher_type : 3; //journal Voucher
			$model->voucher_date = ( count( explode('/', $date) ) == 3 ) ? $date : date('d/m/Y');
		}
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('create_voucher', array( 'model' => $model ) );
	}

    public function actionCreatereceipt()
    {
        $model = new FinanceVoucherHead;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_receipt_voucher', array('model' => $model));
    }

    public function actionLedgerlist()
    {
        $term = trim($_GET['term']);
        $response = array();
        $condition = 't.isParent="N"';
        if( $term != '' )
            $condition .= ' AND ( t.description LIKE "%' . $term . '%" OR t.account_no LIKE "%' . $term . '%" ) ';
            // $ledgers=Yii::app()->db->createCommand("select t.haveSubledger, t.account_no, t.description, t.id,SUM(amount) AS amount from {{finance_legder}} AS t LEFT JOIN {{finance_voucher_items}} AS I ON t.id=I.ledger_id LEFT JOIN {{finance_voucher_head}} AS H ON I.header_id=H.id  $condition group by t.id limit 100")->queryAll();
        $ledgers = FinanceLegder::model()->findAll(array('select' => 'haveSubledger, account_no, description, id', 'condition' => $condition, 'limit' => 10));
        foreach ($ledgers as $i => $each) {
            $ledger=Yii::app()->db->createCommand("select SUM(amount) AS amount from {{finance_voucher_items}} AS I LEFT JOIN {{finance_voucher_head}} AS H ON I.header_id=H.id where H.is_posted='Y' AND I.ledger_id=".$each['id'])->queryScalar();
            $response[$i]['label'] =  $each['account_no'].' : '.$each['description'].' : AED '.(float)$ledger;
            $response[$i]['description'] = $each['description'];
            $response[$i]['value'] = $each['id'];
            $response[$i]['other'] = $each['haveSubledger'];
        }
        
        echo json_encode($response);
    }

    public function actionSubledgerlist()
    {

        $term = trim($_GET['term']);
        $ledger = (int)$_GET['ledger'];
        $override = $_GET['override'] == 'true' ? true : false;
        $type = (int) $_GET['type'];

        $response = array();

        if ($term != '' && ( $ledger > 0 || $override ) ) {
            $legderModel = FinanceLegder::model()->findBypk($ledger);
            $sub_types = $override ? $type : $legderModel->subledger_types;
            if ( $sub_types != '') {
                $condition='( t.account_no LIKE "%' . $term . '%" OR t.description LIKE "%' . $term . '%" ) AND t.subledger_type_id IN (' . $sub_types . ') AND description NOT  LIKE "%- CRM%"';
                // $subledgers=Yii::app()->db->createCommand("select t.account_no, t.description, t.id,SUM(amount) AS amount from {{finance_subledger}} AS t LEFT JOIN {{finance_voucher_items}} AS I ON t.id=I.ledger_id LEFT JOIN {{finance_voucher_head}} AS H ON I.header_id=H.id  $condition group by t.id limit 100")->queryAll();
                $subledgers = FinanceSubledger::model()->findAll(array( 'select' => 'account_no, description, id', 'condition' => '( account_no LIKE "%' . $term . '%" OR description LIKE "%' . $term . '%" ) AND subledger_type_id IN (' . $sub_types . ') AND description NOT  LIKE "%- CRM%"', 'limit' => 10));
                foreach ($subledgers as $i => $each) {
                    $ledgers=Yii::app()->db->createCommand("select SUM(amount) AS amount from {{finance_voucher_items}} AS I LEFT JOIN {{finance_voucher_head}} AS H ON I.header_id=H.id where H.is_posted='Y' AND I.ledger_id=".$ledger." AND I.subledger_id=".$each['id'])->queryScalar();
                    $response[$i]['label'] = $each['account_no'].' : '.$each['description'].' : AED '.(float)$ledgers;
                    $response[$i]['value'] = $each['id'];
                }
            }
        }

        echo json_encode($response);
    }

    public function actionSubledgerlist_all()
    {

        $term = trim($_GET['term']);
        $response = array();

        if ( $term != '' ) {
            $subledgers = FinanceSubledger::model()->findAll(array('condition' => 'description LIKE "%' . $term . '%" AND description NOT  LIKE "%- CRM%"', 'limit' => 200));
            foreach ($subledgers as $i => $each) {
                $response[$i]['label'] = $each->description;
                $response[$i]['value'] = $each->id;
            }
        }

        echo json_encode($response);
    }

    public function actionSavevoucher(){
		
		function savableDate( $date ){
			$last_closed_year = FinanceAuditClose::lastClosed();
			$voucherDate_array = explode('-', $date);
			$voucherYear = $voucherDate_array[0];
			return ( $voucherYear <= $last_closed_year ) ? false : true;
		}

		function matchTotal( $debit, $credit, $voucherType ){
			return ( ( $debit > 0 && $credit > 0 && $debit == $credit )) ? true : false;
		}

		$others = $modelItems = array();
		$model = new FinanceVoucherHead;
		$i = $debitTotal = $creditTotal = 0;
		$scene = 'new';
		if( (int) $_POST['FinanceVoucherHead']['id'] > 0 ){
			$model = $model->findBypk( (int) $_POST['FinanceVoucherHead']['id']);
			$scene = 'edit';
		}else{
			$model->is_posted = 'N';
			$model->created_by = Yii::app()->user->id;
			$model->created_datetime = date('Y-m-d h:i:s');
		}
        $model->attributes = $_POST['FinanceVoucherHead'];
        $model->general_narration = $_POST['FinanceVoucherHead']['general_narration'];
		$model->voucher_date = ( count( explode('/', $_POST['FinanceVoucherHead']['voucher_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['voucher_date']) )) : date('Y-m-d');
		$model->due_date = $model->voucher_date;
		$savableVoucher = savableDate($model->voucher_date);
		$voucherType =  $_POST['FinanceVoucherHead']['voucher_type'];
		$model->total_voucher_amount = 0;
		
		$voucherModel = FinanceVoucherType::model()->findBypk( (int) $voucherType ); 
		if( in_array($voucherType, array(1, 2)) ){ //Receipt or Payment
			if( $_POST['FinanceVoucherHead']['payment_method'] == 4 ) //card
				$model->scenario = 'card';
			else if( $_POST['FinanceVoucherHead']['payment_method'] == 2 ){ //cheque
				$model->scenario = ( $voucherType == 2 ) ? 'chequereceived' : 'chequepaid';
				$model->realisation_date = ( count( explode('/', $_POST['FinanceVoucherHead']['realisation_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['realisation_date']) )) : date('Y-m-d');
				$model->cheque_date = ( count( explode('/', $_POST['FinanceVoucherHead']['cheque_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['cheque_date']) )) : date('Y-m-d');
				$model->cheque_cleared = 'N';
			}else if( $_POST['FinanceVoucherHead']['payment_method'] == 3 ){ //bank
				if( $voucherType == 2 ) //Bank
					$model->scenario = 'bank'; //
			}else //cash
				$model->scenario = 'cash';
		}else
			$model->scenario = 'simpleVoucher';
		$valid = $model->validate() && $savableVoucher;	
		if( is_array( $_POST['FinanceVoucherItems'] ) ){
			foreach( $_POST['FinanceVoucherItems'] as $eachItem ){
                //Input filter
                $eachItem['debit'] = str_replace(',', '', $eachItem['debit']);
                $eachItem['credit'] = str_replace(',', '', $eachItem['credit']);

                $modelItems[$i] = new FinanceVoucherItems;
                $modelItems[$i]->attributes = $eachItem;
                $modelItems[$i]->brand_id = $eachItem['brand_id'];
				$modelItems[$i]->header_id = 0;
				if( $eachItem['ledger_id'] > 0 ){
					$ledger = FinanceLegder::model()->findBypk( $eachItem['ledger_id'] );
					if( $ledger->haveSubledger == 'Y' )
						$modelItems[$i]->scenario = 'havesubledger';
				}
				$modelItems[$i]->narration = ( trim($eachItem['narration']) == '') ? $_POST['FinanceVoucherHead']['general_narration'] : $eachItem['narration'];
				if( $eachItem['debit'] > 0 ){
					$modelItems[$i]->amount = $eachItem['debit'];
					$debitTotal += $eachItem['debit']*$eachItem['exchange_rate'];
				}else{
					$modelItems[$i]->amount = -1*$eachItem['credit'];
					$creditTotal += $eachItem['credit']*$eachItem['exchange_rate'];
				}
				$valid = $modelItems[$i]->validate() && $valid;	
				$i++;
			}
		}
		
		// $matchingTotals = matchTotal($debitTotal, $creditTotal, $voucherType);

		// if( $valid && count($modelItems) > 0 && $matchingTotals ){
        if( $valid && count($modelItems) > 0){
			if( $model->isNewRecord )
				$model->voucher_no = FinanceVoucherType::getVoucherno( $model->voucher_type, true);
			$model->total_voucher_amount = $debitTotal;
			// if( $model->scenario == 'simpleVoucher' )
			// 	$model->reference_no = $voucherModel->code.'/'.$model->voucher_no;
			$model->save();
			FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $model->id));
			foreach( $modelItems as $each ){
				$each->header_id = $model->id;
                $each->save();
                $each->update_currency_code();
			}
			echo json_encode( array( 'status' => 'success', 'scene' => $scene ) );
		}else{
			$error1 = json_decode(CActiveForm::validate($model, '', false), true);
			$error2 = json_decode(CActiveForm::validateTabular($modelItems, '', false), true);
			if( !$savableVoucher )
				$others[] = 'All the vouchers in this year are closed';
			if( count($modelItems) == 0 )
				$others[] = 'Please add ledger entries!';
			// if( !$matchingTotals )
			// 	$others[] = 'Totals are not matching!';
			echo CJSON::encode(array_merge_recursive($error1, $others, $error2));
		}
	}

    public function actionUpdatevoucher()
    {
        $id = (int) $_POST['id'];
        $type = $_POST['type'];

        function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        if ($id > 0) {
            $voucherModel = FinanceVoucherHead::model()->findBypk($id);
            if (isPostable($voucherModel->voucher_date)) {
                if ($type == 0) {
                    //unpost
                    if ( $voucherModel->is_allocated == 'N' && !$voucherModel->haveReconcilation() ) {
                        $voucherModel->is_posted = 'N';
                        $voucherModel->save(false);
                        $msg = 'success';
                    } else {
                        $msg = 'Remove Allocation and Reconciliation first!';
                    }
                } else if ($type == 2) {
                    //delete
                    if ($voucherModel->is_allocated == 'N') {
                        FinanceVoucherHead::model()->deleteBypk($id);
                        FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $id));
                        $msg = 'success';
                    } else {
                        $msg = 'Remove allocation first!';
                    }
                } else {
                    //post
                    if ($voucherModel->is_postable_voucher()) {
                        $voucherModel->is_posted = 'Y';
                        $voucherModel->save(false);
                        $msg = 'success';
                    } else {
                        $msg = 'There is an error in your voucher!';
                    }
                }
                echo $msg;
            } else {
                echo 'Audited!';
            }

        } else {
            echo 'Something Went Wrong!';
        }

    }

    public function actionReports()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('reports');
    }

    public function actionGlreport_excel()
    {

        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');

        $ledger = (int) $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id=' . $ledger;
            $condition_for_opening .= ' AND I.ledger_id=' . $ledger;
        }
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        $openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount*I.exchange_rate) AS amount FROM erp_finance_voucher_items I LEFT JOIN erp_finance_voucher_head H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));

        $filename = "glreport" . date('dmYhis') . ".xls";
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                        <thead>
                        <tr>
                        <th colspan="8">
                        '.$settings->company_name.'
                        </th>
                        </tr>
							    <tr>
								<th class="head">Date</th>
								<th class="head">Voucher No</th>
								<th class="head">Ledger</th>
								<th class="head">Subledger</th>
								<th class="head">Narration</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                                <th class="head">Balance</th>
                                </tr>
                            </thead>
						<tbody>';
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';
        $data .= '<tr>
						<td colspan="5"><b>Opening Balance</b></td>
						<td>' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? $previousBalance : ''), " ") . '</td>
						<td>' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? $previousBalance : ''), " ") . '</td>
						<td>' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
					</tr>';
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? $each->amount*$each->exchange_rate : '';
            $credit = ($each->amount < 0) ? abs($each->amount*$each->exchange_rate) : '';
            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $data .= '<tr>
								<td>' . $each->parent->voucher_date . '</td>
								<td>' . $each->parent->fullvoucher . '</td>
								<td>' . $each->ledger->description . '</td>
								<td>' . $subledgerName . '</td>
								<td>' . $each->narration . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . ' ' . $symbol . '</td>
							</tr>';
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $data .= '<tr>
						<td class="head" colspan="7"><b>Closing Balance</b></td>
						<td class="head">' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</td>
					</tr>';
        $data .= '      </tbody>
					</table>
				</body>
			</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    function generateEntries($from_date, $to_date, $ledger)
    {
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"AND t.ledger_id=' . $ledger;
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '" AND I.ledger_id=' . $ledger;

        $openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount) AS amount FROM erp_finance_voucher_items I LEFT JOIN erp_finance_voucher_head H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));

        return array('opening_balance' => (float) $openingBalance, 'entries' => $items);
    }

    function generateSymbol($value)
    {
        return ($value > 0) ? ' Dr' : ' Cr';
    }

    public function actionGlreport_pdf()
    {
        $from_date_original = Yii::app()->request->getParam('from_date');
        $to_date_original = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = Yii::app()->request->getParam('subledger');

        $model = FinanceLegder::model()->findBypk((int) $ledger);
        $table = '';
        
        if ($model->isParent != 'N') {
            $from_date = (count(explode('/', $from_date_original)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date_original))) : date('Y-m-d');
            $to_date = (count(explode('/', $to_date_original)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date_original))) : date('Y-m-d');

            $all_accounts = FinanceLegder::model()->findAll(array('condition' => ($ledger > 0) ? 'id=' . $ledger : 'id IN(1,2,3,4)', 'order' => 'id ASC'));
            $grand_debit = 0;
            $grand_credit = 0;
            foreach ($all_accounts as $eachAcc) { //Level 1
                $total_credit_lv0 = 0;
                $total_debit_lv0 = 0;
                if ($eachAcc->isParent == 'Y') {
                    $table .= '  <tr><td colspan="6"><b>' . $eachAcc->account_no . ' : ' . $eachAcc->description . '</b></td></tr>';
                    $all_accounts_lv2 = FinanceLegder::model()->findAll(array('condition' => 'parent_account=' . $eachAcc->id, 'order' => 'id ASC'));
                    foreach ($all_accounts_lv2 as $eachAcc2) { //Level 2
                        if ($eachAcc2->isParent == 'Y') {
                            $table .= '  <tr><td colspan="6">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachAcc2->account_no . ' : ' . $eachAcc2->description . '</b></td></tr>';
                            $all_accounts_lv3 = FinanceLegder::model()->findAll(array('condition' => 'parent_account=' . $eachAcc2->id, 'order' => 'id ASC'));
                            foreach ($all_accounts_lv3 as $eachAcc3) { //Level 3
                                if ($eachAcc3->isParent == 'Y') {
                                    $table .= '  <tr><td colspan="6">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachAcc3->account_no . ' : ' . $eachAcc3->description . '</b></td></tr>';
                                    $all_accounts_lv4 = FinanceLegder::model()->findAll(array('condition' => 'parent_account=' . $eachAcc3->id, 'order' => 'id ASC'));
                                    foreach ($all_accounts_lv4 as $eachAcc4) { //Level 4
                                        if ($eachAcc4->isParent == 'Y') {
                                            $table .= '  <tr><td colspan="6">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachAcc4->account_no . ' : ' . $eachAcc4->description . '</b></td></tr>';
                                            $all_accounts_lv5 = FinanceLegder::model()->findAll(array('condition' => 'parent_account=' . $eachAcc4->id, 'order' => 'id ASC'));
                                            foreach ($all_accounts_lv5 as $eachAcc5) { //Level 5
                                                $entryData = $this->generateEntries($from_date, $to_date, $eachAcc5->id);
                                                $closingBalance = $entryData['opening_balance'];
                                                $previousBalance = $entryData['opening_balance'];
                                                $table .= '  <tr><td colspan="6">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachAcc5->account_no . ' : ' . $eachAcc5->description . '</b></td></tr>
                                                                <tr>
                                                                    <td colspan="6" class="text-right">Opening Balance : ' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $this->generateSymbol($previousBalance) . '</td>
                                                                </tr>';
                                                $total_debit_lv5 = ( $previousBalance > 0 ) ? $previousBalance : 0;
                                                $total_credit_lv5 = ( $previousBalance < 0 ) ? $previousBalance : 0;

                                                foreach ($entryData['entries'] as $each) {

                                                    $debit = ($each->amount > 0) ? $each->amount : '';
                                                    $credit = ($each->amount < 0) ? abs($each->amount) : '';
                                                    $running = $debit - $credit + $previousBalance;
                                                    $previousBalance = $running;
                                                    $closingBalance += ($debit - $credit);

                                                    $total_debit_lv5 += $debit;
                                                    $total_credit_lv5 += $credit;
                                                    
                                                    $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';

                                                    $table .= ' <tr>
                                                                        <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                                                        <td>' . $each->parent->fullvoucher . '</td>
                                                                        <td>' . $subledgerName . '</td>
                                                                        <td>' . $each->narration . '</td>
                                                                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                                                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>

                                                                    </tr>';
                                                }

                                               
                                                    $table .= '<tr>
                                                                    <td colspan="4" class="text-right"><b>Total (' . $eachAcc5->description . ')</b></td>
                                                                    <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit_lv5), " ") . '</b></td>
                                                                    <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit_lv5), " ") . '</b></td>
                                                                </tr>';
                                                    $total_debit_lv0 += $total_debit_lv5;
                                                    $total_credit_lv0 += $total_credit_lv5;
                                                
                                            }
                                        } else {
                                            $entryData = $this->generateEntries($from_date, $to_date, $eachAcc4->id);
                                            $closingBalance = $entryData['opening_balance'];
                                            $previousBalance = $entryData['opening_balance'];

                                            $table .= '  <tr><td colspan="6">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachAcc4->account_no . ' : ' . $eachAcc4->description . '</b></td></tr>';
                                            
                                                $table .= '<tr>
                                                                <td colspan="6" class="text-right">Opening Balance : ' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $this->generateSymbol($previousBalance) . '</td>
                                                            </tr>';
                                            
                                            
                                            $total_debit_lv4 = ( $previousBalance > 0 ) ? $previousBalance : 0;
                                            $total_credit_lv4 = ( $previousBalance < 0 ) ? $previousBalance : 0;

                                            foreach ($entryData['entries'] as $each) {

                                                $debit = ($each->amount > 0) ? $each->amount : '';
                                                $credit = ($each->amount < 0) ? abs($each->amount) : '';
                                                $running = $debit - $credit + $previousBalance;
                                                $previousBalance = $running;
                                                $closingBalance += ($debit - $credit);

                                                $total_debit_lv4 += $debit;
                                                $total_credit_lv4 += $credit;

                                                $grand_debit += $debit;
                                                $grand_credit += $credit;
                                                
                                                $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';

                                                $table .= ' <tr>
                                                                    <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                                                    <td>' . $each->parent->fullvoucher . '</td>
                                                                    <td>' . $subledgerName . '</td>
                                                                    <td>' . $each->narration . '</td>
                                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>

                                                                </tr>';
                                            }

                                            
                                                $table .= '<tr>
                                                                <td colspan="4" class="text-right"><b>Total (' . $eachAcc4->description . ')</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit_lv4), " ") . '</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit_lv4), " ") . '</b></td>
                                                            </tr>';
                                            
                                            $total_debit_lv0 += $total_debit_lv4;
                                            $total_credit_lv0 += $total_credit_lv4;
                                        }
                                    }
                                } else {
                                    $entryData = $this->generateEntries($from_date, $to_date, $eachAcc3->id);
                                    $closingBalance = $entryData['opening_balance'];
                                    $previousBalance = $entryData['opening_balance'];
                                    $table .= '  <tr><td colspan="6">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachAcc3->account_no . ' : ' . $eachAcc3->description . '</b></td></tr>';
                                    
                                        $table .= '<tr>
                                                        <td colspan="6" class="text-right">Opening Balance : ' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $this->generateSymbol($previousBalance) . '</td>
                                                    </tr>';
                                    

                                    $total_debit_lv3 = ( $previousBalance > 0 ) ? $previousBalance : 0;
                                    $total_credit_lv3 = ( $previousBalance < 0 ) ? $previousBalance : 0;

                                    foreach ($entryData['entries'] as $each) {

                                        $debit = ($each->amount > 0) ? $each->amount : '';
                                        $credit = ($each->amount < 0) ? abs($each->amount) : '';
                                        $running = $debit - $credit + $previousBalance;
                                        $previousBalance = $running;
                                        $closingBalance += ($debit - $credit);

                                        $total_debit_lv3 += $debit;
                                        $total_credit_lv3 += $credit;
                                        
                                        $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';

                                        $table .= ' <tr>
                                                            <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                                            <td>' . $each->parent->fullvoucher . '</td>
                                                            <td>' . $subledgerName . '</td>
                                                            <td>' . $each->narration . '</td>
                                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>

                                                        </tr>';
                                    }
                                    
                                        $table .= '<tr>
                                                        <td colspan="4" class="text-right"><b>Total (' . $eachAcc3->description . ')</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit_lv3), " ") . '</b></td>
                                                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit_lv3), " ") . '</b></td>
                                                    </tr>';
                                        
                                        $total_debit_lv0 += $total_debit_lv3;
                                        $total_credit_lv0 += $total_credit_lv3;
                                    
                                }
                            }
                        } else {
                            $entryData = $this->generateEntries($from_date, $to_date, $eachAcc2->id);
                            $closingBalance = $entryData['opening_balance'];
                            $previousBalance = $entryData['opening_balance'];
                            $table .= '  <tr><td colspan="6">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachAcc2->account_no . ' : ' . $eachAcc2->description . '</b></td></tr>';
                            
                                $table .= '<tr>
                                                <td colspan="6" class="text-right">Opening Balance : ' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $this->generateSymbol($previousBalance) . '</td>
                                            </tr>';
                            

                            $total_debit_lv2 = ( $previousBalance > 0 ) ? $previousBalance : 0;
                            $total_credit_lv2 = ( $previousBalance < 0 ) ? $previousBalance : 0;

                            foreach ($entryData['entries'] as $each) {

                                $debit = ($each->amount > 0) ? $each->amount : '';
                                $credit = ($each->amount < 0) ? abs($each->amount) : '';
                                $running = $debit - $credit + $previousBalance;
                                $previousBalance = $running;
                                $closingBalance += ($debit - $credit);

                                $total_debit_lv2 += $debit;
                                $total_credit_lv2 += $credit;
                                
                                $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';

                                $table .= ' <tr>
                                                    <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                                    <td>' . $each->parent->fullvoucher . '</td>
                                                    <td>' . $subledgerName . '</td>
                                                    <td>' . $each->narration . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>

                                                </tr>';
                                }
                               
                                    $table .= '<tr>
                                                    <td colspan="4" class="text-right"><b>Total (' . $eachAcc2->description . ')</b></td>
                                                    <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit_lv2), " ") . '</b></td>
                                                    <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit_lv2), " ") . '</b></td>
                                                </tr>';
                                
                                $total_debit_lv0 += $total_debit_lv2;
                                $total_credit_lv0 += $total_credit_lv2;
                                
                        }
                    }
                } else {
                   
                    $entryData = $this->generateEntries($from_date, $to_date, $eachAcc->id);
                    $closingBalance = $entryData['opening_balance'];
                    $previousBalance = $entryData['opening_balance'];
                    $table .= '  <tr><td colspan="6"><b>' . $eachAcc->account_no . ' : ' . $eachAcc->description . '</b></td></tr>';
                    
                        $table .= '<tr>
                                    <td colspan="6" class="text-right">Opening Balance : ' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $this->generateSymbol($previousBalance) . '</td>
                                </tr>';
                    

                    $total_debit_lv1 = ( $previousBalance > 0 ) ? $previousBalance : 0;
                    $total_credit_lv1 = ( $previousBalance < 0 ) ? $previousBalance : 0;

                    foreach ($entryData['entries'] as $each) {

                        $debit = ($each->amount > 0) ? $each->amount : '';
                        $credit = ($each->amount < 0) ? abs($each->amount) : '';
                        $running = $debit - $credit + $previousBalance;
                        $previousBalance = $running;
                        $closingBalance += ($debit - $credit);

                        $total_debit_lv1 += $debit;
                        $total_credit_lv1 += $credit;

                        $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';

                        $table .= ' <tr>
                                        <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                        <td>' . $each->parent->fullvoucher . '</td>
                                        <td>' . $subledgerName . '</td>
                                        <td>' . $each->narration . '</td>
                                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                                    </tr>';
                    }
                  
                        $table .= '<tr>
                                    <td colspan="4" class="text-right"><b>Total (' . $eachAcc->description . ')</b></td>
                                    <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit_lv1), " ") . '</b></td>
                                    <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit_lv1), " ") . '</b></td>
                                </tr>';
                    
                        $total_debit_lv0 += $total_debit_lv1;
                        $total_credit_lv0 += $total_credit_lv1;

                }

               
                    $table .= '<tr>
                                <td colspan="4" class="text-right"><b>Total (' . $eachAcc->description . ')</b></td>
                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit_lv0), " ") . '</b></td>
                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit_lv0), " ") . '</b></td>
                            </tr>';
                
                $grand_debit += $total_debit_lv0;
                $grand_credit += $total_credit_lv0;
            }
            
             $table .= '<tr style=" border: 0; background-color:white;">
                             <td colspan="6"></td>
                        <tr>
                        <tr style=" border: 0; background-color:white;">
                             <td colspan="6"></td>
                        <tr>
                        <tr>
                            <td colspan="4" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grand_debit), " ") . '</b></td>
                            <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grand_credit), " ") . '</b></td>
                        </tr>';
            
            $closing = abs($grand_debit) - abs($grand_credit);
            $table .= '<tr>
                        <td colspan="5" class="text-right"><b>Closing Balance</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closing), " ") .$this->generateSymbol($closing).'</b></td>
                    </tr>';
        }

        $param = array(
            'from_date' => $from_date_original,
            'to_date' => $to_date_original,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'table' => $table,
        );

        $mode = ($model->id > 0 && $model->isParent == 'N') ? 'A4' : 'A4-L';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = ($model->id > 0 && $model->isParent == 'N') ? 'print_gl_report' : 'print_gl_report_detailed';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));

        $mpdf->Output("GLReport" . date("d-m-Y").".pdf", 'I');
    }

    public function generateView($type, $from_date, $to_date, $ledger)
    {
        $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
        if ($type == 'trial_balance') {
            $query_head = 'CREATE OR REPLACE VIEW erp_finance_balancesheet AS SELECT
						L.id AS ledger_id,
						L.account_no AS ledger_no,
						L.description AS ledger_name,
						L.level AS level,
						L.parent_account AS parent,
						ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
					FROM erp_finance_legder  L
					LEFT JOIN erp_finance_voucher_items VI ON VI.ledger_id = L.id
					LEFT JOIN erp_finance_voucher_head V On VI.header_id = V.id
					WHERE V.is_posted="Y" AND V.voucher_date <= "' . $to_date . '" AND L.type_of_account IN ("B")
					GROUP BY L.id';
            Yii::app()->db->createCommand($query_head)->execute();
            $query_tail = 'CREATE OR REPLACE VIEW erp_finance_profit_or_loss AS SELECT
								L.id AS ledger_id,
								L.account_no AS ledger_no,
								L.description AS ledger_name,
								L.level AS level,
								L.parent_account AS parent,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
							FROM erp_finance_legder  L
							LEFT JOIN erp_finance_voucher_items VI ON VI.ledger_id = L.id
							LEFT JOIN erp_finance_voucher_head V On VI.header_id = V.id
							WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $accountingPeriod['from'] . '" AND "' . $to_date . '" AND L.type_of_account IN ("P")
							GROUP BY L.id';
            Yii::app()->db->createCommand($query_tail)->execute();

            $query_all = 'CREATE OR REPLACE VIEW erp_finance_trialbalance AS SELECT * FROM erp_finance_balancesheet UNION SELECT * FROM erp_finance_profit_or_loss';
            Yii::app()->db->createCommand($query_all)->execute();
        } else if ($type == 'gl_summary') {

            $glSummaryquery = 'CREATE OR REPLACE VIEW erp_finance_gl_summary AS SELECT
								SL.account_no AS subledger_no,
								SL.description AS subledger_name,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
							FROM erp_finance_voucher_items VI
							LEFT JOIN erp_finance_voucher_head V ON V.id = VI.header_id
							LEFT JOIN erp_finance_legder L ON L.id = VI.ledger_id
							LEFT JOIN erp_finance_subledger SL ON SL.id = VI.subledger_id
							WHERE VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date <= "' . $to_date . '"
							GROUP BY  VI.ledger_id, VI.subledger_id';
            Yii::app()->db->createCommand($glSummaryquery)->execute();
        } else if ($type == 'profit_or_loss') {

            $query_tail = 'CREATE OR REPLACE VIEW erp_finance_profit_or_loss AS SELECT
								L.id AS ledger_id,
								L.account_no AS ledger_no,
								L.description AS ledger_name,
								L.level AS level,
								L.parent_account AS parent,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
							FROM erp_finance_legder  L
							LEFT JOIN erp_finance_voucher_items VI ON VI.ledger_id = L.id
							LEFT JOIN erp_finance_voucher_head V On VI.header_id = V.id
							WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("P")
							GROUP BY L.id';
            Yii::app()->db->createCommand($query_tail)->execute();
        } else if ($type == 'trial_balance_detailed') {
            $query_head = 'CREATE OR REPLACE VIEW erp_finance_balancesheet_detailed AS SELECT
						L.id AS ledger_id,
						L.account_no AS ledger_no,
						L.description AS ledger_name,
						L.level AS level,
						L.parent_account AS parent,
						S.id AS subledger_id,
						S.description AS subledger_name,
						S.account_no AS subledger_no,
						ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
					FROM erp_finance_legder  L
					LEFT JOIN erp_finance_voucher_items VI ON VI.ledger_id = L.id
					LEFT JOIN erp_finance_voucher_head V ON VI.header_id = V.id
					LEFT JOIN erp_finance_subledger S ON S.id = VI.subledger_id
					WHERE V.is_posted="Y" AND V.voucher_date <= "' . $to_date . '" AND L.type_of_account IN ("B")
					GROUP BY S.id, L.id';
            Yii::app()->db->createCommand($query_head)->execute();
            $query_tail = 'CREATE OR REPLACE VIEW erp_finance_profit_or_loss_detailed AS SELECT
								L.id AS ledger_id,
								L.account_no AS ledger_no,
								L.description AS ledger_name,
								L.level AS level,
								L.parent_account AS parent,
								S.id AS subledger_id,
								S.description AS subledger_name,
								S.account_no AS subledger_no,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
							FROM erp_finance_legder  L
							LEFT JOIN erp_finance_voucher_items VI ON VI.ledger_id = L.id
							LEFT JOIN erp_finance_voucher_head V On VI.header_id = V.id
							LEFT JOIN erp_finance_subledger S ON S.id = VI.subledger_id
							WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $accountingPeriod['from'] . '" AND "' . $to_date . '" AND L.type_of_account IN ("P")
							GROUP BY S.id, L.id';
            Yii::app()->db->createCommand($query_tail)->execute();

            $query_all = 'CREATE OR REPLACE VIEW erp_finance_trialbalance_detailed AS SELECT * FROM erp_finance_balancesheet_detailed UNION SELECT * FROM erp_finance_profit_or_loss_detailed';
            Yii::app()->db->createCommand($query_all)->execute();
        }
    }

    public function actionTrialbalance_excel()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $this->generateView('trial_balance', 0, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_trialbalance WHERE ledger_id=' . $id)->queryScalar();
        }

        $filename = "trialbalance" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Ledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';
        //We have 5 levels
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P")'));
        $debitTotal = $creditTotal = 0;
        foreach ($levelOne as $eachOne) {
            $accountTotal = accountTotal($eachOne->id);
            $debit = ($accountTotal > 0) ? $accountTotal : '';
            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
            $debitTotal += ($debit > 0) ? $debit : 0;
            $creditTotal += ($credit > 0) ? $credit : 0;
            $data .= '<tr>
								<td>' . $eachOne->account_no . '</td>
								<td><b>' . $eachOne->description . '</b></td>
								<td>' . $debit . '</td>
								<td>' . $credit . '</td>
							</tr>';
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachOne->id));
            foreach ($levelTwo as $eachTwo) {
                $accountTotal = accountTotal($eachTwo->id);
                $debit = ($accountTotal > 0) ? $accountTotal : '';
                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                $debitTotal += ($debit > 0) ? $debit : 0;
                $creditTotal += ($credit > 0) ? $credit : 0;
                $data .= '<tr>
										<td>' . $eachTwo->account_no . '</td>
										<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachTwo->description . '</b></td>
										<td>' . $debit . '</td>
										<td>' . $credit . '</td>
									</tr>';
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachTwo->id));
                foreach ($levelThree as $eachThree) {
                    $accountTotal = accountTotal($eachThree->id);
                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                    $debitTotal += ($debit > 0) ? $debit : 0;
                    $creditTotal += ($credit > 0) ? $credit : 0;
                    $data .= '<tr>
										<td>' . $eachThree->account_no . '</td>
										<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>' . $eachThree->description . '</b></td>
										<td>' . $debit . '</td>
										<td>' . $credit . '</td>
									</tr>';
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachThree->id));
                    foreach ($levelFour as $eachFour) {
                        $accountTotal = accountTotal($eachFour->id);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += ($debit > 0) ? $debit : 0;
                        $creditTotal += ($credit > 0) ? $credit : 0;
                        $data .= '<tr>
											<td>' . $eachFour->account_no . '</td>
											<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
											<td>' . $debit . '</td>
											<td>' . $credit . '</td>
										</tr>';
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachFour->id));
                        foreach ($levelFive as $eachFive) {
                            $accountTotal = accountTotal($eachFive->id);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += ($debit > 0) ? $debit : 0;
                            $creditTotal += ($credit > 0) ? $credit : 0;
                            $data .= '<tr>
												<td>' . $eachFive->account_no . '</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
												<td>' . $debit . '</td>
												<td>' . $credit . '</td>
											</tr>';
                        }
                    }
                }
            }
        }

        $data .= '<tr>
						<td class="head" colspan="2"><b>Total</b></td>
						<td class="head">' . Yii::app()->numberFormatter->formatCurrency($debitTotal, " ") . '</td>
						<td class="head">' . Yii::app()->numberFormatter->formatCurrency($creditTotal, " ") . '</td>
					</tr>';
        $data .= '      </tbody>
					</table>
				</body>
			</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionTrialbalance_pdf()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $this->generateView('trial_balance', 0, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_trialbalance WHERE ledger_id=' . $id)->queryScalar();
        }

        $data = '<tbody>';
        //We have 5 levels
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
        $debitTotal = $creditTotal = 0;
        foreach ($levelOne as $eachOne) {
            $accountTotal = accountTotal($eachOne->id);
            $debit = ($accountTotal > 0) ? $accountTotal : '';
            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
            $debitTotal += ($debit > 0) ? $debit : 0;
            $creditTotal += ($credit > 0) ? $credit : 0;
            $data .= '<tr>
								<td class="text-right">' . $eachOne->account_no . '</td>
								<td><b>' . $eachOne->description . '</b></td>
								<td class="text-right">' . $debit . '</td>
								<td class="text-right">' . $credit . '</td>
							</tr>';
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachOne->id));
            foreach ($levelTwo as $eachTwo) {
                $accountTotal = accountTotal($eachTwo->id);
                $debit = ($accountTotal > 0) ? $accountTotal : '';
                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                $debitTotal += ($debit > 0) ? $debit : 0;
                $creditTotal += ($credit > 0) ? $credit : 0;
                $data .= '<tr>
										<td class="text-right">' . $eachTwo->account_no . '</td>
										<td class="level_two"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
										<td class="text-right">' . $debit . '</td>
										<td class="text-right">' . $credit . '</td>
									</tr>';
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachTwo->id));
                foreach ($levelThree as $eachThree) {
                    $accountTotal = accountTotal($eachThree->id);
                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                    $debitTotal += ($debit > 0) ? $debit : 0;
                    $creditTotal += ($credit > 0) ? $credit : 0;
                    $data .= '<tr>
										<td class="text-right">' . $eachThree->account_no . '</td>
										<td class="level_three"><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
										<td class="text-right">' . $debit . '</td>
										<td class="text-right">' . $credit . '</td>
									</tr>';
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachThree->id));
                    foreach ($levelFour as $eachFour) {
                        $accountTotal = accountTotal($eachFour->id);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += ($debit > 0) ? $debit : 0;
                        $creditTotal += ($credit > 0) ? $credit : 0;
                        $data .= '<tr>
											<td class="text-right">' . $eachFour->account_no . '</td>
											<td class="level_four">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachFour->id));
                        foreach ($levelFive as $eachFive) {
                            $accountTotal = accountTotal($eachFive->id);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += ($debit > 0) ? $debit : 0;
                            $creditTotal += ($credit > 0) ? $credit : 0;
                            $data .= '<tr>
												<td class="text-right">' . $eachFive->account_no . '</td>
												<td class="level_five">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
												<td class="text-right">' . $debit . '</td>
												<td class="text-right">' . $credit . '</td>
											</tr>';
                        }
                    }
                }
            }
        }

        $data .= '<tr>
									<td colspan="2" class="text-right"><b>Total</b></td>
									<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($debitTotal, " ") . '</b></td>
									<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($creditTotal, " ") . '</b></td>
								</tr>';
        $data .= '  </tbody>';

        $param = array('data' => $data, 'to_date' => $to_date);
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_trial_balance', $param, true));

        $mpdf->Output("trialbalance" . date("d-m-Y").".pdf", 'I');
    }

    public function actionGlsummary_excel()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $ledger = (int) $_GET['ledger'];

        $this->generateView('gl_summary', 0, $to_date, $ledger);

        $summaryItems = Yii::app()->db->createCommand('SELECT * FROM erp_finance_gl_summary ORDER BY subledger_name')->queryAll();

        $filename = "gl_summary" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Subledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';

        $totalDebit = $totalCredit = 0;
        foreach ($summaryItems as $each) {

            $debit = ($each['balance'] > 0) ? $each['balance'] : '';
            $credit = ($each['balance'] < 0) ? abs($each['balance']) : '';

            $data .= '<tr>
								<td>' . $each['subledger_no'] . '</td>
								<td>' . $each['subledger_name'] . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
							</tr>';

            $totalDebit += $debit;
            $totalCredit += $credit;
        }

        $data .= '<tr>
						<td class="head" colspan="2"><b>Total</b></td>
						<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency($totalDebit, " ") . '</b></td>
						<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency($totalCredit, " ") . '</b></td>
					</tr>';

        $balance = $totalDebit - $totalCredit;

        $debitBalance = ($balance > 0) ? $balance : 0;
        $creditBalance = ($balance <= 0) ? abs($balance) : 0;

        $data .= '<tr>
					<td class="head" colspan="2"><b>Balance</b></td>
					<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency($debitBalance, " ") . '</b></td>
					<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency($creditBalance, " ") . '</b></td>
				</tr>';
        $data .= '      </tbody>
					</table>
				</body>
			</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionStatement_excel()
    {

        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');

        $ledger = (int) $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id=' . $ledger;
            $condition_for_opening .= ' AND I.ledger_id=' . $ledger;
        }
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        $openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount*I.exchange_rate) AS amount FROM erp_finance_voucher_items I LEFT JOIN erp_finance_voucher_head H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));

        $filename = "statement" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
							<thead>
								<th class="head">Date</th>
								<th class="head">Voucher No</th>
								<th class="head">Narration</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
								<th class="head">Balance</th>
                            </thead>
							<tbody>';
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';
        $data .= '<tr>
						<td colspan="3"><b>Opening Balance</b></td>
						<td>' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? $previousBalance : ''), " ") . '</td>
						<td>' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
						<td>' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
					</tr>';
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? $each->amount*$each->exchange_rate : '';
            $credit = ($each->amount < 0) ? abs($each->amount*$each->exchange_rate) : '';
            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $data .= '<tr>
								<td>' . $each->parent->voucher_date . '</td>
								<td>' . $each->parent->fullvoucher . '</td>
								<td>' . $each->narration . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . ' ' . $symbol . '</td>
							</tr>';
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $data .= '<tr>
						<td class="head" colspan="5"><b>Closing Balance</b></td>
						<td class="head">' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</td>
					</tr>';
        $data .= '      </tbody>
					</table>
				</body>
			</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionStatement_pdf()
    {
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = Yii::app()->request->getParam('subledger');

        $aging_to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');

        $aging_report = $this->generateAgeing($aging_to_date, $ledger, $subledger);

        function getSymbol($value)
        {
            return ($value > 0) ? '&nbsp;Dr' : '&nbsp;Cr';
        }

        $data = '<tbody>';
        $grand_total = 0;
        $one = 0;
        $two = 0;
        $three = 0;
        $four = 0;
        $five = 0;
        foreach ($aging_report as $i => $each):
            $total = $each['0_30'] + $each['31_60'] + $each['61_90'] + $each['91_120'] + $each['greater_120'];
            $one += $each['0_30'];
            $two += $each['31_60'];
            $three += $each['61_90'];
            $four += $each['91_120'];
            $five += $each['greater_120'];
            $grand_total += $total;
            $data .= '<tr>

												<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['0_30']), " ") . getSymbol($each['0_30']) . '</td>
												<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['31_60']), " ") . getSymbol($each['31_60']) . '</td>
												<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['61_90']), " ") . getSymbol($each['61_90']) . '</td>
												<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['91_120']), " ") . getSymbol($each['91_120']) . '</td>
												<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['greater_120']), " ") . getSymbol($each['greater_120']) . '</td>
												<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($total), " ") . getSymbol($total) . '</td>
											</tr>';
        endforeach;

        $data .= '<tr>
										<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($one), " ") . getSymbol($one) . '</b></td>
										<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($two), " ") . getSymbol($two) . '</b></td>
										<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($three), " ") . getSymbol($three) . '</b></td>
										<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($four), " ") . getSymbol($four) . '</b></td>
										<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($five), " ") . getSymbol($five) . '</b></td>
										<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grand_total), " ") . getSymbol($grand_total) . '</b></td>
									</tr>';
        $data .= ' </tbody>';

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'table' => $data,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_statement', $param, true));

        $mpdf->Output("statement_of_account" . date("d-m-Y").".pdf", 'I');
    }

    public function actionStatement_pdf_as_on_date()
    {
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = Yii::app()->request->getParam('subledger');
        
        $param = array(
            'from_date' => '01/01/2016',
            'to_date' => date('d/m/Y'),
            'ledger' => $ledger,
            'subledger' => $subledger
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_statement_as_on_date', $param, true));
        $mpdf->Output("statement_of_account" . date("d-m-Y").".pdf", 'I');
    }

    public function actionRecon_statement_pdf()
    {
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = Yii::app()->request->getParam('subledger');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_recon_statement', $param, true));

        $mpdf->Output("recon_statement_of_account" . date("d-m-Y").".pdf", 'I');
    }

    public function actionGlsummary_pdf()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $ledger = Yii::app()->request->getParam('ledger');

        $this->generateView('gl_summary', 0, $to_date, $ledger);

        $param = array(
            'to_date' => $to_date,
            'ledger' => $ledger,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_gl_summary', $param, true));

        $mpdf->Output("gl_summary" . date("d-m-Y").".pdf", 'I');
    }

    public function actionBalancesheet_excel()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $lastSavedid = 0;

        $accountingPeriod = FinanceVoucherType::generateAccountingperiod(date('Y-m-d'));
        $balanceQuery = 'SELECT SUM(VI.amount*VI.exchange_rate) AS amount FROM erp_finance_voucher_items VI LEFT JOIN erp_finance_voucher_head V ON VI.header_id = V.id LEFT JOIN erp_finance_legder L ON VI.ledger_id = L.id WHERE V.is_posted="Y" AND V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $to_date . '"';
        $grossProfitorloss = Yii::app()->db->createCommand($balanceQuery)->queryScalar();

        $voucherHead = array();
        $voucherHead['voucher_type'] = 11; //Year Closing
        $voucherHead['voucher_no'] = date('Y');
        $voucherHead['voucher_date'] = date('Y-m-d');
        $voucherHead['header_table_id'] = 0;
        $voucherHead['reference_no'] = 'System generated voucher';
        $voucherHead['is_posted'] = 'Y';
        $voucherHead['created_by'] = Yii::app()->user->id;
        $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

        $lastSavedid = $this->addVoucherhead($voucherHead);
        if ($lastSavedid > 0) {
            $this->addVoucheritems($lastSavedid, array('narration' => 'Current Year Profit', 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('current_year_profit')));
            $this->addVoucheritems($lastSavedid, array('narration' => 'Current Year Profit', 'amount' => -1 * $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('net_profit')));
        }

        $this->generateView('trial_balance', 0, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_balancesheet WHERE ledger_id=' . $id)->queryScalar();
        }

        $filename = "balancesheet" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Ledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';
        //We have 5 levels
        $balanceSheet = array('A' => 'Assets', 'L' => 'Equity & Liabilities');
        foreach ($balanceSheet as $key => $head) {
            $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND main_account_type="' . $key . '"', 'order' => 'main_account_type'));
            $debitTotal = $creditTotal = 0;
            foreach ($levelOne as $eachOne) {
                $accountTotal = accountTotal($eachOne->id);
                $debit = ($accountTotal > 0) ? $accountTotal : '';
                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                $debitTotal += $debit;
                $creditTotal += $credit;

                $data .= '<tr>
									<td>' . $eachOne->account_no . '</td>
									<td><b>' . $eachOne->description . '</b></td>
									<td class="text-right">' . $debit . '</td>
									<td class="text-right">' . $credit . '</td>
								</tr>';
                $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND parent_account=' . $eachOne->id));
                foreach ($levelTwo as $eachTwo) {
                    $accountTotal = accountTotal($eachTwo->id);
                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                    $debitTotal += $debit;
                    $creditTotal += $credit;

                    $data .= '<tr>
											<td>' . $eachTwo->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                    $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND parent_account=' . $eachTwo->id));
                    foreach ($levelThree as $eachThree) {
                        $accountTotal = accountTotal($eachThree->id);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += $debit;
                        $creditTotal += $credit;

                        $data .= '<tr>
											<td>' . $eachThree->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                        $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND parent_account=' . $eachThree->id));
                        foreach ($levelFour as $eachFour) {
                            $accountTotal = accountTotal($eachFour->id);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += $debit;
                            $creditTotal += $credit;

                            $data .= '<tr>
												<td>' . $eachFour->account_no . '</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
												<td class="text-right">' . $debit . '</td>
												<td class="text-right">' . $credit . '</td>
											</tr>';
                            $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND parent_account=' . $eachFour->id));
                            foreach ($levelFive as $eachFive) {
                                $accountTotal = accountTotal($eachFive->id);
                                $debit = ($accountTotal > 0) ? $accountTotal : '';
                                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                $debitTotal += $debit;
                                $creditTotal += $credit;

                                $data .= '<tr>
													<td>' . $eachFive->account_no . '</td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
													<td class="text-right">' . $debit . '</td>
													<td class="text-right">' . $credit . '</td>
												</tr>';
                            }
                        }
                    }
                }
            }

            $balance = $debitTotal - $creditTotal;
            $finalDebit = ($balance > 0) ? Yii::app()->numberFormatter->formatCurrency($balance, " ") : '';
            $finalCredit = ($balance < 0) ? Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") : '';
            $data .= '<tr>
								<td class="head" colspan="2" class="text-right"><b>Total ' . $head . '</b></td>
								<td class="head" class="text-right"><b>' . $finalDebit . '</b></td>
								<td class="head" class="text-right"><b>' . $finalCredit . '</b></td>
							</tr>';
        }
        $data .= '      </tbody>
					</table>
				</body>
			</html>';

        if ($lastSavedid > 0) {
            FinanceVoucherHead::model()->deletebypk($lastSavedid);
            FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $lastSavedid));
        }

        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionBalancesheet_pdf()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $lastSavedid = 0;

        $accountingPeriod = FinanceVoucherType::generateAccountingperiod(date('Y-m-d'));
        $balanceQuery = 'SELECT SUM(VI.amount*VI.exchange_rate) AS amount FROM erp_finance_voucher_items VI LEFT JOIN erp_finance_voucher_head V ON VI.header_id = V.id LEFT JOIN erp_finance_legder L ON VI.ledger_id = L.id WHERE V.is_posted="Y" AND V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $to_date . '"';
        $grossProfitorloss = Yii::app()->db->createCommand($balanceQuery)->queryScalar();

        $voucherHead = array();
        $voucherHead['voucher_type'] = 11; //Year Closing
        $voucherHead['voucher_no'] = date('Y');
        $voucherHead['voucher_date'] = date('Y-m-d');
        $voucherHead['header_table_id'] = 0;
        $voucherHead['reference_no'] = 'System generated voucher';
        $voucherHead['is_posted'] = 'Y';
        $voucherHead['created_by'] = Yii::app()->user->id;
        $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

        $lastSavedid = $this->addVoucherhead($voucherHead);
        if ($lastSavedid > 0) {
            $this->addVoucheritems($lastSavedid, array('narration' => 'Current Year Profit', 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('current_year_profit')));
            $this->addVoucheritems($lastSavedid, array('narration' => 'Current Year Profit', 'amount' => -1 * $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('net_profit')));
        }

        $this->generateView('trial_balance', 0, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_balancesheet WHERE ledger_id=' . $id)->queryScalar();
        }
        $data = array();

        //We have 5 levels
        $balanceSheet = array('A' => 'Assets', 'L' => 'Equity & Liabilities');
        foreach ($balanceSheet as $key => $head) {
            $data[$key] = '<tbody>';
            $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND main_account_type="' . $key . '"', 'order' => 'main_account_type'));
            $debitTotal = $creditTotal = 0;
            foreach ($levelOne as $eachOne) {
                $accountTotal = accountTotal($eachOne->id);
                $debit = ($accountTotal > 0) ? $accountTotal : '';
                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                $debitTotal += $debit;
                $creditTotal += $credit;

                $data[$key] .= '<tr>
									<td><b>' . $eachOne->account_no . '</b></td>
									<td><b>' . $eachOne->description . '</b></td>
									<td class="text-right">' . $debit . '</td>
									<td class="text-right">' . $credit . '</td>
								</tr>';
                $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND parent_account=' . $eachOne->id));
                foreach ($levelTwo as $eachTwo) {
                    $accountTotal = accountTotal($eachTwo->id);
                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                    $debitTotal += $debit;
                    $creditTotal += $credit;

                    $data[$key] .= '<tr>
											<td><b>' . $eachTwo->account_no . '</b></td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                    $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND parent_account=' . $eachTwo->id));
                    foreach ($levelThree as $eachThree) {
                        $accountTotal = accountTotal($eachThree->id);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += $debit;
                        $creditTotal += $credit;

                        $data[$key] .= '<tr>
											<td><b>' . $eachThree->account_no . '</b></td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                        $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND parent_account=' . $eachThree->id));
                        foreach ($levelFour as $eachFour) {
                            $accountTotal = accountTotal($eachFour->id);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += $debit;
                            $creditTotal += $credit;

                            $data[$key] .= '<tr>
												<td><b>' . $eachFour->account_no . '</b></td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
												<td class="text-right">' . $debit . '</td>
												<td class="text-right">' . $credit . '</td>
											</tr>';
                            $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND parent_account=' . $eachFour->id));
                            foreach ($levelFive as $eachFive) {
                                $accountTotal = accountTotal($eachFive->id);
                                $debit = ($accountTotal > 0) ? $accountTotal : '';
                                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                $debitTotal += $debit;
                                $creditTotal += $credit;

                                $data[$key] .= '<tr>
													<td><b>' . $eachFive->account_no . '</b></td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
													<td class="text-right">' . $debit . '</td>
													<td class="text-right">' . $credit . '</td>
												</tr>';
                            }
                        }
                    }
                }
            }
            $balance = $debitTotal - $creditTotal;
            $finalDebit = ($balance > 0) ? Yii::app()->numberFormatter->formatCurrency($balance, " ") : '';
            $finalCredit = ($balance < 0) ? Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") : '';
            $data[$key] .= '<tr>
								<td class="head" colspan="2" class="text-right"><b>Total ' . $head . '</b></td>
								<td class="head" class="text-right"><b>' . $finalDebit . '</b></td>
								<td class="head" class="text-right"><b>' . $finalCredit . '</b></td>
							</tr>';
            $data[$key] .= '</tbody>';
        }

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_balancesheet', array('data' => $data, 'to_date' => $to_date), true));
        $mpdf->Output("balancesheet" . date("d-m-Y").".pdf", 'I');

        if ($lastSavedid > 0) {
            FinanceVoucherHead::model()->deletebypk($lastSavedid);
            FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $lastSavedid));
        }
    }

    public function actionProfitorloss_pdf()
    {

        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $this->generateView('profit_or_loss', $from_date, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_profit_or_loss WHERE ledger_id=' . $id)->queryScalar();
        }

        function isCostosale($id)
        {
            return ($id == FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale')) ? true : false;
        }

        function getSymbol( $value ){
            return ( $value > 0 ) ? ' Dr' : ' Cr';
        }

        $data = array();

        //We have 5 levels
        $balanceSheet = array('I' => 'Income', 'E' => 'Expense');
        $totalIncome = 0;
        $cost_of_sale = 0;
        $totalExpense = 0;
        foreach ($balanceSheet as $key => $head) {
            $data[$key] = '<tbody>';
            $levelOne = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=1 AND main_account_type="' . $key . '"'));
            $totalAmount = 0;
            foreach ($levelOne as $eachOne) {
                $accountTotal = accountTotal($eachOne->id);
                $amount = abs($accountTotal);
                $totalAmount += $accountTotal;

                $data[$key] .= '<tr>
										<td><b>' . $eachOne->account_no . '</b></td>
										<td><b>' . $eachOne->description . '</b></td>
										<td class="text-right">' . $amount .getSymbol($accountTotal). '</td>
									</tr>';
                $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=2 AND parent_account=' . $eachOne->id));
                foreach ($levelTwo as $eachTwo) {
                    $accountTotal = accountTotal($eachTwo->id);
                    $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                    $amount = abs($accountTotal);
                    $totalAmount += $accountTotal;

                    $data[$key] .= '<tr>
												<td><b>' . $eachTwo->account_no . '</b></td>
												<td><b>&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
												<td class="text-right">' . $amount .getSymbol($accountTotal). '</td>
											</tr>';
                    if ($key == 'E' && isCostosale($eachTwo->id)) {
                        $cost_of_sale = $amount;
                    }

                    $levelThree = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=3 AND parent_account=' . $eachTwo->id));
                    foreach ($levelThree as $eachThree) {
                        $accountTotal = accountTotal($eachThree->id);
                        $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                        $amount = abs($accountTotal);
                        $totalAmount += $accountTotal;

                        $data[$key] .= '<tr>
														<td><b>' . $eachThree->account_no . '</b></td>
														<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
														<td class="text-right">' . $amount .getSymbol($accountTotal). '</td>
													</tr>';
                        if ($key == 'E' && isCostosale($eachThree->id)) {
                            $cost_of_sale = $amount;
                        }

                        $levelFour = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=4 AND parent_account=' . $eachThree->id));
                        foreach ($levelFour as $eachFour) {
                            $accountTotal = accountTotal($eachFour->id);
                            $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                            $amount = abs($accountTotal);
                            $totalAmount += $accountTotal;

                            $data[$key] .= '<tr>
															<td><b>' . $eachFour->account_no . '</b></td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
															<td class="text-right">' . $amount .getSymbol($accountTotal). '</td>
														</tr>';
                            if ($key == 'E' && isCostosale($eachFour->id)) {
                                $cost_of_sale = $amount;
                            }

                            $levelFive = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=5 AND parent_account=' . $eachFour->id));
                            foreach ($levelFive as $eachFive) {
                                $accountTotal = accountTotal($eachFive->id);
                                $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                                $amount = abs($accountTotal);
                                $totalAmount += $accountTotal;

                                $data[$key] .= '<tr>
																<td><b>' . $eachFive->account_no . '</b></td>
																<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
																<td class="text-right">' . $amount .getSymbol($accountTotal). '</td>
															</tr>';
                                if ($key == 'E' && isCostosale($eachFive->id)) {
                                    $cost_of_sale = $amount;
                                }

                            }
                        }
                    }
                }
                if ($key == 'I') {
                    $totalIncome = $totalAmount;
                }

                if ($key == 'E') {
                    $totalExpense = $totalAmount;
                }

            }

            $symbol = ($totalAmount > 0) ? 'Dr' : 'Cr';

            $data[$key] .= '<tr>
							<td colspan="2" class="text-right"><b>Total ' . $head . '</b></td>
							<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($totalAmount), " ") . '</b></td>
						</tr>';
            $data[$key] .= '</tbody>';
        }

        $footer = '<tr>
						<td colspan="2" class="text-right"><b>Total Cogs</b></td>
						<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($cost_of_sale, " ") . '</b></td>
					  </tr>
					  <tr>
						<td colspan="2" class="text-right"><b>Gross Profit</b></td>
						<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency((abs($totalIncome) - abs($cost_of_sale)), " ") . '</b></td>
					  </tr>';
        $state = (abs($totalIncome) - abs($totalExpense) > 0) ? 'Profit' : 'Loss';
        $color = (abs($totalIncome) - abs($totalExpense) > 0) ? '#97ff95' : '#ffa295';
        $value = abs($totalIncome) - abs($totalExpense);
        $footer .= '<tr style="background-color:' . $color . '">
						<td colspan="2" class="text-right"><b>Net ' . $state . '</b></td>
						<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($value), " ") . '</b></td>
						</tr>';

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_profit_or_loss', array('data' => $data, 'from_date' => $from_date, 'to_date' => $to_date, 'footer' => $footer), true));

        $mpdf->Output("profitorloss" . date("d-m-Y").".pdf", 'I');
    }

    public function actionProfitorloss_excel()
    {

        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $this->generateView('profit_or_loss', $from_date, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_profit_or_loss WHERE ledger_id=' . $id)->queryScalar();
        }

        function isCostosale($id)
        {
            return ($id == FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale')) ? true : false;
        }

        //We have 5 levels
        $balanceSheet = array('I' => 'Income', 'E' => 'Expense');
        $totalIncome = 0;
        $cost_of_sale = 0;
        $totalExpense = 0;
        $filename = "balancesheet" . date('dmYhis') . ".xls";
        $data = '<html>
						<head>
							<style>
								table{
									width:100%;
								}
								.head{
									background-color : yellow;
									font-weight: bold;
									font-size: 14px;
								}
								.total{
									text-align: right;
									font-weight: bold;
									font-size: 14px;
								}
							</style>
						</head>
						<body>
							<table border=1>
								<thead>
									<th class="head">#</th>
									<th class="head">Ledger</th>
									<th class="head">Amount</th>
								</thead>
								<tbody>';
        foreach ($balanceSheet as $key => $head) {
            $levelOne = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=1 AND main_account_type="' . $key . '"'));
            $totalAmount = 0;
            foreach ($levelOne as $eachOne) {
                $accountTotal = accountTotal($eachOne->id);
                $amount = abs($accountTotal);
                $totalAmount += $accountTotal;

                $data .= '<tr>
										<td><b>' . $eachOne->account_no . '</b></td>
										<td><b>' . $eachOne->description . '</b></td>
										<td class="text-right">' . $amount . '</td>
									</tr>';
                $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=2 AND parent_account=' . $eachOne->id));
                foreach ($levelTwo as $eachTwo) {
                    $accountTotal = accountTotal($eachTwo->id);
                    $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                    $amount = abs($accountTotal);
                    $totalAmount += $accountTotal;

                    $data .= '<tr>
												<td><b>' . $eachTwo->account_no . '</b></td>
												<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
												<td class="text-right">' . $amount . '</td>
											</tr>';
                    if ($key == 'E' && isCostosale($eachTwo->id)) {
                        $cost_of_sale = $amount;
                    }

                    $levelThree = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=3 AND parent_account=' . $eachTwo->id));
                    foreach ($levelThree as $eachThree) {
                        $accountTotal = accountTotal($eachThree->id);
                        $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                        $amount = abs($accountTotal);
                        $totalAmount += $accountTotal;

                        $data .= '<tr>
														<td><b>' . $eachThree->account_no . '</b></td>
														<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
														<td class="text-right">' . $amount . '</td>
													</tr>';
                        if ($key == 'E' && isCostosale($eachThree->id)) {
                            $cost_of_sale = $amount;
                        }

                        $levelFour = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=4 AND parent_account=' . $eachThree->id));
                        foreach ($levelFour as $eachFour) {
                            $accountTotal = accountTotal($eachFour->id);
                            $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                            $amount = abs($accountTotal);
                            $totalAmount += $accountTotal;

                            $data .= '<tr>
															<td><b>' . $eachFour->account_no . '</b></td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
															<td class="text-right">' . $amount . '</td>
														</tr>';
                            if ($key == 'E' && isCostosale($eachFour->id)) {
                                $cost_of_sale = $amount;
                            }

                            $levelFive = FinanceLegder::model()->findAll(array('condition' => 'type_of_account IN ("P") AND level=5 AND parent_account=' . $eachFour->id));
                            foreach ($levelFive as $eachFive) {
                                $accountTotal = accountTotal($eachFive->id);
                                $symbol = ($accountTotal > 0) ? 'Dr' : 'Cr';
                                $amount = abs($accountTotal);
                                $totalAmount += $accountTotal;

                                $data .= '<tr>
																<td><b>' . $eachFive->account_no . '</b></td>
																<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
																<td class="text-right">' . $amount . '</td>
															</tr>';
                                if ($key == 'E' && isCostosale($eachFive->id)) {
                                    $cost_of_sale = $amount;
                                }

                            }
                        }
                    }
                }
                if ($key == 'I') {
                    $totalIncome = $totalAmount;
                }

                if ($key == 'E') {
                    $totalExpense = $totalAmount;
                }

            }

            $symbol = ($totalAmount > 0) ? 'Dr' : 'Cr';

            $data .= '<tr>
							<td colspan="2" class="head"><b>Total ' . $head . '</b></td>
							<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($totalAmount), " ") . '</b></td>
						</tr>';
        }

        $data .= '<tr>
						<td colspan="2" class="head"><b>Total Cogs</b></td>
						<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency($cost_of_sale, " ") . '</b></td>
					  </tr>
					  <tr>
						<td colspan="2" class="head"><b>Gross Profit</b></td>
						<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency((abs($totalIncome) - abs($cost_of_sale)), " ") . '</b></td>
					  </tr>';
        $state = (abs($totalIncome) - abs($totalExpense) > 0) ? 'Profit' : 'Loss';
        $value = abs($totalIncome) - abs($totalExpense);
        $data .= '<tr>
						<td colspan="2" class="head"><b>Net ' . $state . '</b></td>
						<td class="head"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($value), " ") . '</b></td>
						</tr>';
        $data .= '      </tbody>
						</table>
					</body>
				</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function addVoucherhead($arr_items)
    {
        $model = new FinanceVoucherHead;
        $model->voucher_type = $arr_items['voucher_type'];
        $model->voucher_no = $arr_items['voucher_no'];
        $model->voucher_date = $arr_items['voucher_date'];
        $model->due_date = $model->voucher_date;
        $model->currency = ( isset($arr_items['currency']) ) ? $arr_items['currency'] : 'AED';
        $model->exchange_rate = ( isset($arr_items['exchange_rate']) && $arr_items['exchange_rate'] > 0 ) ? $arr_items['exchange_rate'] : 1;
        $model->header_table_id = $arr_items['header_table_id'];
        $model->reference_no = $arr_items['reference_no'];
        $model->is_posted =( isset($arr_items['is_posted']) ) ? $arr_items['is_posted'] : 'Y';
        $model->created_by = Yii::app()->user->id;
        $model->created_datetime = date('Y-m-d h:i:s');
        return ($model->save(false)) ? $model->id : 0; //exception
    }

    public function addVoucheritems($headerId, $arr_items)
    {
        $model = new FinanceVoucherItems;
        $model->header_id = $headerId;
        $model->ledger_id = $arr_items['ledger_id'];
        $model->subledger_id = $arr_items['subledger_id'];
        $model->narration = $arr_items['narration'];
        $model->amount = $arr_items['amount'];
        $model->save(false);
    }

    public function actionTrialbalance_pdf_detailed()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $this->generateView('trial_balance_detailed', 0, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_trialbalance_detailed WHERE ledger_id=' . (int) $id)->queryScalar();
        }

        function accountTotalsubledger($id, $sub)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_trialbalance_detailed WHERE ledger_id=' . (int) $id . ' AND subledger_id=' . (int) $sub)->queryScalar();
        }
        function getAllsubledgers($id)
        {
            return Yii::app()->db->createCommand('SELECT subledger_id AS id, subledger_name, subledger_no FROM erp_finance_trialbalance_detailed WHERE  ledger_id=' . (int) $id)->queryAll();
        }
        $data = '<tbody>';
        //We have 5 levels
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
        $debitTotal = $creditTotal = 0;
        foreach ($levelOne as $eachOne) {
            if ($eachOne->haveSubledger == 'Y') {
                $data .= '<tr>
									<td class="text-right">' . $eachOne->account_no . '</td>
									<td><b>' . $eachOne->description . '</b></td>
									<td class="text-right"></td>
									<td class="text-right"></td>
								</tr>';
                $allSublegders = getAllsubledgers($eachOne->id);
                if (!empty($allSublegders)) {
                    foreach ($allSublegders as $eachsub) {
                        $accountTotal = accountTotalsubledger($eachOne->id, $eachsub['id']);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += ($debit > 0) ? $debit : 0;
                        $creditTotal += ($credit > 0) ? $credit : 0;
                        $data .= '<tr>
										<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
										<td><small><i>' . $eachsub['subledger_name'] . '</i></small></td>
										<td class="text-right"><small><b><i>' . $debit . '</i></b></small></td>
										<td class="text-right"><small><b><i>' . $credit . '</i></b></small></td>
									</tr>';
                    }
                }

            } else {
                $accountTotal = accountTotal($eachOne->id);
                $debit = ($accountTotal > 0) ? $accountTotal : '';
                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                $debitTotal += ($debit > 0) ? $debit : 0;
                $creditTotal += ($credit > 0) ? $credit : 0;
                $data .= '<tr>
									<td class="text-right">' . $eachOne->account_no . '</td>
									<td><b>' . $eachOne->description . '</b></td>
									<td class="text-right">' . $debit . '</td>
									<td class="text-right">' . $credit . '</td>
								</tr>';
            }
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachOne->id));
            foreach ($levelTwo as $eachTwo) {
                if ($eachTwo->haveSubledger == 'Y') {
                    $data .= '<tr>
											<td class="text-right">' . $eachTwo->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
											<td class="text-right"></td>
											<td class="text-right"></td>
										</tr>';
                    $allSublegders = getAllsubledgers($eachTwo->id);
                    if (!empty($allSublegders)) {
                        foreach ($allSublegders as $eachsub) {
                            $accountTotal = accountTotalsubledger($eachTwo->id, $eachsub['id']);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += ($debit > 0) ? $debit : 0;
                            $creditTotal += ($credit > 0) ? $credit : 0;
                            $data .= '<tr>
												<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
												<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</small></i></td>
												<td class="text-right"><small><b><i>' . $debit . '</i></b></small></td>
												<td class="text-right"><small><b><i>' . $credit . '</i></b></small></td>
											</tr>';
                        }
                    }

                } else {
                    $accountTotal = accountTotal($eachTwo->id);
                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                    $debitTotal += ($debit > 0) ? $debit : 0;
                    $creditTotal += ($credit > 0) ? $credit : 0;
                    $data .= '<tr>
											<td class="text-right">' . $eachTwo->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                }
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachTwo->id));
                foreach ($levelThree as $eachThree) {
                    if ($eachThree->haveSubledger == 'Y') {
                        $data .= '<tr>
													<td class="text-right">' . $eachThree->account_no . '</td>
													<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
													<td class="text-right"></td>
													<td class="text-right"></td>
												</tr>';
                        $allSublegders = getAllsubledgers($eachThree->id);
                        if (!empty($allSublegders)) {
                            foreach ($allSublegders as $eachsub) {
                                $accountTotal = accountTotalsubledger($eachThree->id, $eachsub['id']);
                                $debit = ($accountTotal > 0) ? $accountTotal : '';
                                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                $debitTotal += ($debit > 0) ? $debit : 0;
                                $creditTotal += ($credit > 0) ? $credit : 0;
                                $data .= '<tr>
														<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
														<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</small></i></td>
														<td class="text-right"><small><b><i>' . $debit . '</i></b></small></td>
														<td class="text-right"><small><b><i>' . $credit . '</i></b></small></td>
													</tr>';
                            }
                        }

                    } else {
                        $accountTotal = accountTotal($eachThree->id);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += ($debit > 0) ? $debit : 0;
                        $creditTotal += ($credit > 0) ? $credit : 0;
                        $data .= '<tr>
											<td class="text-right">' . $eachThree->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                    }
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachThree->id));
                    foreach ($levelFour as $eachFour) {
                        if ($eachFour->haveSubledger == 'Y') {
                            $data .= '<tr>
														<td class="text-right">' . $eachFour->account_no . '</td>
														<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
														<td class="text-right"></td>
														<td class="text-right"></td>
													</tr>';
                            $allSublegders = getAllsubledgers($eachFour->id);
                            if (!empty($allSublegders)) {
                                foreach ($allSublegders as $eachsub) {
                                    $accountTotal = accountTotalsubledger($eachFour->id, $eachsub['id']);
                                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                    $debitTotal += ($debit > 0) ? $debit : 0;
                                    $creditTotal += ($credit > 0) ? $credit : 0;
                                    $data .= '<tr>
															<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
															<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</small></i></td>
															<td class="text-right"><small><b><i>' . $debit . '</i></b></small></td>
															<td class="text-right"><small><b><i>' . $credit . '</i></b></small></td>
														</tr>';
                                }
                            }

                        } else {
                            $accountTotal = accountTotal($eachFour->id);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += ($debit > 0) ? $debit : 0;
                            $creditTotal += ($credit > 0) ? $credit : 0;
                            $data .= '<tr>
												<td class="text-right">' . $eachFour->account_no . '</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
												<td class="text-right">' . $debit . '</td>
												<td class="text-right">' . $credit . '</td>
											</tr>';
                        }

                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachFour->id));
                        foreach ($levelFive as $eachFive) {
                            if ($eachFive->haveSubledger == 'Y') {
                                $data .= '<tr>
															<td class="text-right">' . $eachFive->account_no . '</td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
															<td class="text-right"></td>
															<td class="text-right"></td>
														</tr>';
                                $allSublegders = getAllsubledgers($eachFive->id);
                                if (!empty($allSublegders)) {
                                    foreach ($allSublegders as $eachsub) {
                                        $accountTotal = accountTotalsubledger($eachFive->id, $eachsub['id']);
                                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                        $debitTotal += ($debit > 0) ? $debit : 0;
                                        $creditTotal += ($credit > 0) ? $credit : 0;
                                        $data .= '<tr>
																<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
																<td><small><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</small></i></td>
																<td class="text-right"><small><b><i>' . $debit . '</i></b></small></td>
																<td class="text-right"><small><b><i>' . $credit . '</i></b></small></td>
															</tr>';
                                    }
                                }

                            } else {
                                $accountTotal = accountTotal($eachFive->id);
                                $debit = ($accountTotal > 0) ? $accountTotal : '';
                                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                $debitTotal += ($debit > 0) ? $debit : 0;
                                $creditTotal += ($credit > 0) ? $credit : 0;
                                $data .= '<tr>
													<td class="text-right">' . $eachFive->account_no . '</td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
													<td class="text-right">' . $debit . '</td>
													<td class="text-right">' . $credit . '</td>
												</tr>';
                            }
                        }
                    }
                }
            }
        }

        $data .= '<tr>
									<td colspan="2" class="text-right"><b>Total</b></td>
									<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($debitTotal, " ") . '</b></td>
									<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($creditTotal, " ") . '</b></td>
								</tr>';
        $data .= '  </tbody>';

        $param = array('data' => $data, 'to_date' => $to_date);
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_trial_balance', $param, true));

        $mpdf->Output("trialbalance" . date("d-m-Y").".pdf", 'I');
    }

    public function actionTrialbalance_excel_detailed()
    {

        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $this->generateView('trial_balance_detailed', 0, $to_date, 0);

        function accountTotal($id)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_trialbalance_detailed WHERE ledger_id=' . (int) $id)->queryScalar();
        }

        function accountTotalsubledger($id, $sub)
        {
            return (float) Yii::app()->db->createCommand('SELECT balance FROM erp_finance_trialbalance_detailed WHERE ledger_id=' . (int) $id . ' AND subledger_id=' . (int) $sub)->queryScalar();
        }
        function getAllsubledgers($id)
        {
            return Yii::app()->db->createCommand('SELECT subledger_id AS id, subledger_name, subledger_no FROM erp_finance_trialbalance_detailed WHERE ledger_id=' . (int) $id)->queryAll();
        }
        $filename = "trialbalance" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">#</th>
								<th class="head">Ledger</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
                            </thead>
							<tbody>';

        //We have 5 levels
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
        $debitTotal = $creditTotal = 0;
        foreach ($levelOne as $eachOne) {
            if ($eachOne->haveSubledger == 'Y') {
                $data .= '<tr>
									<td class="text-right">' . $eachOne->account_no . '</td>
									<td><b>' . $eachOne->description . '</b></td>
									<td class="text-right"></td>
									<td class="text-right"></td>
								</tr>';
                $allSublegders = getAllsubledgers($eachOne->id);
                if (!empty($allSublegders)) {
                    foreach ($allSublegders as $eachsub) {
                        $accountTotal = accountTotalsubledger($eachOne->id, $eachsub['id']);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += ($debit > 0) ? $debit : 0;
                        $creditTotal += ($credit > 0) ? $credit : 0;
                        $data .= '<tr>
										<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
										<td><i>' . $eachsub['subledger_name'] . '</i></td>
										<td class="text-right"><small><b>' . $debit . '</b></small></td>
										<td class="text-right"><small><b>' . $credit . '</b></small></td>
									</tr>';
                    }
                }

            } else {
                $accountTotal = accountTotal($eachOne->id);
                $debit = ($accountTotal > 0) ? $accountTotal : '';
                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                $debitTotal += ($debit > 0) ? $debit : 0;
                $creditTotal += ($credit > 0) ? $credit : 0;
                $data .= '<tr>
									<td class="text-right">' . $eachOne->account_no . '</td>
									<td><b>' . $eachOne->description . '</b></td>
									<td class="text-right">' . $debit . '</td>
									<td class="text-right">' . $credit . '</td>
								</tr>';
            }
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachOne->id));
            foreach ($levelTwo as $eachTwo) {
                if ($eachTwo->haveSubledger == 'Y') {
                    $data .= '<tr>
											<td class="text-right">' . $eachTwo->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
											<td class="text-right"></td>
											<td class="text-right"></td>
										</tr>';
                    $allSublegders = getAllsubledgers($eachTwo->id);
                    if (!empty($allSublegders)) {
                        foreach ($allSublegders as $eachsub) {
                            $accountTotal = accountTotalsubledger($eachTwo->id, $eachsub['id']);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += ($debit > 0) ? $debit : 0;
                            $creditTotal += ($credit > 0) ? $credit : 0;
                            $data .= '<tr>
												<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
												<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</i></td>
												<td class="text-right"><small><b>' . $debit . '</b></small></td>
												<td class="text-right"><small><b>' . $credit . '</b></small></td>
											</tr>';
                        }
                    }

                } else {
                    $accountTotal = accountTotal($eachTwo->id);
                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                    $debitTotal += ($debit > 0) ? $debit : 0;
                    $creditTotal += ($credit > 0) ? $credit : 0;
                    $data .= '<tr>
											<td class="text-right">' . $eachTwo->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachTwo->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                }
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachTwo->id));
                foreach ($levelThree as $eachThree) {
                    if ($eachThree->haveSubledger == 'Y') {
                        $data .= '<tr>
													<td class="text-right">' . $eachThree->account_no . '</td>
													<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
													<td class="text-right"></td>
													<td class="text-right"></td>
												</tr>';
                        $allSublegders = getAllsubledgers($eachThree->id);
                        if (!empty($allSublegders)) {
                            foreach ($allSublegders as $eachsub) {
                                $accountTotal = accountTotalsubledger($eachThree->id, $eachsub['id']);
                                $debit = ($accountTotal > 0) ? $accountTotal : '';
                                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                $debitTotal += ($debit > 0) ? $debit : 0;
                                $creditTotal += ($credit > 0) ? $credit : 0;
                                $data .= '<tr>
														<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
														<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</i></td>
														<td class="text-right"><small><b>' . $debit . '</b></small></td>
														<td class="text-right"><small><b>' . $credit . '</b></small></td>
													</tr>';
                            }
                        }

                    } else {
                        $accountTotal = accountTotal($eachThree->id);
                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                        $debitTotal += ($debit > 0) ? $debit : 0;
                        $creditTotal += ($credit > 0) ? $credit : 0;
                        $data .= '<tr>
											<td class="text-right">' . $eachThree->account_no . '</td>
											<td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachThree->description . '</b></td>
											<td class="text-right">' . $debit . '</td>
											<td class="text-right">' . $credit . '</td>
										</tr>';
                    }
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachThree->id));
                    foreach ($levelFour as $eachFour) {
                        if ($eachFour->haveSubledger == 'Y') {
                            $data .= '<tr>
														<td class="text-right">' . $eachFour->account_no . '</td>
														<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
														<td class="text-right"></td>
														<td class="text-right"></td>
													</tr>';
                            $allSublegders = getAllsubledgers($eachFour->id);
                            if (!empty($allSublegders)) {
                                foreach ($allSublegders as $eachsub) {
                                    $accountTotal = accountTotalsubledger($eachFour->id, $eachsub['id']);
                                    $debit = ($accountTotal > 0) ? $accountTotal : '';
                                    $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                    $debitTotal += ($debit > 0) ? $debit : 0;
                                    $creditTotal += ($credit > 0) ? $credit : 0;
                                    $data .= '<tr>
															<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
															<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</i></td>
															<td class="text-right"><small><b>' . $debit . '</b></small></td>
															<td class="text-right"><small><b>' . $credit . '</b></small></td>
														</tr>';
                                }
                            }

                        } else {
                            $accountTotal = accountTotal($eachFour->id);
                            $debit = ($accountTotal > 0) ? $accountTotal : '';
                            $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                            $debitTotal += ($debit > 0) ? $debit : 0;
                            $creditTotal += ($credit > 0) ? $credit : 0;
                            $data .= '<tr>
												<td class="text-right">' . $eachFour->account_no . '</td>
												<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFour->description . '</td>
												<td class="text-right">' . $debit . '</td>
												<td class="text-right">' . $credit . '</td>
											</tr>';
                        }

                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . $eachFour->id));
                        foreach ($levelFive as $eachFive) {
                            if ($eachFive->haveSubledger == 'Y') {
                                $data .= '<tr>
															<td class="text-right">' . $eachFive->account_no . '</td>
															<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
															<td class="text-right"></td>
															<td class="text-right"></td>
														</tr>';
                                $allSublegders = getAllsubledgers($eachFive->id);
                                if (!empty($allSublegders)) {
                                    foreach ($allSublegders as $eachsub) {
                                        $accountTotal = accountTotalsubledger($eachFive->id, $eachsub['id']);
                                        $debit = ($accountTotal > 0) ? $accountTotal : '';
                                        $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                        $debitTotal += ($debit > 0) ? $debit : 0;
                                        $creditTotal += ($credit > 0) ? $credit : 0;
                                        $data .= '<tr>
																<td class="text-right"><small>' . $eachsub['subledger_no'] . '</small></td>
																<td><i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachsub['subledger_name'] . '</i></td>
																<td class="text-right"><small><b>' . $debit . '</b></small></td>
																<td class="text-right"><small><b>' . $credit . '</b></small></td>
															</tr>';
                                    }
                                }

                            } else {
                                $accountTotal = accountTotal($eachFive->id);
                                $debit = ($accountTotal > 0) ? $accountTotal : '';
                                $credit = ($accountTotal < 0) ? abs($accountTotal) : '';
                                $debitTotal += ($debit > 0) ? $debit : 0;
                                $creditTotal += ($credit > 0) ? $credit : 0;
                                $data .= '<tr>
													<td class="text-right">' . $eachFive->account_no . '</td>
													<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachFive->description . '</td>
													<td class="text-right">' . $debit . '</td>
													<td class="text-right">' . $credit . '</td>
												</tr>';
                            }
                        }
                    }
                }
            }
        }

        $data .= '<tr>
									<td colspan="2" class="text-right"><b>Total</b></td>
									<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($debitTotal, " ") . '</b></td>
									<td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($creditTotal, " ") . '</b></td>
								</tr>';
        $data .= '      </tbody>
					</table>
				</body>
			</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionLoadtemplate()
    {
        $voucher_type = $_POST['voucher_type'];
        $payment_method = $_POST['payment_method'];

        $template = FinanceVoucherType::loadtemplate($voucher_type, $payment_method);
        $this->render('voucher_template', array('template' => $template));
    }

    public function actionAllocate()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_allocation', array('model' => new FinanceAllocation));
    }

    public function actionGetallocationdata()
    {
        $ledger = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $allocationDebit = 'CREATE OR REPLACE VIEW erp_finance_allocated_debit AS SELECT
								V.id AS voucher_id,
								VI.id AS voucher_item_id,
								V.voucher_no, VI.amount*VI.exchange_rate AS amount,
								IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
								(VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
							FROM erp_finance_voucher_items VI
							LEFT JOIN erp_finance_voucher_head V ON V.id = VI.header_id
							LEFT JOIN erp_finance_allocation_items AI ON AI.voucher_item_id = VI.id
							WHERE V.is_posted ="Y" AND VI.amount > 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
							GROUP BY VI.id';
        $allocationCredit = 'CREATE OR REPLACE VIEW erp_finance_allocated_credit AS SELECT
							V.id AS voucher_id,
							VI.id AS voucher_item_id,
							V.voucher_no, ABS(VI.amount*VI.exchange_rate) AS amount,
							IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
							ABS(VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
						FROM erp_finance_voucher_items VI
						LEFT JOIN erp_finance_voucher_head V ON V.id = VI.header_id
						LEFT JOIN erp_finance_allocation_items AI ON AI.voucher_item_id = VI.id
						WHERE V.is_posted ="Y" AND VI.amount < 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
						GROUP BY VI.id';
        Yii::app()->db->createCommand($allocationDebit)->execute();
        Yii::app()->db->createCommand($allocationCredit)->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM erp_finance_allocated_debit WHERE balance > 0')->queryAll();
        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM erp_finance_allocated_credit WHERE balance > 0')->queryAll();

        $tables = array();
        $tables['debit'] = '';
        $tables['credit'] = '';

        if ($debitAllocatables[0]['value'] != '') {
            // $allItems = FinanceVoucherItems::model()->findAll(array('condition' => 'id IN (' . $debitAllocatables[0]['value'] . ')'));
//            $debitAllocatablesVariable=rtrim($debitAllocatables[0]['value'], ",");
//            $allItems = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.id IN (' . $debitAllocatablesVariable . ')', 'order' => 'parent.voucher_date ASC'));
            $allItems = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.id IN (' . $debitAllocatables[0]['value'] . ')', 'order' => 'parent.voucher_date ASC'));
            foreach ($allItems as $i => $each) {
                $balance = Yii::app()->db->createCommand('SELECT ROUND(balance,2) AS balance FROM erp_finance_allocated_debit WHERE voucher_item_id=' . $each->id)->queryScalar();
                $tables['debit'] .= '<tr>
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('class'=>'debit','value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id); calculateValue();')) . '</td>
										<td>' . $each->parent->fullvoucher . '</td>
										<td>' . $each->parent->vtype->description . '</td>
										<td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
										<td>' . $balance . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each->header_id) .
                CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each->id) .
                CHtml::hiddenfield('Debit[' . $i . '][balance]', $balance) .
                CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
            }

            $tables['debit'] .= '<tr>
									<td colspan="5" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
        } else {
            $tables['debit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
        }

        if ($creditAllocatables[0]['value'] != '') {
            // $allItems = FinanceVoucherItems::model()->findAll(array('condition' => 'id IN (' . $creditAllocatables[0]['value'] . ')'));
//            $creditAllocatablesVariable=rtrim($creditAllocatables[0]['value'], ",");
//            $allItems = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.id IN (' . $creditAllocatablesVariable . ')', 'order' => 'parent.voucher_date ASC'));
            $allItems = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.id IN (' . $creditAllocatables[0]['value'] . ')', 'order' => 'parent.voucher_date ASC'));
            foreach ($allItems as $i => $each) {
                $balance = Yii::app()->db->createCommand('SELECT ROUND(balance,2) AS balance FROM erp_finance_allocated_credit WHERE voucher_item_id=' . $each->id)->queryScalar();
                $head=FinanceVoucherHead::model()->findByPk($each['header_id']);
                if($head->voucher_type==8)
                {
                $ref=' : '.PurchasingInvoice::model()->findByPk($head->voucher_no)->invoice_no;    
                }
                else {
                $ref=$each->parent->reference_no;    
                }
                $tables['credit'] .= '<tr>
										<td>' . CHtml::CheckBox('Credit[' . $i . '][check]', '', array('class'=>'credit','value' => $each->id, 'onChange' => 'copyValue("Credit", this, this.id); calculateValue();')) . '</td>
										<td>' . $each->parent->fullvoucher . $ref . '</td>
										<td>' . $each->parent->vtype->description . '</td>
										<td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
										<td>' . $balance . '</td>
										<td>' . CHtml::hiddenfield('Credit[' . $i . '][voucher_id]', $each->header_id) .
                CHtml::hiddenfield('Credit[' . $i . '][voucher_item_id]', $each->id) .
                CHtml::hiddenfield('Credit[' . $i . '][balance]', $balance) .
                CHtml::textfield('Credit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Credit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
            }

            $tables['credit'] .= '<tr>
									<td colspan="5" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
        } else {
            $tables['credit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
        }
        echo json_encode($tables);
    }

    public function actionSaveallocation()
    {

        $creditTotal = (float) $_POST['total_credit'];
        $debitTotal = (float) $_POST['total_debit'];
        if (($debitTotal > 0 && $creditTotal > 0) && $creditTotal == $debitTotal) {

            $model = new FinanceAllocation;
            $model->attributes = $_POST['FinanceAllocation'];
            $model->allocation_date = date('Y-m-d');
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');

            $totalDebit = $totalCredit = 0;
            $debitArray = $creditArray = array();
            foreach ($_POST['Debit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $debitArray[$i] = new FinanceAllocationItems;
                    $debitArray[$i]->header_id = 0;
                    $debitArray[$i]->voucher_id = $each['voucher_id'];
                    $debitArray[$i]->voucher_item_id = $each['voucher_item_id'];
                    $debitArray[$i]->amount = $each['amount'];
                    $totalDebit += (float)$each['amount'];
                }
            }
            foreach ($_POST['Credit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $creditArray[$i] = new FinanceAllocationItems;
                    $creditArray[$i]->header_id = 0;
                    $creditArray[$i]->voucher_id = $each['voucher_id'];
                    $creditArray[$i]->voucher_item_id = $each['voucher_item_id'];
                    $creditArray[$i]->amount = -1 * $each['amount'];
                    $totalCredit += (float)$each['amount'];
                }
            }
            $epsilon = 0.01; 
            if (abs($totalCredit-$totalDebit)<$epsilon) {
                if ($model->validate()) {
                    echo json_encode(array('status' => 'success'));
                    $model->amount = $totalCredit;
                    $model->save();
                    foreach ($debitArray as $each) {
                        $each->header_id = $model->id;
                        $each->save(false);
                        FinanceVoucherHead::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                    }
                    foreach ($creditArray as $each) {
                        $each->header_id = $model->id;
                        $each->save(false);
                        FinanceVoucherHead::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                    }
                } else {
                    echo CActiveForm::validate($model, '', false);
                }
            } else {
                echo json_encode(array('Totals are not matching!'));
            }
        } else {
            echo json_encode(array('Totals are not matching!'));
        }
    }

    public function generateAgeing($to_date, $ledger, $subledger)
    {

        $one = array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date);
        $two = array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days')));
        $three = array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days')));
        $four = array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days')));
        $five = array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days')));

        $dates_array = array('0_to_30' => $one, '31_to_60' => $two, '61_to_90' => $three, '91_to_120' => $four, 'greaterthan_120' => $five);

        foreach ($dates_array as $key => $each_date_pair) {
            $condition = 'VH.is_posted="Y" AND VI.ledger_id = "' . (int) $ledger . '"';
            if ($subledger > 0) {
                $condition .= 'AND VI.subledger_id = "' . (int) $subledger . '"';
            }

            $query = 'CREATE OR REPLACE VIEW erp_finance_ageing_' . $key . ' AS SELECT
						L.id AS ledger_id,
						S.id AS subledger_id,
						L.description AS ledger,
						IFNULL(S.description, "No Subledger") AS subledger,
						SUM(VI.amount*VI.exchange_rate) AS amount
					FROM erp_finance_voucher_items VI
					LEFT JOIN erp_finance_voucher_head VH ON VH.id = VI.header_id
					LEFT JOIN erp_finance_legder L ON VI.ledger_id = L.id
					LEFT JOIN erp_finance_subledger S ON VI.subledger_id = S.id
					WHERE VH.due_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '" AND
					' . $condition . '
					GROUP BY VI.subledger_id, VI.ledger_id';
            Yii::app()->db->createCommand($query)->execute();
        }

        $query = 'SELECT
					ledger_id,
					ledger,
					subledger_id,
					subledger,
					SUM(0_30) AS 0_30,
					SUM(31_60) AS 31_60,
					SUM(61_90) AS 61_90,
					SUM(91_120) AS 91_120,
					SUM(greater_120) AS greater_120
				FROM ( SELECT
					ledger_id,
					ledger,
					subledger_id,
					subledger,
					amount AS 0_30,
					0 AS 31_60,
					0 AS 61_90,
					0 AS 91_120,
					0 AS greater_120
				FROM erp_finance_ageing_0_to_30
				UNION
				SELECT
					ledger_id,
					ledger,
					subledger_id,
					subledger,
					0 AS 0_30,
					amount AS 31_60,
					0 AS 61_90,
					0 AS 91_120,
					0 AS greater_120
				FROM erp_finance_ageing_31_to_60
				UNION
				SELECT
					ledger_id,
					ledger,
					subledger_id,
					subledger,
					0 AS 0_30,
					0 AS 31_60,
					amount AS 61_90,
					0 AS 91_120,
					0 AS greater_120
				FROM erp_finance_ageing_61_to_90
				UNION
				SELECT
					ledger_id,
					ledger,
					subledger_id,
					subledger,
					0 AS 0_30,
					0 AS 31_60,
					0 AS 61_90,
					amount AS 91_120,
					0 AS greater_120
				FROM erp_finance_ageing_91_to_120
				UNION
				SELECT
					ledger_id,
					ledger,
					subledger_id,
					subledger,
					0 AS 0_30,
					0 AS 31_60,
					0 AS 61_90,
					0 AS 91_120,
					amount AS greater_120
				FROM erp_finance_ageing_greaterthan_120 ) AS A GROUP BY A.subledger ORDER BY A.subledger ASC';

        return Yii::app()->db->createCommand($query)->queryAll();
    }

    public function actionAging_excel()
    {
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $ledger = (int) Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');

        $one = array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date);
        $two = array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days')));
        $three = array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days')));
        $four = array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days')));
        $five = array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days')));

        $dates_array = array('0_to_30' => $one, '31_to_60' => $two, '61_to_90' => $three, '91_to_120' => $four, 'greaterthan_120' => $five);

        foreach ($dates_array as $key => $each_date_pair) {
            
            $condition = 'V.is_posted="Y" AND VI.ledger_id = "' . (int) $ledger . '"';
            
            if ( $subledger > 0 ) {
                $condition .= 'AND VI.subledger_id = "' . (int) $subledger . '"';
            }

            if( $ledger == FinanceSystemAccountsMapping::getSystemdefault('debtors') ){
                $condition .= ' AND VI.amount > 0';
            }else{
                $condition .= ' AND VI.amount < 0';
            }

            $query = 'CREATE OR REPLACE VIEW {{finance_ageing_' . $key . '}} AS SELECT
                                   VI.ledger_id AS ledger_id,
                                   VI.subledger_id AS subledger_id,
                                   IFNULL(S.description, "No Subledger") AS subledger,
                                   V.id AS voucher_id,
                                   V.voucher_date AS voucher_date,
                                   V.due_date AS due_date,
                                   V.reference_no AS reference_no,
                                   VI.narration AS narration,
                                   VI.id AS voucher_item_id,
                                   V.voucher_no, 
                                   ABS(VI.amount*VI.exchange_rate) AS total_amount,
                                   IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                                   ABS(VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS amount
                               FROM {{finance_voucher_items}} VI
                               LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                               LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                               LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                               WHERE V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '" AND
                               ' . $condition . '
                               GROUP BY VI.id, VI.subledger_id';

            Yii::app()->db->createCommand($query)->execute();
        }
   
        $query = 'SELECT
        ledger_id,
        subledger_id,
        subledger,
        SUM(0_30) AS 0_30,
        SUM(31_60) AS 31_60,
        SUM(61_90) AS 61_90,
        SUM(91_120) AS 91_120,
        SUM(greater_120) AS greater_120
    FROM ( SELECT
        ledger_id,
        subledger_id,
        subledger,
        SUM(amount) AS 0_30,
        0 AS 31_60,
        0 AS 61_90,
        0 AS 91_120,
        0 AS greater_120
    FROM {{finance_ageing_0_to_30}} GROUP BY subledger_id 
    UNION
    SELECT
        ledger_id,
        subledger_id,
        subledger,
        0 AS 0_30,
        SUM(amount) AS 31_60,
        0 AS 61_90,
        0 AS 91_120,
        0 AS greater_120
    FROM {{finance_ageing_31_to_60}} GROUP BY subledger_id 
    UNION
    SELECT
        ledger_id,
        subledger_id,
        subledger,
        0 AS 0_30,
        0 AS 31_60,
        SUM(amount) AS 61_90,
        0 AS 91_120,
        0 AS greater_120
    FROM {{finance_ageing_61_to_90}} GROUP BY subledger_id 
    UNION
    SELECT
        ledger_id,
        subledger_id,
        subledger,
        0 AS 0_30,
        0 AS 31_60,
        0 AS 61_90,
        SUM(amount) AS 91_120,
        0 AS greater_120
    FROM {{finance_ageing_91_to_120}} GROUP BY subledger_id 
    UNION
    SELECT
        ledger_id,
        subledger_id,
        subledger,
        0 AS 0_30,
        0 AS 31_60,
        0 AS 61_90,
        0 AS 91_120,
        SUM(amount) AS greater_120
    FROM {{finance_ageing_greaterthan_120}} GROUP BY subledger_id ) AS A GROUP BY A.subledger_id ORDER BY A.subledger ASC';

$aging_report =  Yii::app()->db->createCommand($query)->queryAll();

        $filename = "agingreport" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
								<th class="head">#</th>
								<th class="head">Subledger</th>
								<th class="head">0-30</th>
								<th class="head">31-60</th>
								<th class="head">61-90</th>
								<th class="head">91-120</th>
								<th class="head"> > 120</th>
								<th class="head">Total</th>
                            </thead>
							<tbody>';
                            $grand_total = 0;
                            $one = 0;
                            $two = 0;
                            $three = 0;
                            $four = 0;
                            $five = 0;
                            foreach ($aging_report as $i => $each):
                                $total = $each['0_30'] + $each['31_60'] + $each['61_90'] + $each['91_120'] + $each['greater_120'];
                                $one += $each['0_30'];
                                $two += $each['31_60'];
                                $three += $each['61_90'];
                                $four += $each['91_120'];
                                $five += $each['greater_120'];
                                $grand_total += $total;
                                if( $total != 0 ) :
                                    $data .= '<tr>
                                                    <td>' . ($i + 1) . '</td>
                                                    <td>' . $each['subledger'] . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['0_30']), " ")  . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['31_60']), " ") . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['61_90']), " ")  . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['91_120']), " ")  . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each['greater_120']), " ")  . '</td>
                                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($total), " ") . '</td>
                                                </tr>';
                                endif;
                            endforeach;
                    
                            $data .= '<tr>
                                                                <td colspan="2" class="text-right"><b>Total</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($one), " ") . '</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($two), " ") . '</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($three), " ") . '</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($four), " ") . '</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($five), " ") . '</b></td>
                                                                <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grand_total), " ") . '</b></td>
                                                            </tr>';
                            $data .= ' </tbody>;
						</table>
					</body>
				</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionAging_pdf()
    {
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $ledger = (int) Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        
        $param = array(
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4-L');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_aging_report', $param, true));
        $mpdf->Output("aging" . date("d-m-Y").".pdf", 'I');
    }

    public function actionGetallocationdata_for_receipt()
    {
        $ledger = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $allocationDebit = 'CREATE OR REPLACE VIEW erp_finance_allocated_debit AS SELECT
								V.id AS voucher_id,
								VI.id AS voucher_item_id,
								V.voucher_no, VI.amount,
								IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
								(VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
							FROM erp_finance_voucher_items VI
							LEFT JOIN erp_finance_voucher_head V ON V.id = VI.header_id
							LEFT JOIN erp_finance_allocation_items AI ON AI.voucher_item_id = VI.id
							WHERE V.is_posted ="Y" AND VI.amount > 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
							GROUP BY VI.id';

        Yii::app()->db->createCommand($allocationDebit)->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM erp_finance_allocated_debit WHERE balance > 0')->queryAll();

        $tables = array();
        $tables['debit'] = '';

        if ($debitAllocatables[0]['value'] != '') {
            $allItems = FinanceVoucherItems::model()->findAll(array('condition' => 'id IN (' . $debitAllocatables[0]['value'] . ')'));
            foreach ($allItems as $i => $each) {
                $balance = Yii::app()->db->createCommand('SELECT balance AS balance FROM erp_finance_allocated_debit WHERE voucher_item_id=' . $each->id)->queryScalar();
                $tables['debit'] .= '<tr>
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id); calculateValue();')) . '</td>
										<td>' . $each->parent->fullvoucher . '</td>
										<td>' . $each->parent->vtype->description . '</td>
										<td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
										<td>' . $balance . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each->header_id) .
                CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each->id) .
                CHtml::hiddenfield('Debit[' . $i . '][balance]', $balance) .
                CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
            }

            $tables['debit'] .= '<tr>
									<td colspan="5" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
        } else {
            $tables['debit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
        }

        echo json_encode($tables);
    }

    public function actionSavereceiptvoucher()
    {

        function savableDate($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        function validate_receipt_data($arr_of_data)
        {
            $response = array('status' => true);
            if ((int) $arr_of_data['customer_subledger_id'] == 0):
                $response['errors'][] = 'Customer Cannot Blank!';
                $response['status'] = false;
            endif;
            if ((float) $arr_of_data['amount'] == 0):
                $response['errors'][] = 'Amount Cannot Blank!';
                $response['status'] = false;
            endif;
            if ((int) $arr_of_data['receipt_ledger'] == 0):
                $response['errors'][] = 'Receipt Ledger Cannot Blank!';
                $response['status'] = false;
            endif;
            if (FinanceLegder::is_subledger_account((int) $arr_of_data['receipt_ledger']) && (int) $arr_of_data['receipt_subledger_id'] == 0):
                $response['errors'][] = 'Receipt Subledger Cannot Blank!';
                $response['status'] = false;
            endif;
            if (trim($arr_of_data['general_narration']) == ''):
                $response['errors'][] = 'Narration Cannot Blank!';
                $response['status'] = false;
            endif;
            $totalAllocation = 0;
            if (!empty($arr_of_data['Debit'])) {
                foreach ($arr_of_data['Debit'] as $each):
                    $totalAllocation += (float) $each['amount'];
                endforeach;
            }
            if ($totalAllocation > 0 && $totalAllocation != (float) $arr_of_data['amount']):
                $response['errors'][] = 'Amounts are not matching!';
                $response['status'] = false;
            endif;
            $response['total_allocation'] = $totalAllocation;
            return $response;
        }

        $validation = validate_receipt_data($_POST);

        $voucher_date = (count(explode('/', $_POST['FinanceVoucherHead']['voucher_date'])) == 3) ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['FinanceVoucherHead']['voucher_date']))) : date('Y-m-d');
        $savableVoucher = savableDate($voucher_date);
        if ($validation['status'] && $savableVoucher) {
            echo json_encode(array('status' => 'success'));

            $modelHead = new FinanceVoucherHead;
            $modelHead->voucher_date = $voucher_date;
            $modelHead->due_date = $modelHead->voucher_date;
            $modelHead->voucher_type = 2; //Receipt Voucher
            $modelHead->voucher_no = FinanceVoucherType::getVoucherno($modelHead->voucher_type, true);
            $modelHead->reference_no = $_POST['FinanceVoucherHead']['reference_no'];
            $modelHead->payment_method = 1; //Cash default
            $modelHead->cheque_cleared = 'Y'; //Cleared Default , Assuming payment method is Cash
            $modelHead->is_posted = 'Y';
            $modelHead->total_voucher_amount = (float) $_POST['amount'];
            $modelHead->created_by = Yii::app()->user->id;
            $modelHead->created_datetime = date('Y-m-d h:i:s');

            if ($modelHead->save(false)) {
                //Debtor Entry (Credit Entry)
                $modelDebtor = new FinanceVoucherItems;
                $modelDebtor->header_id = $modelHead->id;
                $modelDebtor->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('debtors');
                $modelDebtor->subledger_id = $_POST['customer_subledger_id'];
                $modelDebtor->narration = $_POST['general_narration'];
                $modelDebtor->amount = -1 * $_POST['amount'];
                $modelDebtor->save(false);
                //Cash in Hand Entry (Debit Entry)
                $modelCash = new FinanceVoucherItems;
                $modelCash->header_id = $modelHead->id;
                $modelCash->ledger_id = $_POST['receipt_ledger'];
                $modelCash->subledger_id = (int) $_POST['receipt_subledger_id'];
                $modelCash->narration = $_POST['general_narration'];
                $modelCash->amount = $_POST['amount'];
                $modelCash->save(false);
            }

            if ($validation['total_allocation'] > 0) {

                $modelAllocation = new FinanceAllocation;
                $modelAllocation->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('debtors');
                $modelAllocation->subledger_id = $_POST['customer_subledger_id'];
                $modelAllocation->allocation_date = date('Y-m-d');
                $modelAllocation->created_by = Yii::app()->user->id;
                $modelAllocation->created_date_time = date('Y-m-d h:i:s');

                $totalDebit = 0;
                if ($modelAllocation->save(false)) {

                    $modelAllocationitems = new FinanceAllocationItems;
                    $modelAllocationitems->header_id = $modelAllocation->id;
                    $modelAllocationitems->voucher_id = $modelHead->id;
                    $modelAllocationitems->voucher_item_id = $modelDebtor->id;
                    $modelAllocationitems->amount = -1 * $_POST['amount'];
                    $modelAllocationitems->save(false);

                    foreach ($_POST['Debit'] as $eachItem):
                        if ($eachItem['amount'] > 0):

                            $modelAllocationitems = new FinanceAllocationItems;
                            $modelAllocationitems->header_id = $modelAllocation->id;
                            $modelAllocationitems->voucher_id = $eachItem['voucher_id'];
                            $modelAllocationitems->voucher_item_id = $eachItem['voucher_item_id'];
                            $modelAllocationitems->amount = (float) $eachItem['amount'];
                            $modelAllocationitems->save(false);

                            FinanceVoucherHead::model()->updateBypk($eachItem['voucher_id'], array( 'is_allocated' => 'Y' ));

                            $totalDebit += (float) $eachItem['amount'];
                        endif;
                    endforeach;
                }

                $modelAllocation->amount = $totalDebit;
                $modelAllocation->update();

                $modelHead->is_allocated = 'Y';
                $modelHead->update();
            }
        } else {
            if (!$savableVoucher) {
                $validation['errors'][] = 'Vouchers in the selected date is audited!';
            }

            echo json_encode($validation['errors']);
        }
    }

    public function actionCashreport_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4-L');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_cash_report', $param, true));

        $mpdf->Output("cash_report" . date("d-m-Y").".pdf", 'I');

    }

    public function actionCashreport_excel()
    {

        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');

        $ledger = (int) $_GET['ledger'];

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id=' . $ledger;
            $condition_for_opening .= ' AND I.ledger_id=' . $ledger;
        }

        $openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount*I.exchange_rate) AS amount FROM erp_finance_voucher_items I LEFT JOIN erp_finance_voucher_head H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));

        $filename = "cashreport" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
							<thead>
								<th class="head">Date</th>
								<th class="head">Voucher No</th>
								<th class="head">Voucher Ref</th>
								<th class="head">Subledger</th>
								<th class="head">Narration</th>
								<th class="head">Dr</th>
								<th class="head">Cr</th>
								<th class="head">Balance</th>
                            </thead>
							<tbody>';
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';
        $data .= '<tr>
						<td colspan="5"><b>Opening Balance</b></td>
						<td>' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? $previousBalance : ''), " ") . '</td>
						<td>' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? $previousBalance : ''), " ") . '</td>
						<td>' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
					</tr>';
        $totalDebit = 0;
        $totalCredit = 0;

        foreach ($items as $each) {

            $debit = ( $each->amount > 0 ) ? $each->amount*$each->exchange_rate : '';
            $credit = ( $each->amount < 0 ) ? abs($each->amount*$each->exchange_rate) : '';

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $totalDebit += $debit;
            $totalCredit += $credit;

            $data .= '<tr>
								<td>' . $each->parent->voucher_date . '</td>
								<td>' . $each->parent->fullvoucher . '</td>
								<td>' . $each->parent->reference_no . '</td>
								<td>' . $each->get_any_subledger() . '</td>
								<td>' . $each->narration . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
								<td>' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . ' ' . $symbol . '</td>
							</tr>';
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $data .= '<tr>
                    <td colspan="5" class="text-right"><b>Total</b></td>
                    <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($totalDebit," ").'</b></td>
                    <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($totalCredit)," ").'</b></td>
                    <td></td>
                </tr>';
        $data .= '<tr>
						<td class="head" colspan="6"><b>Closing Balance</b></td>
						<td class="head">' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</td>
					</tr>';
        $data .= '      </tbody>
					</table>
				</body>
			</html>';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionVat_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_vat_report', $param, true));

        $mpdf->Output("vat_report" . date("d-m-Y").".pdf", 'I');
    }

    public function actionVat_excel(){
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
       
        $from_date = ( count(explode('/',$from_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date)))  : date('Y-m-d');
        $to_date = ( count(explode('/',$to_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date)))  : date('Y-m-d');

        $condition = 'ledger.main_account_type="A" AND ledger.classification="VAT" AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
        $items = FinanceVoucherItems::model()->with('parent', 'ledger')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
    
        $filename = "vatreport" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <h4>VAT(Asset)</h4>
                        <table border=1>
                            <thead>
                                <tr>
                                    <th class="head">Date</th>
                                    <th class="head">Voucher No</th>
                                    <th class="head">Voucher Ref</th>
                                    <th class="head">Subledger</th>
                                    <th class="head">Narration</th> 
                                    <th class="head">Value</th> 
                                    <th class="head">VAT</th> 
                                </tr>
                            </thead>
                            <tbody>';

                            $total_asset = 0; 
                            $total_value = 0;
                            foreach ( $items as $each ){  
                               $data .= '<tr>   
                                            <td>'.date("d/m/Y",strtotime($each->parent->voucher_date)).'</td>
                                            <td>'.$each->parent->fullvoucher.'</td>
                                            <td>'.$each->parent->reference_no.'</td>
                                            <td>'.$each->get_any_subledger().'</td>
                                            <td>'.$each->narration.'</td>
                                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(($each->parent->debit_total*$each->exchange_rate)," ").'</td>
                                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(($each->amount*$each->exchange_rate)," ").'</td>
                                        </tr>';
                                        
                                        $total_asset += ($each->amount*$each->exchange_rate);
                                        $total_value += ($each->parent->debit_total*$each->exchange_rate);
                            } 
                            
                        $data .= '<tr>
                                    <td colspan="5" class="text-right"><b>Total</b></td>
                                    <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($total_value," ").'</b></td>
                                    <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($total_asset," ").'</b></td>
                                </tr>';
                        $data .= '      </tbody>
                                    </table>';

                    //Liability
                    $condition = 'ledger.main_account_type="L" AND ledger.classification="VAT" AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
                    $items = FinanceVoucherItems::model()->with('parent', 'ledger')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
                    
                    $data .= '
                            <h4>VAT(Liability)</h4>
                        <table border=1>
                                    <thead>
                                        <tr>
                                            <th class="head">Date</th>
                                            <th class="head">Voucher No</th>
                                            <th class="head">Voucher Ref</th>
                                            <th class="head">Subledger</th>
                                            <th class="head">Narration</th> 
                                            <th class="head">Value</th> 
                                            <th class="head">VAT</th> 
                                        </tr>
                                    </thead>
                                    <tbody>';
        
                                    $total_liability = 0; 
                                    $total_value = 0;
                                    foreach ( $items as $each ){  
                                       $data .= '<tr>   
                                                    <td>'.date("d/m/Y",strtotime($each->parent->voucher_date)).'</td>
                                                    <td>'.$each->parent->fullvoucher.'</td>
                                                    <td>'.$each->parent->reference_no.'</td>
                                                    <td>'.$each->get_any_subledger().'</td>
                                                    <td>'.$each->narration.'</td>
                                                    <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(($each->parent->debit_total*$each->exchange_rate)," ").'</td>
                                                    <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(((-1*$each->amount)*$each->exchange_rate)," ").'</td>
                                                </tr>';
                                                
                                                $total_liability += ($each->amount*$each->exchange_rate);
                                                $total_value += ($each->parent->debit_total*$each->exchange_rate);
                                    } 
                                    
                                $data .= '<tr>
                                            <td colspan="5" class="text-right"><b>Total</b></td>
                                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency($total_value," ").'</b></td>
                                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(-1*$total_liability," ").'</b></td>
                                        </tr>';
                                $data .= '      </tbody>
                                            </table>';

                    $data .=       '</body>
                            </html>';
                        header("Content-type: application/vnd.ms-excel");
                        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
                        echo $data;
                        Yii::app()->end();
                        return;
                }

    public function actionCreateexpense()
    {
        $expense_id = (int) Yii::app()->request->getParam('expense_id');
        $model = new FinanceVoucherHead;
        $model->voucher_type = 1; //payment Voucher
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_expense_voucher', array('model' => $model, 'expense_id' => $expense_id));
    }

    public function actionSubledger_summary_pdf(){
        
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $subledger = (int) Yii::app()->request->getParam('subledger');

        $from_date = ( count(explode('/',$from_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date)))  : date('Y-m-d');
        $to_date = ( count(explode('/',$to_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date)))  : date('Y-m-d');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'subledger' => $subledger,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('print_subledger_summary', $param, true));

        $mpdf->Output("subledger_summary" . date("d-m-Y").".pdf", 'I');
    }

    public function actionSubledger_summary_excel(){
        
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $subledger = (int) Yii::app()->request->getParam('subledger');

        $from_date = ( count(explode('/',$from_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date)))  : date('Y-m-d');
        $to_date = ( count(explode('/',$to_date)) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date)))  : date('Y-m-d');

        $query = 'SELECT ledger_id
            FROM erp_finance_voucher_items
            WHERE subledger_id='.(int) $subledger.' GROUP BY ledger_id';
        
        $legders = ( $subledger > 0 ) ? Yii::app()->db->createCommand($query)->queryAll() : array();

        $filename = "subledgerreport" . date('dmYhis') . ".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>';

        if( !empty( $legders ) ) {
            foreach( $legders as $i => $each ) :
                $ledgerModel = FinanceLegder::model()->findBypk($each['ledger_id']);
                if( $i > 0 )
                    $data .= '<br>';
        $data .='<table border=1>
                    <thead>
                        <tr><td colspan="6" class="head"><b>'.$ledgerModel->description.'</b></td></tr>
                        <tr>
                            <th class="head">Date</th>
                            <th class="head">Voucher No</th>
                            <th class="head">Narration</th> 
                            <th class="head">Dr</th> 
                            <th class="head">Cr</th> 
                            <th class="head">Balance</th>  
                        </tr>
                    </thead>';
            
                        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
                        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "'.$from_date.'"';
                        
                        $condition .= ' AND t.ledger_id='.$ledgerModel->id;
                        $condition_for_opening .= ' AND I.ledger_id='.$ledgerModel->id;
                        
                        $condition .= ' AND t.subledger_id='.$subledger;
                        $condition_for_opening .= ' AND I.subledger_id='.$subledger;
                        
                        $openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount*I.exchange_rate) AS amount FROM erp_finance_voucher_items I LEFT JOIN erp_finance_voucher_head H ON I.header_id = H.id WHERE '.$condition_for_opening.' ')->queryScalar();
                        $items = FinanceVoucherItems::model()->with('parent')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
                
                        $previousBalance = $openingBalance;
                        $closingBalance = $openingBalance;
                        $symbol = ( $previousBalance > 0 ) ? 'Dr' : 'Cr';
                    
                $data .= '<tbody>    
                            <tr>
                                <td colspan="5"><b>Opening Balance</b></td>
                                <td>'.Yii::app()->numberFormatter->formatCurrency(abs($previousBalance)," ").' '.$symbol.'</td>
                            </tr>';
                    
                        $total_debit = 0;
                        $total_credit = 0;
                        foreach ( $items as $each ){
                            
                            $debit = ( $each->amount > 0 ) ? $each->amount*$each->exchange_rate : '';
                            $credit = ( $each->amount < 0 ) ? abs($each->amount*$each->exchange_rate) : '';
                            $running = $debit - $credit + $previousBalance;
                            $previousBalance = $running;
                            $symbol = ( $running > 0 ) ? 'Dr' : 'Cr';
                            $closingBalance +=  ( $debit - $credit );

                            $total_debit += $debit;
                            $total_credit += $credit;
                            
                    
                            $data .= '<tr>      
                                        <td>'.date("d/m/Y",strtotime($each->parent->voucher_date)).'</td>
                                        <td>'.$each->parent->fullvoucher.'</td>
                                        <td>'.$each->narration.'</td>
                                        <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency($debit," ").'</td>
                                        <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(abs($credit)," ").'</td>
                                        <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(abs($running)," ")." ".$symbol.'</td>
                                    </tr>';
                        } 
                        
                        $symbol = ( $closingBalance > 0 ) ? 'Dr' : 'Cr';
                    
                $data .= '<tr>
                            <td colspan="3" class="total"><b>Total</b></td>
                            <td class="total"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($total_debit)," ").'</b></td>
                            <td class="total"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($total_credit)," ").'</b></td>
                            <td class="total"></td>
                        </tr>
                        <tr>
                            <td colspan="5" class="total"><b>Closing Balance</b></td>
                            <td class="total"><b>'.Yii::app()->numberFormatter->formatCurrency(abs($closingBalance)," ").' '.$symbol.'</b></td>
                        </tr>
                    </tbody>
                </table>';

            endforeach; 
        }else{
            $data .= '<table border=1>
                    <thead>
                        <tr>
                            <th class="head">Date</th>
                            <th class="head">Voucher No</th>
                            <th class="head">Narration</th> 
                            <th class="head">Dr</th> 
                            <th class="head">Cr</th> 
                            <th class="head">Balance</th>  
                        </tr>
                    </thead>
                    <tbody>
                        <tr><td colspan="6" class="total">No Data</td></tr>
                    </tbody>
                </table>';
        }

        $data .=       '</body>
                </html>';
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            echo $data;
            Yii::app()->end();
            return;
    }

    public function actionGetexchange_rate(){
        $currency = (int) $_POST['currency'];
        echo (float) MasCurrency::model()->findBypk($currency)->exchange_rate;
    }

    public function actionGetorders(){
        $term = trim($_GET['term']);
        $subledger_id = trim($_REQUEST['subledger_id']);
        if($subledger_id>0)
        {
        $subledger=FinanceSubledger::model()->findBypk($subledger_id);
        if($subledger->subledger_type_id==1)
        {
        $customer_id=$subledger->parent_id;
        $condition='id LIKE "%' . $term . '%" AND customer_id='.$customer_id;
        }
        else {
        $condition='id LIKE "%' . $term . '%"';    
        }
        }
        else {
        $condition='id LIKE "%' . $term . '%"';        
        }
        $allOrders = Order::model()->findAll( array( 'select' => 'id, customer_id,currency,grand_total', 'condition' => $condition, 'limit' => 500 ) );
        $response = array();
        foreach( $allOrders as $i => $each ){
            $response[$i]['value'] = $each->id;
            $response[$i]['label'] = $each->id.' | '.$each->customer->customer_name.' | '.$each->currencyname->currency_code.' '.$each->grand_total;
        }

        echo json_encode($response);
    }

    public function actionPostvoucher(){
		
		function savableDate( $date ){
			$last_closed_year = FinanceAuditClose::lastClosed();
			$voucherDate_array = explode('-', $date);
			$voucherYear = $voucherDate_array[0];
			return ( $voucherYear <= $last_closed_year ) ? false : true;
		}

		function matchTotal( $debit, $credit, $voucherType ){
			return ( ( $debit > 0 && $credit > 0 && $debit == $credit )) ? true : false;
		}

		$others = $modelItems = array();
		$model = new FinanceVoucherHead;
		$i = $debitTotal = $creditTotal = 0;
		$scene = 'new';
		if( (int) $_POST['FinanceVoucherHead']['id'] > 0 ){
			$model = $model->findBypk( (int) $_POST['FinanceVoucherHead']['id']);
                                                              $model->is_posted = 'Y';
			$scene = 'edit';
		}else{
			$model->is_posted = 'Y';
			$model->created_by = Yii::app()->user->id;
			$model->created_datetime = date('Y-m-d h:i:s');
		}
        $model->attributes = $_POST['FinanceVoucherHead'];
        $model->general_narration = $_POST['FinanceVoucherHead']['general_narration'];
		$model->voucher_date = ( count( explode('/', $_POST['FinanceVoucherHead']['voucher_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['voucher_date']) )) : date('Y-m-d');
		$model->due_date = $model->voucher_date;
		$savableVoucher = savableDate($model->voucher_date);
		$voucherType =  $_POST['FinanceVoucherHead']['voucher_type'];
		$model->total_voucher_amount = 0;
		
		$voucherModel = FinanceVoucherType::model()->findBypk( (int) $voucherType ); 
		if( in_array($voucherType, array(1, 2)) ){ //Receipt or Payment
			if( $_POST['FinanceVoucherHead']['payment_method'] == 4 ) //card
				$model->scenario = 'card';
			else if( $_POST['FinanceVoucherHead']['payment_method'] == 2 ){ //cheque
				$model->scenario = ( $voucherType == 2 ) ? 'chequereceived' : 'chequepaid';
				$model->realisation_date = ( count( explode('/', $_POST['FinanceVoucherHead']['realisation_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['realisation_date']) )) : date('Y-m-d');
				$model->cheque_date = ( count( explode('/', $_POST['FinanceVoucherHead']['cheque_date']) ) == 3 ) ? date('Y-m-d', strtotime( str_replace('/', '-', $_POST['FinanceVoucherHead']['cheque_date']) )) : date('Y-m-d');
				$model->cheque_cleared = 'N';
			}else if( $_POST['FinanceVoucherHead']['payment_method'] == 3 ){ //bank
				if( $voucherType == 2 ) //Bank
					$model->scenario = 'bank'; //
			}else //cash
				$model->scenario = 'cash';
		}else
			$model->scenario = 'simpleVoucher';
		$valid = $model->validate() && $savableVoucher;	
		if( is_array( $_POST['FinanceVoucherItems'] ) ){
			foreach( $_POST['FinanceVoucherItems'] as $eachItem ){
                //Input filter
                $eachItem['debit'] = str_replace(',', '', $eachItem['debit']);
                $eachItem['credit'] = str_replace(',', '', $eachItem['credit']);

                $modelItems[$i] = new FinanceVoucherItems;
                $modelItems[$i]->attributes = $eachItem;
                $modelItems[$i]->brand_id = $eachItem['brand_id'];
				$modelItems[$i]->header_id = 0;
				if( $eachItem['ledger_id'] > 0 ){
					$ledger = FinanceLegder::model()->findBypk( $eachItem['ledger_id'] );
					if( $ledger->haveSubledger == 'Y' )
						$modelItems[$i]->scenario = 'havesubledger';
				}
				$modelItems[$i]->narration = ( trim($eachItem['narration']) == '') ? $_POST['FinanceVoucherHead']['general_narration'] : $eachItem['narration'];
				if( $eachItem['debit'] > 0 ){
					$modelItems[$i]->amount = $eachItem['debit'];
					$debitTotal += $eachItem['debit']*$eachItem['exchange_rate'];
				}else{
					$modelItems[$i]->amount = -1*$eachItem['credit'];
					$creditTotal += $eachItem['credit']*$eachItem['exchange_rate'];
				}
				$valid = $modelItems[$i]->validate() && $valid;	
				$i++;
			}
		}
		
		// $matchingTotals = matchTotal($debitTotal, $creditTotal, $voucherType);

		// if( $valid && count($modelItems) > 0 && $matchingTotals ){
        if( $valid && count($modelItems) > 0){
			if( $model->isNewRecord )
				$model->voucher_no = FinanceVoucherType::getVoucherno( $model->voucher_type, true);
			$model->total_voucher_amount = $debitTotal;
			// if( $model->scenario == 'simpleVoucher' )
			// 	$model->reference_no = $voucherModel->code.'/'.$model->voucher_no;
			$model->save();
			FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $model->id));
			foreach( $modelItems as $each ){
				$each->header_id = $model->id;
                $each->save();
                $each->update_currency_code();
			}
			echo json_encode( array( 'status' => 'success', 'scene' => $scene ) );
		}else{
			$error1 = json_decode(CActiveForm::validate($model, '', false), true);
			$error2 = json_decode(CActiveForm::validateTabular($modelItems, '', false), true);
			if( !$savableVoucher )
				$others[] = 'All the vouchers in this year are closed';
			if( count($modelItems) == 0 )
				$others[] = 'Please add ledger entries!';
			// if( !$matchingTotals )
			// 	$others[] = 'Totals are not matching!';
			echo CJSON::encode(array_merge_recursive($error1, $others, $error2));
		}
	}

    public function actionAllocateVoucher()
    {
    Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
     $this->render('create_allocation_voucher', array('model' => new FinanceAllocation));
    }
    
    public function actionVehicle_list()
    {

        $term = trim($_GET['term']);
        $response = array();

        if ( $term != '' ) {
            $subledgers = FinanceSubledger::model()->findAll(array('condition' => 'description LIKE "%' . $term . '%" AND subledger_type_id=4', 'limit' => 200));
            foreach ($subledgers as $i => $each) {
                $response[$i]['label'] = $each->description;
                $response[$i]['value'] = $each->id;
            }
        }
        
        echo json_encode($response);
    }
    
    public function actionAdd_payment() 
    {
    $model=new FinanceVoucherHead;   
    Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    $this->render('add_payment_voucher', array( 'model' => $model ) );
    }
    public function actionAdd_receipt() 
    {
    $model=new FinanceVoucherHead;   
    Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    $this->render('add_receipt_voucher', array( 'model' => $model ) );
    }     
    
    public function actionGetallocationdataFromReceipt()
    {
        $ledger = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $allocationDebit = 'CREATE OR REPLACE VIEW erp_finance_allocated_debit AS SELECT
								V.id AS voucher_id,
								VI.id AS voucher_item_id,
								V.voucher_no, VI.amount*VI.exchange_rate AS amount,
								IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
								(VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
							FROM erp_finance_voucher_items VI
							LEFT JOIN erp_finance_voucher_head V ON V.id = VI.header_id
							LEFT JOIN erp_finance_allocation_items AI ON AI.voucher_item_id = VI.id
							WHERE V.is_posted ="Y" AND VI.amount > 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
							GROUP BY VI.id';
        Yii::app()->db->createCommand($allocationDebit)->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM erp_finance_allocated_debit WHERE balance > 0')->queryAll();
        $tables = array();
        $tables['debit'] = '';
        $tables['credit'] = '';

        if ($debitAllocatables[0]['value'] != '') {
            // $allItems = FinanceVoucherItems::model()->findAll(array('condition' => 'id IN (' . $debitAllocatables[0]['value'] . ')'));
            $allItems = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.id IN (' . $debitAllocatables[0]['value'] . ')', 'order' => 'parent.voucher_date ASC'));
            foreach ($allItems as $i => $each) {
                $balance = Yii::app()->db->createCommand('SELECT ROUND(balance,2) AS balance FROM erp_finance_allocated_debit WHERE voucher_item_id=' . $each->id)->queryScalar();
                $tables['debit'] .= '<tr>
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('class'=>'debit','value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id); calculateValue();')) . '</td>
										<td>' . $each->parent->fullvoucher . '</td>
                                                                                <td>' . $each->parent->reference_no . '</td>
										<td>' . $each->parent->vtype->description . '</td>
										<td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
										<td>' . $balance . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each->header_id) .
                CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each->id) .
                CHtml::hiddenfield('Debit[' . $i . '][balance]', $balance) .
                CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
            }

            $tables['debit'] .= '<tr>
									<td colspan="6" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
        } else {
            $tables['debit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
        }

        echo json_encode($tables);
    }
        public function actionGetallocationdataFromPayment()
    {
        $ledger = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $allocationCredit = 'CREATE OR REPLACE VIEW erp_finance_allocated_credit AS SELECT
							V.id AS voucher_id,
							VI.id AS voucher_item_id,
							V.voucher_no, ABS(VI.amount*VI.exchange_rate) AS amount,
							IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
							ABS(VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
						FROM erp_finance_voucher_items VI
						LEFT JOIN erp_finance_voucher_head V ON V.id = VI.header_id
						LEFT JOIN erp_finance_allocation_items AI ON AI.voucher_item_id = VI.id
						WHERE V.is_posted ="Y" AND VI.amount < 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
						GROUP BY VI.id';
        
        Yii::app()->db->createCommand($allocationCredit)->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM erp_finance_allocated_credit WHERE balance > 0')->queryAll();
        $tables = array();
        $tables['debit'] = '';
        $tables['credit'] = '';

        if ($creditAllocatables[0]['value'] != '') {
            // $allItems = FinanceVoucherItems::model()->findAll(array('condition' => 'id IN (' . $debitAllocatables[0]['value'] . ')'));
            $allItems = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.id IN (' . $creditAllocatables[0]['value'] . ')', 'order' => 'parent.voucher_date ASC'));
            foreach ($allItems as $i => $each) {
                $balance = Yii::app()->db->createCommand('SELECT ROUND(balance,2) AS balance FROM erp_finance_allocated_credit WHERE voucher_item_id=' . $each->id)->queryScalar();
                $tables['credit'] .= '<tr>
										<td>' . CHtml::CheckBox('Credit[' . $i . '][check]', '', array('class'=>'credit','value' => $each->id, 'onChange' => 'copyValue("Credit", this, this.id); calculateValue();')) . '</td>
										<td>' . $each->parent->fullvoucher . '</td>
                                                                                <td>' . $each->parent->reference_no . '</td>
										<td>' . $each->parent->vtype->description . '</td>
										<td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
										<td>' . $balance . '</td>
										<td>' . CHtml::hiddenfield('Credit[' . $i . '][voucher_id]', $each->header_id) .
                CHtml::hiddenfield('Credit[' . $i . '][voucher_item_id]', $each->id) .
                CHtml::hiddenfield('Credit[' . $i . '][balance]', $balance) .
                CHtml::textfield('Credit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Credit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
            }

            $tables['credit'] .= '<tr>
									<td colspan="6" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
        } else {
            $tables['credit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
        }

        echo json_encode($tables);
    }
}
