<?php
$pendingUrl = $this->createUrl('/features/feature/pendingFeatures');
$ackUrl     = $this->createUrl('/features/feature/acknowledgeFeature');
$csrf       = Yii::app()->request->csrfToken;
$csrfName   = Yii::app()->request->csrfTokenName;

$js = <<<JS
function loadPendingFeatures() {
    $.getJSON('$pendingUrl', function(res){
        if (!res.success || !res.data || res.data.length === 0) return;
        showFeatureQueue(res.data);
    });
}

function showFeatureQueue(list) {
    var i = 0;
    function next() {
        if (i >= list.length) return;
        showPopup(list[i++], next);
    }
    next();
}

function showPopup(item, callback) {
    var tpl = $('#featurePopupTemplate').children().clone();

    tpl.find('#popup_feature_desc').text(item.feature_desc);
    tpl.find('#popup_module').text(item.module);
    tpl.find('#popup_submodule').text(item.sub_module);
    tpl.find('#popup_detail_id').val(item.detail_id || '');

    var checkbox = tpl.find('.ack-checkbox');
    var saveBtn = tpl.find('.save-btn');

    checkbox.on('change', function() {
        saveBtn.prop('disabled', !checkbox.is(':checked'));
    });

    saveBtn.on('click', function() {
        var postData = {};
        postData['detail_id'] = item.detail_id;
        postData['$csrfName'] = '$csrf';

        saveBtn.prop('disabled', true).text('Saving...');

        $.post('$ackUrl', postData, function(r) {
            if (r && r.success) {
                tpl.modal('hide');
                tpl.remove();
                if (typeof callback === 'function') callback();
            } else {
                alert(r.message ? r.message : 'Could not acknowledge.');
                saveBtn.prop('disabled', false).text('Save');
            }
        }, 'json').fail(function() {
            alert('Network error.');
            saveBtn.prop('disabled', false).text('Save');
        });
    });

    tpl.find('.close-btn').on('click', function(){
        tpl.modal('hide');
        tpl.remove();
        if (typeof callback === 'function') callback();
    });

    $('body').append(tpl);
    tpl.modal({
        backdrop: 'static',
        keyboard: false
    });
}

$(document).ready(function(){
    loadPendingFeatures();
});
JS;

Yii::app()->clientScript->registerScript('feature_popup_js', $js, CClientScript::POS_END);
