<?php

/**
 * This is the model class for table "{{mas_feature_details}}".
 *
 * The followings are the available columns in table '{{mas_feature_details}}':
 * @property integer $id
 * @property integer $feature_id
 * @property integer $user_id
 * @property string $accept_status
 * @property string $accepted_date_time
 * @property string $created_date_time
 */
class MasFeatureDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_feature_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('feature_id, user_id, accepted_date_time, created_date_time', 'required'),
			array('feature_id, user_id', 'numerical', 'integerOnly'=>true),
			array('accept_status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, feature_id, user_id, accept_status, accepted_date_time, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'feature_id' => 'Feature',
			'user_id' => 'User',
			'accept_status' => 'Accept Status',
			'accepted_date_time' => 'Accepted Date Time',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('feature_id',$this->feature_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('accept_status',$this->accept_status,true);
		$criteria->compare('accepted_date_time',$this->accepted_date_time,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasFeatureDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
