<?php

/**
 * This is the model class for table "{{features_operations}}".
 *
 * The followings are the available columns in table '{{features_operations}}':
 * @property integer $id
 * @property string $operations_type
 * @property integer $file_no
 * @property string $operation_date
 * @property integer $level
 * @property integer $header_id
 * @property integer $user_id
 * @property string $user_name
 * @property string $operation_status
 * @property string $notes
 */
class FeaturesOperations extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{features_operations}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('operations_type, file_no, operation_date, level, header_id, user_id, user_name, operation_status', 'required'),
			array('file_no, level, header_id, user_id', 'numerical', 'integerOnly'=>true),
			array('operations_type', 'length', 'max'=>50),
			array('user_name', 'length', 'max'=>255),
			array('operation_status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, operations_type, file_no, operation_date, level, header_id, user_id, user_name, operation_status, notes, is_active, modified_by, modified_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'operations_type' => 'Operations Type',
			'file_no' => 'File No',
			'operation_date' => 'Operation Date',
			'level' => 'Level',
			'header_id' => 'Header',
			'user_id' => 'User',
			'user_name' => 'User Name',
			'operation_status' => 'Operation Status',
			'notes' => 'Notes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('operations_type',$this->operations_type,true);
		$criteria->compare('file_no',$this->file_no);
		$criteria->compare('operation_date',$this->operation_date,true);
		$criteria->compare('level',$this->level);
		$criteria->compare('header_id',$this->header_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('user_name',$this->user_name,true);
		$criteria->compare('operation_status',$this->operation_status,true);
		$criteria->compare('notes',$this->notes,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FeaturesOperations the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
