<?php
class ApprovelevelController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array( 'listleveldetail', 'listlevelusers','SaveFeaturesApprovals', 'Saveapprove', 'Savereject', 'GetApprovalHistory', 'GetApprovalHistoryList'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionlistleveldetail() {   
        $max_level =Yii::app()->request->getparam('max_level'); 
        $operations_type =Yii::app()->request->getparam('operations_type'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_list', array('max_level' => $max_level,'operations_type' => $operations_type,'employee_id'=>$employee_id,'row'=>$row), false, true); 
    }

    public static function actionlistlevelusers() {
        $level_id =Yii::app()->request->getparam('level_id');
        $row_field_id =Yii::app()->request->getparam('row_field_id');
        $model_approval = new FeaturesApproveLevel();
        $users_list = $model_approval->getUsersByLevel($level_id);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        echo CHtml::activedropDownList($model_approval, '[' . $row_field_id . ']level_'.$level_id.'_authority', $users_list, array('class' => 'searchdropdown class_level_1_user', 'empty' => 'Select', 'style' => "width:250px;", 'onchange' => 'checkuserexist(this.id,1)'));
    }

    public static function SaveFeaturesApprovals($dataArray) {
        if ($dataArray) {
            Yii::import('application.modules.features.models.FeaturesApproveLevel');
            foreach ($dataArray as $approvalKey => $approvalData) {
                $featuresApproveLevel[$approvalKey] = new FeaturesApproveLevel();
                //if ($approvalData && $approvalData['max_level']>0) {
                    if ($approvalData['id']>0) {
                        $featuresApproveLevel[$approvalKey] = FeaturesApproveLevel::model()->findByPk($approvalData['id']);
                        $featuresApproveLevel[$approvalKey]['updated_by'] = Yii::app()->user->id;
                        $featuresApproveLevel[$approvalKey]['updated_date_time'] = date('Y-m-d h:i:s');
                    } else {
                        $featuresApproveLevel[$approvalKey]['created_by'] = Yii::app()->user->id;
                        $featuresApproveLevel[$approvalKey]['created_date_time'] = date('Y-m-d h:i:s');
                    }
                    $featuresApproveLevel[$approvalKey]['operations_type'] = $approvalData['operations_type']?$approvalData['operations_type']:'';
                    $featuresApproveLevel[$approvalKey]['max_level'] = $approvalData['max_level']?$approvalData['max_level']:0;
                    if ($approvalData['max_level'] == 0 || $approvalData['max_level'] == '') {
                        switch ($approvalData['operations_type']) {
                            case 'LE':
                                $model = new Lead();
                                $condition = 't.isActive="Y" AND t.lead_type="sale" AND file.is_approved = "N" AND file.current_process_status="L"';
                                $model = $model->with('file', 'customer', 'crmUser', 'leadowner')->findAll(array('condition' => $condition));
                                foreach ($model as $row) {
                                    MasterFile::model()->updateByPk($row['file_id'], array('current_process_status' => "L", 'is_approved' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                                }
                                break;
                            case 'QU':
                                $model = new Quotes();
                                $condition = 't.isActive="Y" AND (file.current_process_status="Q") ';
                                $model = $model->with('customer', 'file', 'currencyname', 'leadowner')->findAll(array('condition' => $condition));
                                foreach ($model as $row) {
                                    MasterFile::model()->updateByPk($row['file_id'], array('current_process_status' => "Q", 'is_approved' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                                }
                                break;
                            case 'SO':
                                $model = new Order();
                                $condition = 't.isActive="Y" AND (file.current_process_status="O" OR file.current_process_status="PD" OR file.current_process_status="PI") AND t.order_type ="sales"';
                                $model = $model->with('customer', 'file', 'currencyname')->findAll(array('condition' => $condition));
                                foreach ($model as $row) {
                                    MasterFile::model()->updateByPk($row['file_id'], array('current_process_status' => "O", 'is_approved' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                                }
                                break;
                            case 'SRO':
                                $model = new Order();
                                $condition = 't.isActive="Y" AND t.order_type ="service"';
                                $model = $model->with('customer', 'file', 'currencyname')->findAll(array('condition' => $condition));
                                foreach ($model as $row) {
                                    MasterFile::model()->updateByPk($row['file_id'], array('current_process_status' => "O", 'is_approved' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                                }
                                break;
                            case 'PR':
                                $model = new PurchasingRequisition();
                                $condition = 't.isActive="Y" AND t.convert_status!="0"';
                                $model = $model->findAll(array('condition' => $condition));
                                foreach ($model as $row) {
                                    MasterFile::model()->updateByPk($row['file_id'], array('current_process_status' => "P_R", 'is_approved' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                                }
                                break;
                            case 'PE':
                                $model = new PurchasingEnquiry();
                                $condition = " t.convert_status='Y'";
                                $sql = "SELECT t.id, t.vendor_id, t.title, t.enquiry_date, t.required_date, t.convert_status, t.isActive, t.file_id, IFNULL(A.nonlocal_qty,0) AS nonlocal_qty 
                                FROM `erp_purchasing_enquiry` t 
                                LEFT JOIN (SELECT purchasing_enquiry_id, IFNULL(COUNT(S.id),0) AS nonlocal_qty 
                                    FROM erp_purchasing_enquiry_stock_item PEI 
                                    LEFT JOIN erp_store S ON (PEI.stock_item_id =S.id) 
                                    GROUP BY purchasing_enquiry_id)A ON t.id = A.purchasing_enquiry_id 
                                WHERE A.purchasing_enquiry_id=t.id";
                                $SQL1 = $sql . " AND ($condition) ";
                                $model = Yii::app()->db->createCommand($SQL1)->queryAll();
                                foreach ($model as $row) {
                                    MasterFile::model()->updateByPk($row['file_id'], array('current_process_status' => "P_E", 'is_approved' => $approveStatus, 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                                }
                                break;
                            case 'PO':
                                $model = new PurchasingOrder();
                                $condition = "((file.current_process_status = 'P_O' OR t.convert_status = 'Y')  AND completed!='C')";
                                $sql = "SELECT t.id, t.project_ids, t.project_classification_id, t.ticket_id, t.file_id, t.title, t.order_date, t.required_date, t.expected_delivery_date, t.completed, t.stock_grand_total, t.nonstock_grandtotal, t.exchange_rate, t.convert_status, t.vendor_id, t.service_invoice, t.vendor_contact_id, t.created_by, currencyname.currency_code, vendor_details.vendor_name, t.approved_level, file.current_process_status, file.is_approved, IFNULL(A.nonlocal_qty,0) AS nonlocal_qty
                                FROM `erp_purchasing_order` t
                                LEFT JOIN (SELECT purchasing_order_id, IFNULL(COUNT(S.id),0) AS nonlocal_qty 
                                    FROM erp_purchasing_order_stock_item PEI
                                    LEFT JOIN erp_store S ON (PEI.stock_item_id =S.id) 
                                    GROUP BY purchasing_order_id)A ON t.id = A.purchasing_order_id
                                LEFT JOIN {{master_file}} file ON file.id=t.file_id
                                LEFT JOIN {{vendor}} vendor_details ON vendor_details.id=t.vendor_id
                                LEFT JOIN {{mas_currency}} currencyname ON currencyname.id=t.currency
                                WHERE A.purchasing_order_id=t.id";
                                $SQL1 = $sql . " AND ($condition) ";
                                $model = Yii::app()->db->createCommand($SQL1)->queryAll();
                                foreach ($model as $row) {
                                    MasterFile::model()->updateByPk($row['file_id'], array('current_process_status' => "P_O", 'is_approved' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                                }
                                break;
                            default:
                                // Fallback case
                                break;
                        }
                    }
                    //$featuresApproveLevel[$approvalKey]['level_1_type'] = $approvalData['level_1_type']?$approvalData['level_1_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_1_authority'] = $approvalData['level_1_authority']?$approvalData['level_1_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_2_type'] = $approvalData['level_2_type']?$approvalData['level_2_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_2_authority'] = $approvalData['level_2_authority']?$approvalData['level_2_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_3_type'] = $approvalData['level_3_type']?$approvalData['level_3_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_3_authority'] = $approvalData['level_3_authority']?$approvalData['level_3_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_4_type'] = $approvalData['level_4_type']?$approvalData['level_4_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_4_authority'] = $approvalData['level_4_authority']?$approvalData['level_4_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_5_type'] = $approvalData['level_5_type']?$approvalData['level_5_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_5_authority'] = $approvalData['level_5_authority']?$approvalData['level_5_authority']:'';
                    //$valid = $featuresApproveLevel[$approvalKey]->validate();
                    if($featuresApproveLevel[$approvalKey]->validate()){
                        $featuresApproveLevel[$approvalKey]->save();
                    }
                //}
            }
            // if ($valid) {
            //     if (!empty($featuresApproveLevel)) {
            //         foreach ($FeaturesAppfeaturesApproveLevelroveLevel as $eachModel) {
            //             $eachModel->save();
            //         }
            //     }
            // } else {
            //     $error = CActiveForm::validate($featuresApproveLevel, '', false);
            //     if ($error != '[]')
            //         echo $error;
            // }
            //$jsonData['status'] = 'success';
            //echo CJSON::encode($jsonData);
        }
    }
    
    public function actionSaveapprove() {
        if ((isset($_POST['Lead']) && $_POST['Lead']) || (isset($_POST['Order']) && $_POST['Order']) || (isset($_POST['Quotes']) && $_POST['Quotes']) || (isset($_POST['PurchasingOrder']) && $_POST['PurchasingOrder']) || (isset($_POST['PurchasingEnquiry']) && $_POST['PurchasingEnquiry']) || (isset($_POST['PurchasingRequisition']) && $_POST['PurchasingRequisition'])){
            $valid=true;
            $itemsLead = $_POST['Lead'];
            $itemsOrder = $_POST['Order'];
            $itemsQuotes = $_POST['Quotes'];
            $itemsPurchasingOrder = $_POST['PurchasingOrder'];
            $itemsPurchasingEnquiry = $_POST['PurchasingEnquiry'];
            $itemsPurchasingRequisition = $_POST['PurchasingRequisition'];
            if($itemsLead['id']>0){
                $modelLead = Lead::model()->findByPK($itemsLead['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'LE';
                $modelFeaturesOperations->file_no = $modelLead->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelLead->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsLead['remarks'];
            }
            if($itemsOrder['id']>0){
                $modelOrder = Order::model()->findByPK($itemsOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'SO';
                if ($_POST['frm'] == 3) {
                    $modelFeaturesOperations->operations_type = 'SRO';
                }
                $modelFeaturesOperations->file_no = $modelOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsOrder['notes'];
            }
            if($itemsQuotes['id']>0){
                $modelQuotes = Quotes::model()->findByPK($itemsQuotes['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'QU';
                $modelFeaturesOperations->file_no = $modelQuotes->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelQuotes->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsQuotes['notes'];
            }
            if($itemsPurchasingOrder['id']>0){
                $modelPurchasingOrder = PurchasingOrder::model()->findByPK($itemsPurchasingOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PO';
                $modelFeaturesOperations->file_no = $modelPurchasingOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsPurchasingOrder['notes'];
            }
            if($itemsPurchasingEnquiry['id']>0){
                $modelPurchasingEnquiry = PurchasingEnquiry::model()->findByPK($itemsPurchasingEnquiry['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PE';
                $modelFeaturesOperations->file_no = $modelPurchasingEnquiry->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingEnquiry->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsPurchasingEnquiry['remarks'];
            }
            if($itemsPurchasingRequisition['id']>0){
                $modelPurchasingRequisition = PurchasingRequisition::model()->findByPK($itemsPurchasingRequisition['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PR';
                $modelFeaturesOperations->file_no = $modelPurchasingRequisition->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingRequisition->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsPurchasingRequisition['remarks'];
            }
            $valid = $modelFeaturesOperations->validate() && $valid;
            if($valid){
                if (!empty($modelFeaturesOperations)) {
                    $modelFeaturesOperations->save();
                    $model_approval = new FeaturesApproveLevel();
                    $model_level_approval = $model_approval->model()->find(array('condition' => ' operations_type="' . $modelFeaturesOperations->operations_type .'"'));
                    if ($model_level_approval->max_level == $modelFeaturesOperations->level) {
                        $status = 'Q';
                        if ($modelFeaturesOperations->operations_type == 'LE') {
                            $status = 'L';
                        }
                        if ($modelFeaturesOperations->operations_type == 'SO' || $modelFeaturesOperations->operations_type == 'SRO') {
                            $status = 'O';
                        }
                        if ($modelFeaturesOperations->operations_type == 'PO') {
                            $status = 'P_O';
                        }
                        if ($modelFeaturesOperations->operations_type == 'PE') {
                            $status = 'P_E';
                        }
                        if ($modelFeaturesOperations->operations_type == 'PR') {
                            $status = 'P_R';
                        }
                        MasterFile::model()->updateByPk($modelFeaturesOperations->file_no, array('is_approved' => "Y", 'current_process_status' => $status, 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($modelFeaturesOperations, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    public function actionSavereject() {
        if ((isset($_POST['Lead']) && $_POST['Lead']) || (isset($_POST['Order']) && $_POST['Order']) || (isset($_POST['Quotes']) && $_POST['Quotes']) || (isset($_POST['PurchasingOrder']) && $_POST['PurchasingOrder']) || (isset($_POST['PurchasingEnquiry']) && $_POST['PurchasingEnquiry']) || (isset($_POST['PurchasingRequisition']) && $_POST['PurchasingRequisition'])){
            $valid=true;
            $itemsLead = $_POST['Lead'];
            $itemsOrder = $_POST['Order'];
            $itemsQuotes = $_POST['Quotes'];
            $itemsPurchasingOrder = $_POST['PurchasingOrder'];
            $itemsPurchasingEnquiry = $_POST['PurchasingEnquiry'];
            $itemsPurchasingRequisition = $_POST['PurchasingRequisition'];
            if($itemsLead['id']>0){
                $modelLead = Lead::model()->findByPK($itemsLead['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'LE';
                $modelFeaturesOperations->file_no = $modelLead->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelLead->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsLead['remarks'];
            }
            if($itemsOrder['id']>0){
                $modelOrder = Order::model()->findByPK($itemsOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'SO';
                if ($_POST['frm'] == 3) {
                    $modelFeaturesOperations->operations_type = 'SRO';
                }
                $modelFeaturesOperations->file_no = $modelOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsOrder['notes'];
            }
            if($itemsQuotes['id']>0){
                $modelQuotes = Quotes::model()->findByPK($itemsQuotes['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'QU';
                $modelFeaturesOperations->file_no = $modelQuotes->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelQuotes->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsQuotes['notes'];
            }
            if($itemsPurchasingOrder['id']>0){
                $modelPurchasingOrder = PurchasingOrder::model()->findByPK($itemsPurchasingOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PO';
                $modelFeaturesOperations->file_no = $modelPurchasingOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsPurchasingOrder['notes'];
            }
            if($itemsPurchasingEnquiry['id']>0){
                $modelPurchasingEnquiry = PurchasingEnquiry::model()->findByPK($itemsPurchasingEnquiry['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PE';
                $modelFeaturesOperations->file_no = $modelPurchasingEnquiry->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingEnquiry->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsPurchasingEnquiry['remarks'];
            }
            if($itemsPurchasingRequisition['id']>0){
                $modelPurchasingRequisition = PurchasingRequisition::model()->findByPK($itemsPurchasingRequisition['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PR';
                $modelFeaturesOperations->file_no = $modelPurchasingRequisition->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingRequisition->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsPurchasingRequisition['remarks'];
            }
            $valid = $modelFeaturesOperations->validate() && $valid;
            if($valid){
                if (!empty($modelFeaturesOperations)) {
                    $modelFeaturesOperations->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($modelFeaturesOperations, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetApprovalHistory() {
        $serviceOrderCondition = '';
        $file_id = Yii::app()->request->getparam("file_id");
        $frm = Yii::app()->request->getparam("frm");
        if ($frm == 3) {
            $serviceOrderCondition =  ' AND operations_type = "SRO" ';
        }
        $modelHistory = FeaturesOperations::model()->find(array('condition' => 'file_no = "' . $file_id . '"'.$serviceOrderCondition));
        if (empty($modelHistory)) {
            $modelHistory = new FeaturesOperations();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('approval_history', array('modelHistory' => $modelHistory, 'file_id' => $file_id, 'frm' => $frm), false, true);
    }

    public function actionGetApprovalHistoryList()
    {
        $model = new FeaturesOperations();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.user_id',
            1 => 't.operation_date',
            2 => 't.level',
            3 => 't.operations_type',
            4 => 'notes'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.file_no = "' . $_POST['file_id'] . '"';
        $frm = $_POST['frm'];
        if ($frm == 3) {
            $condition .=  ' AND t.operations_type = "SRO" ';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (user_name LIKE '%" . $searchString . "%' OR operations_type LIKE '%" . $searchString . "%' OR notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'operation_date DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $status = "Approved";
            if ($row['operation_status'] == 'R') {
                $status = "Rejected";
            }
            $rowData[] = array($m, $row['user_name'], date("d/m/Y h:i:s", strtotime($row['operation_date'])), $row['level'], $status, $row['notes']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
}