<script>
    $(document).ready(function () {

        var table_id = "#tbl_cheque_details";
        var table = $(table_id).DataTable({
            scrollY: "645px",
            // scrollX         : "true",
            // scrollCollapse  : true,
            pageLength: 50,
            processing: true,
            ajax: {
                url: 'index.php?r=cheque/default/GetList',
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        });
        $(".dataTables_scrollFoot").hide();
    });
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-users"></i> Cheque Template
        <?php if (Yii::app()->user->authorised_user == 1 || ( isset(Yii::app()->user->havePermissionOn["cheque_template_add"]))) {
            ?>
            <div class="pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('cheque/default/create', 'Add New ', 'lg')"><i class="fa fa-plus"></i> ADD</button>
            </div>
        <?php } ?>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_cheque_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th> Name</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Actions</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<script>

    function viewTemplates(id) {
        window.open("index.php?r=cheque/default/view&id=" + id);
    }
    function deleteTemplates(id) {
        var msg = "Are you sure you want to delete this Template?";
        var dr = confirm(msg);
        if (dr) {
            $.ajax({
                url: "index.php?r=cheque/default/deleteItem",
                type: 'POST',
                dataType: 'json',
                data: {id: id},
                beforeSend: function (xhr) {
                    $("#loader").show();
                },
                success: function (data, textStatus, jqXHR) {
                    reloadTable("#tbl_cheque_details");
                    $("#loader").hide();

                }
            });
        }
    }
</script>
