<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("Invoiceposted", "function Invoiceposted(invoice_id,invoice_no) {
    jConfirm('Confirm Posting  of Production Order- '+invoice_no+' ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':invoice_id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/Posting/PostProductionOrder') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Production Order Posted!');
                            reloadTable('#tble_order_material');
                        }else{
                            $.each(data, function(key, val) {
                                t8.error(val);
                            });
                        }
                    },
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
                });
            }
        });
};", CClientScript::POS_HEAD);
?>
<script>
    $(document).ready(function() {
        var table_id = "#tble_order_material";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('assembly/production/getorder') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                if (aData[8].posted == "Y")  {
                    $("td", nRow).addClass("bg-success");
                }
            }
        });
    });

    function AddContextMenu(row, datas) {
         var print_permission = <?php echo (Yii::app()->user->havePermissionOn['prod_po_print']) ? '1' : '0'; ?>;
        var edit_flag = datas[8].edit_flag;
        var invoice_posted = datas[8].posted;
        var have_service_item = datas[8].have_service_item;
        $(row).contextMenu({
            selector: 'td',

            items: {
                
                 <?php if (isset(Yii::app()->user->havePermissionOn['prod_po_edit_new']) ||  Yii::app()->user->authorised_user == 1) {
                    ?>
                "edit": {
                
                 
                        name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function() {
                            var edit_flag = datas[8].edit_flag;
                            loadPopupModal("assembly/production/CreatePO&id=" + datas[8].id, datas[8].code, "lg");
                        },
                        disabled: function(key, opt) {
                            // this references the trigger element
                            if (edit_flag != 'Y') {
                                return !this.data('editDisabled');
                            }
                        }
                },

             <?php } ?>


                "print": {

                   

                        name: "Print",
                        icon: "fa-print",
                        accesskey: "e",
                          disabled: function () {
                            // If permission is not granted, disable the item
                            return print_permission != 1;
                        },
                        callback: function() {
                            var url = $('#liveSite').val() + "index.php?r=assembly/production/PrintProductionPOPDF&id=" + datas[8].id;
                            window.open(url);
                        }
                   
                },


                <?php // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_post_to_finance"])) { ?>
                /*  "post": {
                        name: "Post to Finance",
                        icon: "fa-arrow-right",
                        accesskey: "d",
                        callback: function() {

                            Invoiceposted(datas[8].id, datas[8].id);
                            // posted(aData[10]);
                        },
                        disabled: function(key, opt) {
                            if (invoice_posted == 'Y' || have_service_item == 'N') {
                                return !this.data('postDisabled');
                            }
                        }
                    },*/
                <?php //} ?>






            }
        });
    }
</script>


<section class="panel">

    <header class="panel-heading clearfix panel-theame">

        <i class="material-icons">list</i> Production Orders

        <div class="pull-right">

            <?php
            //here auto production from bill of material commented by mereena on 27/06/2024 
            if (isset(Yii::app()->user->havePermissionOn['prod_po_add']) ||  Yii::app()->user->authorised_user == 1) {?>

                <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('assembly/production/createPO','Add New Production Order','xl')"><i class="fa fa-plus"></i> ADD</button>

                <?php } ?> </div>

    </header>

    <div class="panel-body">

        <div class="custom-data-table">

            <table class="table table-hover table-bordered personal-task" id="tble_order_material">

                <thead>

                    <tr>

                        <th>PRD No.</th>
                        <th>Product#</th>
                        <th>Description</th>
                        <th>Quantity</th>
                        <th>PRD Date</th>
                        <th>Customer</th>
                        <th>Reference</th>
                        <th>Status</th>
                    </tr>

                </thead>

            </table>

        </div>

    </div>

</section>