<?php

use Dom\Element;



class ProductionController extends Controller
{



    public function accessRules()
    {

        return array(

            array(

                'allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array(

                'allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array(

                    'BillofMaterial',
                    'GetBill',
                    'CreateBill',
                    'GetDocumentList',
                    'UploadDocuments',
                    'SaveBill',

                    'order_index',
                    'GetOrder',
                    'CreatePO',
                    'SavePO',
                    'DeletePOItem',
                    'DeleteBMItem',
                    'GetProductionOrders',

                    'GetProducts',
                    'GetItemDetails',
                    'GoodsIssue',
                    'GetGoodsIssue',
                    'GoodsReceipt',
                    'GetGoodsReceipt',

                    'SaveGR',

                    'CreateGoodsIssue',
                    'CreateGoodsReceipt',
                    'GetProductionOrderDetails',
                    'SaveGI',
                    'GetProductionReceiptDetails',

                    'PrintProductionBOMPDF',
                    'PrintProductionPOPDF',
                    'PrintProductionGIPDF',
                    'PrintProductionGRPDF',
                    'Getunitdrop',
                    'Getunit',
                    'GetStockDetails',
                    'AddQtnDetails',
                    'GetProductionReceiptMaterialDetails',
                    'addIssuesQtnDetails',
                    'GetRate',
                    'GetListProGoodsIssue',

                    'GetListProGoodsIssueReturn',
                    'ReturnItemForm',
                    'Savematerial',
                    'Getunitdropnew',
                    'GetunitFactor',
                    'GetPODetailsForGoodsIssue',
                    'GetPODetailsForGoodsReceipt',

                    'GetSalesOrders',
                    'orderConvertion'

                ),

                /**modified and editted by jisha on 08-11-17**/

                'expression' => '$user->isMember()',

            ),

            array(

                'deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function filters()
    {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionGetBill()
    {

        $model = new ProductionBillofmaterial();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'product.part_number',

            2 => 'product.description',

            3 => 'quantity',

            4 => 't.id',



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (product.part_number LIKE '%" . $searchString . "%' OR product.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";

        }

        $count = $model->with('product')->count(array('condition' => $condition));

        $model = $model->with('product')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $current = strtotime(date('y-m-d'));

        foreach ($model as $row) {

            $div = '';

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_bill_edit"])) {

                $div .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'assembly/production/CreateBill&id=' . $row['id'] . '\',\'' . $row['id'] . " / " . $row['product']['part_number'] . '\',\'xl\')"><i class="fa fa-pencil"></i></button>';

            }

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_bill_print"])) {

                $div .= ' <a class="btn btn-primary btn-xs" title="Print BOM" target="_blank" href="index.php?r=production/PrintProductionBOMPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

            }



            $rowData[] = array(

                $row['id'],

                $row['product']['part_number'],

                $row['product']['description'],

                number_format((float) $row['quantity'], 2),
                '<div class="btn-wrap text-center">' . $div . '</div>',

                array('id' => $row['id'], 'code' => 'Edit Bill of Material')

            );

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionGetProductionOrders()
    {

        $from = $_GET['frm'];



        $searchTerm = $_GET['term'];

        $condition = 'id LIKE "%' . $searchTerm . '%" AND isActive="Y" ';

        if ($from == 'gi' || $from == 'gr')

            $condition .= ' AND is_completed="N"';

        $model = new ProductionOrder();

        $model = $model->findAll(array('condition' => $condition));

        $i = 0;

        foreach ($model as $i => $eachModel) {

            $data[$i]['value'] = $eachModel->id;

            $data[$i]['label'] = $eachModel->id . '-' . $eachModel->customerdetails->customer_name;

            $data[$i]['customer_id'] = $eachModel->customer_id;

            $data[$i]['other'] = $eachModel->reference;

            $data[$i]['customer_name'] = $eachModel->customerdetails->customer_name;

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    /**modified and editted by jisha on 08-11-17**/

    public function actionGetProductionReceiptDetails()
    {

        $order_id = $_POST['order_id'];

        $modelorder = new ProductionOrder();

        $modelorder = $modelorder->findByPk($order_id);





        $total_amount = number_format($modelorder->goods_issue_total_rate, 2, '.', '');



        $model_order_items = array(new ProductionOrderItem());

        $model_order_items = ProductionOrderItem::model()->findAll(array('condition' => 'production_order_id="' . $order_id . '"'));

        $actual_cost = 0;

        $issued_rate = 0;

        foreach ($model_order_items as $i => $model_order_items) {



            $product_id = $model_order_items['product_id'];

            $product_qty = $model_order_items['quantity'];

            $per_product_qty = $product_qty / $modelorder->quantity;

            $pro_factor = $model_order_items->unitdetails_mes->factor;

            $product_model = Store::model()->findByPk($product_id);

            $rate = ($pro_factor * $per_product_qty) * $product_model['rate'];





            $SQL = "SELECT SUM(rate * picked_qty) as issued_rate FROM erp_production_goods_issue_item WHERE po_item_id=" . (int) $model_order_items->id;

            $issued_rate = (float) Yii::app()->db->createCommand($SQL)->queryScalar();



            $SQL = "SELECT SUM(return_qty * rate) as returned_rate FROM `erp_production_goods_issues_return_item` WHERE po_item_id=" . (int) $model_order_items->id;

            $returned_rate = (float) Yii::app()->db->createCommand($SQL)->queryScalar();



            $final_product_rate = $issued_rate - $returned_rate;



            //$issued_rate = ($issued_rate * $modelorder->quantity);



            $actual_cost += $final_product_rate;

            //$actual_cost += $rate;



            //echo $pro_factor." = ".$per_product_qty." = ".$product_model['rate']." = ".$rate."<br/>"; 

        }

        $actual_cost1 = $actual_cost;

        $actual_cost = number_format($actual_cost, 2, '.', '');



        // echo "cost  = ".$actual_cost."<br/>"; 

        //die();

        $po_id_row = $modelorder->po_row;

        $po_row = $po_id_row + 1;

        $data['order'] = $modelorder;

        $data['product'] = $modelorder->product->part_number;

        $data['product_id'] = $modelorder->product_id;

        $data['description'] = $modelorder->description;

        $data['quantity'] = $modelorder->quantity;

        $data['customer_id'] = $modelorder->customer_id;

        $data['customer_name'] = $modelorder->customer_id;

        $data['variance'] = $modelorder->variance;

        $data['rowid'] = $po_row;

        $varients = $modelorder->variance;

        $order_quantity = $modelorder->quantity;

        $calculate = ($varients / 100) * $order_quantity;

        if ($calculate < 1) {

            $calculate = 0;

        }

        $max_quantity = $order_quantity + $calculate;



        $data['model_items'] = '';

        $po_id = $modelorder->id;



        $product = Store::model()->findByPk($modelorder->product_id);

        $items = array(new ProductionGoodsReceiptItem());

        foreach ($items as $i => $model) {

            $model->production_goods_receipt_id = '';

            $model->description = $modelorder->description;

            $model->product_name = $modelorder->product->part_number;

            $model->product_id = $modelorder->product_id;

            $model->unit = $modelorder->unit;

            $factor = $modelorder->unitdetails->factor;

            $received_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0)as quantity FROM  erp_production_goods_receipt_item WHERE po_id=' . $po_id . ' ')->queryScalar();

            $model->po_id = $po_id;

            $model->remaining_quantity = $modelorder->quantity - $received_qty;

            if ($model->remaining_quantity < 1) {

                $model->remaining_quantity = 0;

            }

            $model->quantity = $modelorder->quantity - $received_qty;

            $total_quantity_with_unit = $model->quantity * $factor;



            $max_qty = $max_quantity - $received_qty;

            if ($model->quantity < 1) {

                if ($max_qty > 0) {

                    $model->quantity = $max_qty;

                } else {

                    $model->quantity = 0;

                }

            }



            $amount = $actual_cost1 * $model->quantity;

            $amount1 = number_format($amount, 2, '.', '');

            $base_unit = UnitOfMeasurement::model()->find(array('condition' => 'product_id="' . $model->product_id . '" AND isBase="Y"'));



            $data['model_items'] .= '

                        <tr>

                        <td class="text-center"><label>' . ($i + 1) . CHtml::activeHiddenField($model, "[$i]id") . CHtml::activeHiddenField($model, "[$i]production_goods_receipt_id") . '</label></td>

                        <td>'

                . CHtml::hiddenField("ProductionGoodsReceiptItem[$i]_factor", $factor)

                . CHtml::hiddenField("ProductionGoodsReceiptItem[$i]_total_quantity_with_unit", $total_quantity_with_unit)

                . CHtml::hiddenField('ProductionGoodsReceiptItem[' . $i . '][row_id]', $po_row)

                . CHtml::hiddenField('ProductionGoodsReceiptItem[' . $i . '][maximumQty]', $max_qty)

                . CHtml::activeTextField($model, "[$i]product_name", array('class' => 'tooltipster go', 'value' => $product->part_number))

                . CHtml::activeHiddenField($model, "[$i]product_id") . CHtml::activeHiddenField($model, "[$i]po_id")

                . CHtml::hiddenField('ProductionGoodsReceiptItem[' . $i . '][item_row_id]', $i) . '</td>

                        <td>' . CHtml::activeTextField($model, "[$i]description", array('class' => 'tooltipster go', 'value' => $model->description)) . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]quantity", array('class' => 'qty go', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeyup' => 'checkQty(this.id);calculateValues($("#tbl_gr_item"));')) . '</td>

                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]remaining_quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#tbl_gr_item"));', 'readonly' => true)) . '</td>

                       <td class="text-center">' . CHtml::activedropdownlist($model, "[$i]unit", UnitOfMeasurement::getUnits($model->product_id), array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)', 'disabled' => true))

                . CHtml::activeHiddenField($model, "[$i]unit", array('value' => $base_unit->id)) . '</td>'



                . '<td class="text-center">' . CHtml::activeTextField($model, "[$i]rate", array('class' => 'rate go', 'value' => $actual_cost, 'readonly' => true)) . '</td>'

                . '<td class="text-center">' . CHtml::activeTextField($model, "[$i]amount", array('class' => 'rate go', 'value' => $total_amount, 'readonly' => true)) . CHtml::activeHiddenField($model, "[$i]actual_amount", array('class' => 'tooltipster go', 'value' => $total_amount)) . '</td>'

                . '</tr>';

        }



        echo CJSON::encode($data);

        Yii::app()->end();

    }

    /**modified and editted by jisha on 08-11-17**/

    /*public function actionGetProductionOrderDetails() {

        $order_id = $_POST['order_id'];

        $modelorder = new ProductionOrder();

        $modelorder = $modelorder->findByPk($order_id);

        $data['order'] = $modelorder;

        $data['product'] = $modelorder->product->part_number;

        $data['product_id'] = $modelorder->product_id;

        $data['description'] = $modelorder->description;

        $data['quantity'] = $modelorder->quantity;

        $data['customer_id'] = $modelorder->customer_id;

        $data['customer_name'] = $modelorder->customer_id;

        $items = ProductionOrderItem::model()->findAll(array('condition'=>'production_order_id ="'.$order_id.'"'));

        

        $data['model_items'] = '';

                foreach ($items as $i => $model) {

                    $po_item_id =$model->id;

                    $product = Store::model()->findByPk($model->product_id);

                    $temp = new ProductionGoodsIssueItem;

                    $temp->attributes = $model->attributes;

                    $temp->production_goods_issue_id = '';

                    $temp->description = $model->description;

                    $model = $temp;

                    $received_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(picked_qty),0)as quantity FROM  crm_production_goods_issue_item WHERE po_item_id='.$po_item_id.' ')->queryScalar();

                    $model->po_item_id=$po_item_id ;

                    $model->remaining_quantity=$model->quantity - $received_qty;  

//                    $req_quantity=$model->quantity*$quantity;

//                    $act_quantity=$model->quantity;

//                    $rate = $product->rate;

//                    $rate = number_format($rate,2);

//                    //$unit = Unit::model()->findByPk($product->unit_id);

                    //.CHtml::hiddenField( "ProductionOrderItem[$i][bom_qty]",$act_quantity, array('class' => 'qty go','id'=>'ProductionOrderItem_'.$i.'_bom_qty')) 

                    $data['model_items'] .= '

                        <tr>

                        <td class="text-center"><label>' . ($i + 1). CHtml::activeHiddenField($model, "[$i]id") . CHtml::activeHiddenField($model, "[$i]production_goods_issue_id") . '</label></td>

                        <td>' . CHtml::activeTextField($model, "[$i]product_name", array('class' => 'tooltipster go',  'value' => $product->part_number)) 

                                .CHtml::hiddenField("ProductionGoodsIssueItem[$i]_factor",$model->unitdetails->factor)

                              . CHtml::activeHiddenField($model, "[$i]product_id") . CHtml::activeHiddenField($model, "[$i]po_item_id")  . '</td>

                        <td>' . CHtml::activeTextField($model, "[$i]description", array('class' => 'tooltipster go',  'value' => $model->description)) . '</td>

                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' => 'calculateValues($("#tbl_gi_item"));')) . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]remaining_quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' => 'calculateValues($("#tbl_gi_item"));','value'=>$req_quantity)) . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]picked_qty", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' => 'calculateValues($("#tbl_gi_item"));checkQty(this.id);','onkeydown' => 'FetchData(this.value,this.id,event)','value'=>$req_quantity)) . '</td>

                       <td class="text-center">' . CHtml::activedropdownlist($model, "[$i]unit",UnitOfMeasurement::getUnits($model->product_id), array('class' => 'unit go','onchange' => 'getFactor(this.id,this.value)')) .'</td>

<td class="text-center nw" width="3%">' . CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removePOTable($("#tbl_gi_item"), this,this.id);','id'=>'order_'.$i)) . '</td>

                    </tr>';$i++;

                }



        echo CJSON::encode($data);

        Yii::app()->end();

    }*/



    /*public function actionGetProductionOrderDetails() {

        $order_id = $_POST['order_id'];

        $modelorder = new ProductionOrder();

        $modelorder = $modelorder->findByPk($order_id);

        //$conditions  = 'isActive="Y"';

        //$modelorder  = $modelorder->find(array('condition' =>  'isActive="Y"'));

        $data['order'] = $modelorder;

        $data['product'] = $modelorder->product->part_number;

        $data['product_id'] = $modelorder->product_id;

        $data['description'] = $modelorder->description;

        $data['quantity'] = $modelorder->quantity;

        $data['customer_id'] = $modelorder->customer_id;

        $data['customer_name'] = $modelorder->customer_id;

        $items = ProductionOrderItem::model()->findAll(array('condition'=>'production_order_id ="'.$order_id.'"'));

        

        $error_count  = 0;

        $data['model_items'] = '';

                foreach ($items as $i => $model) {

                    $po_item_id =$model->id;

                    $product = Store::model()->findByPk($model->product_id);

                    $temp = new ProductionGoodsIssueItem;

                    $temp->attributes = $model->attributes;

                    $temp->production_goods_issue_id = '';

                    $temp->description = $model->description;

                    $model = $temp;

                    $unit  = $model->unit;

                    $received_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(picked_qty),0)as quantity FROM  crm_production_goods_issue_item WHERE po_item_id='.$po_item_id.' ')->queryScalar();                                        

                    

                    $model->po_item_id=$po_item_id ;

                    $model->remaining_quantity=$model->quantity - $received_qty;

                    $picked_qty             = $model->unitdetails->factor*$model->remaining_quantity;

                    $picked_qty_baseunit    = $picked_qty/$model->unitdetails->factor;

                    

                    $model_unit_measure   = new UnitOfMeasurement();

                    $model_unit_measure   = $model_unit_measure->find('product_id="'.$model->product_id.'" AND isBase="Y"');

                    $model->unit  = $model_unit_measure->id;

                    $factor       = $model_unit_measure->factor; 

                    

                    

                     

//                    $req_quantity=$model->quantity*$quantity;

//                    $act_quantity=$model->quantity;

//                    $rate = $product->rate;

//                    $rate = number_format($rate,2);

//                    //$unit = Unit::model()->findByPk($product->unit_id);

                    //.CHtml::hiddenField( "ProductionOrderItem[$i][bom_qty]",$act_quantity, array('class' => 'qty go','id'=>'ProductionOrderItem_'.$i.'_bom_qty'))

                    

                    if($picked_qty>0){

                    $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'product_id="'.$model->product_id.'"'))->quantity; 

                    $total_available_product=ProductLocation::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'stock_id="'.$model->product_id.'"'))->quantity; 

                    $model->total_qty = (float)$total_available_product;

                    $model->allocated_qty = (float)$total_allocated_product; 

                     

                    $data['model_items'] .= '

                        <tr>

                        <td class="text-center"><label>' . ($i + 1). CHtml::activeHiddenField($model, "[$i]id") . CHtml::activeHiddenField($model, "[$i]production_goods_issue_id") . '</label></td>

                        <td>' . CHtml::activeTextField($model, "[$i]product_name", array('class' => 'tooltipster go',  'value' => $product->part_number,'readonly'=>true)) 

                                .CHtml::hiddenField("ProductionGoodsIssueItem[$i]_factor",$factor)                               

                                .CHtml::hiddenField("ProductionGoodsIssueItem[$i]_totalqty",$picked_qty)

                                .CHtml::hiddenField("ProductionGoodsIssueItem[$i]_actual_factor",$model->unitdetails->factor)                                

                              . CHtml::activeHiddenField($model, "[$i]product_id") . CHtml::activeHiddenField($model, "[$i]po_item_id")  . '</td>

                        <td>' . CHtml::activeTextField($model, "[$i]description", array('class' => 'tooltipster go',  'value' => $model->description,'readonly'=>true)) . '</td>

                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' => 'calculateValues($("#tbl_gi_item"));','readonly'=>true)) . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]remaining_quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' => 'calculateValues($("#tbl_gi_item"));','value'=>$req_quantity,'readonly'=>true)) . '</td>

                       <td class="text-center">'.$model->unitdetails->name.'</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]total_qty", array('class' => ' go', 'readonly'=>true)) . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]allocated_qty", array('class' => ' go','readonly'=>true)) . '</td>

                       <td class="text-center">' . CHtml::textField("ProductionGoodsIssueItemcheck[$i]_picked_qty",$picked_qty, array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' => 'checkingconvert(this.id,this.value);checkQty(this.id,this.value);','onkeydown' => 'FetchData(this.value,this.id,event)')) 

                       . CHtml::activeHiddenField($model, "[$i]picked_qty", array('class' => 'qty go', 'value'=>$picked_qty_baseunit)) .'</td>                       

                       <td class="text-center">' . CHtml::activedropdownlist($model, "[$i]unit",UnitOfMeasurement::getUnits($model->product_id), array('class' => 'unit go','onchange' => 'getFactor(this.id,this.value)','disabled'=>true)) .CHtml::activeHiddenField($model, "[$i]unit", array('class' => 'qty go', 'value'=>$unit)).'</td>

                        <td class="text-center nw" width="3%">' . //CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removePOTable($("#tbl_gi_item"), this,this.id);','id'=>'order_'.$i)) . 

                        '</td>

                    </tr>';$i++;

                    }

                    else{

                        $error_count++;

                    }

                }

                if($error_count >0){

                    $data['model_items'] .= '<tr><td colspan="9">No Products</td></tr>';

                }



        echo CJSON::encode($data);

        Yii::app()->end();

    }*/

    public function actionGetProductionOrderDetails()
    {

        $order_id = $_POST['order_id'];



        $warehouse_id = $_POST['warehouse_id'];





        $modelorder = new ProductionOrder();

        $modelorder = $modelorder->findByPk($order_id);

        //$conditions  = 'isActive="Y"';

        //$modelorder  = $modelorder->find(array('condition' =>  'isActive="Y"'));

        $data['order'] = $modelorder;

        $data['product'] = $modelorder->product->part_number;

        $data['product_id'] = $modelorder->product_id;

        $data['description'] = $modelorder->description;

        $data['quantity'] = $modelorder->quantity;

        $data['customer_id'] = $modelorder->customer_id;

        $data['customer_name'] = $modelorder->customer_id;

        $items = ProductionOrderItem::model()->findAll(array('condition' => 'production_order_id ="' . $order_id . '"', 'group' => 'product_id'));

        //echo '<pre>';

        //print_r($items);

        //$items = ProductionOrderItem::model()->findAll(array('select'=>'product_id, SUM(quantity) as TOTAL_QTY','condition'=>'production_order_id=:production_order_id','params'=>array(':production_order_id'=>$order_id,'group'=>'product_id')));



        $error_count = 0;

        $data['model_items'] = '';

        foreach ($items as $i => $model) {



            $order_qty = Yii::app()->db->createCommand()

                ->select('sum(quantity)')

                ->from('erp_production_order_item')

                ->where('production_order_id=' . $order_id . ' AND product_id=' . $model['product_id'])

                ->queryScalar();



            $model->quantity = $order_qty;



            $po_item_id = $model->id;

            $product = Store::model()->findByPk($model->product_id);

            $temp = new ProductionGoodsIssueItem;

            $temp->attributes = $model->attributes;

            $temp->production_goods_issue_id = '';

            $temp->description = $model->description;

            $model = $temp;

            $unit = $model->unit;

            $received_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(picked_qty),0)as quantity FROM  erp_production_goods_issue_item WHERE po_item_id=' . $po_item_id . ' ')->queryScalar();

            //echo 'SELECT IFNULL(SUM(picked_qty),0)as quantity FROM  erp_production_goods_issue_item WHERE po_item_id='.$po_item_id.' ';

            $model->po_item_id = $po_item_id;

            $model->remaining_quantity = $model->quantity - $received_qty;

            $picked_qty = $model->unitdetails->factor * $model->remaining_quantity;

            $picked_qty_baseunit = $picked_qty / $model->unitdetails->factor;



            $model_unit_measure = new UnitOfMeasurement();

            $model_unit_measure = $model_unit_measure->find('product_id="' . $model->product_id . '" AND isBase="Y"');

            $model->unit = $model_unit_measure->id;

            $factor = $model_unit_measure->factor;







            //                    $req_quantity=$model->quantity*$quantity;

            //                    $act_quantity=$model->quantity;

            //                    $rate = $product->rate;

            //                    $rate = number_format($rate,2);

            //                    //$unit = Unit::model()->findByPk($product->unit_id);

            //.CHtml::hiddenField( "ProductionOrderItem[$i][bom_qty]",$act_quantity, array('class' => 'qty go','id'=>'ProductionOrderItem_'.$i.'_bom_qty'))



            if ($picked_qty > 0) {

                $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $model->product_id . '"'))->quantity;

                //$total_available_product = ProductLocation::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'stock_id="'.$model->product_id.'"'))->quantity; 

                //    $total_available_product = Store::model()->findByPk($model->product_id)->totalQuantity;



                // ----------------added by indhu 14_04_2023---------------------------------------

                $total_qty = $model->getTotalQuantitywithwarehouse($warehouse_id);

                $model->total_qty = $total_qty;



                // -------------------------------------------------------  









                //   $model->total_qty = (float)$total_available_product;



                $model->allocated_qty = (float) $total_allocated_product;



                $data['model_items'] .= '

                        <tr>

                        <td class="text-center"><label>' . ($i + 1) . CHtml::activeHiddenField($model, "[$i]id") . CHtml::activeHiddenField($model, "[$i]production_goods_issue_id") . '</label></td>

                        <td>' . CHtml::activeTextField($model, "[$i]product_name", array('class' => 'tooltipster go', 'value' => $product->part_number, 'readonly' => true))

                    . CHtml::hiddenField("ProductionGoodsIssueItem[$i]_factor", $factor)

                    . CHtml::hiddenField("ProductionGoodsIssueItem[$i]_totalqty", $picked_qty)

                    . CHtml::hiddenField("ProductionGoodsIssueItem[$i]_actual_factor", $model->unitdetails->factor)

                    . CHtml::activeHiddenField($model, "[$i]product_id") . CHtml::activeHiddenField($model, "[$i]po_item_id") . '</td>

                        <td>' . CHtml::activeTextField($model, "[$i]description", array('class' => 'tooltipster go', 'value' => $model->description, 'readonly' => true)) . '</td>

                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#tbl_gi_item"));', 'readonly' => true)) . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]remaining_quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#tbl_gi_item"));', 'value' => $req_quantity, 'readonly' => true)) . '</td>

                       <td class="text-center">' . $model->unitdetails->name . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]total_qty", array('class' => 'qty go', 'readonly' => true)) . '</td>

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]allocated_qty", array('class' => 'qty go', 'readonly' => true)) . '</td>

                       <td class="text-center">' . CHtml::textField("ProductionGoodsIssueItemcheck[$i]_picked_qty", $picked_qty, array('class' => 'qty go', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeyup' => 'checkingconvert(this.id,this.value);checkQty(this.id,this.value);'))

                    . CHtml::activeHiddenField($model, "[$i]picked_qty", array('class' => 'qty go', 'value' => $picked_qty_baseunit)) . '</td>                       

                       <td class="text-center">' . CHtml::activedropdownlist($model, "[$i]unit", UnitOfMeasurement::getUnits($model->product_id), array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)', 'disabled' => true)) . CHtml::activeHiddenField($model, "[$i]unit", array('class' => 'qty go', 'value' => $unit)) . '</td>

                        </tr>';

                $i++;

            } else {

                $error_count++;

            }

        }

        if ($error_count > 0) {

            $data['model_items'] .= '<tr><td colspan="9">No Products</td></tr>';

        }



        echo CJSON::encode($data);

        Yii::app()->end();

    }







    public function actionGetProductionReceiptMaterialDetails()
    {



        $order_id = $_POST['order_id'];



        //$items = ProductionOrderItem::model()->findAll(array('condition'=>'production_order_id ="'.$order_id.'"'));

        $items = ProductionOrderItem::model()->findAll(array('condition' => 'production_order_id ="' . $order_id . '"', 'group' => 'product_id'));







        $data['model_items'] = '';



        foreach ($items as $i => $items) {









            $po_item_id = $items->id;



            $product = Store::model()->findByPk($items->product_id);



            $model = new ProductionGoodsIssueReturnItem;



            $model->attributes = $items->attributes;



            $model->description = $items->description;



            $order_qty = Yii::app()->db->createCommand()

                ->select('sum(quantity)')

                ->from('erp_production_order_item')

                ->where('production_order_id=' . $order_id . ' AND product_id=' . $model['product_id'])

                ->queryScalar();



            $received_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(picked_qty),0)as quantity FROM  erp_production_goods_issue_item GII LEFT JOIN erp_production_goods_issue GI ON GI.id = GII.production_goods_issue_id  WHERE po_item_id=' . $po_item_id . ' AND GI.is_goods_issued="Y"')->queryScalar();



            $returned_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(return_qty),0)as quantity FROM  erp_production_goods_issues_return_item WHERE po_item_id=' . $po_item_id . ' ')->queryScalar();



            $model->po_item_id = $po_item_id;



            $model->rate = $items->rate;

            //$model->rate = number_format((($items->goods_issue_cost_rate)/$received_qty), 2, '.', '');







            $remaining_qty = $received_qty - $returned_qty;

            if ($remaining_qty > 0) {

                $remaining_qty = $remaining_qty;

            } else {

                $remaining_qty = 0;

            }

            $model->quantity = $remaining_qty;



            $model->item_actualamount = $model->rate * $remaining_qty; //$items->amount;

            $model->amount = 0;

            $picked_qty = $items->unitdetails_mes->factor * $model->quantity;

            $product_rate = $product->rate;





            $model_unit_measure = new UnitOfMeasurement();

            $model_unit_measure = $model_unit_measure->find('product_id="' . $items->product_id . '" AND isBase="Y"');

            $model->unit = $model_unit_measure->id;

            $factor = $model_unit_measure->factor;



            $unit = $items->unit;



            $data['model_items'] .= '



                        <tr>



                        <td class="text-center"><label>' . ($i + 1) . CHtml::hiddenField("ProductionGoodsIssueReturnItem[$i][factor]", $items->unitdetails_mes->factor)



                . CHtml::hiddenField("ProductionGoodsIssueReturnItem[$i][total_quantity_with_unit]", $items->unitdetails_mes->factor)



                . CHtml::hiddenField("ProductionGoodsIssueReturnItem[$i][product_id]", $items->product_id) . CHtml::activeHiddenField($model, "[$i]po_item_id")

                . CHtml::hiddenField("ProductionGoodsIssueReturnItem[$i][productrate]", $product_rate)

                . CHtml::hiddenField("ProductionGoodsIssueReturnItem[$i][totalPickedQty]", $picked_qty) . '</label></td>

                <td>' . CHtml::activeTextField($model, "[$i]product_name", array('class' => 'tooltipster go', 'value' => $model->product->part_number, 'readonly' => true))



                . '</td>



                        <td>' . CHtml::activeTextField($model, "[$i]description", array('class' => 'tooltipster go', 'value' => $model->description, 'readonly' => true)) . '</td>



                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]quantity", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#tbl_gi_item"));', 'readonly' => true)) . '</td>

                        <td class="text-center">' . $items->unitdetails_mes->name . '</td>

                      

                      



                       <td class="text-center">' . CHtml::activedropdownlist($model, "[$i]unit", UnitOfMeasurement::getUnits($model->product_id), array('class' => 'unit go', 'onchange' => 'getFactor1(this.id,this.value)', 'disabled' => true)) . '</td>

                         

                       <td class="text-center">' . CHtml::activeTextField($model, "[$i]rate", array('class' => 'tooltipster go', 'readonly' => true)) .

                CHtml::activeHiddenField($model, "[$i]po_item_id", array('class' => 'tooltipster go', 'value' => $model->po_item_id))

                . CHtml::activeHiddenField($model, "[$i]unit", array('class' => 'qty go', 'value' => $unit)) .

                //. CHtml::activeHiddenField($model, "[$i]return_qty", array('class' => 'qty go', 'value' => 0)) . 

                '</td>

                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]item_actualamount", array('class' => 'tooltipster go', 'readonly' => true)) . '</td>    

                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]return_qty", array('class' => 'qty go', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'checkQty_issues(this.id);', 'value' => '0')) . '</td>                      

                        <td class="text-center">' . CHtml::activeTextField($model, "[$i]amount", array('class' => 'tooltipster go', 'readonly' => true)) . '</td>

                       



                    </tr>';



            //

            $i++;

        }

        echo CJSON::encode($data);



        Yii::app()->end();

    }





    /**modified and editted by jisha on 08-11-17**/

    public function actionGetProducts()
    {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $id = $_GET['id'];

        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") AND isActive="Y" ';

        if ($id > 0) {

            $condition .= ' AND id != ' . $id;

        }

        $model = new Store();

        $model = $model->findAll(array('select' => 'id,part_number,description,unit_id,rate', 'condition' => $condition, 'limit' => 200));

        $i = 0;

        foreach ($model as $eachModel) {

            $data[$i]['value'] = $eachModel->id;

            $data[$i]['other'] = $eachModel->part_number;

            $data[$i]['label'] = $eachModel->part_number . ':' . $eachModel->description;

            $data[$i]['description'] = $eachModel->description;

            $data[$i]['unit_id'] = $eachModel->unit->id;

            $data[$i]['rate'] = $eachModel->rate;

            $data[$i]['unit_name'] = $eachModel->unit->symbol;

            $i++;

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionGetItemDetails()
    {

        $product_id = $_POST['item_id'];

        $quantity = $_POST['quantity'];

        if (!$quantity > 0) {

            $quantity = 1;

        }

        $condition = 'product_id ="' . $product_id . '"';

        $model = new ProductionBillofmaterial();

        $model = $model->with('product')->find(array('condition' => $condition));

        $bill_id = $model->id;

        $items = ProductionBillofmaterialItem::model()->findAll(array('condition' => 'production_billofmaterial_id="' . $bill_id . '"'));

        $jsonData['bill_id'] = $bill_id;

        $jsonData['model_items'] = '';

        foreach ($items as $i => $model) {



            $product = Store::model()->findByPk($model->product_id);

            $temp = new ProductionOrderItem;

            $temp->attributes = $model->attributes;

            $temp->production_order_id = $model->id;

            $temp->description = $model->description;

            $model = $temp;

            $req_quantity = $model->quantity * $quantity;

            $act_quantity = $model->quantity;



            $find_unit = UnitOfMeasurement::model()->findByPk($model->unit);





            //$base_unit      = $find_unit->factor*$req_quantity;

            $rate = $product->rate;









            $rate = number_format($rate, 2, '.', '');

            //$rate = $product->rate." = ".$base_unit;//$model->;

            $amount = number_format(($rate * $req_quantity), 2, '.', '');
            ;

            ($model->product_id > 0) ? $data_unit = UnitOfMeasurement::getUnits($model->product_id) : $data_unit = array();

            $jsonData['model_items'] .= '

                        <tr>

                        <td class="text-center"><label>' . ($i + 1) . CHtml::activeHiddenField($model, "[$i]id") . CHtml::activeHiddenField($model, "[$i]production_order_id") . '</label></td>

                        <td>' . CHtml::hiddenField("ProductionOrderItem[$i][bom_qty]", $act_quantity, array('class' => 'qty go', 'id' => 'ProductionOrderItem_' . $i . '_bom_qty')) . CHtml::activeTextField($model, "[$i]product_name", array('class' => 'tooltipster go', 'onKeyup' => 'js:autoCompletePO(this.id,"po");', 'value' => $product->part_number))

                . CHtml::activeHiddenField($model, "[$i]product_id") .

                '</td>

                        <td>' . CHtml::activeTextField($model, "[$i]description", array('class' => 'tooltipster go', 'value' => $model->description, 'readonly' => 'readonly')) . '</td>

                    <td class="text-center">' . CHtml::activeTextField($model, "[$i]quantity", array('class' => 'qty go text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#tbl_po_item"));', 'value' => $req_quantity, 'readonly' => true)) . '</td>

                       <td class="text-center" id="unit_' . $i . '">' .

                CHtml::activedropDownList($model, "[$i]unit", $data_unit, array('class' => 'qty go', 'readonly' => 'readonly')) .

                '</td>

                       <td class="text-right">' . CHtml::activeTextField($model, "[$i]rate", array('class' => 'text-right rate go', 'value' => $rate, 'readonly' => 'readonly')) . '</td>  

                       <td class="text-right">' . CHtml::activeTextField($model, "[$i]amount", array('class' => 'text-right rate go', 'value' => $amount, 'readonly' => 'readonly')) . '</td>                     

                       </td><td class="text-center nw" width="3%">' . CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removePOTable($("#tbl_po_item"), this,this.id);', 'id' => 'order_' . $i)) . '</td>

                     </tr>';

            $i++;

        }

        //     

        // 

        //  



        echo CJSON::encode($jsonData);

        // Yii::app()->end();

    }

    public function actionGetOrder()
    {

        $model = new ProductionOrder();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'product.part_number',

            2 => 'product.description',

            3 => 't.quantity',

            4 => 't.productionorder_date',

            5 => 't.customer_id',

            6 => 't.reference',

            7 => 't.id',

            8 => 't.id'



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (product.part_number LIKE '%" . $searchString . "%' OR  t.reference LIKE '%" . $searchString . "%' OR t.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR t.grand_total LIKE '%" . $searchString . "%')";

        }

        $count = $model->with('product')->count(array('condition' => $condition));

        $model = $model->with('product')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $current = strtotime(date('y-m-d'));

        foreach ($model as $row) {

            /*$div = '';

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_po_edit"])) {

                $div .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'production/CreatePO&id=' . $row['id'] . '\',\'' . $row['id'] . '\',\'lg\')"><i class="fa fa-pencil"></i></button>';

            }

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_po_print"])) {

                $div .= ' <a class="btn btn-primary btn-xs" title="Print BOM" target="_blank" href="index.php?r=production/PrintProductionPOPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

            }

            '<div class="btn-wrap text-center">' . $div . ''

                    . '</div>'

            */

            $edit_flag = 'Y';

            if ($row->POStatus != 'Production Order') {

                $edit_flag = 'N';

            }

            $rowData[] = array(

                $row['id'],

                $row['product']['part_number'],

                $row['product']['description'],

                $row['quantity'],

                date('d/m/Y', strtotime($row['productionorder_date'])),

                $row->customerdetails->customer_name,
                $row->reference,
                $row->POStatus,

                array('id' => $row['id'], 'code' => 'Edit production order', 'edit_flag' => $edit_flag, 'posted' => $row['posted'], 'have_service_item' => $row['have_service_item'])

            );

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionGetGoodsIssue()
    {

        $model = new InventoryGoodsIssue();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'order.id',

            2 => 'product.id',

            3 => 'product.description',

            4 => 'order.productionorder_date',

            5 => 'order.end_date',

            6 => 't.id',



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 'issue_type="PR" '; //is_goods_issued="Y"

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR order.id LIKE '%" . $searchString . "%' OR product.part_number LIKE '%" . $searchString . "%' OR product.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";

        }

        $count = $model->with('order.product', 'order')->count(array('condition' => $condition));

        $model = $model->with('order.product', 'order')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $current = strtotime(date('y-m-d'));

        foreach ($model as $row) {

            //

            $div = '';



            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_gi_print"])) {

                $div .= ' <a class="btn btn-primary btn-xs" title="Print BOM" target="_blank" href="index.php?r=production/PrintProductionGIPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

            }



            $rowData[] = array(

                $row['id'],

                $row['order']['id'],

                $row['order']['product']['part_number'],

                $row['order']['product']['description'],

                date('d/m/Y', strtotime($row['order']['productionorder_date'])),

                date('d/m/Y', strtotime($row['order']['end_date'])),

                '<div class="btn-wrap text-center">' . $div . '</div>',

                array('id' => $row['id'], 'code' => 'Good issue print', 'posted' => $row['posted'])

            );

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionGetGoodsReceipt()
    {

        $model = new InventoryGoodsReceipt();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'order.id',

            2 => 'product.part_number',

            3 => 'order.description',

            4 => 'order.quantity',

            5 => 'order.productionorder_date',

            6 => 'order.end_date',

            7 => 't.id',



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1 AND receipt_type="PGR"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (product.part_number LIKE '%" . $searchString . "%' OR order.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR order.id LIKE '%" . $searchString . "%')";

        }

        $count = $model->with('order')->count(array('condition' => $condition));

        $model = $model->with('order')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $current = strtotime(date('y-m-d'));

        foreach ($model as $row) {

            $div = '';



            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["prod_gr_print"])) {

                $div .= ' <a class="btn btn-primary btn-xs" title="Print " target="_blank" href="index.php?r=production/PrintProductionGRPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

            }



            $rowData[] = array(

                $row['id'],

                $row['order']['id'],

                $row['order']['product']['part_number'],

                $row['order']['description'],

                $row['order']['quantity'],

                date('d/m/Y', strtotime($row['order']['productionorder_date'])),
                date('d/m/Y', strtotime($row['order']['end_date'])),

                '<div class="btn-wrap text-center">' . $div . '</div>',

                array('id' => $row['id'], 'code' => 'Goods receipt print', 'posted' => $row['posted'])

            );

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionBillofMaterial()
    {

        $this->render('billindex');

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionOrder_Index()
    {

        $this->render('orderindex');

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionGoodsIssue()
    {



        $this->render('goodsissueindex');

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionGoodsReceipt()
    {

        $this->render('goodsreceiptindex');

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionCreateBill()
    {

        $id = (int) Yii::app()->request->getParam('id');

        $model = new ProductionBillofmaterial();

        $modelItems = array(new ProductionBillofmaterialItem());

        if ($id > 0) {

            $model = ProductionBillofmaterial::model()->findByPK($id);

            $modelItems = ProductionBillofmaterialItem::model()->findAll(array('condition' => 'production_billofmaterial_id = ' . $id));

            if (empty($modelItems)) {

                $modelItems = array(new ProductionBillofmaterialItem());

            }

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customers_add"])){



        $this->render('billcreate', array('model' => $model, 'modelItems' => $modelItems));

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionCreatePO()
    {

        $id = (int) Yii::app()->request->getParam('id');

        $model = new ProductionOrder();

        $modelItems = array(new ProductionOrderItem());

        if ($id > 0) {

            $model = ProductionOrder::model()->findByPK($id);

            $modelItems = ProductionOrderItem::model()->findAll(array('condition' => 'production_order_id = ' . $id));

            if (empty($modelItems)) {

                $modelItems = array(new ProductionOrderItem());

            }

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customers_add"])){



        $this->render('ordercreate', array('model' => $model, 'modelItems' => $modelItems));

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionCreateGoodsIssue()
    {

        $model = new ProductionGoodsIssue();

        $modelItems = array(new ProductionGoodsIssueItem());

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        $this->render('gicreate', array('model' => $model, 'modelItems' => $modelItems));

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionCreateGoodsReceipt()
    {

        $model = new ProductionGoodsReceipt();

        $modelItems = array(new ProductionGoodsReceiptItem());

        $modelGoodsIssueReturn = array(new ProductionGoodsIssueReturnItem());

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        $this->render('grcreate', array('model' => $model, 'modelItems' => $modelItems, 'modelGoodsIssueReturn' => $modelGoodsIssueReturn));

    }

    /**modified and editted by jisha on 08-11-17**/



    public function actionGetDocumentList()
    {



        $model = new Document();



        // echo $file_id;

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $id = $_POST['id'];

        $type = $_POST['type'];



        $columns = array(

            // datatable column index  => database column name

            0 => 't.file_id',

            1 => 't.document_name',

            2 => 't.created_by',

            3 => 't.created_datetime',



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive="Y" ';

        if ($id != "")

            $condition .= ' AND t.file_id = "' . $id . '"';

        if ($type == "BM")

            $condition .= ' AND t.uploaded_from = "B_M" ';

        if ($type == "PO")

            $condition .= ' AND t.uploaded_from = "PR_O" ';

        if ($type == "GI")

            $condition .= ' AND t.uploaded_from = "G_I" ';

        if ($type == "GR")

            $condition .= ' AND t.uploaded_from = "G_R" ';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (document_name LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $button_string = "";

            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));

            if (isset(Yii::app()->user->havePermissionOn['order_document']) || Yii::app()->user->authorised_user == 1) {

                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';

            }

            $button_string .= '<a href ="' . Yii::app()->createUrl('lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';

            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:m:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }

    /**modified and editted by jisha on 12-04-17**/

    public function actionSaveBill()
    {

        $model = new ProductionBillofmaterial();

        $modelItem = array(new ProductionBillofmaterialItem());

        $other_errors = array();

        $model_his = array();

        if (isset($_POST['ProductionBillofmaterial'])) {

            if ((int) @$_POST['ProductionBillofmaterial']['id'] > 0) {

                $model = $model->findByPK($_POST['ProductionBillofmaterial']['id']);

                $audit_type = 'UPDATED';

            } else {

                $audit_type = 'CREATED';

                $model->crm_user_id = Yii::app()->user->id;

                $model->created_by = Yii::app()->user->id;

                $model->created_datetime = date('Y-m-d h:i:s');

                $model->bm_date = date("Y-m-d");

                if ((int) $_POST['ProductionBillofmaterial']['product_id'] > 0) {

                    $prod_id = (int) $_POST['ProductionBillofmaterial']['product_id'];

                    $model_his = $model->findAll(array('condition' => 'product_id = "' . $prod_id . '"'));

                }

            }

            $model->attributes = $_POST['ProductionBillofmaterial'];

            $model->notes = $_POST['ProductionBillofmaterial']['notes'];

            $model->remarks = $_POST['ProductionBillofmaterial']['remarks'];

            $model->terms_and_conditions = $_POST['ProductionBillofmaterial']['terms_and_conditions'];

            $model->unit_factor = $_POST['ProductionBillofmaterial']['unit_factor'];



            $model->updated_by = Yii::app()->user->id;

            $model->updated_datetime = date('Y-m-d h:i:s');

            $valid = $model->validate();

            if (!empty($model_his)) {

                $valid = FALSE;

                $other_errors[] = 'Product Already Taken';

            }

            if (!empty($_POST['ProductionBillofmaterialItem'])) {

                foreach ($_POST['ProductionBillofmaterialItem'] as $k => $rowItem) {

                    if (empty($rowItem['id'])) {

                        $modelItem[$k] = new ProductionBillofmaterialItem();

                        $modelItem[$k]->created_by = Yii::app()->user->id;

                        $modelItem[$k]->created_datetime = date('Y-m-d h:i:s');

                    } else {

                        $modelItem[$k] = ProductionBillofmaterialItem::model()->findByPk($rowItem['id']);

                    }

                    $modelItem[$k]->production_billofmaterial_id = 0;

                    $modelItem[$k]->attributes = $_POST['ProductionBillofmaterialItem'][$k];



                    $modelItem[$k]->updated_by = Yii::app()->user->id;

                    $modelItem[$k]->updated_datetime = date('Y-m-d h:i:s');

                    $valid = $modelItem[$k]->validate() && $valid;

                }

            }



            if ($valid) {

                if ($model->save()) {

                    // inserting to audit log

                    AuditLog::saveAuditLogs(

                        'BILL_OF_MATERIAL',

                        Yii::app()->user->id,

                        $audit_type,

                        " with Bill No: - {$model->id}  "

                    );

                    // end audit log

                    if (!empty($modelItem)) {

                        foreach ($modelItem as $eachItem) {

                            $eachItem->production_billofmaterial_id = $model->id;

                            $qty = $eachItem['quantity'] / $_POST['ProductionBillofmaterial']['quantity'];

                            $eachItem->quantity = $qty;



                            $eachItem->save(false);

                        }

                    }





                    $jsonData['id'] = $model->id;

                    $jsonData['bm'] = $model->findByPk($model->id);

                    $jsonData['status'] = 'success';

                    echo CJSON::encode($jsonData);

                }

            } else {

                $error1 = array();

                $error2 = array();

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);

                if ($modelItem[0]->product_id > 0)

                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else

                    $error2[] = "Please add atleast one item";

                $error = CJSON::encode(array_merge_recursive($error2, $error1, $other_errors));

                if ($error != '[]')

                    echo $error;

            }

        }

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionSavePO()
    {

        $model = new ProductionOrder();

        $modelItem = array(new ProductionOrderItem());

        if (isset($_POST['ProductionOrder'])) {

            if ((int) @$_POST['ProductionOrder']['id'] > 0) {

                $model = $model->findByPK($_POST['ProductionOrder']['id']);

                $audit_type = 'UPDATED';

            } else {

                $model->crm_user_id = Yii::app()->user->id;

                $model->created_by = Yii::app()->user->id;

                $model->created_datetime = date('Y-m-d h:i:s');

                $audit_type = 'CREATED';

            }

            $model->attributes = $_POST['ProductionOrder'];

            $model->notes = $_POST['ProductionOrder']['notes'];

            $model->remarks = $_POST['ProductionOrder']['remarks'];

            $model->reference = $_POST['ProductionOrder']['reference'];

            $model->connected_file = $_POST['ProductionOrder']['connected_file'];

            $model->terms_and_conditions = $_POST['ProductionOrder']['terms_and_conditions'];

            if ($_POST['ProductionOrder']['productionorder_date'] != '') {

                $model->productionorder_date = str_replace('/', '-', $_POST['ProductionOrder']['productionorder_date']);

                $model->productionorder_date = date("Y-m-d", strtotime($model->productionorder_date));

            }

            if ($_POST['ProductionOrder']['end_date'] != '') {

                $model->end_date = str_replace('/', '-', $_POST['ProductionOrder']['end_date']);

                $model->end_date = date("Y-m-d", strtotime($model->end_date));

            }

            $model->updated_by = Yii::app()->user->id;

            $model->updated_datetime = date('Y-m-d h:i:s');

            $valid = $model->validate();

            $other_errors = array();

            //   ---------------------AccAuditClose check------------------------------------





            $productionorder_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ProductionOrder']['productionorder_date'])));



            $modelAccAuditClose = new AccAuditClose();

            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());

            $productionorder_date = strtotime($productionorder_datex);

            if ($productionorder_date <= $existing_date) {

                $valid = false;

                $other_errors[] = ' Given Production Order date must be greater than Audit Close date  :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';

            }

            //   --------------------//-AccAuditClose check------------------------------------





            if (!empty($_POST['ProductionOrderItem'])) {

                foreach ($_POST['ProductionOrderItem'] as $k => $rowItem) {

                    if (empty($rowItem['id'])) {

                        $modelItem[$k] = new ProductionOrderItem();

                        $modelItem[$k]->created_by = Yii::app()->user->id;

                        $modelItem[$k]->created_datetime = date('Y-m-d h:i:s');

                    } else {

                        $modelItem[$k] = ProductionOrderItem::model()->findByPk($rowItem['id']);

                    }

                    $modelItem[$k]->attributes = $_POST['ProductionOrderItem'][$k];

                    $modelItem[$k]->bom_qty = $rowItem['bom_qty'];

                    $modelItem[$k]->rate = $rowItem['rate'];

                    $modelItem[$k]->production_order_id = 0;

                    $modelItem[$k]->updated_by = Yii::app()->user->id;

                    $modelItem[$k]->updated_datetime = date('Y-m-d h:i:s');

                    $valid = $modelItem[$k]->validate() && $valid;

                }

            }



            if ($valid) {

                if ($model->save()) {

                    // inserting to audit log

                    AuditLog::saveAuditLogs(

                        'PRODUCTION_ORDER',

                        Yii::app()->user->id,

                        $audit_type,

                        " with PRD No: - {$model->id}  "

                    );

                    // end audit log 

                    $sum = 0;

                    if (!empty($modelItem)) {

                        foreach ($modelItem as $eachItem) {

                            $eachItem->production_order_id = $model->id;

                            $sum += $eachItem->amount;

                            $eachItem->save(false);

                        }

                    }

                    $model->updateByPk($model->id, array('grand_total' => $sum));

                    $jsonData['id'] = $model->id;

                    $jsonData['po'] = $model->findByPk($model->id);

                    $jsonData['status'] = 'success';

                    echo CJSON::encode($jsonData);

                }

            } else {

                $error1 = array();

                $error2 = array();

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);

                if ($modelItem[0]->product_id != '')

                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else

                    $error2[] = "Please add atleast one item";

                $error = CJSON::encode(array_merge_recursive($error2, $error1, $other_errors));

                if ($error != '[]')

                    echo $error;

            }

        }

    }

    /**modified and editted by jisha on 08-11-17**/

    public function actionSaveGR()
    {





        $model = new ProductionGoodsReceipt();

        if (isset($_POST['ProductionGoodsReceipt'])) {

            if ((int) @$_POST['ProductionGoodsReceipt']['id'] > 0) {

                $model = $model->findByPK($_POST['ProductionGoodsReceipt']['id']);

                $audit_type = 'UPDATED';

            } else {

                $model->crm_user_id = Yii::app()->user->id;

                $model->created_by = Yii::app()->user->id;

                $model->created_datetime = date('Y-m-d h:i:s');

                $audit_type = 'CREATED';

            }

            $model->attributes = $_POST['ProductionGoodsReceipt'];

            $model->notes = $_POST['ProductionGoodsReceipt']['notes'];

            $model->remarks = $_POST['ProductionGoodsReceipt']['remarks'];

            $model->reference = $_POST['ProductionGoodsReceipt']['reference'];

            $model->variants = $_POST['ProductionGoodsReceipt']['variants'];

            $model->warehouse_id = $_POST['ProductionGoodsReceipt']['warehouse_id'];



            $model->terms_and_conditions = $_POST['ProductionGoodsReceipt']['terms_and_conditions'];



            $model->is_updated_store = 'Y';



            if ($_POST['ProductionGoodsReceipt']['goods_receipt_date'] != '') {

                $model->goods_receipt_date = str_replace('/', '-', $_POST['ProductionGoodsReceipt']['goods_receipt_date']);

                $model->goods_receipt_date = date("Y-m-d", strtotime($model->goods_receipt_date));

            }



            $model->updated_by = Yii::app()->user->id;

            $model->updated_datetime = date('Y-m-d h:i:s');

            $valid = $model->validate();

            $other_errors = array();

            //   ---------------------AccAuditClose check------------------------------------





            $issue_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ProductionGoodsReceipt']['goods_receipt_date'])));



            $modelAccAuditClose = new AccAuditClose();

            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());

            $issue_date = strtotime($issue_datex);

            if ($issue_date <= $existing_date) {

                $valid = false;

                $other_errors[] = ' Given Receipt date must be greater than Audit Close date  :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';

            }

            //   --------------------//-AccAuditClose check------------------------------------





            if (!empty($_POST['ProductionGoodsReceiptItem'])) {



                foreach ($_POST['ProductionGoodsReceiptItem'] as $k => $rowItem) {

                    if (empty($rowItem['id'])) {

                        $modelItem[$k] = new ProductionGoodsReceiptItem();

                        $modelItem[$k]->created_by = Yii::app()->user->id;

                        $modelItem[$k]->created_datetime = date('Y-m-d h:i:s');

                    } else {

                        $modelItem[$k] = ProductionGoodsReceiptItem::model()->findByPk($rowItem['id']);

                    }

                    $modelItem[$k]->attributes = $_POST['ProductionGoodsReceiptItem'][$k];

                    $modelItem[$k]->production_goods_receipt_id = 0;

                    $modelItem[$k]->updated_by = Yii::app()->user->id;

                    $modelItem[$k]->updated_datetime = date('Y-m-d h:i:s');

                    $modelItem[$k]->product_id = $rowItem['product_id'];

                    //$modelItem[$k]->po_item_id =$rowItem['item_row_id'];

                    $valid = $modelItem[$k]->validate() && $valid;

                }

            }



            $modelCustomer = new Customer();

            $modelcustomer_name = '';

            if ((int) $model->customer_id > 0) {

                $modelcustomer_name = $modelCustomer->findByPk($model->customer_id)->customer_name;

            }







            if ((int) $model->warehouse_id > 0) {

                $warehouse_id = $model->warehouse_id;

            } else {

                $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
                ;

            }



            $warehouse_name = '';

            if ($warehouse_id > 0) {

                $modwarehouse = new MasInventoryWarehouse();

                $warehouse_name = $modwarehouse->getWarehouseName($warehouse_id);

            }







            if (!empty($_POST['ProductionGoodsIssueReturnItem'])) {







                foreach ($_POST['ProductionGoodsIssueReturnItem'] as $z => $rowItemReturn) {





                    if ($rowItemReturn['return_qty'] > 0) {



                        if (empty($rowItemReturn['id'])) {



                            $modelItem_return[$z] = new ProductionGoodsIssueReturnItem();

                        } else {



                            $modelItem_return[$z] = ProductionGoodsIssueReturnItem::model()->findByPk($rowItemReturn['id']);

                        }



                        $modelItem_return[$z]->attributes = $_POST['ProductionGoodsIssueReturnItem'][$z];



                        $modelItem_return[$z]->po_item_id = $rowItemReturn['po_item_id'];



                        $modelItem_return[$z]->product_id = $rowItemReturn['product_id'];



                        $modelItem_return[$z]->product_name = $rowItemReturn['product_name'];



                        $modelItem_return[$z]->description = $rowItemReturn['description'];



                        $modelItem_return[$z]->quantity = $rowItemReturn['quantity'];



                        $modelItem_return[$z]->return_qty = $rowItemReturn['return_qty'];



                        $modelItem_return[$z]->rate = $rowItemReturn['rate'];



                        $modelItem_return[$z]->amount = $rowItemReturn['amount'];



                        $modelItem_return[$z]->unit = $rowItemReturn['unit'];

                    }

                }

            }











            if ($valid) {



                if ($model->save()) {

                    // inserting to audit log

                    AuditLog::saveAuditLogs(

                        'GOODS_RECEIPT',

                        Yii::app()->user->id,

                        $audit_type,

                        " with Checking No: - {$model->id}  "

                    );

                    // end audit log



                    $row = $_POST['ProductionGoodsReceipt']['production_order_id'];

                    $rowid = $_POST['ProductionGoodsReceipt']['rowid'];

                    ProductionOrder::model()->updateByPk($row, array('po_row' => $rowid));

                    $sum = 0;

                    //$production_order  = $_POST['ProductionGoodsReceipt']['production_order_id'];

                    //$update_rowid =$_POST['goodsreceipt'][0]['row_id'];

                    /*   if (!empty($modelItem)) {

                        foreach ($modelItem as $eachItem) {

                            $eachItem->production_goods_receipt_id = $model->id;

                            //$eachItem->item_row_id = $update_rowid;

                            $sum += $eachItem->amount;

                            $eachItem->save();

                            

                        }

                    }*/



                    $total_current_cost_rate = 0;

                    if (!empty($modelItem_return)) {

                        foreach ($modelItem_return as $eachReturnItem) {

                            $eachReturnItem->production_goods_receipt_id = $model->id;

                            $eachReturnItem->save(false);





                            if ((int) $eachReturnItem->return_qty > 0) {



                                $modelRack = new MasInvRack();

                                $modelBin = new MasInvBin();

                                $modelProductClass = new ProductClass();

                                $modelUOM = new UnitOfMeasurement();







                                $modelproduct_class = '';

                                if ((int) $eachReturnItem->product->brand_class_id > 0) {

                                    $modelproduct_class = $modelProductClass->findByPk($eachReturnItem->product->brand_class_id)->product_class;

                                }



                                $modelUOM = $modelUOM->findByPk((int) $eachReturnItem->unit);





                                $modelProductionOrderItem = new ProductionOrderItem();



                                $modelProductionOrderItem = $modelProductionOrderItem->findByPk((int) $eachReturnItem->po_item_id);



                                $current_cost_rate = ($modelProductionOrderItem->goods_issue_cost_rate - $eachReturnItem->amount);



                                $modelUpdateProductionOrderItem = new ProductionOrderItem();



                                $modelUpdateProductionOrderItem = $modelProductionOrderItem->updateByPk((int) $eachReturnItem->po_item_id, array('goods_issue_cost_rate' => $current_cost_rate));



                                $total_current_cost_rate += $current_cost_rate;









                                $modelStockLedger = new StockLedger();

                                $modelStockLedger->brand_id = $eachReturnItem->product->brand_class_id;

                                $modelStockLedger->brand_name = $modelproduct_class;

                                $modelStockLedger->customer_vendor_id = $model->customer_id;

                                $modelStockLedger->customer_vendor_name = $modelcustomer_name;

                                $modelStockLedger->file_id = $model->file_id;

                                $modelStockLedger->header_id = $model->id;

                                $modelStockLedger->header_item_id = $eachReturnItem->id;

                                $modelStockLedger->product_id = $eachReturnItem->product_id;

                                $modelStockLedger->product_name = $eachReturnItem->product->part_number;

                                $modelStockLedger->product_description = $eachReturnItem->product->description;

                                $modelStockLedger->warehouse_id = $warehouse_id;

                                $modelStockLedger->warehouse_name = $warehouse_name;

                                $modelStockLedger->rack_id = $modelRack->getDefaultRackId();

                                $modelStockLedger->rack_name = $modelRack->getRackName((int) $modelStockLedger->rack_id);

                                $modelStockLedger->bin_id = $modelBin->getDefaultBinId();

                                $modelStockLedger->bin_name = $modelBin->getBinName((int) $modelStockLedger->bin_id);

                                $modelStockLedger->unit_id = $eachReturnItem->unit;

                                $modelStockLedger->unit_name = $modelUOM->name;

                                $modelStockLedger->unit_factor = $modelUOM->factor;

                                $modelStockLedger->quantity = $eachReturnItem->return_qty;

                                $modelStockLedger->available_status = 'A';

                                $modelStockLedger->buying_price = $eachReturnItem->rate;
                                ;

                                $modelStockLedger->batch_no = '';

                                $modelStockLedger->serial_no = '';

                                $modelStockLedger->manufacturing_date = '0000-00-00';

                                $modelStockLedger->expiry_date = '0000-00-00';

                                $modelStockLedger->cost_price = $eachReturnItem->rate;

                                $modelStockLedger->transaction_cost_rate = $eachReturnItem->rate;

                                // $modelStockLedger->sales_price                    = $eachItem['rate']*$modelUOM->factor;

                                $modelStockLedger->sales_price = 0;

                                $modelStockLedger->transaction_date = ($model->goods_receipt_date != '' && $model->goods_receipt_date != '0000-00-00') ? $model->goods_receipt_date : '0000-00-00';

                                $modelStockLedger->transaction_from = 'PRODUCTION_GOODS_RETURN'; //when goods receipt -- item returned

                                $modelStockLedger->transaction_type = "IN";

                                $modelStockLedger->stock_after_transaction = 0;

                                $modelStockLedger->stock_value_after_transaction = 0;

                                $modelStockLedger->master_stock_ledger_id = 0;

                                $modelStockLedger->stock_updated = 'Y';

                                $modelStockLedger->created_by = (int) Yii::app()->user->id;

                                $modelStockLedger->created_date = date("Y-m-d H:i:s");

                                $modelStockLedger->save(false);

                            }

                        }

                    }





                    // ----------------------added by indhu 14_04_2023------------------------------------------------



                    $sum = 0;

                    if (!empty($modelItem)) {





                        $modelRack = new MasInvRack();

                        $modelBin = new MasInvBin();

                        $modelProductClass = new ProductClass();

                        $modelUOM = new UnitOfMeasurement();







                        $total_current_cost_rate_new = 0;

                        foreach ($modelItem as $eachItem) {



                            $eachItem->production_goods_receipt_id = $model->id;

                            //$eachItem->item_row_id = $update_rowid;

                            $sum += $eachItem->amount;









                            $modelStore = new Store();

                            $modelStore = $modelStore->findByPk((int) $eachItem->product_id);







                            $modelStore = new Store();

                            $modelStore = $modelStore->findByPk((int) $eachItem->product_id);





                            $total_current_cost_rate_new = $eachItem->amount;



                            $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity*unit_factor) FROM  erp_stock_ledger WHERE product_id=' . (int) $eachItem->product_id . ' ')->queryScalar();



                            $old_amount = ($modelStore->rate * $old_total_qty);



                            $new_qty = $old_total_qty + $eachItem->quantity;

                            //echo $old_total_qty."=new_qty=".$new_qty."=oldamt=".$old_amount."cuuamt=".$total_current_cost_rate_new."<br>";

                            if ($new_qty > 0) {

                                $cost_rate = ($old_amount + $total_current_cost_rate_new) / $new_qty;

                            } else {

                                $cost_rate = $old_amount;

                            }





                            $eachItem->save();



                            // -------------------------------------------------------------------



                            $modelproduct_class = '';

                            if ((int) $eachItem->product->brand_class_id > 0) {

                                $modelproduct_class = $modelProductClass->findByPk($eachItem->product->brand_class_id)->product_class;

                            }



                            /*  $modelcustomer_name = '';

                            if ((int)$model->customer_id > 0) {

                                $modelcustomer_name = $modelCustomer->findByPk($model->customer_id)->customer_name;

                            }*/



                            $modelUOM = $modelUOM->findByPk((int) $eachItem->unit);

                            // ---------------------------

                            $modelStockLedger = new StockLedger();

                            $modelStockLedger->brand_id = $eachItem->product->brand_class_id;

                            $modelStockLedger->brand_name = $modelproduct_class;

                            $modelStockLedger->customer_vendor_id = $model->customer_id;

                            $modelStockLedger->customer_vendor_name = $modelcustomer_name;

                            $modelStockLedger->file_id = $model->file_id;

                            $modelStockLedger->header_id = $model->id;

                            $modelStockLedger->header_item_id = $eachItem->id;

                            $modelStockLedger->product_id = $eachItem->product_id;

                            $modelStockLedger->product_name = $eachItem->product->part_number;

                            $modelStockLedger->product_description = $eachItem->product->description;

                            $modelStockLedger->warehouse_id = $warehouse_id;

                            $modelStockLedger->warehouse_name = $warehouse_name;

                            $modelStockLedger->rack_id = $modelRack->getDefaultRackId();

                            $modelStockLedger->rack_name = $modelRack->getRackName((int) $modelStockLedger->rack_id);

                            $modelStockLedger->bin_id = $modelBin->getDefaultBinId();

                            $modelStockLedger->bin_name = $modelBin->getBinName((int) $modelStockLedger->bin_id);

                            $modelStockLedger->unit_id = $eachItem->unit;

                            $modelStockLedger->unit_name = $modelUOM->name;

                            $modelStockLedger->unit_factor = $modelUOM->factor;

                            $modelStockLedger->quantity = $eachItem->quantity;

                            $modelStockLedger->available_status = 'A';

                            $modelStockLedger->buying_price = $cost_rate;

                            $modelStockLedger->batch_no = '';

                            $modelStockLedger->serial_no = '';

                            $modelStockLedger->manufacturing_date = '0000-00-00';

                            $modelStockLedger->expiry_date = '0000-00-00';

                            $modelStockLedger->cost_price = $cost_rate;

                            $modelStockLedger->transaction_cost_rate = $cost_rate;

                            // $modelStockLedger->sales_price                    = $eachItem['rate']*$modelUOM->factor;

                            $modelStockLedger->sales_price = 0;

                            $modelStockLedger->transaction_date = ($model->goods_receipt_date != '' && $model->goods_receipt_date != '0000-00-00') ? $model->goods_receipt_date : '0000-00-00';

                            $modelStockLedger->transaction_from = 'PRODUCTION_GOODS_RECEIPT';

                            $modelStockLedger->transaction_type = "IN";

                            $modelStockLedger->stock_after_transaction = 0;

                            $modelStockLedger->stock_value_after_transaction = 0;

                            $modelStockLedger->master_stock_ledger_id = 0;

                            $modelStockLedger->stock_updated = 'Y';

                            $modelStockLedger->created_by = (int) Yii::app()->user->id;

                            $modelStockLedger->created_date = date("Y-m-d H:i:s");

                            $modelStockLedger->save(false);





                            $modelUpdateStore = new Store();

                            $modelUpdateStore->updateByPk((int) $eachItem->product_id, array('rate' => $cost_rate));

                        }

                    }







                    /**end**/

                    $model->updateByPk($model->id, array('grand_total' => $sum));







                    $production_order_id = (int) $_POST['ProductionGoodsReceipt']['production_order_id'];



                    if ((int) $total_current_cost_rate > 0 && $production_order_id > 0) {

                        //update production order

                        $modelProductionOrder = new ProductionOrder();



                        $modelProductionOrder->updateByPk($production_order_id, array('goods_issue_total_rate' => $total_current_cost_rate));

                    }





                    $jsonData['id'] = $model->id;

                    $jsonData['po'] = $model->findByPk($model->id);

                    $jsonData['status'] = 'success';

                    echo CJSON::encode($jsonData);

                }

            } else   //$model_stock_item_issue
            {

                $error1 = array();

                $error2 = array();

                $error3 = array();

                $error4 = array();

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);

                //if(!empty($model_stock_item))

                //$error3 = json_decode(CActiveForm::validate($model_stock_item, '', false), true); 

                //if(!empty($model_stock_item_issue))

                //$error4 = json_decode(CActiveForm::validate($model_stock_item_issue, '', false), true); 

                if ($modelItem[0]->product_id != '')

                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else

                    $error2[] = "Please add atleast one item " . $modelItem[0]->product_id;

                $error = CJSON::encode(array_merge_recursive($error2, $error1, $error3, $error4, $other_errors));

                if ($error != '[]')

                    echo $error;

            }

        }

    }

    public function updateStock($model)
    {



        $qty = $model->quantity;

        $warehouse = $model->warehouse_id;

        $rack = $model->rack_id;

        $bin = $model->bin_id;

        $product_id = $model->product_id;



        $receipt_id = $model->material_receipt_id;

        $row_item_id = $model->item_row_no;

        $find_id = $model->material_receipt_id;



        $item_model = new ProductionGoodsReceiptItem();

        $conditions = "production_goods_receipt_id='" . $receipt_id . "' AND row_id='" . $row_item_id . "'";



        $item_model = $item_model->find(array('condition' => $conditions));



        $qty = $qty * $item_model->unitdetails_mes->factor;

        $model->quantity = $qty;

        $model->updated = 'Y';

        $model->save(false);



        if ($rate > 0)

            $cur_total = $rate * $qty;
        else

            $cur_total = 0;

        if ($product_id > 0) {

            $product = Store::model()->findbyPk($product_id);

            $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id=' . $product_id . ' ')->queryScalar();

            $con = 'stock_id=' . $product_id;

            if ($warehouse > 0)

                $con .= ' AND warehouse_id=' . $warehouse;

            if ($rack > 0)

                $con .= ' AND rack=' . $rack;

            if ($bin > 0)

                $con .= ' AND bin=' . $bin;

            $productlocation = ProductLocation::model()->find(array('condition' => $con));

            if ($productlocation->id > 0) {

                $loc = ProductLocation::model()->findByPk($productlocation->id);

                $old = $loc->quantity;

                $loc->quantity = $old + $qty;

                $loc->save(false);

            } else {

                $newloc = new ProductLocation;

                $newloc->stock_id = $product_id;

                $newloc->warehouse_id = $warehouse;

                $newloc->rack = $rack;

                $newloc->bin = $bin;

                $newloc->quantity = $qty;

                $newloc->save(false);

            }

            Store::model()->updateByPk($product_id, array('total_quantity' => ($old_total_qty + $qty)));

        }

    }

    public function updateStock1($model)
    {



        $qty = $model->quantity;

        $warehouse = $model->warehouse_id;

        $rack = $model->rack_id;

        $bin = $model->bin_id;

        $product_id = $model->product_id;



        $receipt_id = $model->material_receipt_id;

        $row_item_id = $model->item_row_no;

        $find_id = $model->material_receipt_id;



        $item_model = new ProductionGoodsIssueReturnItem();

        $conditions = "production_goods_receipt_id='" . $receipt_id . "' AND row_id='" . $row_item_id . "'";



        $item_model = $item_model->find(array('condition' => $conditions));

        $qty = $qty * $item_model->unitdetails->factor;

        $model->quantity = $qty;

        $model->updated = 'Y';

        $model->save(false);



        if ($rate > 0)

            $cur_total = $rate * $qty;
        else

            $cur_total = 0;

        if ($product_id > 0) {

            $product = Store::model()->findbyPk($product_id);

            $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id=' . $product_id . ' ')->queryScalar();

            $con = 'stock_id=' . $product_id;

            if ($warehouse > 0)

                $con .= ' AND warehouse_id=' . $warehouse;

            if ($rack > 0)

                $con .= ' AND rack=' . $rack;

            if ($bin > 0)

                $con .= ' AND bin=' . $bin;

            $productlocation = ProductLocation::model()->find(array('condition' => $con));

            if ($productlocation->id > 0) {

                $loc = ProductLocation::model()->findByPk($productlocation->id);

                $old = $loc->quantity;

                $loc->quantity = $old + $qty;

                $loc->save(false);

            } else {

                $newloc = new ProductLocation;

                $newloc->stock_id = $product_id;

                $newloc->warehouse_id = $warehouse;

                $newloc->rack = $rack;

                $newloc->bin = $bin;

                $newloc->quantity = $qty;

                $newloc->save(false);

            }

            Store::model()->updateByPk($product_id, array('total_quantity' => ($old_total_qty + $qty)));

        }

    }



    /**modified and editted by jisha on 08-11-17**/

    public function actionSaveGI()
    {





        $model = new ProductionGoodsIssue();

        $modelItem = array(new ProductionGoodsIssueItem());

        if (isset($_POST['ProductionGoodsIssue'])) {

            if ((int) @$_POST['ProductionGoodsIssue']['id'] > 0) {

                $model = $model->findByPK($_POST['ProductionOrder']['id']);

                $audit_type = 'UPDATED';

            } else {

                $model->crm_user_id = Yii::app()->user->id;

                $model->created_by = Yii::app()->user->id;

                $model->created_datetime = date('Y-m-d h:i:s');

                $audit_type = 'CREATED';

            }

            $model->attributes = $_POST['ProductionGoodsIssue'];

            $model->notes = $_POST['ProductionGoodsIssue']['notes'];

            $model->remarks = $_POST['ProductionGoodsIssue']['remarks'];

            $model->reference = $_POST['ProductionGoodsIssue']['reference'];

            $model->connected_file = $_POST['ProductionGoodsIssue']['connected_file'];

            $model->terms_and_conditions = $_POST['ProductionGoodsIssue']['terms_and_conditions'];

            $model->customer_id = $_POST['ProductionGoodsIssue']['customer_id'];

            $model->is_goods_issued = 'Y';

            $model->warehouse_id = $_POST['ProductionGoodsIssue']['warehouse_id'];



            $production_order_id = (int) $_POST['ProductionGoodsIssue']['production_order_id'];



            if ($_POST['ProductionGoodsIssue']['goods_issue_date'] != '') {

                $model->goods_issue_date = str_replace('/', '-', $_POST['ProductionGoodsIssue']['goods_issue_date']);

                $model->goods_issue_date = date("Y-m-d", strtotime($model->goods_issue_date));

            }



            $model->updated_by = Yii::app()->user->id;

            $model->updated_datetime = date('Y-m-d h:i:s');

            $valid = $model->validate();

            $other_errors = array();



            //   ---------------------AccAuditClose check------------------------------------





            $issue_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['ProductionGoodsIssue']['goods_issue_date'])));



            $modelAccAuditClose = new AccAuditClose();

            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());

            $issue_date = strtotime($issue_datex);

            if ($issue_date <= $existing_date) {

                $valid = false;

                $other_errors[] = ' Given Issue date must be greater than Audit Close date  :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';

            }

            //   --------------------//-AccAuditClose check------------------------------------







            if (!empty($_POST['ProductionGoodsIssueItem'])) {

                foreach ($_POST['ProductionGoodsIssueItem'] as $k => $rowItem) {









                    if (empty($rowItem['id'])) {

                        $modelItem[$k] = new ProductionGoodsIssueItem();

                        $modelItem[$k]->created_by = Yii::app()->user->id;

                        $modelItem[$k]->created_datetime = date('Y-m-d h:i:s');

                    } else {

                        $modelItem[$k] = ProductionGoodsIssueItem::model()->findByPk($rowItem['id']);

                    }

                    $modelItem[$k]->attributes = $_POST['ProductionGoodsIssueItem'][$k];

                    //$modelItem[$k]->product_location_id = $rowItem['product_location_id']; 

                    $modelItem[$k]->picked_qty = $rowItem['picked_qty'];

                    $modelItem[$k]->po_item_id = $rowItem['po_item_id'];







                    $modelItem[$k]->production_goods_issue_id = 0;

                    $modelItem[$k]->updated_by = Yii::app()->user->id;

                    $modelItem[$k]->updated_datetime = date('Y-m-d h:i:s');

                    $valid = $modelItem[$k]->validate() && $valid;

                }

            }



            if ($valid) {

                if ($model->save()) {

                    // inserting to audit log

                    AuditLog::saveAuditLogs(

                        'GOODS_ISSUE',

                        Yii::app()->user->id,

                        $audit_type,

                        " with PKG No: - {$model->id}  "

                    );

                    // end audit log



                    /*    $sum = 0; 

                   if (!empty($modelItem)) {

                        foreach ($modelItem as $eachItem) {

                            $eachItem->production_goods_issue_id = $model->id;

                            $sum += $eachItem->amount;

                            $eachItem->save();

                            

                        }

                    }

                    $model->updateByPk($model->id, array('grand_total' => $sum));*/







                    // ----------------------added by indhu 14_04_2023------------------------------------------------



                    $sum = 0;

                    if (!empty($modelItem)) {



                        $modelCustomer = new Customer();

                        $modelRack = new MasInvRack();

                        $modelBin = new MasInvBin();

                        $modelProductClass = new ProductClass();

                        $modelUOM = new UnitOfMeasurement();





                        if ((int) $model->warehouse_id > 0) {

                            $warehouse_id = $model->warehouse_id;

                        } else {

                            $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
                            ;

                        }



                        $warehouse_name = '';

                        if ($warehouse_id > 0) {

                            $modwarehouse = new MasInventoryWarehouse();

                            $warehouse_name = $modwarehouse->getWarehouseName($warehouse_id);

                        }



                        $total_current_cost_rate = 0;

                        foreach ($modelItem as $eachItem) {

                            if ($eachItem->product_id > 0) {

                                $eachItem->rate = $eachItem->product->rate;

                                $eachItem->amount = $eachItem->product->rate * $eachItem->quantity;



                                $modelProductionOrderItem = new ProductionOrderItem();



                                $modelProductionOrderItem = $modelProductionOrderItem->findByPk((int) $eachItem->po_item_id);



                                $current_cost_rate = ($modelProductionOrderItem->bom_qty * $eachItem->rate);



                                if ($modelProductionOrderItem->goods_issue_cost_rate < $current_cost_rate) {

                                    $modelUpdateProductionOrderItem = new ProductionOrderItem();



                                    $modelUpdateProductionOrderItem = $modelProductionOrderItem->updateByPk((int) $eachItem->po_item_id, array('goods_issue_cost_rate' => $current_cost_rate));



                                    $total_current_cost_rate += $current_cost_rate;

                                }

                            }



                            $eachItem->production_goods_issue_id = $model->id;

                            $sum += $eachItem->amount;

                            $eachItem->save();

                            // -------------------------------------------------------------------



                            $modelproduct_class = '';

                            if ((int) $eachItem->product->brand_class_id > 0) {

                                $modelproduct_class = $modelProductClass->findByPk($eachItem->product->brand_class_id)->product_class;

                            }



                            $modelcustomer_name = '';

                            if ((int) $model->customer_id > 0) {

                                $modelcustomer_name = $modelCustomer->findByPk($model->customer_id)->customer_name;

                            }



                            $modelUOM = $modelUOM->findByPk((int) $eachItem->unit);

                            // ---------------------------

                            $modelStockLedger = new StockLedger();

                            $modelStockLedger->brand_id = $eachItem->product->brand_class_id;

                            $modelStockLedger->brand_name = $modelproduct_class;

                            $modelStockLedger->customer_vendor_id = $model->customer_id;

                            $modelStockLedger->customer_vendor_name = $modelcustomer_name;

                            $modelStockLedger->file_id = $model->file_id;

                            $modelStockLedger->header_id = $model->id;

                            $modelStockLedger->header_item_id = $eachItem->id;

                            $modelStockLedger->product_id = $eachItem->product_id;

                            $modelStockLedger->product_name = $eachItem->product->part_number;

                            $modelStockLedger->product_description = $eachItem->product->description;

                            $modelStockLedger->warehouse_id = $warehouse_id;

                            $modelStockLedger->warehouse_name = $warehouse_name;

                            $modelStockLedger->rack_id = $modelRack->getDefaultRackId();

                            $modelStockLedger->rack_name = $modelRack->getRackName((int) $modelStockLedger->rack_id);

                            $modelStockLedger->bin_id = $modelBin->getDefaultBinId();

                            $modelStockLedger->bin_name = $modelBin->getBinName((int) $modelStockLedger->bin_id);

                            $modelStockLedger->unit_id = $eachItem->unit;

                            $modelStockLedger->unit_name = $modelUOM->name;

                            $modelStockLedger->unit_factor = $modelUOM->factor;

                            $modelStockLedger->quantity = -1 * $eachItem->picked_qty;

                            $modelStockLedger->available_status = 'U'; //U

                            $modelStockLedger->buying_price = 0;

                            $modelStockLedger->batch_no = '';

                            $modelStockLedger->serial_no = '';

                            $modelStockLedger->manufacturing_date = '0000-00-00';

                            $modelStockLedger->expiry_date = '0000-00-00';

                            $modelStockLedger->cost_price = $eachItem->product->rate;

                            $modelStockLedger->transaction_cost_rate = $eachItem->product->rate;

                            // $modelStockLedger->sales_price                    = $eachItem['rate']*$modelUOM->factor;

                            $modelStockLedger->sales_price = 0;

                            $modelStockLedger->transaction_date = ($model->goods_issue_date != '' && $model->goods_issue_date != '0000-00-00') ? $model->goods_issue_date : '0000-00-00';

                            $modelStockLedger->transaction_from = 'PRODUCTION_GOODS_ISSUE';

                            $modelStockLedger->transaction_type = "OUT";

                            $modelStockLedger->stock_after_transaction = 0;

                            $modelStockLedger->stock_value_after_transaction = 0;

                            $modelStockLedger->master_stock_ledger_id = 0;

                            $modelStockLedger->stock_updated = 'Y';

                            $modelStockLedger->created_by = (int) $model->created_by;

                            $modelStockLedger->created_date = date("Y-m-d H:i:s");

                            $modelStockLedger->save(false);

                        }

                    }

                    // --------------end----------------------------



                    $model->updateByPk($model->id, array('grand_total' => $sum));





                    if ((int) $total_current_cost_rate > 0 && $production_order_id > 0) {

                        //update production order

                        $modelProductionOrder = new ProductionOrder();



                        $modelProductionOrder->updateByPk($production_order_id, array('goods_issue_total_rate' => $total_current_cost_rate));

                    }







                    $jsonData['id'] = $model->id;

                    $jsonData['po'] = $model->findByPk($model->id);

                    $jsonData['status'] = 'success';

                    echo CJSON::encode($jsonData);

                }

            } else {

                $error1 = array();

                $error2 = array();

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);

                if ($modelItem[0]->product_id > 0)

                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else

                    $error2[] = "Please add atleast one item";

                $error = CJSON::encode(array_merge_recursive($error2, $error1, $other_errors));

                if ($error != '[]')

                    echo $error;

            }

        }

    }

    public function actionDeletePOItem()
    {

        $id = $_POST['id'];

        $model = new ProductionOrderItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }

    public function actionDeleteBMItem()
    {

        $id = $_POST['id'];

        $model = new ProductionBillofmaterialItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }

    /**modified and editted by jisha on 08-11-17**/



    public function actionPrintProductionBOMPDF()
    {



        $model = new ProductionBillofmaterial();

        $id = Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = new ProductionBillofmaterial();

        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.production_bom', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');

    }

    /**modified and editted by jisha on 08-11-17**/



    public function actionPrintProductionPOPDF()
    {



        $model = new ProductionOrder();

        $id = Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = new ProductionOrder();

        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.production_po', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');

    }

    /**modified and editted by jisha on 08-11-17**/



    public function actionPrintProductionGIPDF()
    {



        $model = new InventoryGoodsIssue();

        $id = Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = new InventoryGoodsIssue();

        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.production_gi', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');

    }





    /**modified and editted by jisha on 08-11-17**/

    public function actionPrintProductionGRPDF()
    {



        $model = new InventoryGoodsReceipt();

        $id = Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = new InventoryGoodsReceipt();

        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.production_gr', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');

    }



    public function actionGetunitdrop()
    {

        $row = $_POST['row_field'];

        $product = $_POST['product_id'];

        $type = $_POST['type'];

        $drop = array();

        if ($type == 'bof')

            $modelOrder = new ProductionBillofmaterialItem;

        if ($type == 'po')

            $modelOrder = new ProductionOrderItem;

        if ($product > 0) {

            $modelOrder->unit = UnitOfMeasurement::getBaseunit($product);

            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", UnitOfMeasurement::getUnits($product), array('class' => 'unit go'));

        }

        echo CJSON::encode($drop);

    }



    public function actionGetunit()
    {



        $product_id = (int) $_POST['product_id'];

        $modelStore = new Store();

        $modelStore = $modelStore->findByPk($product_id);



        $drop = array();

        $modelOrder = new ProductionBillofmaterial;

        if ($product_id > 0) {



            $model = new UnitOfMeasurement();

            $model = $model->find('product_id="' . $product_id . '" AND unit_id=' . (int) $modelStore->unit_id);



            $data['name'] = $model->name;

            $data['id'] = $model->id;

        }

        echo CJSON::encode($data);

    }



    public function actionGetStockDetails()
    {



        $product_id = $_POST['product_id'];

        $quantity = $_POST['Qty'];

        $length = $_POST['length'];

        $stock_details = array(new MaterialReceiptStockDetails);



        if ((int) $product_id > 0) {

            $product = Store::model()->findBypk($product_id);

            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = ' . $product_id . ' AND quantity > 0'));

        }



        $table = '';

        $flag = 0;

        $checkbox_status = false;



        if ($stock_details[0]->id > 0) {



            foreach ($stock_details as $each) {

                //                $mod_alloc=new AllocatedMaterial();

                //                $alloc_qty=$mod_alloc->find(array('select'=>'SUM(quantity)AS quantity ','condition'=>'product_id = '.$product_id.' AND warehouse_id ='.$from_warehouse))->quantity;

                //                $free_qty=(float)((float)$each->quantity-(float)$alloc_qty);



                if ($each->quantity >= $quantity and $flag == 0) {

                    $qty = $quantity;

                    $checkbox_status = true;

                    $flag++;

                } else {

                    $qty = "";

                }



                $class = '';

                if ($each->expiry_date != '0000-00-00') {

                    $expire = date('d/m/Y', strtotime($each->expiry_date));

                    if (strtotime($each->expiry_date) < strtotime(date('Y-m-d'))) {

                        $class = 'bg-danger';

                    }

                } else {

                    $expire = '-';

                }

                if ($each->stock_affect_date != '0000-00-00') {

                    $purchased = date('d/m/Y', strtotime($each->stock_affect_date));

                } else {

                    $purchased = '-';

                }



                $table .= '<tr class="' . $class . ' TR-' . $length . ' pro' . $product_id . '">';

                $table .= '<td style="display: none;">' . CHtml::checkbox('Data[' . $length . '][checked]', $checkbox_status, array('value' => $each->id, 'class' => 'checkbx chk_of_' . $length)) . '</td>';

                $table .= '<td>' . $each->warehousename->warehouse_name . '</td>';

                $table .= '<td>' . $product->part_number . CHtml::hiddenfield('Data[' . $length . '][product_id]', $product_id) . CHtml::hiddenfield('Data[' . $length . '][material_receipt_id]', $each->id) . '</td>';

                $table .= '<td>' . $each->rack->name . CHtml::hiddenfield('Data[' . $length . '][rack_id]', $each->rack_id) . '</td>';

                $table .= '<td>' . $each->bin->name . CHtml::hiddenfield('Data[' . $length . '][bin_id]', $each->bin_id) . '</td>';

                $table .= '<td>' . $each->batch_no . '</td>';

                $table .= '<td>' . $each->serial_no . '</td>';

                $table .= '<td>' . $purchased . '</td>';

                $table .= '<td>' . $expire . '</td>';

                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][bill_of_exit]', '', array('class' => 'form-control')) . '</td>';

                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][qty_available]', $each->quantity, array('class' => 'form-control text-right', 'readonly' => 'readonly')) . '</td>';

                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][picked_qty]', $qty, array('class' => 'form-control text-right', 'onkeyup' => 'verifyQty(this.id,this.value);', 'onkeypress' => 'return isNumberKey(event);')) . '</td>';

                $table .= '</tr>';

                $length++;

                $checkbox_status = false;

            }

        } else {

            if ($length == 0)

                $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';

        }



        echo $table;

    }



    public function actionAddQtnDetails()
    {



        $product_name = filter_var($_POST['product_name'], FILTER_SANITIZE_STRING);

        $product_id = filter_var($_POST['product_id'], FILTER_VALIDATE_INT);

        $quantity = filter_var($_POST['quantity'], FILTER_VALIDATE_INT);

        $totalquantity = filter_var($_POST['totalquantity'], FILTER_VALIDATE_INT);

        $order_id = filter_var($_POST['order_id'], FILTER_VALIDATE_INT);

        $newId = filter_var($_POST['newId'], FILTER_VALIDATE_INT);

        $item_row_id = filter_var($_POST['item_row_id'], FILTER_VALIDATE_INT);

        $model_material_stock = new MaterialReceiptStockDetails();

        $model_product = Store::model()->findbyPK($product_id);

        $batch_mandty = 0;

        $serial_mandty = 0;

        $color_mandatory = "";

        $color_mandatory_1 = "";

        if ($model_product->have_expiry_date == "Y") {

            $batch_mandty = 1;

            $color_mandatory = "bg-danger";

        }

        if ($model_product->have_serial_no == "Y") {

            $serial_mandty = 1;

            $color_mandatory_1 = "bg-danger";

        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        if ($model_product->have_serial_no == "Y") {

            $this->render('material_receipt_stock_serial_details', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));

        } else {

            $this->render('material_receipt_stock_details', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));

        }

    }

    public function actionAddIssuesQtnDetails()
    {



        $product_name = filter_var($_POST['product_name'], FILTER_SANITIZE_STRING);

        $product_id = filter_var($_POST['product_id'], FILTER_VALIDATE_INT);

        $quantity = filter_var($_POST['quantity'], FILTER_VALIDATE_INT);

        $totalquantity = filter_var($_POST['totalquantity'], FILTER_VALIDATE_INT);

        $order_id = filter_var($_POST['order_id'], FILTER_VALIDATE_INT);

        $newId = filter_var($_POST['newId'], FILTER_VALIDATE_INT);

        $item_row_id = filter_var($_POST['item_row_id'], FILTER_VALIDATE_INT);

        $model_material_stock = new MaterialReceiptStockDetails();

        $model_product = Store::model()->findbyPK($product_id);

        $batch_mandty = 0;

        $serial_mandty = 0;

        $color_mandatory = "";

        $color_mandatory_1 = "";

        if ($model_product->have_expiry_date == "Y") {

            $batch_mandty = 1;

            $color_mandatory = "bg-danger";

        }

        if ($model_product->have_serial_no == "Y") {

            $serial_mandty = 1;

            $color_mandatory_1 = "bg-danger";

        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        if ($model_product->have_serial_no == "Y") {

            $this->render('material_receipt_stock_serial', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));

        } else {

            $this->render('material_receipt_stock', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));

        }

    }





    public function actionGetRate()
    {

        $factor = 1;

        if ((int) $_POST['value'] > 0) {

            $factor = UnitOfMeasurement::getRate($_POST['value']);

        }

        echo $factor;

    }



    public function actionGetListProGoodsIssue()
    {

        $model = new PackagingList();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 'transaction_id',

            1 => 'file_id',

            2 => 'customer_name',

            4 => 'transaction_date',



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 'status="PRGI"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (transaction_id LIKE '%" . $searchString . "%' OR customer_name LIKE '%" . $searchString . "%' OR packing_frm LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'transaction_date desc'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $transaction_date = date("d/m/Y", strtotime($row->transaction_date));

            $rowData[] = array($row['transaction_id'], $transaction_date, $row['customer_name'], $row['packing_frm'], $row['status']);

            $m++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }





    public function actionGetListProGoodsIssueReturn()
    {

        $model = new ProductionGoodsReceipt();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 't.product_name',

            2 => 't.description',

            3 => 'quantity',

            4 => 't.id',



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        //$orderBy = " id desc ";

        $condition = '1=1 AND is_updated_store="N"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (t.product_name LIKE '%" . $searchString . "%' OR t.description LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";

        }

        $count = $model->with('order')->count(array('condition' => $condition));

        $model = $model->with('order')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $current = strtotime(date('y-m-d'));

        foreach ($model as $row) {

            $div = '';



            $rowData[] = array($row['id'], $row['order']['id'], $row['product_name'], $row['description'], $row['quantity'], date('d/m/Y', strtotime($row['order']['productionorder_date'])), date('d/m/Y', strtotime($row['order']['end_date'])), $row['id']);

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }



    public function actionReturnItemForm()
    {

        $id = (int) Yii::app()->request->getParam('id');

        $model = new ProductionGoodsReceipt();

        if ($id > 0) {

            $model = $model->findByPk($id);



            $k = 0;

            $modelReceiptItem = ProductionGoodsReceiptItem::model()->findAll(array('condition' => 'production_goods_receipt_id=' . $id . ' AND quantity>0'));

            if (!empty($modelReceiptItem)) {

                foreach ($modelReceiptItem as $eachItem) {

                    $modelItems[$k] = new ProductLocationDetails;

                    $modelItems[$k]->product_id = $eachItem->product_id;

                    $modelItems[$k]->quantity = $eachItem->quantity;

                    $modelItems[$k]->header_id = $eachItem->production_goods_receipt_id;

                    $modelItems[$k]->header_item_id = $eachItem->id;

                    $modelItems[$k]->transaction_type = "PRODUCTION_RECEIPT";

                    $k++;

                }

            }

            $modelIssueReturnItem = ProductionGoodsIssueReturnItem::model()->findAll(array('condition' => 'production_goods_receipt_id=' . $id . ' AND return_qty>0'));

            if (!empty($modelIssueReturnItem)) {

                foreach ($modelIssueReturnItem as $eachItem) {

                    $modelItems[$k] = new ProductLocationDetails;

                    $modelItems[$k]->product_id = $eachItem->product_id;

                    $modelItems[$k]->quantity = $eachItem->return_qty;

                    $modelItems[$k]->header_id = $eachItem->production_goods_receipt_id;

                    $modelItems[$k]->header_item_id = $eachItem->id;

                    $modelItems[$k]->transaction_type = "PRODUCTION_RETURN_ISSUE_ITEM";

                    $k++;

                }

            }

            if (empty($modelItems)) {

                $modelItems = array(new ProductLocationDetails());

            }

        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);

        $this->render('returnItemForm', array('model' => $model, 'items' => $modelItems, 'id' => $id));

    }



    public function actionSavematerial()
    {



        $modelReceipt = new ProductionGoodsReceipt();

        $receivedQuantity = array();

        $valid = true;



        if (is_array($_POST['ProductLocationDetails'])) {

            foreach ($_POST['ProductLocationDetails'] as $i => $item) {



                if ($item['product_id'] > 0 and $item['quantity'] > 0) {

                    $modelProLocDetails[$i] = new ProductLocationDetails;

                    $modelProLocDetails[$i]->attributes = $_POST['ProductLocationDetails'][$i];

                    $modelProLocDetails[$i]->header_id = $item['header_id'];

                    $modelProLocDetails[$i]->header_item_id = $item['header_item_id'];

                    $modelProLocDetails[$i]->product_id = $item['product_id'];

                    $modelProLocDetails[$i]->bill_of_entry = $item['bill_of_entry'];

                    $modelProLocDetails[$i]->warehouse_id = $item['warehouse_id'];

                    $modelProLocDetails[$i]->rack_id = $item['rack_id'];

                    $modelProLocDetails[$i]->bin_id = $item['bin_id'];

                    $modelProLocDetails[$i]->batch_no = $item['batch_no'];

                    $modelProLocDetails[$i]->serial_no = $item['serial_no'];

                    $modelProLocDetails[$i]->quantity = $item['quantity'];

                    $modelProLocDetails[$i]->transaction_type = $item['transaction_type'];

                    $modelProLocDetails[$i]->created_by = Yii::app()->user->id;

                    $modelProLocDetails[$i]->created_date = date('Y-m-d h:i:s');



                    if ($item['manufacturing_date'] != '00/00/0000' and $item['manufacturing_date'] != '01/01/1970' and $item['manufacturing_date'] != '') {

                        $mf_date = str_replace('/', '-', $item['manufacturing_date']);

                        $modelProLocDetails[$i]->manufacturing_date = date("Y-m-d", strtotime($mf_date));

                    } else {

                        $modelProLocDetails[$i]->manufacturing_date = "0000-00-00";

                    }

                    if ($item['expiry_date'] != '00/00/0000' and $item['expiry_date'] != '01/01/1970' and $item['expiry_date'] != '') {

                        $expiry_date = str_replace('/', '-', $item['expiry_date']);

                        $modelProLocDetails[$i]->expiry_date = date("Y-m-d", strtotime($expiry_date));

                    } else {

                        $modelProLocDetails[$i]->expiry_date = "0000-00-00";

                    }

                    $valid = $modelProLocDetails[$i]->validate() && $valid;

                }

            }







            if ($valid) {



                $production_receipt_id = $_POST['production_receipt_id'];

                if ($production_receipt_id > 0) {

                    $modelReceipt = $modelReceipt->findByPk($production_receipt_id);

                    $modelReceipt->is_updated_store = "Y";

                    $modelReceipt->save(false);

                }

                if (!empty($modelProLocDetails)) {

                    foreach ($modelProLocDetails as $eachItem) {

                        if (empty($eachItem->batch_no)) {

                            $eachItem->batch_no = $modelReceipt->id;

                        }

                        $eachItem->isActive = "Y";

                        $eachItem->save(false);



                        $stockLedger = new StockLedger;

                        $stockLedger->header_id = $eachItem['header_id'];

                        $stockLedger->header_item_id = $eachItem['header_item_id'];

                        $stockLedger->transaction_date = date('Y-m-d');

                        $stockLedger->transaction_type = $eachItem['transaction_type'];

                        $stockLedger->product_id = $eachItem['product_id'];

                        $stockLedger->quantity = $eachItem['quantity'];

                        $stockLedger->product_location_id = $eachItem->id;



                        $modelStore = Store::model()->findBypk($eachItem['product_id']);

                        $stockLedger->unit_id = $modelStore['unit_id'];

                        $stockLedger->warehouse_id = $eachItem['warehouse_id'];

                        $stockLedger->rack_id = $eachItem['rack_id'];

                        $stockLedger->bin_id = $eachItem['bin_id'];

                        $stockLedger->created_by = Yii::app()->user->id;

                        $stockLedger->created_date = date('Y-m-d h:i:s');

                        $stockLedger->cost_price = $modelStore->rate;

                        $stockLedger->save(false);

                    }

                }

                echo CJSON::encode(array('status' => 'success'));

            } else {



                $error2 = array();

                $error4 = array();

                $error1 = array();

                if (!empty($modelProLocDetails))

                    $error2 = json_decode(CActiveForm::validateTabular($modelProLocDetails, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $error2));

                if ($error != '[]' || $error != '')

                    echo $error;

            }

        }

    }





    public function actionGetunitdropnew()
    {

        $product_id = (int) $_POST['product_id'];

        $drop = array();

        $modelProductionBillofmaterial = new ProductionBillofmaterial;

        if ($product_id > 0) {

            $modelProductionBillofmaterial->unit = UnitOfMeasurement::getBaseunit($product_id);

            $drop['drop'] = CHtml::activeDropDownList($modelProductionBillofmaterial, "unit", UnitOfMeasurement::getUnits($product_id), array('onchange' => 'GetUnitFactor(this.value);', 'class' => 'tooltipster', 'title' => 'Unit', 'data-label' => 'Unit <span style="color:red">*</span>'));



            $drop['status'] = 'success';

        }

        echo CJSON::encode($drop);

    }



    public function actionGetunitFactor()
    {

        $product_id = (int) $_POST['product_id'];

        $unit_id = (int) $_POST['unit'];

        $data = array();

        $modelProductionBillofmaterial = new ProductionBillofmaterial;

        if ($product_id > 0) {

            $modelUnitOfMeasurement = new UnitOfMeasurement();

            $modelUnitOfMeasurement = $modelUnitOfMeasurement->find(array('condition' => 'product_id=' . $product_id . ' AND id=' . $unit_id . ''));

            $unit_factor = ($modelUnitOfMeasurement->factor > 0) ? $modelUnitOfMeasurement->factor : 0;

            $data['unit_factor'] = $unit_factor;

            $data['status'] = 'success';

        }

        echo CJSON::encode($data);

    }





    public function actionGetPODetailsForGoodsIssue()
    {

        $order_id = (int) $_POST['order_id'];

        $warehouse_id = (int) $_POST['warehouse_id'];

        //$frm            = (int) $_POST['frm'];





        $modelorder = new ProductionOrder();

        $modelorder = $modelorder->findByPk($order_id);

        //$conditions  = 'isActive="Y"';

        //$modelorder  = $modelorder->find(array('condition' =>  'isActive="Y"'));

        $data['order'] = $modelorder;

        $data['customer_id'] = $modelorder->customer_id;

        $data['customer_name'] = $modelorder->customer_id;

        $items = ProductionOrderItem::model()->findAll(array('condition' => 'production_order_id ="' . $order_id . '"', 'group' => 'product_id'));



        $error_count = 0;

        $data['model_items'] = '';

        $balance_qty = 0;

        foreach ($items as $i => $model) {



            $order_qty = Yii::app()->db->createCommand()

                ->select('sum(quantity)')

                ->from('erp_production_order_item')

                ->where('production_order_id=' . $order_id . ' AND product_id=' . $model['product_id'])

                ->queryScalar();



            $model->quantity = $order_qty;

            $po_item_id = $model->id;

            $product = Store::model()->findByPk($model->product_id);

            $modelGoodsIssueItem = new InventoryGoodsIssueItem;



            //$modelGoodsIssueItem->

            $picked_qty = $model->quantity;

            //$picked_qty_baseunit    = $picked_qty / $model->unitdetails->factor;



            $model_unit_measure = new UnitOfMeasurement();

            //$model_unit_measure   = $model_unit_measure->find('product_id="' . $model->product_id . '" AND isBase="Y"');

            $model_unit_measure = $model_unit_measure->find('product_id="' . $model->product_id . '"');

            //echo $model->product_id;

            $model->unit = $model_unit_measure->id;

            $factor = $model_unit_measure->factor;



            if ($picked_qty > 0) {

                if ((int) $model->product_id > 0 && $warehouse_id > 0) {

                    $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . (int) $model->product_id . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();



                    $availble_qty = number_format((float) $availble_qty, 2, '.', '');



                } else {

                    $availble_qty = '0';

                }



                $SQL_ISSUE = 'SELECT SUM(picked_qty) FROM `erp_inventory_goods_issue_item` GII INNER JOIN erp_inventory_goods_issue GI ON GI.id=GII.inventory_goods_issue_id WHERE product_id=' . (int) $model->product_id . ' AND warehouse_id=' . (int) $warehouse_id . ' AND reference_id=' . (int) $order_id . ' AND GI.stock_updated="Y"';

                $goods_issue_qty = Yii::app()->db->createCommand($SQL_ISSUE)->queryScalar();





                $bom_qty = number_format((float) $model->quantity, 2, '.', '');

                $picked_qty = number_format((float) $model->quantity, 2, '.', '');

                $balance_qty = number_format((float) ($bom_qty - $goods_issue_qty), 2, '.', '');



                ($modelGoodsIssueItem->unit > 0) ? $factor = $modelGoodsIssueItem->uom->factor : $factor = 1;

                ($model->product_id > 0) ? $unit_data = UnitOfMeasurement::getUnits($model->product_id) : $unit_data = array();

                $data['model_items'] .= ' <tr>



                <td><label>' . ($i + 1) . '</label></td>

               

                <td>' . CHtml::ActivehiddenField($modelGoodsIssueItem, "[" . $i . "]id") .

                    CHtml::ActivehiddenField($modelGoodsIssueItem, "[" . $i . "]product_id", array('value' => $model->product_id)) .

                    CHtml::ActivehiddenField($modelGoodsIssueItem, "[" . $i . "]rate") .

                    CHtml::ActivetextField($modelGoodsIssueItem, "[" . $i . "]product_name", array('class' => 'go', 'readonly' => true, 'value' => $model->product_name)) . '</td>

                <td class="cell-right">' . CHtml::ActivetextArea($modelGoodsIssueItem, "[" . $i . "]description", array('data-label' => 'Description', 'class' => 'go', 'readonly' => 'readonly', 'value' => $model->description)) . '</td>

                <td class="cell-right">' . CHtml::ActivetextField($modelGoodsIssueItem, "[" . $i . "]free_qty", array('class' => 'go', 'readonly' => true, 'value' => $availble_qty)) . '</td>

                <td class="cell-right">' . CHtml::ActivetextField($modelGoodsIssueItem, "[" . $i . "]bom_qty", array('class' => 'go', 'readonly' => true, 'value' => $bom_qty)) . '</td>

                <td class="cell-right">' . CHtml::ActivetextField($modelGoodsIssueItem, "[" . $i . "]balance_qty", array('class' => 'go', 'readonly' => true, 'value' => $balance_qty)) . '</td>

                <td>' . CHtml::ActivetextField($modelGoodsIssueItem, "[" . $i . "]picked_qty", array(

                                'class' => 'qty go cell-center text-right',
                                'onkeypress' => 'return isPositiveInteger(event)',
                                'onkeydown' => 'isNumberKey(event,this.value)',

                                'onkeyup' => 'checkVal(this.id,this.value);',
                                'data-label' => 'Quantity',
                                'class' => 'go'

                            )) . '</td>

                <td id="unit_' . $i . '">' . CHtml::Activedropdownlist($modelGoodsIssueItem, "[" . $i . "]unit", $unit_data, array('class' => 'qty go')) . '</td>

                <td class="text-center nw" width="1%">' . CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeTable($(\'#issue_details_table\'),this,this.id)', 'title' => 'Remove this item', 'id' => 'requisition_' . $i)) . '</td>

                </tr>';

            } else {

                $error_count++;

            }

        }

        if ($error_count > 0) {

            $data['model_items'] .= '<tr><td colspan="9">No Products</td></tr>';

        }



        echo CJSON::encode($data);

        Yii::app()->end();

    }



    public function actionGetPODetailsForGoodsReceipt()
    {

        $order_id = (int) $_POST['order_id'];

        $warehouse_id = (int) $_POST['warehouse_id'];

        $frm = (int) $_POST['frm'];





        $modelorder = new ProductionOrder();

        $modelorder = $modelorder->findByPk($order_id);



        $picked_qty = $modelorder->quantity;



        $item_per_cost = '';

        if ($picked_qty > 0) {

            //$mod_ledger = StockLedger::model()->find(['select'=>'SUM(cost_price*quantity) AS cost_price,SUM(quantity) AS quantity','condition'=>'transaction_from="GOODS_ISSUE" AND header_id ='.(int)$eachIssueItem->id]);

            $SQL = "SELECT SUM(`quantity`*`cost_price`) AS cost_price

                    FROM `erp_stock_ledger` 

                    WHERE transaction_from='GOODS_ISSUE' 

                        AND header_id IN (SELECT id FROM erp_inventory_goods_issue WHERE reference_id=" . (int) $order_id . ")";

            $total_cost = (float) abs(Yii::app()->db->createCommand($SQL)->queryScalar());

            //$SQL="SELECT SUM(`quantity`*`rate`) AS total_cost FROM `erp_production_order_item` WHERE `production_order_id`=".$order_id;

            //$total_cost = (float) Yii::app()->db->createCommand($SQL)->queryScalar();



            $item_per_cost = ($total_cost / $picked_qty);

        }



        $error_count = 0;

        $data['model_items'] = '';



        $po_item_id = $modelorder->id;

        $modelStore = Store::model()->findByPk($modelorder->product_id);

        $modelGoodsRececiptItem = new InventoryGoodsReceiptItem;





        $data['customer_id'] = $modelorder->customer_id;

        $data['customer_name'] = $modelorder->customerdetails->customer_name;

        $data['reference'] = $modelorder->reference;

        $model_unit_measure = new UnitOfMeasurement();

        $model_unit_measure = $model_unit_measure->find('product_id="' . $modelStore->id . '"');

        $i = 0;

        if ($picked_qty > 0) {

            ($modelGoodsRececiptItem->unit > 0) ? $factor = $modelGoodsRececiptItem->uom->factor : $factor = 1;

            ($modelStore->id > 0) ? $unit_data = UnitOfMeasurement::getUnits($modelStore->id) : $unit_data = array();

            $data['model_items'] .= ' <tr>



            <td><label>' . ($i + 1) . '</label></td>

           

            <td>' . CHtml::ActivehiddenField($modelGoodsRececiptItem, "[" . $i . "]id") .

                CHtml::ActivehiddenField($modelGoodsRececiptItem, "[" . $i . "]product_id", array('value' => $modelStore->id)) .

                CHtml::ActivehiddenField($modelGoodsRececiptItem, "[" . $i . "]rate") .

                CHtml::ActivetextField($modelGoodsRececiptItem, "[" . $i . "]product_name", array('class' => 'go', 'readonly' => true, 'value' => $modelStore->part_number)) . '</td>

            <td class="cell-right">' . CHtml::ActivetextArea($modelGoodsRececiptItem, "[" . $i . "]description", array('data-label' => 'Description', 'class' => 'go', 'readonly' => 'readonly', 'value' => $modelStore->description)) . '</td>

             

            <td>' . CHtml::ActivetextField($modelGoodsRececiptItem, "[" . $i . "]picked_qty", array(

                            'class' => 'qty go cell-center text-right',
                            'onkeypress' => 'return isPositiveInteger(event)',
                            'onkeydown' => 'isNumberKey(event,this.value)',

                            'onkeyup' => 'checkVal(this.id,this.value);',
                            'data-label' => 'Quantity',
                            'class' => 'go',
                            'value' => number_format($picked_qty, 2, '.', '')

                        )) . '</td>

                <td id="unit_' . $i . '">' . CHtml::Activedropdownlist($modelGoodsRececiptItem, "[" . $i . "]unit", $unit_data, array('class' => 'qty go')) . '</td>

            <td>' . CHtml::ActivetextField($modelGoodsRececiptItem, "[" . $i . "]current_cost", array('class' => 'go', 'value' => number_format($modelStore->rate, 2, '.', ''), 'readonly' => true)) . '</td> 

            <td>' . CHtml::ActivetextField($modelGoodsRececiptItem, "[" . $i . "]rate", array('class' => 'go', 'value' => number_format($item_per_cost, 2, '.', ''))) . '</td>   

           

            <td class="text-center nw" width="1%">' . CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeTable($(\'#issue_details_table\'),this,this.id)', 'title' => 'Remove this item', 'id' => 'requisition_' . $i)) . '</td>

            </tr>';

        } else {

            $error_count++;

        }



        if ($error_count > 0) {

            $data['model_items'] .= '<tr><td colspan="9">No Products</td></tr>';

        }



        echo CJSON::encode($data);

        Yii::app()->end();

    }



    public function actionGetProductionOrderItem()
    {

        $warehouse_id = (int) $_POST['warehouse_id'];

        $production_order_id = (int) $_POST['production_order_id'];

        $frm = $_POST['frm'];



        $modelProductionOrder = new ProductionOrder();

        $modelProductionOrder = $modelProductionOrder->findByPk($production_order_id);



        $modelProductionOrderItem = new ProductionOrderItem();

        $modelProductionOrderItem = $modelProductionOrderItem->findAll(array('condition' => 'production_order_id=' . $production_order_id));



        $data['order_items'] = '';

        foreach ($modelProductionOrderItem as $i => $eachItem) {



            if ($frm == 'PO') {



                if ($warehouse_id > 0) {

                    $total_available_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . (int) $eachItem->product_id . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();

                } else {

                    $total_available_qty = $total_free_qty - $total_allocated_qty;

                }



                $total_available_qty = round($total_available_qty, 2);

            } else {

                $modelStore = new Store();

                $modelStore = $modelStore->findByPk((int) $eachItem->product_id);

                $total_free_qty = (float) $modelStore->totalQuantity;

                $total_allocated_qty = (float) $modelStore->total_allocated_quantity;

                $total_available_qty = $total_free_qty - $total_allocated_qty;

            }



            $eachItem->bom_qty = $eachItem->quantity;



            $eachItem->quantity = ($eachItem->quantity * $modelProductionOrder->quantity);



            if ($eachItem->quantity > $total_available_qty) {

                $data['order_items'] .= '<tr id="tr_po_' . $i . '" style="background-color:#df8585">';

            } else {

                $data['order_items'] .= '<tr id="tr_po_' . $i . '">';

            }

            $data['order_items'] .= '<td><label>' . ($i + 1) . '</label></td>';

            $data['order_items'] .= '<td>' . CHtml::ActivetextField($eachItem, "[" . $i . "]product_name", array(
                'class' => 'tooltipster go',
                'placeholder' => 'Type & Select',

                'onKeyup' => 'js:autoCompletePO(this.id,"po");',
                'value' => $eachItem->product->part_number,

                'title' => 'Select product',
                'readonly' => true
            )) .

                CHtml::ActivehiddenField($eachItem, "[" . $i . "]id") .

                CHtml::ActivehiddenField($eachItem, "[" . $i . "]product_id") . '</td>';

            $data['order_items'] .= '<td>

                ' . CHtml::ActivetextArea($eachItem, "[" . $i . "]description", array('class' => 'tooltipster desc go', 'title' => 'Add Description here', 'readonly' => true)) . '</td>';

            $data['order_items'] .= '<td>' . CHtml::ActivetextField($eachItem, "[" . $i . "]bom_qty", array('class' => 'qty go text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#tbl_po_item"));', 'readonly' => true)) . '                  

            </td>';

            $data['order_items'] .= '<td>' . CHtml::ActivetextField($eachItem, "[" . $i . "]quantity", array('class' => 'qty go text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValues($("#tbl_po_item"));', 'readonly' => true)) . '                  

            </td>';

            $data['order_items'] .= '<td style="color:red;text-align:right;">' . $total_available_qty . CHtml::ActivehiddenField($eachItem, "[" . $i . "]available_qty", array('value' => $total_available_qty)) . '</td>';

            $data['order_items'] .= '</tr>';



        }





        echo CJSON::encode($data);





    }

    /**added by jisha on 23-05-25 

    ---to get salesorder in PO**/

    public function actionGetSalesOrders()
    {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $condition = 'id LIKE "%' . $searchTerm . '%" AND isActive="Y" ';

        $model = new Order();

        $model = $model->findAll(array('condition' => $condition));

        $i = 0;

        foreach ($model as $i => $eachModel) {

            $data[$i]['value'] = $eachModel->id;

            $data[$i]['label'] = $eachModel->id . '-' . $eachModel->customer->customer_name;

            $data[$i]['customer_id'] = $eachModel->customer_id;

            $data[$i]['other'] = $eachModel->customer->customer_name;

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }
    public function actionorderConvertion()
    {
        $response = ['success' => false, 'message' => 'No data received'];
        $modelStore = Store::model()->find('part_number = :part_number', [':part_number' => 'D100001']);

        if (!empty($_POST['OrderItem'])) {
            $allSaved = true;

            foreach ($_POST['OrderItem'] as $k => $rowItem) {
                $model = new ProductionOrder();
                $model->product_id = $rowItem['product_id'] ?? null;
                $model->selectedproductionorder_name = $rowItem['product_name'] ?? null;
                $model->description = $rowItem['description'] ?? null;
                $model->quantity = $rowItem['quantity'] ?? null;
                $model->unit = $rowItem['unit_id'] ?? null;
                $model->crm_user_id = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
                $model->customer_id = $_POST['customer_id'] ?? null;
                $model->reference = $_POST['order_id'] ?? null;
                $model->productionorder_date = date('Y-m-d');
                $model->end_date = date('Y-m-d');
                if ($model->save()) {                    // Find product from Store

                    $modelBillofmaterial = new ProductionBillofmaterial();
                    $condition = 'product_id ="' . $rowItem['product_id'] . '"';
                    $modelBillofmaterial = $modelBillofmaterial->with('product')->find(array('condition' => $condition));
                    $bill_id = $modelBillofmaterial->id;
                    $items = ProductionBillofmaterialItem::model()->findAll(array('condition' => 'production_billofmaterial_id="' . $bill_id . '"'));
                    if (!empty($items)) {
                        foreach ($items as $i => $modelBillItem) {
                            $product = Store::model()->findByPk($modelBillItem->product_id);
                            $temp = new ProductionOrderItem;
                            $temp->production_order_id = $model->id;
                            $temp->product_id = $product->id;
                            $temp->product_name = $product->part_number;
                            $temp->description = $product->description;
                            $temp->unit = $product->unit_id;
                            $temp->quantity = 1;
                            if (!$temp->save()) {
                                $allSaved = false;
                                $msg = CJSON::encode($temp->getErrors());
                                break;
                            }
                        }
                    } else {
                        $modelStore = Store::model()->find('part_number = :part_number', [':part_number' => 'D100001']);

                        if ($modelStore) {
                            $modelItem = new ProductionOrderItem();
                            $modelItem->production_order_id = $model->id;
                            $modelItem->product_id = $modelStore->id;
                            $modelItem->product_name = $modelStore->part_number;
                            $modelItem->description = $modelStore->description;
                            $modelItem->unit = $modelStore->unit_id;
                            $modelItem->quantity = 1;

                            if (!$modelItem->save()) {
                                $allSaved = false;
                                $msg = CJSON::encode($modelItem->getErrors());
                                break;
                            }
                        } else {
                            $allSaved = false;
                            $msg = 'Store item with part number D100001 not found.';
                            break;
                        }
                    }
                } else {
                    $allSaved = false;
                    $msg = CJSON::encode($model->getErrors());
                    break;
                }
            }

            if ($allSaved) {
                $response['success'] = true;
                $response['message'] = 'All items saved successfully';
            } else {
                $response['message'] = $msg;
            }
        }

        echo CJSON::encode($response);
        Yii::app()->end();
    }





}

