<?php $customer_name = ($model->customer_id > 0) ? $model->customer->customer_name : '';
 
?>
<ul class="clearfix form-ul material">
    <li class="col-sm-6">
        <?php echo $form->hiddenField($model, 'id'); ?>
        <?php echo $form->hiddenField($model, 'product_id'); ?>
        <?php echo $form->textField($model, 'part_number', array('class' => 'tooltipster', 'data-label' => 'Product <span style="color:red">*</span>', 'onKeyup' => 'js:autoCompleteBillMaterial(this.id,"bill");')); ?>
        <?php echo $form->error($model, 'part_number'); ?>
     </li>
    <li class="col-sm-6">
        <?php echo CHtml::textField('customer_name', $customer_name, array('class' => 'text-bold', 'title' => 'Please choose a customer', 'data-label' => 'Customer', 'onKeyup' => 'js:autoCompleteCustomers(this.id,"po");')); ?>
        <?php echo $form->hiddenField($model, 'customer_id'); ?>
        <?php echo $form->error($model, 'customer_id'); ?>
    </li>
</ul>

<ul class="clearfix form-ul material">
    <li class="col-sm-6">
        <?php echo $form->textArea($model, 'description', array('class' => 'tooltipster', 'data-label' => 'Description <span style="color:red">*</span>', 'readonly' => 'true')); ?>
        <?php echo $form->error($model, 'description'); ?>
    </li>


    <li class="col-sm-3">
        <?php echo $form->textField($model, 'quantity', array('data-label' => 'Quantity', 'onkeyup' => 'calculateItemQty(this.value)', 'onkeypress' => 'return isPositiveNumber(event);')); ?>
        <?php echo $form->error($model, 'quantity'); ?>
    </li>


    <li id="div_unit_oilissue" class="col-sm-3">
        <?php       
        $product_id = ($model->id >0)?$model->product_id:0;
        echo $form->dropDownList($model, 'unit',UnitOfMeasurement::getUnits($product_id), array('onchange' => 'GetUnitFactor(this.value);','class' => 'tooltipster', 'title' => 'Unit', 'data-label' => 'Unit <span style="color:red">*</span>'));
        ?>
    </li>
    <?php echo $form->hiddenField($model, 'unit_factor'); ?>

    <?php /* ?>
    <li class="col-sm-6">
        <?php echo $form->textField($model, 'unit_name', array('data-label' => 'Unit', 'readonly' => true, 'value' => $model->unitdetails->name)); ?>
        <?php echo $form->hiddenField($model, 'unit'); ?>
        <?php echo $form->error($model, 'unit'); ?>
    </li>
    <?php */ ?>

</ul>

<?php $cs = Yii::app()->getClientScript();
$cs->registerScript("autoCompleteCustomers", "function autoCompleteCustomers(field_id,frm) {
    var url = '" . Yii::app()->createUrl('customer/GetCustomerDetails') . "'+'&frm='+frm;
    $('#'+field_id).autocomplete({
        minLength   : 1,
        source      : function (request, response) { autoCompleteSource(request, response,url) },
        focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
        select          : function( event, ui ) {
            event.preventDefault();
            trigger_target_id  	=   $(event.target).attr('id');
            var customer_id=ui.item.value; 	
            $('#ProductionBillofmaterial_customer_id').val(customer_id); 
        }
    })
}", CClientScript::POS_HEAD);
$cs->registerScript("autoCompleteBillMaterial", "function autoCompleteBillMaterial(field_id,frm)
		{
		var url = '" . Yii::app()->createUrl('assembly/production/GetProducts') . "'+'&frm='+frm;
				$('#'+field_id).autocomplete({

                minLength   : 1,



                source      : function (request, response) { autoCompleteSource(request, response,url) },



                focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},



                select          : function( event, ui ) {



                event.preventDefault();



                trigger_target_id  	=   $(event.target).attr('id');



				var product_id=ui.item.value; 	



                                var desc=ui.item.description; 



                                var unit_id=ui.item.unit_id;  



                                var unit_name=ui.item.unit_name;



                                var arr_fields= field_id.split('_');



                                var model_name   = arr_fields[0];



                                var row_field  = arr_fields[1];         

                                $('#ProductionBillofmaterial_description').addClass('filled');

                                $('#ProductionBillofmaterial_description').val(desc);

                                $('#ProductionBillofmaterial_quantity').addClass('filled');

                                $('#ProductionBillofmaterial_quantity').val('1');

                                //$('#ProductionBillofmaterial_unit_name').addClass('filled');

                                //$('#ProductionBillofmaterial_unit_name').val(unit_name); 

                                $('#ProductionBillofmaterial_unit').addClass('filled'); 

                                $('#ProductionBillofmaterial_unit').val(unit_id);  

                                $('#ProductionBillofmaterial_product_id').addClass('filled');  

                                $('#ProductionBillofmaterial_product_id').val(product_id); 

                                $('#ProductionBillofmaterial_part_number').val(ui.item.other); 

                                if(product_id > 0){
                                   jQuery.ajax({
                                        'type': 'post',
                                        'dataType': 'json',
                                        'url': '" . Yii::app()->createUrl('assembly/production/Getunitdropnew') . "',
                                        'data': {'product_id': product_id}, 
                                        'cache': false,
                                        'success': function(data) {
                                        if (data.status=='success') {
                                                if (data.drop) {
                                                $('#div_unit_oilissue').html(data.drop);
                                                var unit_id = $('#ProductionBillofmaterial_unit').val(); 
                                                GetUnitFactor(unit_id);
                                        } else {
                                            console.error('Dropdown data not found in response');
                                        }
                                        }else{
                                            t8.error('failed');
                                    
                                            }
                                        },
                                            
                                    });    

                                }

                            }

			})







		}", CClientScript::POS_HEAD);


        $cs->registerScript("GetUnitFactor", "function GetUnitFactor(unit_id){    
     
            var product_id=$('#ProductionBillofmaterial_product_id').val();
            jQuery.ajax({
                'type': 'post',
                'dataType': 'json',
               'url': '" . Yii::app()->createUrl('assembly/production/GetunitFactor') . "',
                'data': {'product_id' : product_id,'unit':unit_id},
                'cache': false,
                'success': function(data) {
                     if (data.status=='success') {
                         var unit_factor = (Number(data.unit_factor));
                        $('#ProductionBillofmaterial_unit_factor').val(unit_factor);
                         return false;            
                     }
                 }
        
           });
        
         }", CClientScript::POS_HEAD);

$cs->registerScript("calculateItemQty", " function calculateItemQty(value) {

            

            

                     

            var table_len = $('#tbl_bill_item').find('tr:gt(0)').length;

          

            for (i=0; i < table_len; i++){

                

                var qty    =   $('#ProductionBillofmaterialItem_'+i+'_subQty').val();  

                             

                var total_qty    =   value*Number(qty);

                //if(total_qty>0)

               // {

                    $('#ProductionBillofmaterialItem_'+i+'_quantity').val(Number(total_qty));

                //}

            }



           



        }", CClientScript::POS_HEAD);





?>