<style>
    table.customer-profile {
        width: 100%;
        border-collapse: collapse;
    }

    table.customer-profile td {
        padding: 4px 1px;
        vertical-align: top;
        font-size: 14px;
    }

    table.customer-profile td:first-child {
        width: 28px;
        text-align: center;
    }

    .icon {
        color: #55a196;
    }

    .icon-tooltip {
        position: relative;
        display: inline-block;
        color: #55a196;
        cursor: pointer;
    }

    .icon-tooltip .tooltip-text {
        visibility: hidden;
        width: max-content;
        background-color: #333;
        color: #fff;
        text-align: center;
        border-radius: 6px;
        padding: 5px 8px;
        position: absolute;
        z-index: 1;
        bottom: 125%;
        /* Position above the icon */
        left: 50%;
        transform: translateX(-50%);
        opacity: 0;
        transition: opacity 0.3s;
        font-size: 12px;
        white-space: nowrap;
    }

    .icon-tooltip:hover .tooltip-text {
        visibility: visible;
        opacity: 1;
    }

    .form-label {
        display: block;
        margin-bottom: 10px;
        font-weight: bold;
    }

    input[type="range"] {
        -webkit-appearance: none;
        width: 100%;
        height: 10px;
        border-radius: 5px;
        background: linear-gradient(135deg, #2c3e50 0%, #5db5a4 100%);
        outline: none;
        transition: background 0.3s ease;
    }

    /* WebKit Thumb */
    input[type="range"]::-webkit-slider-thumb {
        -webkit-appearance: none;
        appearance: none;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        background: #ffffff;
        border: 2px solid #5db5a4;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    /* Firefox Thumb */
    input[type="range"]::-moz-range-thumb {
        width: 20px;
        height: 20px;
        border-radius: 50%;
        background: #ffffff;
        border: 2px solid #5db5a4;
        cursor: pointer;
    }

    /* IE (if needed) */
    input[type="range"]::-ms-thumb {
        width: 20px;
        height: 20px;
        border-radius: 50%;
        background: #ffffff;
        border: 2px solid #5db5a4;
        cursor: pointer;
    }

    .card-hover:hover {
        transform: translateY(-3px);
        transition: 0.2s ease;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }

    .wdth {
        max-width: 20% !important;
        flex: 0 0 20% !important;
        padding-right: 5px;
        padding-left: 11px;
    }

    .h-80 {
        height: 80%;
    }

    .class-created {
        font-size: 11px;
        color: #037862;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<?php

$searchdate = date('Y-m-d');
if (isset($search_date) && $search_date != "")
    $searchdate = $search_date;
$modelCustomer = Customer::model()->findAll(array('condition' => 'isActive="Y" AND DATE(created_date_time)="' . $searchdate . '"'));
$modelLead = Lead::model()->with('file')->findAll(array('condition' => 't.isActive="Y"    AND t.lead_type="sale" AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelQuotation = Quotes::model()->with('file')->findAll(array('condition' => 't.isActive="Y"  AND DATE(t.created_date_time)="' . $searchdate . '"'));
$modelOrder = Order::model()->with('file')->findAll(array('condition' => 't.isActive="Y"  AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelDelivery = DeliveryNote::model()->with('customer', 'file', 'file.leadowner')->findAll(array('condition' => 't.isActive="Y" AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelInvoice = Invoice::model()->findAll(array('condition' => 't.isActive="Y" AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelSalesReturn = Creditnote::model()->findAll(array('condition' => 't.isActive="Y" AND t.is_updated_store="Y" AND DATE(t.created_datetime)="' . $searchdate . '"'));

$modelVendor = Vendor::model()->findAll(array('condition' => 'isActive="Y" AND DATE(created_date_time)="' . $searchdate . '"'));
$modelRequisition = PurchasingRequisition::model()->findAll(array('condition' => 't.isActive="Y"  AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelEnquiry = PurchasingEnquiry::model()->findAll(array('condition' => '1=1 AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelPurchasingOrder = PurchasingOrder::model()->findAll(array('condition' => '1=1 AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelMaterialReceipt = PurchasingMaterialreceipt::model()->findAll(array('condition' => '1=1 AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelQualityCheck = PurchasingMaterialreceipt::model()->with('file', 'vendor_details', 'purchaseorder')->findAll(array('condition' => '(qcchecked="Y") and purchaseorder.service_invoice!="Y" AND DATE(t.updated_datetime)="' . $searchdate . '"'));
$modelPurchaseInvoice = PurchasingInvoice::model()->findAll(array('condition' => 't.isActive="Y"  AND DATE(t.invoice_date)="' . $searchdate . '"'));
$modelPurchaseReturn = Purchasingdebitnote::model()->findAll(array('condition' => 't.is_goods_returned="Y"  AND DATE(t.created_datetime)="' . $searchdate . '"'));



$ModelStore = Store::model()->findAll(array('condition' => 'isActive="Y" AND DATE(created_date_time)="' . $searchdate . '"'));
$ModelIssue = InventoryGoodsIssue::model()->findAll(array('condition' => 't.stock_updated="Y" AND DATE(goods_issue_date)="' . $searchdate . '"'));
$ModelPackaging = PackagingList::model()->findAll(array('condition' => 't.status="GI" AND DATE(transaction_date)="' . $searchdate . '"'));
$modelReceipts = InventoryGoodsReceipt::model()->findAll(array('condition' => '1=1  AND DATE(goods_receipt_date)="' . $searchdate . '"'));
$modelCheck = CheckinList::model()->findAll(array('condition' => '1=1  AND DATE(transaction_date)="' . $searchdate . '"'));
$modelTransfer = InventoryDirectTransfer::model()->findAll(array('condition' => 't.status="C"   AND  t.added_from="DT"  AND DATE(transfer_date)="' . $searchdate . '"'));

?>
<!-- Header -->
<div class="row">

</div>
<!-- Main Content -->
<div class="row "><br></br>
    <div class="col-lg-3">
        <!-- Sales Details -->
        <div class="card">
            <h3>Customers</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelCustomer as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $limited = preg_replace('/\s\d.*$/', '...', $eachItem['customer_name']);
                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">customer</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $limited; ?><br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created" style="float:right;"
                                <?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span></td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <!-- Right Side: Related Information -->
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Leads</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelLead as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);

                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 20) . '...'; ?><span
                                style="float:right;font-size:12px"><?php ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Quotations</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelQuotation as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelQuotesItemcount = QuotesItem::model()->count(array('condition' => 'quotes_id =' . (int) $eachItem['id']));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 20) . '...'; ?><span
                                style="float:right;font-size:12px">AED
                                <?php echo number_format($eachItem['grand_total'], 2);//$ModelQuotesItemcount; ?>
                            </span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>

    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Orders</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelOrder as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelOrderItemcount = OrderItem::model()->count(array('condition' => 'order_id =' . (int) $eachItem['id']));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 20) . '...'; ?><span
                                style="float:right;font-size:12px">AED
                                <?php echo $eachItem['grand_total'];//$ModelOrderItemcount; ?> </span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created" style="float:right;"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Delivery Note</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelDelivery as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelDeliveryItemcount = DeliveryNoteItem::model()->count(array('condition' => 'delivery_note_id =' . (int) $eachItem['id']));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 20) . '...'; ?><span
                                style="float:right;font-size:12px"><?php  //echo $ModelDeliveryItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Invoices</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelInvoice as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelInvoiceItemcount = InvoiceItem::model()->count(array('condition' => 'invoice_id =' . (int) $eachItem['id']));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 20) . '...'; ?><span
                                style="float:right;font-size:12px">AED
                                <?php echo number_format($eachItem['grand_total'], 2);//$ModelInvoiceItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>

    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Sales Returns</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelSalesReturn as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelCreditItemcount = CreditnoteItem::model()->count(array('condition' => 'creditnote_id =' . (int) $eachItem['id']));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 20) . '...'; ?><span
                                style="float:right;font-size:12px">AED
                                <?php echo $eachItem['credited_amount'];//$ModelCreditItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
</div>
<!--Sales-->





<div class="mb-3">
    <input type="range" id="topRange" name="topRange" min="1" max="20" value="10" class="form-range">
</div>



<div class="row "><br></br>
    <div class="col-lg-3">
        <!-- Purchase Details -->
        <div class="card">
            <h3>Suppliers</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelVendor as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $limited = preg_replace('/\s\d.*$/', '...', $eachItem['vendor_name']);
                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">vendor</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $limited; ?><br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <!-- Right Side: Related Information -->
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Requisitions</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelRequisition as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);

                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> | <?php echo $eachItem['reference']; ?><span
                                style="float:right;font-size:12px"><?php ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Purchase Enquiries</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelEnquiry as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelQuotesItemcount = QuotesItem::model()->count(array('condition'=>'quotes_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> | <?php echo $eachItem['reference']; ?><span
                                style="float:right;font-size:12px"><?php // echo $ModelQuotesItemcount; ?> </span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>

    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Purchase Orders</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelPurchasingOrder as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelPurchaseOrderAmt = $eachItem['stock_grand_total'] + $eachItem['nonstock_grandtotal'];
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->vendor->vendor_name, 0, 15) . '...'; ?> <span
                                style="float:right;font-size:12px">AED
                                <?php echo number_format($ModelPurchaseOrderAmt, 2); ?> </span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Material Receipts</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelMaterialReceipt as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelDeliveryItemcount = DeliveryNoteItem::model()->count(array('condition'=>'delivery_note_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->vendor->vendor_name, 0, 15) . '...'; ?> <span
                                style="float:right;font-size:12px"><?php  //echo $ModelDeliveryItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Quality Check</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelQualityCheck as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelInvoiceItemcount = InvoiceItem::model()->count(array('condition'=>'invoice_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->vendor->vendor_name, 0, 15) . '...'; ?> <span
                                style="float:right;font-size:12px"><?php  //echo $ModelDeliveryItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['updated_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>

    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Purchase Invoices</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelPurchaseInvoice as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelCreditItemcount = CreditnoteItem::model()->count(array('condition'=>'creditnote_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> |
                            <?php echo substr($eachItem->vendor->vendor_name, 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px">AED
                                <?php echo number_format($eachItem['grand_total'], 2); ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php  //echo date("h:i A" ,strtotime($eachItem['in'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Purchase Return</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelPurchaseReturn as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelCreditItemcount = CreditnoteItem::model()->count(array('condition'=>'creditnote_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?>
                            |<?php echo substr($eachItem->vendor->vendor_name, 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px">
                                <?php echo number_format($eachItem['debited_amount'], 2); ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>

</div>
<!--Purchase-->





<div class="mb-3">
    <input type="range" id="topRange" name="topRange" min="1" max="20" value="10" class="form-range">
</div>

<?php
$modelBillofMaterial = ProductionBillofmaterial::model()->findAll(array('condition' => '1=1 AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelProductionOrder = ProductionOrder::model()->findAll(array('condition' => '1=1 AND DATE(t.created_datetime)="' . $searchdate . '"'));
$modelGoodsIssue1 = InventoryGoodsIssue::model()->findAll(array('condition' => 't.stock_updated="Y" AND t.issue_type="PR" AND DATE(t.created_date_time)="' . $searchdate . '"'));
$modelGoodsIssue2 = PackagingList::model()->findAll(array('condition' => 't.status="GI" AND DATE(t.transaction_date)="' . $searchdate . '"'));
$modelGoodsReceipt1 = InventoryGoodsReceipt::model()->findAll(array('condition' => 't.isActive="Y" AND t.stock_updated="Y" AND DATE(t.created_date_time)="' . $searchdate . '"'));
$modelGoodsReceipt2 = CheckinList::model()->findAll(array('condition' => 't.status="IGR" AND DATE(t.transaction_date)="' . $searchdate . '"'));

?>
<div class="row "><br></br>
    <div class="col-lg-3">
        <!-- Production Details -->
        <div class="card">
            <h3>Bills of Material</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelBillofMaterial as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">vendor</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem['id']; ?> |
                            <?php echo substr($eachItem['part_number'], 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php echo round($eachItem['quantity'], 2); ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <!-- Right Side: Related Information -->
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Production Orders</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelProductionOrder as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);

                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem['id']; ?> |
                            <?php echo substr($eachItem->product->part_number, 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php echo round($eachItem['quantity'], 2); ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_datetime'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Issue</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelGoodsIssue1 as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelQuotesItemcount = QuotesItem::model()->count(array('condition'=>'quotes_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem['id']; ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php //echo $eachItem['quantity']; ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
            <h3> Packaging</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelGoodsIssue2 as $eachItem) {
                    $PackagingData = InventoryGoodsIssue::model()->findByPk((int) $eachItem['transaction_id']);
                    $ModelPackingItemcount = InventoryGoodsIssueItem::model()->count(array('condition' => 'goods_issue_id  =' . (int) $eachItem['transaction_id']));
                    $modelUser = User::model()->findByPk((int) $PackagingData->created_by);
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem['transaction_id']; ?> |
                            <?php echo substr($eachItem['customer_name'], 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php //echo $eachItem['quantity']; ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($PackagingData->created_date_time)); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>

    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Receipts</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelGoodsReceipt1 as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelQuotesItemcount = QuotesItem::model()->count(array('condition'=>'quotes_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem['id']; ?> |
                            <?php echo substr($eachItem->customer->customer_name, 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php //echo $eachItem['quantity']; ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
            <h3> Checkin</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelGoodsReceipt2 as $eachItem) {
                    $PackagingData = InventoryGoodsReceipt::model()->findByPk((int) $eachItem['transaction_id']);
                    $ModelPackingItemcount = InventoryGoodsReceiptItem::model()->count(array('condition' => 'goods_receipt_id  =' . (int) $eachItem['transaction_id']));
                    $modelUser = User::model()->findByPk((int) $PackagingData->created_by);
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem['transaction_id']; ?> |
                            <?php echo substr($eachItem['customer_name'], 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php //echo $eachItem['quantity']; ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($PackagingData->created_date_time)); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>



</div>
<!--Production-->


<div class="mb-3">
    <input type="range" id="topRange" name="topRange" min="1" max="20" value="10" class="form-range">
</div>

<?php
$modelProject = WsProject::model()->findAll(array('condition' => 't.isActive="Y" AND DATE(t.created_date_time)="' . $searchdate . '"'));
$modelAdminProjectTime = WsProjectWorkTime::model()->findAll(array('condition' => 'task_type="A" AND DATE(t.created_date_time)="' . $searchdate . '"'));
$modelLabourProjectTime = WsProjectWorkTime::model()->findAll(array('condition' => 'task_type="O" AND DATE(t.created_date_time)="' . $searchdate . '"'));

?>
<div class="row "><br></br>
    <div class="col-lg-3">
        <!-- Production Details -->
        <div class="card">
            <h3>Projects</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelProject as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">vendor</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem['id']; ?> |
                            <?php echo substr($eachItem['project_name'], 0, 25); ?><span style="float:right;font-size:12px">
                                <?php ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <!-- Right Side: Related Information -->
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Admin Project Time</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelAdminProjectTime as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);

                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem->project->id; ?> |
                            <?php echo substr($eachItem->project->project_name, 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Labour Project Time</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelLabourProjectTime as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    //$ModelQuotesItemcount = QuotesItem::model()->count(array('condition'=>'quotes_id ='.(int)$eachItem['id'] ));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo $eachItem->project->id; ?> |
                            <?php echo substr($eachItem->project->project_name, 0, 15) . '...'; ?><span
                                style="float:right;font-size:12px"> <?php ?></span>
                            <br> <span class="class-created">
                                <?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>

        </div>
    </div>



</div>
<!--Project-->


<div class="mb-3">
    <input type="range" id="topRange" name="topRange" min="1" max="20" value="10" class="form-range">
</div>

<!-- Inventory-->
<div class="row "><br></br>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3>Inventory Details</h3>
            <table class="customer-profile">
                <?php
                foreach ($ModelStore as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    // $limited = preg_replace('/\s\d.*$/', '...', $eachItem['description']);
                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">Inventory</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0"><?php echo htmlspecialchars($eachItem['part_number']); ?>
                            |
                            <?php echo substr($eachItem['description'], 0, 20) . '...'; ?><br> <span
                                class="class-created"><?php echo $modelUser->fullname; ?></span><span class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <!-- Right Side: Related Information -->
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Issues</h3>
            <table class="customer-profile">
                <?php
                foreach ($ModelIssue as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelIssueItemcount = InventoryGoodsIssueItem::model()->count(array('condition' => 'goods_issue_id=' . (int) $eachItem['id']));

                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> | <?php echo $eachItem['reference']; ?><span
                                style="float:right;font-size:12px"><?php echo $ModelIssueItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
            <h3> Packaging</h3>
            <table class="customer-profile">
                <?php
                foreach ($ModelPackaging as $eachItem) {
                    $PackagingData = InventoryGoodsIssue::model()->findByPk((int) $eachItem['transaction_id']);
                    $ModelPackingItemcount = InventoryGoodsIssueItem::model()->count(array('condition' => 'goods_issue_id  =' . (int) $eachItem['transaction_id']));
                    $modelUser = User::model()->findByPk((int) $PackagingData->created_by);

                    ?>
                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['transaction_id']); ?> |
                            <?php echo $PackagingData->reference; ?><span
                                style="float:right;font-size:12px"><?php echo $ModelPackingItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($PackagingData->created_date_time)); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Receipts</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelReceipts as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelReceiptItemcount = InventoryGoodsReceiptItem::model()->count(array('condition' => 'goods_receipt_id =' . (int) $eachItem['id']));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> | <?php echo $eachItem['reference']; ?><span
                                style="float:right;font-size:12px"><?php echo $ModelReceiptItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
            <h3> Checkin</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelCheck as $eachItem) {
                    $CheckinData = InventoryGoodsReceipt::model()->findByPk((int) $eachItem['transaction_id']);
                    $ModelReceiptItemcount = InventoryGoodsReceiptItem::model()->count(array('condition' => 'goods_receipt_id =' . (int) $eachItem['transaction_id']));
                    $modelUser = User::model()->findByPk((int) $CheckinData->created_by);
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['transaction_id']); ?> |
                            <?php echo $CheckinData->reference; ?><span
                                style="float:right;font-size:12px"><?php echo $ModelReceiptItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($CheckinData->created_date_time)); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
    <div class="col-lg-3">
        <!-- Inventory Details -->
        <div class="card">
            <h3> Direct Transfer</h3>
            <table class="customer-profile">
                <?php
                foreach ($modelTransfer as $eachItem) {
                    $modelUser = User::model()->findByPk((int) $eachItem['created_by']);
                    $ModelTransferItemcount = InventoryDirectTransferItem::model()->count(array('condition' => 'direct_transfer_id =' . (int) $eachItem['id']));
                    ?>

                    <tr>
                        <td>
                            <span class="icon-tooltip">
                                <i class="fas fa-globe"><strong></strong></i>
                                <span class="tooltip-text">City</span>
                            </span>
                        </td>
                        <td style="font-size:14px;padding-top:0">
                            <?php echo htmlspecialchars($eachItem['id']); ?> | <?php echo $eachItem['reference']; ?><span
                                style="float:right;font-size:12px"><?php echo $ModelTransferItemcount; ?></span><br>
                            <span class="class-created"><?php echo $modelUser->fullname; ?></span><span
                                class="class-created"
                                style="float:right;"><?php echo date("h:i A", strtotime($eachItem['created_date_time'])); ?></span>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    </div>
</div>

<div class="mb-3">
    <input type="range" id="topRange" name="topRange" min="1" max="20" value="10" class="form-range">
</div>
<div class="row "><br></br>

    <?php
    $modelVoucherType = new AccVoucherType();
    $voucherTypes = $modelVoucherType->findAll(array('condition' => ''));
    if ($voucherTypes):
        $selectedDate = $search_date;
        foreach ($voucherTypes as $voucherType):
            ?>
            <div class="col-lg-3">
                <div class="card">
                    <h3>
                        <?php echo htmlspecialchars($voucherType['description']); ?>
                        <br><small><?php //echo $voucherType['code']; ?></small>
                    </h3>
                    <table class="customer-profile">
                        <?php
                        if ($voucherType['code'] == 'SI'):
                            $modelResults = Invoice::model()->with('customer', 'createdby')->findAll(array('condition' => 'invoice_date = "' . $selectedDate . '"'));
                            foreach ($modelResults as $modelResult): ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"><strong></strong></i>
                                            <span class="tooltip-text">Sales Invoice</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php echo htmlspecialchars($modelResult['id']); ?> |
                                        <?php echo substr($modelResult->customer->customer_name, 0, 20) . '...'; ?><span
                                            style="float:right;font-size:12px">AED
                                            <?php echo number_format($modelResult['grand_total'], 2);//$ModelInvoiceItemcount; ?></span><br>
                                        <span class="class-created"><?php echo $modelResult->createdby->fullname; ?></span><span
                                            class="class-created"
                                            style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_datetime'])); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach;

                        elseif ($voucherType['code'] == 'PI'):
                            $modelResults = PurchasingInvoice::model()->with('vendor', 'crmUser')->findAll(array('condition' => 'invoice_date = "' . $selectedDate . '"'));
                            foreach ($modelResults as $modelResult): ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"></i>
                                            <span class="tooltip-text">Purchase</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php echo htmlspecialchars($modelResult['id']); ?> |
                                        <?php echo substr($modelResult->vendor_name, 0, 20) . '...'; ?><span
                                            style="float:right;font-size:12px">AED
                                            <?php echo number_format($modelResult['grand_total'], 2);//$ModelInvoiceItemcount; ?></span><br>
                                        <span class="class-created"><?php echo $modelResult->crmUser->fullname; ?></span><span
                                            class="class-created"
                                            style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_datetime'])); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach;

                        elseif ($voucherType['code'] == 'GI'):
                            $modelResults = InventoryGoodsIssue::model()->with('customer', 'user', 'order')->findAll(array('condition' => 'goods_issue_date = "' . $selectedDate . '"'));
                            foreach ($modelResults as $modelResult):
                                $ModelIssueItemcount = InventoryGoodsIssueItem::model()->count(array('condition' => 'goods_issue_id=' . (int) $modelResult['id']));

                                ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"></i>
                                            <span class="tooltip-text">Goods Issue</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php echo htmlspecialchars($modelResult['id']); ?> |
                                        <?php echo $modelResult['reference']; ?><span
                                            style="float:right;font-size:12px"><?php echo $ModelIssueItemcount; ?></span><br>
                                        <span class="class-created"><?php echo $modelResult->user->fullname; ?></span><span
                                            class="class-created"
                                            style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_date_time'])); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach;

                        elseif ($voucherType['code'] == 'GR'):
                            $modelResults = InventoryGoodsReceipt::model()->with('customer', 'user', 'order')->findAll(array('condition' => 'goods_receipt_date = "' . $selectedDate . '"'));
                            foreach ($modelResults as $modelResult):
                                $ModelReceiptItemcount = InventoryGoodsReceiptItem::model()->count(array('condition' => 'goods_receipt_id =' . (int) $modelResult['id']));

                                ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"></i>
                                            <span class="tooltip-text">Goods Receipt</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php echo htmlspecialchars($modelResult['id']); ?> |
                                        <?php echo $modelResult['reference']; ?><span
                                            style="float:right;font-size:12px"><?php echo $ModelReceiptItemcount; ?></span><br>
                                        <span class="class-created"><?php echo $modelResult->user->fullname; ?></span><span
                                            class="class-created"
                                            style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_date_time'])); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach;

                        elseif ($voucherType['code'] == 'CN'):
                            $modelResults = Creditnote::model()->with('customer', 'createdby', 'invoice')->findAll(array('condition' => 'credited_date = "' . $selectedDate . '"'));
                            foreach ($modelResults as $modelResult): ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"></i>
                                            <span class="tooltip-text">Credit Note</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php echo htmlspecialchars($modelResult['id']); ?> |
                                        <?php echo substr($modelResult->customer->customer_name, 0, 20) . '...'; ?><span
                                            style="float:right;font-size:12px">AED <?php  echo $modelResult['credited_amount']; ?></span><br>
                                        <span class="class-created"><?php echo $modelResult->createdby->fullname; ?></span><span
                                            class="class-created"
                                            style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_datetime'])); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach;

                        elseif ($voucherType['code'] == 'DN'):
                            $modelResults = Purchasingdebitnote::model()->with('vendor', 'invoice', 'createdby')->findAll(array('condition' => 'debited_date = "' . $selectedDate . '"'));
                            foreach ($modelResults as $modelResult): ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"></i>
                                            <span class="tooltip-text">Debit Note</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php echo htmlspecialchars($modelResult['id']); ?> |
                                        <?php echo substr($modelResult->vendor->vendor_name, 0, 20) . '...'; ?><span
                                            style="float:right;font-size:12px">AED <?php  echo $modelResult['debited_amount']; ?></span><br>
                                        <span class="class-created"><?php echo $modelResult->createdby->fullname; ?></span><span
                                            class="class-created"
                                            style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_datetime'])); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach;

                        elseif (in_array($voucherType['code'], ['PV', 'RV', 'JV'])):
                            $sqlQuery = "SELECT V.voucher_no, V.payment_method,PM.mode,SL.subledger_name,V.reference_no, V.net_amount, C.customer_name, U.first_name, V.created_datetime
                                 FROM erp_acc_voucher V 
                                 LEFT JOIN erp_customer C ON V.customer_vendor_id = C.id 
                                 LEFT JOIN erp_acc_voucher_items VI ON VI.acc_voucher_id = V.id 
                                 LEFT JOIN erp_acc_subledger SL ON VI.subledger_id = SL.id 
                                 LEFT JOIN erp_acc_payment_mode PM ON V.payment_method = PM.id 
                                 LEFT JOIN " . User::model()->tableName() . " U ON V.created_by = U.id 
                                 WHERE voucher_date = '$selectedDate' AND voucher_type = {$voucherType['id']} 
                                 ORDER BY V.id";

                            $sqlQueryResults = Yii::app()->db->createCommand($sqlQuery)->queryAll();
                            // var_dump($sqlQueryResults);
                            foreach ($sqlQueryResults as $row): ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"></i>
                                            <span class="tooltip-text">Voucher</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php
                                        echo $row['voucher_no'];

                                        if (!empty($row['subledger_name'])) {
                                            echo ' | ' . substr($row['subledger_name'], 0, 10) . '...';
                                        }

                                        if (!empty($row['mode'])) {
                                            echo ' | <span style="font-size:12px">' . substr($row['mode'],0,5) . '</span>';
                                        }
                                        ?>

                                        <span style="float:right;font-size:12px">AED
                                            <?php echo number_format($row['net_amount'], 2); ?></span><br>

                                        <span class="class-created"><?php echo $row['first_name']; ?></span>

                                        <?php if (isset($modelResult['created_datetime'])): ?>
                                            <span class="class-created"
                                                style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_datetime'])); ?></span>
                                        <?php endif; ?>
                                        <?php if (isset($modelResult['created_date_time'])): ?>
                                            <span class="class-created"
                                                style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_date_time'])); ?></span>
                                        <?php endif; ?>
                                    </td>

                                </tr>
                            <?php endforeach;

                        elseif ($voucherType['code'] == 'DL'):
                            $modelResults = DeliveryNote::model()->with('customer', 'order', 'items', 'createdby')->findAll(array('condition' => 't.delivery_date = "' . $selectedDate . '"'));
                            foreach ($modelResults as $modelResult): ?>
                                <tr>
                                    <td>
                                        <span class="icon-tooltip">
                                            <i class="fas fa-globe"></i>
                                            <span class="tooltip-text">Delivery</span>
                                        </span>
                                    </td>
                                    <td style="font-size:14px;padding-top:0">
                                        <?php echo htmlspecialchars($modelResult['id']); ?> |
                                        <?php echo substr($modelResult->customer->customer_name, 0, 20) . '...'; ?><span
                                            style="float:right;font-size:12px"><?php  //echo $ModelDeliveryItemcount; ?></span><br>
                                        <span class="class-created"><?php echo $modelResult->createdby->fullname; ?></span><span
                                            class="class-created"
                                            style="float:right;"><?php echo date("h:i A", strtotime($modelResult['created_datetime'])); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach;
                        endif;
                        ?>
                    </table>
                </div>
            </div>
            <?php
        endforeach;
    endif;
    ?>



</div>