<style>
    table.customer-profile {
        width: 100%;
        border-collapse: collapse;
    }
   table.customer-profile td {
        padding: 4px 1px;
        vertical-align: top;
            font-size: 14px;
    }
   table.customer-profile  td:first-child {
        width:28px;
        text-align: center;
    }
        .icon {
        color: #55a196;
    }
        .icon-tooltip {
        position: relative;
        display: inline-block;
        color: #55a196;
        cursor: pointer;
    }

    .icon-tooltip .tooltip-text {
        visibility: hidden;
        width: max-content;
        background-color: #333;
        color: #fff;
        text-align: center;
        border-radius: 6px;
        padding: 5px 8px;
        position: absolute;
        z-index: 1;
        bottom: 125%; /* Position above the icon */
        left: 50%;
        transform: translateX(-50%);
        opacity: 0;
        transition: opacity 0.3s;
        font-size: 12px;
        white-space: nowrap;
    }

    .icon-tooltip:hover .tooltip-text {
        visibility: visible;
        opacity: 1;
    }
</style>

<div class="card">

    <h3>Supplier Details</h3>

    <!--<p><strong>ID:</strong> <?php echo htmlspecialchars($vendor['id']); ?></p>-->



<table class="customer-profile">
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-city"><strong></strong></i>
                <span class="tooltip-text">City</span>
            </span>
        </td>
        <td><?php echo htmlspecialchars($vendor['vendor_city']); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-flag"><strong></strong></i>
                <span class="tooltip-text">Country</span>
            </span>
        </td>
        <td><?php
        $vendorCountry = MasCountry::model()->findByPk($vendor['vendor_country']);
        echo htmlspecialchars($vendorCountry->country_name); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-phone"><strong></strong></i>
                <span class="tooltip-text">Phone Number</span>
            </span>
        </td>
        <td><?php echo htmlspecialchars($vendor['vendor_phone_no']); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-envelope"><strong></strong></i>
                <span class="tooltip-text">Email ID</span>
            </span>
        </td>
        <td><?php echo htmlspecialchars($vendor['vendor_email_id']); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-map-marker-alt"><strong></strong></i>
                <span class="tooltip-text">Location</span>
            </span>
        </td>
        <td><?php echo htmlspecialchars($vendor['vendor_location']); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-file-invoice-dollar"><strong></strong></i>
                <span class="tooltip-text">Payment Term</span>
            </span>
        </td>
        <td><?php //echo htmlspecialchars($vendor['vendor_payment_term']);
           $vendorPaymentTerm = MasPaymentTerm::model()->findByPk($vendor['vendor_payment_term']);
        echo htmlspecialchars($vendorPaymentTerm->payment_terms); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-globe"><strong></strong></i>
                <span class="tooltip-text">Website</span>
            </span>
        </td>
        <td><?php echo htmlspecialchars($vendor['vendor_web']); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-id-badge"><strong></strong></i>
                <span class="tooltip-text">TRN No</span>
            </span>
        </td>
        <td><?php echo htmlspecialchars($vendor['vendor_trn_no'] ?: '-'); ?></td>
    </tr>
    <tr>
        <td>
            <span class="icon-tooltip">
                <i class="fas fa-home"><strong></strong></i>
                <span class="tooltip-text">Address</span>
            </span>
        </td>
        <td><?php echo htmlspecialchars($vendor['vendor_address']); ?></td>
    </tr>
</table>


</div>