 <style>
   .form-label {
     display: block;
     margin-bottom: 10px;
     font-weight: bold;
   }

   input[type="range"] {
     -webkit-appearance: none;
     width: 100%;
     height: 10px;
     border-radius: 5px;
     background: linear-gradient(135deg, #2c3e50 0%, #5db5a4 100%);
     outline: none;
     transition: background 0.3s ease;
   }

   /* WebKit Thumb */
   input[type="range"]::-webkit-slider-thumb {
     -webkit-appearance: none;
     appearance: none;
     width: 20px;
     height: 20px;
     border-radius: 50%;
     background: #ffffff;
     border: 2px solid #5db5a4;
     cursor: pointer;
     transition: background 0.3s ease;
   }

   /* Firefox Thumb */
   input[type="range"]::-moz-range-thumb {
     width: 20px;
     height: 20px;
     border-radius: 50%;
     background: #ffffff;
     border: 2px solid #5db5a4;
     cursor: pointer;
   }

   /* IE (if needed) */
   input[type="range"]::-ms-thumb {
     width: 20px;
     height: 20px;
     border-radius: 50%;
     background: #ffffff;
     border: 2px solid #5db5a4;
     cursor: pointer;
   }

   .card-hover:hover {
     transform: translateY(-3px);
     transition: 0.2s ease;
     box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
   }

   .wdth {
     max-width: 20% !important;
     flex: 0 0 20% !important;
   }

   .h-80 {
     height: 80%;
   }
 </style>

 <!-- Optional: Range Slider -->
 <div class="mb-3">

   <input type="range" id="topRange" name="topRange" min="1" max="20" value="10" class="form-range">
 </div>

 <div class="row g-2 poplr-wrp">
   <?php
   
    $sql = "
        SELECT 
            erp_store.part_number, 
            erp_store.description, product_id, 
            total_sales ,quantity
        FROM (
            SELECT 
                YEAR(erp_purchasinginvoice.invoice_date) AS YEAR, 
                erp_purchasinginvoice_item.product_id, 
                SUM(net_amount+tax_amount) AS total_sales,
                SUM(erp_purchasinginvoice_item.quantity) AS quantity, 
                RANK() OVER (
                    PARTITION BY YEAR(erp_purchasinginvoice.invoice_date) 
                    ORDER BY SUM(net_amount+tax_amount) DESC
                ) AS rnk 
            FROM erp_purchasinginvoice_item 
            JOIN erp_purchasinginvoice ON erp_purchasinginvoice_item.purchasing_invoice_id  = erp_purchasinginvoice.id WHERE erp_purchasinginvoice.vendor_id=". $vendorId." 
            GROUP BY erp_purchasinginvoice_item.product_id
        ) AS ranked_sales 
        JOIN erp_store ON erp_store.id = product_id 
        WHERE rnk <= 10 
        ORDER BY product_id, rnk;
    ";

    $rawData = Yii::app()->db->createCommand($sql)->queryAll();
    $index = 1; // Initialize serial number

    foreach ($rawData as $datamodel): ?>
     <div class="col-lg-2 col-md-2 col-sm-6 wdth h-80">
       <div class="card border-0  shadow-sm rounded-4 card-hover" style="margin-bottom: 10px;">
        
         
         <div class="card-title text-white fw-semibold py-2 rounded-top-4" style="background: linear-gradient(135deg, #2c3e50, #5db5a4); font-size: 11px; font-weight: 600;border-radius: 10px;">
                <span><?php echo $index . '. ' . htmlspecialchars($datamodel["part_number"]); ?></span>
                <?php if($type=='V'){ ?>
                <span class="card-count"><?php echo number_format($datamodel["total_sales"], 2); ?></span>
                <?php }
                else {
                    ?>
                <span class="card-count"><?php echo round($datamodel["quantity"], 2); ?></span>
                <?php
                }
                ?>
            </div>
            
         <div class="card-body px-3 py-3">
           <p class="mb-2 text-secondary small" style="font-size: 13px;">
            <!-- <strong>Description:</strong> -->
             <?php echo htmlspecialchars($datamodel["description"]); ?>
           </p>
  <?php 
              $sqlproduct = "
        SELECT 
            YEAR, 
            erp_store.part_number, 
            erp_store.description, product_id, 
            total_sales ,quantity
        FROM (
            SELECT 
                YEAR(erp_purchasinginvoice.invoice_date) AS YEAR, 
                erp_purchasinginvoice_item.product_id, 
                SUM(net_amount+tax_amount) AS total_sales,
                SUM(erp_purchasinginvoice_item.quantity) AS quantity, 
                RANK() OVER (
                    PARTITION BY YEAR(erp_purchasinginvoice.invoice_date) 
                    ORDER BY SUM(net_amount+tax_amount) DESC
                ) AS rnk 
            FROM erp_purchasinginvoice_item 
            JOIN erp_purchasinginvoice ON erp_purchasinginvoice_item.purchasing_invoice_id  = erp_purchasinginvoice.id WHERE erp_purchasinginvoice.vendor_id=". $vendorId." AND product_id = ".$datamodel["product_id"]."
            GROUP BY YEAR(erp_purchasinginvoice.invoice_date) 
        ) AS ranked_sales 
        JOIN erp_store ON erp_store.id = product_id 
        WHERE rnk <= 10 
        ORDER BY YEAR DESC, rnk;
    ";

    $rawDatabyYear = Yii::app()->db->createCommand($sqlproduct)->queryAll();
    foreach($rawDatabyYear as $eachProductByYear){
    ?>
           <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
             <div class="text-muted d-flex align-items-center" style="gap: 4px;">
               <i class="fas fa-calendar-alt"></i>
             
               <?php
               //echo $datamodel["year"];
                if (!empty($eachProductByYear["YEAR"])) {
                  echo $eachProductByYear["YEAR"];
                } elseif (!empty($eachProductByYear["created_date"])) {
                  echo date('Y', strtotime($eachProductByYear["created_date"]));
                } 
                else {
                  echo '2025';
                }
                ?>
             </div>
             <span class="fw-bold" style="color: #57a699 !important;">
                  <?php if($type=='V'){ ?>
                 <?php echo number_format($eachProductByYear["total_sales"], 2); ?> 
                <?php }
                else {
                    ?>
                 <?php echo round($eachProductByYear["quantity"], 2); ?> 
                <?php
                }
                ?>
                
              
             </span>
           </div>
            <?php } ?>
         </div>
       </div>
     </div>
   <?php
      $index++; // Increment serial number
    endforeach; ?>
 </div>
<?php /* ?>
 <div class="mb-3">

   <input type="range" id="topRange" name="topRange" min="1" max="20" value="10" class="form-range">
 </div>

 <div class="row g-3">
   <!-- Card 1: col-6 -->
   <div class="col-12 col-md-6">
     <div class="card shadow-sm p-3" style="border-left: 5px solid #55a196;">
       <h5 class="card-title mb-2 ">Card Title 1</h5>
       <p class="card-text text-muted">This is a wider card that uses up half the row. Add your content here.</p>
     </div>
   </div>

   <!-- Card 2: col-3 -->
   <div class="col-12 col-md-3">
     <div class="card shadow-sm p-3 " style="border-left: 5px solid #ffc107;">
       <h6 class="card-title  mb-2">Card Title 2</h6>
       <p class="card-text text-muted">Quarter width card.</p>
     </div>
   </div>

   <!-- Card 3: col-3 -->
   <div class="col-12 col-md-3">
     <div class="card shadow-sm p-3 " style="border-left: 5px solid #0d6efd;">
       <h6 class="card-title  mb-2">Card Title 3</h6>
       <p class="card-text text-muted">Another quarter width card.</p>
     </div>
   </div>
 </div>
 <?php */ ?>