<!-- dashboard.php -->



<!DOCTYPE html>



<html lang="en">



<head>



    <meta charset="UTF-8">



    <meta name="viewport" content="width=device-width, initial-scale=1.0">



    <title>Customer Dashboard</title>



    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">



    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">



    <!--script src="https://code.jquery.com/jquery-3.5.1.min.js"></script-->



    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>



    <style>
        /* ===== RESET AND BASE STYLES ===== */



        * {



            margin: 0;



            padding: 0;



            box-sizing: border-box;



        }

        .content {
            padding: 0px;
        }



        .gradient-icon {
            background: linear-gradient(135deg, #2c3e50, #5db5a4);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }


        html,
        body {



            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;



            font-size: 14px;



            line-height: 1.6;



            color: #333;



            background-color: #f5f6f5;



        }







        /* ===== LAYOUT CONTAINERS ===== */



        .container {



            max-width: 1200px;



            margin: 20px auto;



            padding: 0 15px;



        }







        .row {



            display: flex;



            flex-wrap: wrap;



            margin: 0 -15px;



        }







        .col-4,
        .col-8 {



            padding: 0 15px;



        }







        .col-4 {



            flex: 0 0 33.333333%;



            max-width: 33.333333%;



        }







        .col-8 {



            flex: 0 0 66.666667%;



            max-width: 66.666667%;



        }







        /* ===== HEADER STYLES ===== */



        .dashboard-header {



            background: linear-gradient(135deg, #2c3e50 0%, #5db5a4 100%);



            color: white;



            padding: 20px 30px;



            border-radius: 10px;



            margin-bottom: 20px;



            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);



            display: flex;



            justify-content: space-between;



            align-items: center;



        }







        .dashboard-header h1 {



            font-size: 28px;



            font-weight: 300;



            margin: 0;



        }







        .header-stats {



            display: flex;



            gap: 20px;



        }







        .header-stats .stat {



            text-align: center;



        }







        .header-stats .stat .number {



            font-size: 20px;



            font-weight: 600;



        }







        .header-stats .stat .label {



            font-size: 12px;



            opacity: 0.8;



        }







        /* ===== CARD STYLES ===== */



        .card {



            background: white;



            border-radius: 10px;



            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08);



            padding: 9px !important;



            margin-bottom: 20px;



            border-left: 5px solid #55a196 !important;



        }







        .card h3 {


            font-size: 16px;
            margin-bottom: 8px;



            color: #2c3e50;



            border-bottom: 2px solid #55a296;



            padding-bottom: 10px;



        }







        .card p {



            margin: 5px 0;



            font-size: 13px;



        }







        .card p strong {



            color: #2c3e50;



            display: inline-block;



            width: 150px;



        }







        /* ===== GRID VIEW STYLES ===== */



        .grid-view {



            background: white;



            border-radius: 10px;



            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08);



            overflow: hidden;



            margin-bottom: 20px;



        }







        .grid-view table {



            width: 100%;



            border-collapse: collapse;



            font-size: 14px;



        }







        .grid-view thead {



            background: #f5f6f5;



        }







        .grid-view thead th {



            padding: 15px;



            color: #333;



            font-weight: bold;



            text-align: left;



            border-bottom: 1px solid #dee2e6;



        }







        .grid-view tbody tr:nth-child(even) {



            background-color: #fff;



        }







        .grid-view tbody tr:hover {



            background-color: #e3f2fd;



        }







        .grid-view tbody td {



            padding: 15px;



            border-bottom: 1px solid #dee2e6;



            vertical-align: middle;



        }







        /* ===== BUTTON STYLES ===== */



        .btn {



            display: inline-block;



            padding: 10px 20px;



            font-size: 14px;



            font-weight: 500;



            text-align: center;



            border-radius: 6px;



            text-decoration: none;



            transition: all 0.3s;



        }







        .btn-primary {



            color: #fff;



            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);



            border: none;



        }







        .btn-primary:hover {



            background: linear-gradient(135deg, #2980b9 0%, #21618c 100%);



            transform: translateY(-2px);



            box-shadow: 0 4px 15px rgba(52, 152, 219, 0.4);



        }







        .btn-success {



            color: #fff;



            background: linear-gradient(135deg, #27ae60 0%, #229954 100%);



            border: none;



        }







        .btn-success:hover {



            background: linear-gradient(135deg, #229954 0%, #1e8449 100%);



            transform: translateY(-2px);



            box-shadow: 0 4px 15px rgba(39, 174, 96, 0.4);



        }







        .btn-default {



            color: #333;



            background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);



            border: 1px solid #ced4da;



        }







        .btn-default:hover {



            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);



            transform: translateY(-2px);



            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);



        }







        .buttons {



            margin-top: 20px;



            text-align: right;



        }







        .buttons .btn {



            margin-left: 10px;



        }







        /* Utility Classes */



        .text-right {



            text-align: right;



        }







        .mb-3 {



            margin-bottom: 1rem;



        }







        /* Responsive Design */



        @media (max-width: 768px) {



            .col-4,
            .col-8 {



                flex: 0 0 100%;



                max-width: 100%;



                margin-bottom: 20px;



            }







            .dashboard-header {



                flex-direction: column;



                align-items: flex-start;



            }







            .header-stats {



                margin-top: 15px;



            }



        }

        .search-container {
            display: flex;
            align-items: center;
            background-color: white;
            border-radius: 10px;
            padding: 4px 20px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease;
            height: 46px;
            margin-bottom: 10px;
        }

        .search-container:focus-within {
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
        }

        #searchInput {
            flex: 1;
            padding: 12px 15px;
            font-size: 16px;
            border: none;
            outline: none;
            border-radius: 40px;
            background-color: transparent;
        }

        .search-container button {
            padding: 4px 15px;
            font-size: 16px;
            border: none;
            border-radius: 10px;
            background: linear-gradient(135deg, #2c3e50 0%, #5db5a4 100%);
            color: white;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .search-container button:hover {
            background-color: #0056b3;
        }

        .date-field {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .date-field label {
            white-space: nowrap;
            margin: 0;
            font-weight: 500;
        }

        .date-field input[type="date"] {
            flex: 1;
            height: 46px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            border: none;
            border-radius: 10px;
        }

        .tooltip-inner {
            background-color: #55a196 !important;
            color: #fff;
            font-size: 13px;
            padding: 6px 10px;
            border-radius: 6px;
            text-align: center;
        }

        .tooltip.bs-tooltip-top .tooltip-arrow::before {
            border-top-color: #55a196 !important;
        }

        .activity-icon {
            color: #55a196;
            font-size: 15px;
        }

        .activity-label {
            font-weight: 500;
            color: #444;
        }

        .activity-details {
            font-size: 14px;
            color: #555;
        }
    </style>



</head>



<body>
    <?php
    $modelMasCurrency =  new MasCurrency();
    ?>

    <div class="container-fluid">
        <!-- Header -->

        <div class="dashboard-header">

            <h1>Finance</h1>
            <div class="header-stats">
                <div class="stat">
                    <div class="number"><?php echo $leadsCount; ?></div>
                    <div class="label"></div>
                </div>

                <div class="stat">
                    <div class="number"><?php echo $invoicesCount; ?></div>
                    <div class="label"></div>

                </div>

            </div>

        </div>

        <div class="row">
            <div class="col-12">
                <!-- Quick Stats -->
                <div class="card">
                    <h3>Quick Stats</h3>
                    <div class="row">

                        <div class="col-4">
                            <div class="stats-card">
                                <div class="number"><?php echo $notesCount; ?></div>
                                <div class="label">Notes</div>
                            </div>

                        </div>

                        <div class="col-4">
                            <div class="stats-card">
                                <div class="number"><?php echo $notesCount; ?></div>
                                <div class="label">Notes</div>
                            </div>

                        </div>

                        <div class="col-4">

                            <div class="stats-card">
                                <div class="number"><?php echo $invoicesCount; ?></div>
                                <div class="label">Invoices</div>
                            </div>

                        </div>
                    </div>

                </div>



                <div class="row g-2">
                    <div class="col-lg-3 col-md-3 col-sm-6 wdth h-80">

                        <?php
                        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                        $ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');  //204;
                        $modAccSubledgerType = new AccSubledgerType();
                        $subledger_type_id_v = $modAccSubledgerType->getIdFromType('C'); //customer
                        $year = date('Y');
                        $sql = "SELECT S.subledger_name,subledger_id,SUM(amount) AS amount FROM {{acc_voucher_items}} I INNER join {{acc_subledger}} S ON I.subledger_id=S.id WHERE ledger_id='" . $ledger . "' AND subledger_type='" . $subledger_type_id_v . "' group by subledger_id  
                                ORDER BY SUM(amount) ASC limit 15";
                        $amount_rece = Yii::app()->db->createCommand("SELECT SUM(amount) AS amount FROM {{acc_voucher_items}} I INNER join {{acc_subledger}} S ON I.subledger_id=S.id WHERE ledger_id='" . $ledger . "' AND subledger_type='" . $subledger_type_id_v . "'")->queryScalar();
                        $data = Yii::app()->db->createCommand($sql)->queryAll();
                        ?>

                        <div class="card border-0  shadow-sm rounded-4 card-hover" style="margin-bottom: 10px;">
                            <div class="card-title">
                                <span><i class="fas fa-bullseye"></i> Accounts Receivable (AR)</span>
                                <span class="card-count"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amount_rece);  ?></span>
                            </div>
                            <div class="card-body px-3 py-3">
                                <?php
                                $tot = 0;
                                foreach ($data as $key => $value) {
                                ?>
                                    <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
                                        <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                                            <i class="fas fa-user"></i><?= $value["subledger_name"]; ?>
                                        </div>
                                        <span class="fw-bold" style="color: #57a699 !important;">
                                            <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($value["amount"]);  ?>
                                        </span>
                                    </div>
                                <?php
                            $tot += $value["amount"];
                            
                            } ?>
                                <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
                                    <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                                        <i class="fas fa-user"></i> <?= 'Others'; ?>
                                    </div>
                                    <span class="fw-bold" style="color: #57a699 !important;">
                                        <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amount_rece - $tot);  ?>
                                    </span>
                                </div>
                            </div>
                        </div>                        
                    </div>

                    <div class="col-lg-3 col-md-3 col-sm-6 wdth h-80">
                        <?php
                        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
                        $ledger = $modelAccSystemAccountsMapping->getSystemdefault('creditors');  //204;
                        $modAccSubledgerType = new AccSubledgerType();
                        $subledger_type_id_v = $modAccSubledgerType->getIdFromType('V'); //Suppliers
                        $year = date('Y');
                        $sql = "SELECT S.subledger_name,subledger_id,SUM(amount) AS amount FROM {{acc_voucher_items}} I INNER join {{acc_subledger}} S ON I.subledger_id=S.id WHERE ledger_id='" . $ledger . "' AND subledger_type='" . $subledger_type_id_v . "' group by subledger_id  
                                ORDER BY SUM(amount) ASC limit 15";
                        $amount = Yii::app()->db->createCommand("SELECT SUM(amount) AS amount FROM {{acc_voucher_items}} I INNER join {{acc_subledger}} S ON I.subledger_id=S.id WHERE ledger_id='" . $ledger . "' AND subledger_type='" . $subledger_type_id_v . "'")->queryScalar();
                        $amount_pay =  $amount;
                        $data = Yii::app()->db->createCommand($sql)->queryAll();
                        ?>
                        <div class="card border-0  shadow-sm rounded-4 card-hover" style="margin-bottom: 10px;">
                            <div class="card-title">
                                <span><i class="fas fa-bullseye"></i> Accounts Payables (AP)</span>
                                <span class="card-count"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($amount_pay));  ?></span>
                            </div>
                            <div class="card-body px-3 py-3">
                                <?php
                                $tot = 0;
                                foreach ($data as $key => $value) {
                                ?>
                                    <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
                                        <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                                            <i class="fas fa-user"></i><?= $value["subledger_name"]; ?>
                                        </div>
                                        <span class="fw-bold" style="color: #57a699 !important;">
                                            <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(-1 * $value["amount"]);  ?>
                                        </span>
                                    </div>
                                <?php $tot+= $value["amount"];
                             } ?>
                                <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
                                    <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                                        <i class="fas fa-user"></i> <?= 'Others'; ?>
                                    </div>
                                    <span class="fw-bold" style="color: #57a699 !important;">
                                        <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amount_pay - $tot );  ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-lg-3 col-md-3 col-sm-6 wdth h-80">
                        <?php                       
                        $sql = "SELECT  LD.ledger_acc_name,SUM(amount * exchange_rate) AS amount
                                FROM erp_acc_voucher_items I
                                LEFT JOIN erp_acc_ledger LD ON LD.id = I.ledger_id
                                WHERE LD.`classification` = 'CASH' GROUP BY I.ledger_id";                      
                        $cash_amount = Yii::app()->db->createCommand("SELECT  SUM(amount * exchange_rate) AS amount
                                FROM erp_acc_voucher_items I
                                LEFT JOIN erp_acc_ledger LD ON LD.id = I.ledger_id
                                WHERE LD.`classification` = 'CASH'")->queryScalar();                      
                        $data = Yii::app()->db->createCommand($sql)->queryAll();
                        ?>
                        <div class="card border-0  shadow-sm rounded-4 card-hover" style="margin-bottom: 10px;">
                            <div class="card-title">
                                <span><i class="fas fa-bullseye"></i> CASH</span>
                                <span class="card-count"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($cash_amount);  ?></span>
                            </div>
                            <div class="card-body px-3 py-3">
                                <?php
                                $tot = 0;
                                foreach ($data as $key => $value) {
                                ?>
                                    <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
                                        <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                                            <i class="fas fa-file-invoice-dollar"></i><?= $value["ledger_acc_name"]; ?>
                                        </div>
                                        <span class="fw-bold" style="color: #57a699 !important;">
                                            <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($value["amount"]);  ?>
                                        </span>
                                    </div>
                                <?php } ?>                               
                            </div>
                        </div>
                    </div>



                     <div class="col-lg-3 col-md-3 col-sm-6 wdth h-80">
                        <?php
                      
                        $sql = "SELECT  LD.ledger_acc_name,SUM(amount * exchange_rate) AS amount
                                FROM erp_acc_voucher_items I
                                LEFT JOIN erp_acc_ledger LD ON LD.id = I.ledger_id
                                WHERE LD.`classification` = 'BANK' GROUP BY I.ledger_id";                      
                        $bank_amount = Yii::app()->db->createCommand("SELECT  SUM(amount * exchange_rate) AS amount
                                FROM erp_acc_voucher_items I
                                LEFT JOIN erp_acc_ledger LD ON LD.id = I.ledger_id
                                WHERE LD.`classification` = 'BANK'")->queryScalar();                      
                        $data = Yii::app()->db->createCommand($sql)->queryAll();
                        ?>
                        <div class="card border-0  shadow-sm rounded-4 card-hover" style="margin-bottom: 10px;">
                            <div class="card-title">
                                <span><i class="fas fa-bullseye"></i> BANK</span>
                                <span class="card-count"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($bank_amount);  ?></span>
                            </div>
                            <div class="card-body px-3 py-3">
                                <?php
                                $tot = 0;
                                foreach ($data as $key => $value) {
                                ?>
                                    <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
                                        <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                                            <i class="fas fa-university"></i><?= $value["ledger_acc_name"]; ?>
                                        </div>
                                        <span class="fw-bold" style="color: #57a699 !important;">
                                            <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($value["amount"]);  ?>
                                        </span>
                                    </div>
                                <?php } ?>                               
                            </div>
                        </div>
                    </div>


                </div>



                <!--<div class="buttons">-->
                <!--    <button class="btn btn-primary" data-toggle="modal" data-target="#previewModal">Preview</button>-->
                <!--    <a href="#" class="btn btn-success">Save</a>-->
                <!--    <a href="#" class="btn btn-default">Close</a>-->
                <!--</div>-->
            </div>
        </div>




        <!-- Preview Modal -->

        <div class="modal fade" id="previewModal" tabindex="-1" role="dialog">

            <div class="modal-dialog" role="document">

                <div class="modal-content">



                    <div class="modal-header">



                        <h5 class="modal-title">Customer Preview</h5>



                        <button type="button" class="close" data-dismiss="modal">



                            <span>×</span>



                        </button>



                    </div>



                    <div class="modal-body">



                        <p><strong>Company:</strong> <?php echo htmlspecialchars($customer['customer_name']); ?></p>



                        <p><strong>Phone:</strong> <?php echo htmlspecialchars($customer['customer_phone_no']); ?></p>



                        <p><strong>Email:</strong> <?php echo htmlspecialchars($customer['customer_email_id']); ?></p>



                        <p><strong>Website:</strong> <?php echo htmlspecialchars($customer['customer_web']); ?></p>



                        <p><strong>Address:</strong> <?php echo htmlspecialchars($customer['customer_address']); ?>,



                            <?php echo htmlspecialchars($customer['customer_city']); ?>,



                            <?php echo htmlspecialchars($customer['customer_state']); ?>,



                            <?php echo htmlspecialchars($customer['customer_postal_code']); ?>,



                            <?php echo htmlspecialchars($customer['customer_country']); ?></p>



                        <p><strong>Industry:</strong> <?php echo htmlspecialchars($customer['customer_industry']); ?></p>



                    </div>



                    <div class="modal-footer">



                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>



                    </div>



                </div>



            </div>



        </div>



    </div>

</body>



</html>