<?php
// $from_date,$to_date,$customerId PARAMETERS PASSING

$modelMasCurrency =  new MasCurrency();

$modelAccSubledger = new AccSubledger();
$modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
$modAccSubledgerType = new AccSubledgerType();
$model_voucher_type = new AccVoucherType();
$model_voucher_type_id = $model_voucher_type->find(array('condition' => 'code="PI"'))->id;
$ledger = $modelAccSystemAccountsMapping->getSystemdefault('creditors');  //204;


$subledger_type_id = $modAccSubledgerType->getIdFromType('V');
$subledger_id = $modelAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $vendor_id); //163;


$dates_array = array(

    'current_date' => array('from' => $from_date, 'to' => $to_date),

    '2025' => array('from' => '2025-01-01', 'to' => '2025-12-31'),

    '2024' => array('from' => '2024-01-01', 'to' => '2024-12-31'),

    '2023' => array('from' => '2023-01-01', 'to' => '2023-12-31'),


);
$modelAccLedger = new AccLedger;

$baseCurrency =   $modelAccLedger->baseCurrencycode();


foreach ($dates_array as $key => $each_date_pair) {

    //payment_terms

    $query = ' CREATE OR REPLACE VIEW dasboard_accounts_payment_history_' . $key . ' AS  SELECT
        V.id AS voucher_id,
        VI.id AS voucher_item_id,
        V.voucher_no,
        V.transaction_id,
        ABS(VI.amount * VI.exchange_rate) AS amount,
        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
        ABS(VI.amount * VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance,      
        V.voucher_date,
        MAX(AI.allocation_date) AS payment_date,
        DATEDIFF(MAX(AI.allocation_date), V.voucher_date) AS days_taken,
        INV.payment_terms as payment_terms_id,
        PT.no_of_days as payment_no_of_days,
        DATEDIFF(MAX(AI.allocation_date), V.voucher_date) - PT.no_of_days AS actual_days_taken
        
    FROM
        erp_acc_voucher_items VI
    LEFT JOIN erp_acc_voucher V ON
        V.id = VI.acc_voucher_id
    LEFT JOIN erp_acc_allocation_items AI ON
        AI.voucher_item_id = VI.id
    LEFT JOIN erp_purchasinginvoice INV ON INV.id = V.transaction_id
    LEFT JOIN erp_mas_payment_term PT ON PT.id = INV.payment_terms
    WHERE
        V.is_posted = "Y"
        AND VI.amount < 0
        AND VI.ledger_id = "' . $ledger . '"
        AND VI.subledger_id = "' . $subledger_id . '" AND V.voucher_type = "' . $model_voucher_type_id . '" AND   V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '"
    GROUP BY
        VI.id
    HAVING
        abs(balance) = 0';

    Yii::app()->db->createCommand($query)->execute();
}

$sql_acc = "SELECT
    IFNULL((SELECT COUNT(transaction_id) FROM dasboard_accounts_payment_history_current_date ), 0) AS invoice_count_current_date,
    IFNULL((SELECT COUNT(transaction_id) FROM dasboard_accounts_payment_history_2025 ), 0) AS invoice_count_2025,
    IFNULL((SELECT COUNT(transaction_id) FROM dasboard_accounts_payment_history_2024 ), 0) AS invoice_count_2024,
    IFNULL((SELECT COUNT(transaction_id) FROM dasboard_accounts_payment_history_2023 ), 0) AS invoice_count_2023,
    IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_current_date ), 0) AS days_taken_current_date,
    IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_2025 ), 0) AS days_taken_2025,
    IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_2024 ), 0) AS days_taken_2024,
    IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_2023 ), 0) AS days_taken_2023,
    (
        IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_current_date ), 0) +
        IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_2025 ), 0) +
        IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_2024 ), 0) +
        IFNULL((SELECT SUM(actual_days_taken) FROM dasboard_accounts_payment_history_2023 ), 0)
    ) AS total_days_taken";

$report_result = Yii::app()->db->createCommand($sql_acc)->queryRow();

$days_taken_current_date = $report_result['days_taken_current_date'];
$days_taken_2025 = $report_result['days_taken_2025'];
$days_taken_2024 = $report_result['days_taken_2024'];
$days_taken_2023 = $report_result['days_taken_2023'];
$total_days_taken =  $report_result['days_taken_2025'] + $report_result['days_taken_2024'] + $report_result['days_taken_2023'];

$have_days_taken = 0;

foreach (['2023', '2024', '2025'] as $year) {
    if (abs($report_result["days_taken_$year"])>0) {
        $have_days_taken++;
    }
}



$invoice_count_current_date = $report_result['invoice_count_current_date'];
$invoice_count_2025 = $report_result['invoice_count_2025'];
$invoice_count_2024 = $report_result['invoice_count_2024'];
$invoice_count_2023 = $report_result['invoice_count_2023'];
$total_invoice_count =  $report_result['invoice_count_2025'] + $report_result['invoice_count_2024'] + $report_result['invoice_count_2023'];


?>

<div class="card border-0  shadow-sm rounded-4 card-hover" style="margin-bottom: 10px;">

    <div class="card-title">
        <span><i class="fas fa-bullseye"></i> Payment History</span>
        <span class="card-count"><?php echo ((int)$have_days_taken > 0) ? round((int)$total_days_taken / (int)$have_days_taken, 2) : 0; ?></span>
    </div>
    <div class="card-body px-3 py-3">
        <!--   <p class="mb-2 text-secondary small" style="font-size: 13px;"><strong>Description:</strong>
            xxxxx
        </p> -->



        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">
            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-calendar-alt"></i>Current
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo $invoice_count_current_date; ?></span>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo  $days_taken_current_date;  ?></span>

        </div>


        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">

            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-calendar-alt"></i> 2025
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo  $invoice_count_2025;  ?></span>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo  $days_taken_2025;  ?></span>

        </div>



        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">


            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-calendar-alt"></i> 2024
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo $invoice_count_2024; ?></span>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo  $days_taken_2024;  ?></span>

        </div>

        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;">


            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-calendar-alt"></i>2023
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo $invoice_count_2023; ?></span>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo  $days_taken_2023;  ?></span>

        </div>


    </div>
</div>