<?php

class DashboardController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index','PurchaseIndex','SearchCustomer','GetCustomerDetails','SearchVendor','GetVendorDetails','InfoIndex','FinanceIndex','GetPurchaseInvoiceItems','InventoryIndex',
                    'GetGoogleBusinessProfile','GetRelevantNews','GetEmployeeProfiles'
                    
                ),
                'expression' => '$user->isMember()', 
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
/*    public function actionIndex()
        {
            
            if (isset(Yii::app()->user->havePermissionOn['dashboard_view']) || Yii::app()->user->authorised_user == 1) {
               
                $this->render('index');
            } else {
                // Unauthorized: render custom unauthorized page without layout
                $this->layout = false;
                $this->render('//front/site/unauthorised'); // Do not include .php
                Yii::app()->end(); // Stop execution
            }
        }*/


    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
  
    public function actionIndex() 
    {
        
        
        $this->render('index_ai_dashboard');
        
        
        //$this->render('index_ai_dashboard');
    }
 public function actionPurchaseIndex() 
    {
        //$this->layout = false;
        
        $id = 2001;
        
        $model = new Vendor();
        $model = $model->findByPk($id);
        
        // Get contacts for this customer
        $contactsDataProvider = new CActiveDataProvider('VendorContact', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'vendor_name ASC',
            ),
            'pagination' => array(
                'pageSize' => 10,
            ),
        ));
        
        // Get leads for this customer
        $leadsDataProvider = new CActiveDataProvider('PurchasingOrder', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_datetime DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        // Get quotes for this customer
        $quotesDataProvider = new CActiveDataProvider('PurchasingMaterialreceipt', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_date_time DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        // Get orders for this customer
        $ordersDataProvider = new CActiveDataProvider('PurchasingMaterialreceipt', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_datetime DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        // Get invoices for this customer
        $invoicesDataProvider = new CActiveDataProvider('PurchasingInvoice', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_datetime DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        $this->render('purchase_ai_dashboard', array(
            'model' => $model,
            'contactsDataProvider' => $contactsDataProvider,
            'leadsDataProvider' => $leadsDataProvider,
            'quotesDataProvider' => $quotesDataProvider,
            'ordersDataProvider' => $ordersDataProvider,
            'invoicesDataProvider' => $invoicesDataProvider,
        ));
        
        
        
    }
    
    public function actionSearchCustomer(){
        $model = new Customer();
        $term = Yii::app()->request->getParam('term');
        $condition = "1=1";
        if ($term != '') {
            $condition .= " AND (customer_name LIKE '%" . $term . "%')";
        }
        $model = $model->findAll(["condition" => $condition, "limit" => 10]);
        $data = [];


        foreach ($model as $eachCustomer) {

            $data[] = [
                "value" => $eachCustomer->id,
                "label" => $eachCustomer->customer_name,
                "email" => $eachCustomer->customer_email_id,
                "phone" => $eachCustomer->customer_phone_no,
                "other" => $eachCustomer->location_id,
            ];
        }
        echo json_encode($data);
    }
    
    public function actionGetCustomerDetails(){
        $modelCustomer = new Customer();
        $modelCustomerContact = new CustomerContact();
        
        $customer_id            = (int) Yii::app()->request->getParam('customer_id'); 
        $customer_from_date     = Yii::app()->request->getParam('customer_from_date');
        $customer_to_date       = Yii::app()->request->getParam('customer_to_date');
        
        if(!empty($customer_from_date)){
            
            $arr_customer_from_date = explode("/",$customer_from_date);
            $customer_from_date = $arr_customer_from_date[2]."-".$arr_customer_from_date[1]."-".$arr_customer_from_date[0];
        }
        
        if(!empty($customer_to_date)){
            $arr_customer_to_date = explode("/",$customer_to_date);
            $customer_to_date = $arr_customer_to_date[2]."-".$arr_customer_to_date[1]."-".$arr_customer_to_date[0];
        }
        
        if($customer_id > 0){
            $modelCustomer = $modelCustomer->findByPk($customer_id);
            $modelCustomerContact = $modelCustomerContact->findAll(array('condition'=>'customer_id='.$customer_id));
        }
        
        $this->render('get_customer_details', array('modelCustomer'=>$modelCustomer,'modelCustomerContact'=>$modelCustomerContact,'customer_id'=>$customer_id,'customer_from_date'=>$customer_from_date,'customer_to_date'=>$customer_to_date));
        
    }



    public function actionSearchVendor(){
        $model = new Vendor();
        $term = Yii::app()->request->getParam('term');
        $condition = "1=1";
        if ($term != '') {
            $condition .= " AND (vendor_name LIKE '%" . $term . "%')";
        }
        $model = $model->findAll(["condition" => $condition, "limit" => 10]);
        $data = [];


        foreach ($model as $eachVendor) {

            $data[] = [
                "value" => $eachVendor->id,
                "label" => $eachVendor->vendor_name,
                "email" => $eachVendor->vendor_email_id,
                "phone" => $eachVendor->vendor_phone_no,
                "other" => $eachVendor->vendor_location,
            ];
        }
        echo json_encode($data);
    }
    
    public function actionGetVendorDetails(){
        $modelVendor = new Vendor();
        $modelVendorContact = new VendorContact();
        
        $vendor_id = (int) Yii::app()->request->getParam('vendor_id');
         $vendor_from_date =  Yii::app()->request->getParam('vendor_from_date');
          $vendor_to_date =  Yii::app()->request->getParam('vendor_to_date');
          if(!empty($vendor_from_date)){
            
            $arr_vendor_from_date = explode("/",$vendor_from_date);
            $vendor_from_date = $arr_vendor_from_date[2]."-".$arr_vendor_from_date[1]."-".$arr_vendor_from_date[0];
        }
        
        if(!empty($vendor_to_date)){
            $arr_vendor_to_date = explode("/",$vendor_to_date);
            $vendor_to_date = $arr_vendor_to_date[2]."-".$arr_vendor_to_date[1]."-".$arr_vendor_to_date[0];
        }
        if($vendor_id > 0){
            $modelVendor = $modelVendor->findByPk($vendor_id);
            $modelVendorContact = $modelVendorContact->findAll(array('condition'=>'vendor_id='.$vendor_id));
        }
        
        $this->render('get_vendor_details', array('modelVendor'=>$modelVendor,'modelVendorContact'=>$modelVendorContact,'vendor_id'=>$vendor_id,'vendor_to_date'=>$vendor_to_date,'vendor_from_date'=>$vendor_from_date));
        
    }
    
    public function actionInfoIndex(){
          $this->render('index_ai_info');
    }
    
    public function actionFinanceIndex(){
          $this->render('index_ai_finance');
    }
     public function actionGetPurchaseInvoiceItems(){
         
        $vendor_id = (int) Yii::app()->request->getParam('vendor_id');
        $type = Yii::app()->request->getParam('type');
        
        $this->render('popular_items_purchase', array('vendorId'=>$vendor_id,'type'=>$type ));
        
    }
    
    public function actionInventoryIndex(){
          $this->render('index_ai_inventory');
    }
    
    public function actionGetGoogleBusinessProfile()
    {
        $companyName            = 'Sage Media Group'; 
        $apiKey = 'AIzaSyDbV_5rnOPx03_vYfQk3-gszN72MCtzKnc';
        $gbpLink = '';
        try {
            
            $placeId = '';
            if ($gbpLink) {
                $placeId = $this->extractPlaceId($gbpLink);
            }
            if (!$placeId) {
                $url = 'https://maps.googleapis.com/maps/api/place/findplacefromtext/json?' . http_build_query([
                    'input' => $companyName,
                    'inputtype' => 'textquery',
                    'fields' => 'place_id,name,formatted_address',
                    'key' => $apiKey,
                ]);
               
                $response = $this->makeGetRequest($url);
    
                $data = json_decode($response, true);
                if (empty($data['candidates'])) {
                    return ['error' => 'No Google Business Profile found'];
                }
                $placeId = $data['candidates'][0]['place_id'];
            }

            $url = 'https://maps.googleapis.com/maps/api/place/details/json?' . http_build_query([
                'place_id' => $placeId,
                'fields' => 'name,formatted_address,formatted_phone_number,website,rating,user_ratings_total,opening_hours,reviews',
                'key' => $apiKey,
            ]);
             
            $response = $this->makeGetRequest($url);
            
                       /*  echo '<pre>';
            print_r($response);exit;*/
           
            $result = json_decode($response, true)['result'] ?? [];
             echo '<pre>';
            print_r($result);exit;
            if (empty($result)) {
                return ['error' => 'No Google Business Profile details found'];
            }

            return [
                'name' => $result['name'] ?? 'N/A',
                'address' => $result['formatted_address'] ?? 'N/A',
                'phone' => $result['formatted_phone_number'] ?? 'N/A',
                'website' => $result['website'] ?? 'N/A',
                'rating' => $result['rating'] ?? 'N/A',
                'total_reviews' => $result['user_ratings_total'] ?? 'N/A',
                'opening_hours' => $result['opening_hours']['weekday_text'] ?? 'N/A',
                'top_review' => !empty($result['reviews']) ? $result['reviews'][0]['text'] : 'N/A',
                'place_id' => $placeId,
            ];
           
        } catch (Exception $e) {
            return ['error' => 'Failed to fetch Google Business Profile: ' . $e->getMessage()];
        }
    }
    
    private function extractPlaceId($gbpLink)
    {
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $gbpLink);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
            $response = curl_exec($ch);
            curl_close($ch);

            preg_match('/ChIJ[A-Za-z0-9_-]+/', $response, $matches);
            return !empty($matches) ? $matches[0] : null;
        } catch (Exception $e) {
            return null;
        }
    }
    
    function makeGetRequest($url)
    {
       $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        curl_setopt($ch, CURLOPT_USERAGENT, 'MyApp/1.0 (+https://example.com)');
        
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;

    }

    public function actionGetRelevantNews()
    {
        $companyName            = 'Sage Media Group'; 
        $apiKey = 'c11f4899db0c4311a478b0829a9c6003';
        try {
            $url = 'https://newsapi.org/v2/everything?' . http_build_query([
                'q' => $companyName,
                'sortBy' => 'publishedAt',
                'language' => 'en',
                'pageSize' => 5,
                'apiKey' => $apiKey,
            ]);
            $response = $this->makeGetRequest($url);
            echo '<pre>';
            print_r($response);
            $data = json_decode($response, true);

            if ($data['status'] !== 'ok') {
                return ['error' => 'NewsAPI error: ' . ($data['message'] ?? 'Unknown error')];
            }
            if (empty($data['articles'])) {
                return ['error' => "No news found for '$companyName'"];
            }

            $newsList = [];
            foreach ($data['articles'] as $article) {
                $newsList[] = [
                    'title' => $article['title'],
                    'publisher' => $article['source']['name'],
                    'published_date' => $article['publishedAt'],
                    'url' => $article['url'],
                ];
            }
            return $newsList;
        } catch (Exception $e) {
            return ['error' => 'Failed to fetch news: ' . $e->getMessage()];
        }
    }
    
    public function actionGetEmployeeProfiles()
    {
        // $companyName            = 'Bluesky Technology Consultants FZE'; 
         $companyName            = 'Sage Media Group'; 
        $apiKey = 'AIzaSyBmnCX_hj5vKKrQlAPR7c61eh1CTMvyBDA';
        $cseId = '65f01e14a7a29419b';
        $website='';
        $maxResults=20;
        try {
            $query = "site:linkedin.com \"$companyName\"";
            $employees = [];
            $companyPages = [];
            $others = [];
            $start = 1;

            while (count($employees) + count($companyPages) + count($others) < $maxResults) {
                $url = 'https://www.googleapis.com/customsearch/v1?' . http_build_query([
                    'key' => $apiKey,
                    'cx' => $cseId,
                    'q' => $query,
                    'num' => min($maxResults, 10),
                    'start' => $start,
                ]);
                $response = $this->makeGetRequest($url);
                $data = json_decode($response, true);
                
                echo '<pre>';
                print_r($response);

                if (isset($data['error'])) {
                    return [
                        'employees' => ['error' => 'API error: ' . $data['error']['message']],
                        'company_pages' => ['error' => 'API error: ' . $data['error']['message']],
                        'others' => ['error' => 'API error: ' . $data['error']['message']],
                    ];
                }
                if (empty($data['items'])) {
                    break;
                }

                foreach ($data['items'] as $item) {
                    $title = $item['title'] ?? '';
                    $snippet = $item['snippet'] ?? '';
                    $link = $item['link'] ?? '';

                    if (strpos($link, '/company/') !== false || strpos($link, '/products/') !== false || strpos($link, '/showcase/') !== false) {
                        $companyPages[] = [
                            'title' => $title,
                            'url' => $link,
                            'snippet' => $snippet,
                            'grok_validation' => ['is_employee' => false, 'reason' => 'Company page URL detected', 'confidence' => 100],
                        ];
                        continue;
                    }

                    $content = "Title: $title\nSnippet: $snippet\nURL: $link";
                    $grokResult = $this->analyzeWithGrok($content, $companyName, $website);

                    $nameMatch = preg_match('/^[A-Z][a-z]+(?:\s[A-Z][a-z]+)*\s[A-Z][a-z]+(?:\s[A-Z][a-z]+)*$/i', trim(explode('|', $title)[0]));
                    if ($grokResult['is_employee'] && strpos($link, '/in/') !== false && $nameMatch) {
                        $name = trim(explode('|', $title)[0]);
                        if (!preg_match('/' . preg_quote($companyName, '/') . '/i', $name)) {
                            $employees[] = [
                                'name' => $name,
                                'url' => $link,
                                'snippet' => $snippet,
                                'grok_validation' => $grokResult,
                            ];
                        }
                    } else {
                        $others[] = [
                            'title' => $title,
                            'url' => $link,
                            'snippet' => $snippet,
                            'grok_validation' => $grokResult,
                        ];
                    }
                }

                $start += 10;
                if ($start > 100 || count($data['items']) < 10) {
                    break;
                }
            }

            return [
                'employees' => !empty($employees) ? $employees : ['error' => 'No employee profiles found'],
                'company_pages' => !empty($companyPages) ? $companyPages : ['error' => 'No company pages found'],
                'others' => !empty($others) ? $others : ['error' => 'No other profiles or posts found'],
            ];
        } catch (Exception $e) {
            return [
                'employees' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
                'company_pages' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
                'others' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
            ];
        }
    }



}