<?php
$cs = Yii::app()->getClientScript();
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_activity-master_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            columns: [
                {className: "sl col-max-1"},
                {className: "sl col-max-1"},
                {className: "sl col-max-1"},
                {className: "sl col-max-1"},
            ],
            "columnDefs": [
                {
                    "targets": [],
                    "visible": false,
                },
            ],

            ajax: {
                url: "<?php echo Yii::app()->createUrl('activity/activity/getlist') ?>",
                data: {"frm":<?php echo $frm; ?>},
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                if (aData[5] == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;
<?php if (isset(Yii::app()->user->havePermissionOn['mas_activity-master_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_edit = 1;
<?php } ?>
<?php if (isset(Yii::app()->user->havePermissionOn['mas_activity-master_disable']) || Yii::app()->user->authorised_user == 1) { ?>
            var mas_disable = 1;
<?php } ?>
        $(row).contextMenu({
            selector: 'td',
            items: {
                "edit": {
                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("activity/activity/createmaster&id=" + datas[4], datas[1], "lg");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_edit == '0') {
                            return !this.data('editDisabled');
                        }
                    }
                },
                "Disable_Enable": {
                    name: (datas[5] == "Y") ? "Disable" : "Enable",
                    icon: "edit",
                    accesskey: "d",
                    callback: function () {
                        Disable(datas[4], datas[5]);
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_disable == '0') {
                            return !this.data('Disable_EnableDisabled');
                        }
                    }
                }
            }
        });
    }
</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=activity/activity/disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_activity-master_details').DataTable().ajax.reload()
                        t8.success(' Success');
                    }
                }
            });
        }



    }
</script>
<section class="panel">
    <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
    <header class="panel-heading clearfix panel-theame">

        <i class="fa fa-truck"></i>Activity Master 

        <div class="pull-right">

            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('activity/activity/createmaster', 'Add Activity Master', 'lg')"><i class="fa fa-plus"></i> ADD</button>

        </div>

    </header>

    <div class="panel-body">

        <div class="custom-data-table">

            <table class="table table-hover table-bordered personal-task" id="tbl_activity-master_details">

                <thead>

                    <tr>

                        <th>No</th>
                        <th>Activity</th>

                        <th>Colour</th>
                        <th>F Colour</th>


                    </tr>

                </thead>



            </table>

        </div>

    </div>

</section>
