<?php

class ActivitytypeController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Delete','Save','GetList','UnBlockactivitytype','Blockactivitytype'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
            $model=new ActivityType();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name                    
                     0 =>'id',
                     1 =>'type',
                     2 =>'isDefault',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (type LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div='';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_activity_type_edit"])){
                        $div.='<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'activity/activitytype/create&id='.$row['id'].'\',\'Activity Type - '.$row['type'].' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    }

                    if(isset(Yii::app()->user->havePermissionOn['bank_disable']) ||  Yii::app()->user->authorised_user == 1)
                    {
    
                      if ($row->isActive == "Y") 
                      {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableactivitytype(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                      }
                      if ($row->isActive == 'N') 
                      {
                            $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableactivitytype(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                      }            
                    
                    }
                    $rowData[]=array($m,
                        $row['type'],
                      '<div class="btn-wrap">'.$div.'</div>',
                        $row['isDefault'],
                        $row['isActive'],
                    );;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new ActivityType(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('activitytype_form', array('model' => $model), false, true);
    }
    public function actionSave()
        {
            $model = new ActivityType();
            if (isset($_POST['ActivityType']))
            {   $model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['ActivityType']['id'] > 0)
                {   
                    $id= (int) @$_POST['ActivityType']['id'];
                    $model=$model->findByPk($id); 
                   // $audit_type = 'UPDATED';
                    //$edit_flag=1;
                }
                if($_POST['ActivityType']['isDefault'] == "Y"){
                	ActivityType::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            	}
                $model->attributes = $_POST['ActivityType'];
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                if($model->save())
                {
                                        
                        // inserting to audit log
                        
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['activitytype_form'];
                        $jsonData['id'] = $model->id;
	                	echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
       
        public function actionBlockactivitytype() {
            $id = $_POST['id'];
            if ($id > 0) {
                ActivityType::model()->updateByPK($id, array('isActive' => "N"));
                 // inserting to audit log
                 $model=new ActivityType();
                 $upt = $model->findByPk($id); // audit log changes
                 AuditLog::saveAuditLogs(
                     'ACTIVITYTYPE',
                     Yii::app()->user->id,
                     'BLOCKED',
                     " with type: - {$upt->type}  "
                 );
                // end audit log
                $status['status'] = 'success';
            } else {
                $status['status'] = 'error';
            }
            echo CJSON::encode($status);
        }
    
        public function actionUnBlockactivitytype() {
            $id = $_POST['id'];
            if ($id > 0) {
                ActivityType::model()->updateByPK($id, array('isActive' => "Y"));
                 // inserting to audit log
                 $model=new ActivityType();
                 $upt = $model->findByPk($id); // audit log changes
                 AuditLog::saveAuditLogs(
                     'ACTIVITYTYPE',
                     Yii::app()->user->id,
                     'UNBLOCKED',
                     " with type: - {$upt->type}  "
                 );
                // end audit log
                $status['status'] = 'success';
            } else {
                $status['status'] = 'error';
            }
            echo CJSON::encode($status);
        }
    
    }