<?php

class ActivitystatusController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Delete','Save','GetList','Blockactivitystatus','UnBlockactivitystatus'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
            $model=new ActivityStatus();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                 
                     0 =>'t.id',
                     1 =>'status',
                     2 =>'status_code',
                     3 =>'t.id',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (status LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div='';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_activity_status_edit"])){
                        $div.='<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'activity/activitystatus/create&id='.$row['id'].'\',\'Status - '.$row['status'].' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    }

                    if(isset(Yii::app()->user->havePermissionOn['mas_activity_from_disable']) ||  Yii::app()->user->authorised_user == 1)
                    {
    
                      if ($row->isActive == "Y") 
                      {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableactivitystatus(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                      }
                      if ($row->isActive == 'N') 
                      {
                            $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableactivitystatus(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                      }            
                    
                    }

                    $rowData[]=array($m,
                        $row['status'],
                        $row['status_code'],
                        '<div class="btn-wrap">' . $div . '</div>',
                        $row['isDefault'],
                        $row['isActive'],
                    );     
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new ActivityStatus(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('activitystatus_form', array('model' => $model), false, true);
    }
    public function actionSave()
        {
            $model = new ActivityStatus();
            if (isset($_POST['ActivityStatus']))
            {   $model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['ActivityStatus']['id'] > 0)
                {   
                    $id= (int) @$_POST['ActivityStatus']['id'];
                    $model=$model->findByPk($id); 
                   // $audit_type = 'UPDATED';
                    //$edit_flag=1;
                }
                if($_POST['ActivityStatus']['isDefault'] == "Y"){
                	ActivityStatus::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            	}
                $model->attributes = $_POST['ActivityStatus'];
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                if($model->save())
                {
                                        
                        // inserting to audit log
                        
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['activitytype_form'];
                        $jsonData['id'] = $model->id;
	                	echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
       
        public function actionBlockactivitystatus() {
            $id = $_POST['id'];
            if ($id > 0) {
                ActivityStatus::model()->updateByPK($id, array('isActive' => "N"));
                 // inserting to audit log
                 $model=new ActivityStatus();
                 $upt = $model->findByPk($id); // audit log changes
                 AuditLog::saveAuditLogs(
                     'ACTIVITYSTATUS',
                     Yii::app()->user->id,
                     'BLOCKED',
                     " with status: - {$upt->status}  "
                 );
                // end audit log
                $status['status'] = 'success';
            } else {
                $status['status'] = 'error';
            }
            echo CJSON::encode($status);
        }
    
        public function actionUnBlockactivitystatus() {
            $id = $_POST['id'];
            if ($id > 0) {
                ActivityStatus::model()->updateByPK($id, array('isActive' => "Y"));
                 // inserting to audit log
                 $model=new ActivityStatus();
                 $upt = $model->findByPk($id); // audit log changes
                 AuditLog::saveAuditLogs(
                     'ACTIVITYSTATUS',
                     Yii::app()->user->id,
                     'UNBLOCKED',
                     " with status: - {$upt->status}  "
                 );
                // end audit log
                $status['status'] = 'success';
            } else {
                $status['status'] = 'error';
            }
            echo CJSON::encode($status);
        }
    
    }