<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript(
    "loadledger",
    '$(document).ready(function() {
                    var table_id ="#acc_sub_ledger_types";
                    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.parent_account = $("#parent_account").val();
                        return data;
                    }).DataTable({
                    scrollY         : "450px",
                    pageLength      : 100,
                    ajax: {
                        url: "' . Yii::app()->createUrl('accounts/subledgertype/getsubledgertype') . '",
                        type: "POST",
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
                    processing: true,
                });
                $(".dataTables_scrollFoot").hide();
            });',
    CClientScript::POS_HEAD
);
$cs->registerScript("deleteAccount",  "function deleteAccount(id){
                var r = confirm('Are you sure to delete this?');
                    if(r==true)
                    {
                        jQuery.ajax({
                          'type'  : 'post',
                          'data'  : 'id=' + id,
                          'url'  : $('#liveSite').val()+'index.php?r=accounts/subledgertype/deleteledger',
                          'cache': false,
                          'success':function(data){
                            if(data=='fail'){
                                alert('Error while Delete', 'Alert');
                            }else {
                                reloadTable('#acc_sub_ledger_types');
                                t8.success('Deleted!');
                            }
                           }
                        });
                    }
            };", CClientScript::POS_HEAD);

?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-file"></i>  -->
        Sub Ledger Types
        <div class="pull-right" style="display:flex;">
            <?php
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_subLedger_type_add"])) {
            ?>
                <a class="ad-btn"  onclick="loadPopupModal('accounts/subledgertype/Create','New Sub Ledger Type','lg')">                
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="acc_sub_ledger_types" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Description</th>
                        <!--<th>Parent</th>
                            <th>Group</th> -->
                        <th>Start Serial</th>
                        <th>Actions</th>
                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>