<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'security_cheque-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->dropdownlist($model, 'transaction_type', array('I' => 'Issue', 'R' => 'Received'), array('data-label' => 'Transaction Type <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
                <?php 
                if($model->transaction_date!='' && $model->transaction_date!='0000-00-00'){
                    $model->transaction_date=date("d/m/Y", strtotime($model->transaction_date));
                }else{
                    $model->transaction_date='';
                }
                echo $form->textField($model, 'transaction_date', array('data-label' => 'Transaction Date <span style="color:red">*</span>', 'class' => 'datepicker', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->textField($model, 'bank_name', array('data-label' => 'Bank Name <span style="color:red">*</span>')); ?>
            </li>	
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'location', array('data-label' => 'Location')); ?>
            </li>
            <li class="col-sm-5">
                <?php echo $form->textField($model, 'cheque_payee', array('data-label' => 'Payee')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'cheque_no', array('data-label' => 'Cheque No <span style="color:red">*</span>')); ?>
            </li> 
            <li class="col-sm-3">
                <?php 
                if($model->cheque_date!='' && $model->cheque_date!='0000-00-00'){
                    $model->cheque_date=date("d/m/Y", strtotime($model->cheque_date));
                }else{
                    $model->cheque_date='';
                }
                echo $form->textField($model, 'cheque_date', array('data-label' => 'Cheque Date', 'class' => 'datepicker', 'onkeypress' => 'return false;')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo $form->textField($model, 'cheque_amount', array('data-label' => 'Amount <span style="color:red">*</span>','onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-12">
                <?php echo $form->textArea($model, 'notes', array('data-label' => 'Notes')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default " id="security_cheque_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('accounts/securitycheque/SaveDetails');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' =>'function(data) {
                        if(data.status=="success"){  
                            t8.success("Details Saved Successfully!");
                            $("#security_cheque_close").click();
                            reloadTable("#tbl_security_cheque_details");
                        } else { 
                            $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                            }); 
                        } 
                    }',
        'beforeSend' => 'function(){
                            $("#loader").show();
                            $(".toast8-error").hide(); 
                            $("#security_cheque-form .security_cheque-save-btn").prop("disabled", true);
                            $("#security_cheque-form .security_cheque-save-btn").addClass("btn_loding").removeClass("btn-theme");
                        }',
        'complete' => 'function(){
                            $("#security_cheque-form .security_cheque-save-btn").prop("disabled", false);
                            $("#security_cheque-form .security_cheque-save-btn").addClass("btn-theme").removeClass("btn_loding");
                            $("#loader").hide();
                        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'security_cheque-save-btn btn btn-theme'));
    ?>


</div>


<?php $this->endWidget(); ?>