<!------------------------------------------------------------------------------------------------------- ---->
<!--//VAT on Purchases//-->
<!------------------------------------------------------------------------------------------------------- ---->
<br>
<?php
$sql_purchase = "SELECT P.invoice_date,P.invoice_no,V.vendor_name,V.vendor_trn_no,P.grand_total,P.total_tax_amount
                FROM erp_purchasinginvoice P
                left join erp_vendor V on V.id=P.vendor_id
                WHERE P.invoice_date >= :from_date AND P.invoice_date <= :to_date order by P.invoice_date DESC";
$command3 = Yii::app()->db->createCommand($sql_purchase);
$command3->bindParam(':from_date', $from_date, PDO::PARAM_STR);
$command3->bindParam(':to_date', $to_date, PDO::PARAM_STR);
$purchase_list = $command3->queryAll();




$sql_dn = "SELECT D.debited_date,D.purchasing_invoice_id,D.reference,V.vendor_name,V.vendor_trn_no,D.debited_amount,D.total_tax_amount
                FROM erp_purchasing_debit_note  D
                 left join erp_vendor V on V.id=D.vendor_id
                 WHERE D.debited_date >= :from_date AND D.debited_date <= :to_date";
$command4 = Yii::app()->db->createCommand($sql_dn);
$command4->bindParam(':from_date', $from_date, PDO::PARAM_STR);
$command4->bindParam(':to_date', $to_date, PDO::PARAM_STR);
$dn_list = $command4->queryAll();



?>
<table class="table table-hover table-fixed table-bordered">
    <thead>
        <tr>
            <th class="turnover"  colspan="9">VAT on Purchases</th>
        </tr>
        <tr>
            <th style="width:5%">Sl.No</th>
            <th style="width:5%">Date</th>
            <th style="width:8%">Inv.No</th>
            <th style="width:8%">Inv Ref</th>
            <th style="width:20%">Vendor</th>
            <th style="width:20%">TRN</th>
            <th style="width:8%;">Amount</th>
            <th style="width:5%;">VAT (<?php echo $baseCurrency; ?>)</th>
            <th style="width:10%;">Net Amount</th>
        </tr>
    </thead>
    <tbody>
        <?php $total_tax_amount_pur = $grand_total_pur = 0;
        foreach ($purchase_list as $i => $purchase) {


        ?>
            <tr>
                <td>
                    <?php echo $i + 1; ?>
                </td>
                <td><?php echo  date("d/m/Y", strtotime($purchase['invoice_date'])); ?></td>


                <td><?php echo  'PI' . '/' . $purchase['invoice_no']; ?></td>
                <td>-</td>
                <td><small><?php echo $purchase['vendor_name']; ?> </small></td>
                <td><small><?php echo $purchase['vendor_trn_no']; ?> </small></td>
                <td style="text-align:right !important;">
                    <?php echo $purchase['grand_total'] - $purchase['total_tax_amount'];
                    $total_pur_amt += $purchase['grand_total'] - $purchase['total_tax_amount'];
                    ?></td>

                <td style="text-align:right !important;">
                    <?php echo Yii::app()->numberFormatter->formatCurrency($purchase['total_tax_amount'], " ");
                    $total_tax_amount_pur += $purchase['total_tax_amount'];
                    ?></td>


                <td style="text-align:right !important;">
                    <?php echo $purchase['grand_total'];
                    $grand_total_pur += $purchase['grand_total'];
                    ?></td>
            </tr>
        <?php } ?>


        <?php $i++;
        $total_tax_amount_debit = $grand_total_debit = $total_pur_amt=$total_pur_dr_amt=0;
        foreach ($dn_list as $key => $debit) {

            $i++;
        ?>
            <tr title="Debit Note">
                <td>
                    <?php echo $i; ?>
                </td>
                <td><?php echo  date("d/m/Y", strtotime($debit['debited_date'])); ?></td>


                <td><?php echo  'DN' . '/' . $debit['purchasing_invoice_id']; ?></td>
                <td><small><?php echo $debit['reference']; ?></small></td>
                <td><small><?php echo $debit['vendor_name']; ?> </small></td>
                <td><small><?php echo $debit['vendor_trn_no']; ?> </small></td>
                <td style="text-align:right !important;">
                    <?php echo -1*($debit['debited_amount'] - $debit['total_tax_amount']);
                    $total_pur_dr_amt += -1*($debit['debited_amount'] - $debit['total_tax_amount']);
                    ?></td>

                <td style="text-align:right !important;">
                    <?php echo -1*($debit['total_tax_amount']);
                    $total_tax_amount_debit += $debit['total_tax_amount'];
                    ?></td>


                <td style="text-align:right !important;">
                    <?php echo -1*($debit['debited_amount']);
                    $grand_total_debit += $debit['debited_amount'];
                    ?></td>
            </tr>
        <?php } ?>

        <tr>
            <td colspan="6" style="text-align:right !important;"><b>Total VAT (<?php echo $baseCurrency; ?>)</b></td>
            <td style="text-align:right !important;"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($total_pur_amt - $total_pur_dr_amt, " "); ?></b></td>
            <td style="text-align:right !important;"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($total_tax_amount_pur - $total_tax_amount_debit, " "); ?></b></td>
            <td style="text-align:right !important;"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($grand_total_pur - $grand_total_debit, " "); ?></b></td>

        </tr>
    </tbody>
</table>