<!--
chart of accounts
 trial balance report
date 10-04-2025
author -Sebi
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }
    .to {
        background: rgb(31 103 178);
        color: White;
    }
    .tol1 {
        font-size: 16px !important;
    }
    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }
    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }
    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }
    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }
    .level-5 {
        padding-left: 267px !important;
    }
    .l1 {
        font-size: 17px !important;
    }
    .l2 {
        font-size: 16px !important;
    }
    .l3 {
        font-size: 15px !important;
    }
    .l4 {
        font-size: 14px !important;
    }
    .l5 {
        font-size: 14px !important;
        font-style: italic;
    }
    .txt-right {
        text-align: right !important;
    }
</style>
<table class="table-tree html_table">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Debit</th>
            <th>Credit</th>
        </tr>
    </thead>
    <?php
    /* filter conditions  ----start---- */
    $condition = ' is_posted="Y" ';
    if ($gl_auditclose_id) {
        $auditClose = AccAuditClose::model()->findByPk($gl_auditclose_id);
        $from_date = $auditClose->close_date;
    }
    if ($from_date != '') {
        $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
    }
    if ($to_date != '') {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
    }
    if ((int)$company > 0) {
        $condition .= " AND  company_id = '" . $company . "'";
    }
    if ((int)($salesgroup > 0)) {
        $condition .= " AND  salegroup_id = '" . $salesgroup . "'";
    }
    if ((int)($brand > 0)) {
        $condition .= " AND  brand_id = '" . $brand . "'";
    }
    if ((int)($outlet_id > 0)) {
        $condition .= " AND  outlet_id = '" . $outlet_id . "'";
    }
    if ((int)($warehouse_id > 0)) {
        $condition .= " AND  warehouse_id = '" . $warehouse_id . "'";
    }
    if ((int)($department_id > 0)) {
        $condition .= " AND  department_id = '" . $department_id . "'";
    }
    $maincondition = '';
    if ($level > 0) {
        $maincondition .= " AND level <= '{$level}'";
    }
    $modelMasCurrency =  new MasCurrency();
    $auditCloseLedgerResults = isset($trialBalanceDetails['auditCloseLedgerResults'])?$trialBalanceDetails['auditCloseLedgerResults']:array();
    $acc_profit = isset($trialBalanceDetails['acc_profit'])?$trialBalanceDetails['acc_profit']:'0.00';
    $auditclose = isset($trialBalanceDetails['auditclose'])?$trialBalanceDetails['auditclose']:'';

    $sum_opening = 0.00;
    $sum_closing = 0.00;//var_dump($auditCloseLedgerResults);
    foreach ($auditCloseLedgerResults as $k => $eachAuditClose) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;
        $debit = $eachAuditClose['debit'];
        $credit = $eachAuditClose['credit'];

        if ($eachAuditClose['level'] == '1') {
            $netamount = $debit+$credit;
            if ($netamount > 0) {
                $debit = $netamount;
                $credit = 0.00;
            } else {
                $debit = 0.00;
                $credit = $netamount;
            }
            $sum_debit += $debit;
            $sum_credit += $credit;
        }
        $accountName = '' . $eachAuditClose['ledger_acc_name'] . '';
        if ($eachAuditClose['is_parent'] == 'N' && ($eachAuditClose['ledger_main_acc'] != 'AP' && $eachAuditClose['ledger_main_acc'] != 'CO')) {
            $count = $eachAuditClose['transaction_count'];
            if ($eachAuditClose['have_subledger'] == 'Y') {
                $link = 'js:load_summary_tb(' . $eachAuditClose['ledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
            } else {
                if ($count < 300) {
                    $link = 'js:Load_tb_gl_report(' . $eachAuditClose['ledger_id'] . ',0, 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
                    $link = 'js:load_gl_summary_tab_excel(' . $eachAuditClose['ledger_id'] . ',0,\'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }
            $accountName = '<a href="#" onclick="' . $link . '">' . $eachAuditClose['ledger_acc_name'] . '</a>';
        }
        if (($type != 'NZ' || abs($debit) > 0 || abs($credit) > 0 || $eachAuditClose['level'] == 1) && $eachAuditClose['ledger_acc_no']) {
            if ($level && $eachAuditClose['level'] <= $level) { ?>
                <tr class="l<?= $eachAuditClose['level'] . $style_tr; ?> level<?= $eachAuditClose['level']; ?>">
                    <td class="l1"><?= $eachAuditClose['ledger_acc_no']; ?></td>
                    <td class="level-<?= $eachAuditClose['level']; ?> l<?= $eachAuditClose['level']; ?>"><b><?= $accountName; ?></b></td>
                    <td class="txt-right l<?= $eachAitClose['level']; ?>"><b><?= Yii::app()->numberFormatter->formatCurrency(abs($debit), ""); ?></b></td>
                    <td class="txt-right l<?= $eachAuditClose['level']; ?>"><b><?= Yii::app()->numberFormatter->formatCurrency(abs($credit), ""); ?></b></td>
                </tr>
            <?php }
        }
    } ?>
    <tr><td></td><td></td><td></td><td></td></tr>
    <tr class="to tol1">
        <td></td>
        <td><b>Total</b></td>
        <td class="txt-right  "><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat($sum_debit);  ?></td>
        <td class="txt-right "><?= $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($sum_credit)); ?></td>
    </tr>
</table>
