<!DOCTYPE html>
<html>
<head>
    <title>
        <?php
        echo "Trial Balance Detailed"; ?>
    </title>
    <style type="text/css">
        table {
            font-family: arial, sans-serif !important;
            border-collapse: collapse !important;
            width: 100% !important;
        }
        td,
        th {
            border: 1px solid #dddddd !important;
            text-align: left !important;
            padding: 8px !important;
        }
        .level1 {
            background: #b4c6e7;
            color: black;
        }
        .to {
            background: rgb(31 103 178);
            color: White;
        }
        .tol1 {
            font-size: 16px !important;
        }
        .level-1 {
            padding-left: 5px !important;
            font-weight: bold;
        }
        .level-2 {
            padding-left: 50px !important;
            font-weight: bold;
        }
        .level-3 {
            padding-left: 104px !important;
            font-weight: bold;
        }
        .level-4 {
            padding-left: 197px !important;
            font-weight: bold;
        }
        .level-5 {
            padding-left: 267px !important;
        }
        .l1 {
            font-size: 17px !important;
        }
        .l2 {
            font-size: 16px !important;
        }
        .l3 {
            font-size: 15px !important;
        }
        .l4 {
            font-size: 14px !important;
        }
        .l5 {
            font-size: 14px !important;
        }
        .txt-right {
            text-align: right !important;
        }
        .table-tree th,
        td {
            border-left: 0;
            border-right: 0;
            margin: 0;
            padding: 3px 5px;
        }
        .ze {
            background: #CCC
        }
        .box-pad,
        .box-pad * {
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }
        .tre td {
            /*border:none;*/
        }
        .level-1 {
            padding-left: 5px !important;
        }
        .level-2 {
            padding-left: 20px !important;
        }
        .level-3 {
            padding-left: 35px !important;
        }
        .level-4 {
            padding-left: 55px !important;
        }
        .level-5 {
            padding-left: 80px !important;
        }
        .l1 {
            font-size: 12px !important;
        }
        .l2 {
            font-size: 11px !important;
            font-style: italic !important;
        }
        .l3 {
            font-size: 12px !important;
        }
        .l4 {
            font-size: 11px !important;
            font-style: italic;
        }
        .l5 {
            font-size: 10px !important;
            font-style: italic;
        }
        .txt-right {
            text-align: right !important;
        }
        .tittle {
            width: 100%;
            margin: 10px 0;
            float: left;
            text-align: center;
        }
        .tittle h6 {
            border-bottom: 2px solid #000;
            width: 150px;
            max-width: 400px;
            font-size: 16px;
            margin: 10px auto;
        }
        .date {
            width: 100%;
            float: left;
            font-size: 11px;
            padding-left: 5px;
            font-weight: 600;
            text-align: left;
            padding-bottom: 3px;
        }
        .date span {
            width: 200px;
            display: inline-block;
        }
        .clear {
            clear: both;
        }
        .cell-left {
            text-align: left !important;
        }
        .cell-right {
            text-align: right !important;
        }
        .br-top {
            border-top: 1px solid #000 !important;
            border-bottom: 3px double #000 !important;
        }
        .space {
            width: 100%;
            float: left;
            clear: both;
            height: 5px;
        }
        .col-6 {
            width: 50%;
        }
        .col-9 {
            width: 75%
        }
        .col-3 {
            width: 25%;
        }
        .f-l {
            float: left;
        }
        .f-r {
            float: right;
        }
        .txt-right {
            text-align: right;
        }
        .txt-left {
            text-align: left;
        }
        .x-space {
            box-sizing: border-box;
        }
        .bg-w {
            background: #FFF !important;
        }
        .footer {
            width: 100%;
            float: left;
            font-size: 11px;
            position: absolute;
            bottom: 0px;
            left: 0px;
            text-align: center !important;
            line-height: 18px;
            border-top: 1px dotted #000;
            padding: 5px;
        }
        .span1 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }
        .span2 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }
        .span3 {
            width: auto !important;
            display: inline-block;
            float: left;
        }
        .pro {
            background: #ccffdf;
        }
        .loss {
            background: #ffb4b4;
        }
        .cy {
            background: #cdcdcd;
        }
        .py {
            background: #ececec;
        }
        .to {
            background: #f1f1f1;
        }
    </style>
</head>
 <body style="font-family: 'Times New Roman' Times serif">
    <div class="main">
        <?php $this->renderPartial('//common/header', array('warehouse_id' => $warehouse_id)); ?>
    </div>
    <?php $auditCloseLedgerResults = isset($trialBalanceDetails['auditCloseLedgerResults'])?$trialBalanceDetails['auditCloseLedgerResults']:array();
        $acc_profit = isset($trialBalanceDetails['acc_profit'])?$trialBalanceDetails['acc_profit']:'0.00';
        $auditclose = isset($trialBalanceDetails['auditclose'])?$trialBalanceDetails['auditclose']:''; ?>
    <div style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--add New Template-->
        <div class="">
            <div class="col-12">
                <div class="input-block">
                    <b><?php echo 'Trial Balance'; ?></b>
                </div>
                <table class="table" style="font-size: 10px;">
                    <?php if ($auditclose) { ?>
                        <tr>
                            <td><b>Auditclose</b></td>
                            <td colspan="5"><b><?= $auditclose->name; ?></b></td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <td><b>From</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($from_date)); ?>
                        </td>
                        <td><b>To</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($to_date)); ?>
                        </td>
                        <td><b>Level</b></td>
                        <td>
                            <?php echo $level; ?>
                        </td>
                    </tr>
                    <?php if((int)$outlet_id>0){ ?>
                        <tr>
                            <td><b>Outlet</b></td>
                            <td  colspan="5">
                                <?php
                                if ((int)$outlet_id == 0) {
                                    echo 'All Outlet';
                                } else {
                                    $modelMasOutlet = new MasOutlet();
                                    $modelMasOutlet = $modelMasOutlet->findBypk((int)$outlet_id);
                                    echo $modelMasOutlet->outlet_name;
                                }
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <?php if((int)$warehouse_id>0){ ?>
                    <tr>
                        <td><b>Warehouse</b></td>
                        <td  colspan="5">
                            <?php
                             if ((int)$warehouse_id == 0) {
                                echo 'All Warehouse';
                            } else {
                                $modelMasInventoryWarehouse = new MasInventoryWarehouse();
                                $modelMasInventoryWarehouse = $modelMasInventoryWarehouse->findBypk((int)$warehouse_id);
                                echo $modelMasInventoryWarehouse->warehouse_name;
                            } 
                            ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php if((int)$department_id>0){ ?>
                    <tr>
                        <td><b>Department</b></td>
                        <td colspan="5">
                            <?php
                             if ((int)$department_id == 0) {
                                echo 'All Department';
                            } else {
                                $modelMasDepartment = new MasDepartment();
                                $modelMasDepartment = $modelMasDepartment->findBypk((int)$department_id);
                                echo $modelMasDepartment->department_name;
                            } 
                            ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php if((int)$brand>0){ ?>
                    <tr>
                        <td><b>Brand</b></td>
                        <td colspan="5">
                            <?php
                             if ((int)$brand == 0) {
                                echo 'All Brands';
                            } else {
                                $modelProductClass = new ProductClass();
                                $modelProductClass = $modelProductClass->findBypk((int)$brand);
                                echo $modelProductClass->product_class;
                            } 
                            ?>
                        </td>
                    </tr>
                    <?php } ?>
                </table>
            </div>
        </div>
        <br>

        <table class="table-tree">
            <thead>
                <tr class="to tol1">
                    <th class="cell-left">Account No.</th>
                    <th class="cell-left">Description</th>
                    <th>Opening</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Closing</th>
                </tr>
            </thead>
            <?php
            $sum_opening = 0.00;
            $sum_closing = 0.00;
            foreach ($auditCloseLedgerResults as $k => $eachAuditClose) {
                $style_tr = '';
                $debit = 0.00;
                $credit = 0.00;
                $opening = 0.00;
                $closing = 0.00;
                $netamount = 0.00;
                if ($eachAuditClose['ledger_main_acc'] == 'AP') {
                    $opening = $acc_profit;
                } else {
                    if ($eachAuditClose['ledger_acc_type'] != 'P') {
                        $opening = $eachAuditClose['opening'];
                    }
                }
                
                $debit = $eachAuditClose['debit'];
                $credit = $eachAuditClose['credit'];
        
                if ($eachAuditClose['level'] == '1') {
                    $netamount = $debit+$credit;
                    if ($netamount > 0) {
                        $debit = $netamount;
                        $credit = 0.00;
                    } else {
                        $debit = 0.00;
                        $credit = $netamount;
                    }
                    $sum_debit += $debit;
                    $sum_credit += $credit;
                }
                $closing = $opening+$debit+$credit;
                if ($eachAuditClose['level'] == 1) {
                    $sum_opening += $opening;
                    $sum_closing += $closing;
                }
                
                $accountName = '' . $eachAuditClose['ledger_acc_name'] . '';
                if (($type != 'NZ' || abs($debit) > 0 || abs($credit) > 0 || $eachAuditClose['level'] == 1) && $eachAuditClose['ledger_acc_no']) {
                    if ($level && $eachAuditClose['level'] <= $level) { ?>
                        <tr class="l<?php echo $eachAuditClose['level'] . $style_tr; ?> level<?php echo $eachAuditClose['level']; ?>">
                            <td class="l1"><?php echo $eachAuditClose['ledger_acc_no']; ?></td>
                            <td class="level-<?php echo $eachAuditClose['level']; ?> l<?php echo $eachAuditClose['level']; ?>"><b><?php echo $accountName; ?></b></td>
                            <td class="txt-right l<?php echo $eachAuditClose['level']; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($opening), "").(($opening>0)?' Dr':' Cr'); ?></b></td>
                            <td class="txt-right l<?php echo $eachAuditClose['level']; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($debit), ""); ?></b></td>
                            <td class="txt-right l<?php echo $eachAuditClose['level']; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($credit), ""); ?></b></td>
                            <td class="txt-right l<?php echo $eachAuditClose['level']; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($closing), "").(($closing>0)?' Dr':' Cr'); ?></b></td>
                        </tr>
                    <?php }
                }
            } ?>
    
            <tr><td colspan="6"></td></tr>
            <tr class="to tol1">
                <td></td>
                <td><b>Total</b></td>
                <td class="txt-right  "><?php echo Yii::app()->numberFormatter->formatCurrency(abs($sum_opening), ""); ?></td>
                <td class="txt-right  "><?php echo Yii::app()->numberFormatter->formatCurrency(abs($sum_debit), ""); ?></td>
                <td class="txt-right "><?php echo Yii::app()->numberFormatter->formatCurrency(abs($sum_credit), ""); ?></td>
                <td class="txt-right "><?php echo Yii::app()->numberFormatter->formatCurrency(abs($sum_closing), ""); ?></td>
            </tr>
        </table>
    </div>
    <?php $this->renderPartial("//common/footer");?>
</body>
</html>