<!DOCTYPE html>
<html>

<head>
    <title>
        <?php

        echo 'Subledger Detailed Report'; ?>
    </title>


    <style type="text/css">
        table {
            font-family: arial, sans-serif !important;
            border-collapse: collapse !important;
            width: 100% !important;
        }

        td,
        th {
            border: 1px solid #dddddd !important;
            text-align: left !important;
            padding: 8px !important;
        }




        .txt-right {
            text-align: right !important;
        }


        .table-tree th,
        td {
            border-left: 0;
            border-right: 0;
            margin: 0;
            padding: 3px 5px;
        }

        .ze {
            background: #CCC
        }

        .box-pad,
        .box-pad * {
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }

        .tre td {
            /*border:none;*/
        }



        .txt-right {
            text-align: right !important;
        }

        .tittle {

            width: 100%;

            margin: 10px 0;

            float: left;

            text-align: center;



        }

        .tittle h6 {

            border-bottom: 2px solid #000;

            width: 150px;

            max-width: 400px;

            font-size: 16px;

            margin: 10px auto;

        }

        .date {
            width: 100%;
            float: left;
            font-size: 11px;
            padding-left: 5px;
            font-weight: 600;
            text-align: left;
            padding-bottom: 3px;
        }

        .date span {

            width: 200px;

            display: inline-block;

        }

        .clear {
            clear: both;
        }

        .cell-left {
            text-align: left !important;
        }

        .cell-right {
            text-align: right !important;
        }

        .br-top {
            border-top: 1px solid #000 !important;
            border-bottom: 3px double #000 !important;
        }

        .space {
            width: 100%;
            float: left;
            clear: both;
            height: 5px;
        }

        .col-6 {
            width: 50%;
        }

        .col-9 {
            width: 75%
        }

        .col-3 {
            width: 25%;
        }

        .f-l {
            float: left;
        }

        .f-r {
            float: right;
        }

        .txt-right {
            text-align: right;
        }

        .txt-left {
            text-align: left;
        }

        .x-space {
            box-sizing: border-box;
        }

        .bg-w {
            background: #FFF !important;
        }

        .footer {
            width: 100%;
            float: left;
            font-size: 11px;
            position: absolute;
            bottom: 0px;
            left: 0px;
            text-align: center !important;
            line-height: 18px;
            border-top: 1px dotted #000;
            padding: 5px;
        }

        .span1 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }

        .span2 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }

        .span3 {
            width: auto !important;
            display: inline-block;
            float: left;
        }

        .pro {
            background: #ccffdf;
        }

        .loss {
            background: #ffb4b4;
        }

        .cy {
            background: #cdcdcd;
        }

        .py {
            background: #ececec;
        }

        .to {
            background: #f1f1f1;
        }
    </style>
</head>

<body>

    <div class="header" style="width:100%;float: left;border-bottom: 6px solid #850EA6;padding-bottom:10px;">
    <div class="main">
            <?php $this->renderPartial('//common/header');   ?>
        </div>

    </div>
    <div style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--add New Template-->
        <div class="">
            <div class="col-12">
                <div class="input-block">
                    <b><?php

                        echo 'Subledger Detailed Report'; ?></b>
                </div>
                <br> <br> <br>


                <table class="table" style="font-size: 10px;">
                    <tr>
                        <td><b>From</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($from_date)); ?>
                        </td>

                        <td><b>To</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($to_date)); ?>
                        </td>
                        <td><b>SubLedger</b></td>
                        <td>
                            <?php

                            if ($subledger !== '' && $subledger > 0) {
                                $modelAccSubledger = new AccSubledger();
                                $subledger_det = $modelAccSubledger->findByPk($subledger);
                                echo $subledger_det->subledger_name;
                            }
                            ?>
                        </td>
                      

                    </tr>

                </table>
            </div>

        </div>
        <br>
        <?php
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }


        if ($warehouse_id > 0) {
            $condition .= ' AND t.warehouse_id=' . $warehouse_id;
            $condition_for_opening .= ' AND I.warehouse_id=' . $warehouse_id;
        }


        if ($outlet_id > 0) {
            $condition .= ' AND t.outlet_id IN(' . $outlet_id . ')';
            $condition_for_opening .= ' AND I.outlet_id IN(' . $outlet_id . ')';
        }


        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount 
        FROM {{acc_voucher_items}} I 
        LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id 
        WHERE  ' . $condition_for_opening . ' ')->queryScalar();


        $openingBalance2 = Yii::app()->db->createCommand('SELECT 
        ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount 
        FROM {{acc_voucher_items}} I 
        LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id 
        WHERE  ' . $condition_for_opening . ' ')->queryScalar();
$modelMasCurrency =  new MasCurrency();
        $modelAccVoucherItems =  new AccVoucherItems();
        $items = $modelAccVoucherItems->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));

        $openingBalance = $openingBalance1 + ($openingBalance2 / $exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;

        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;
        ?>
        <table style="font-size:14px;  width:100%;" class="table table-hover table-fixed table-bordere" id="tb_table">
            <thead>
                <tr>
                    <th style="width:7%">Date</th>
                    <th style="width:7%">VO #</th>
                    <th style="width:9%">GL No#</th>
                    <th style="width:10%">Ledger</th>
                    <th style="width:20%">Subledger</th>
                    <th style="width:20%">Warehouse</th>
                    <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                    <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                    <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                    <th style="width:30%">Narration</th>
                </tr>
            </thead>

            <tbody>


                <tr>
                    <td colspan="6" class="text-right"><b>Opening Balance</b></td>
                    <td class="text-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($previousBalance > 0) ? abs($previousBalance) : 0)); 
                                            ?></td>
                    <td class="text-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((($previousBalance < 0) ? abs($previousBalance) : 0)); 
                                            ?></td>
                    <td class="text-right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($previousBalance)) . ' ' . $symbol
                                            ?></td>
                    <td></td>
                </tr>

                <?php

                $total_debit += $previousBalance > 0 ? abs($previousBalance) : 0;
                $total_credit += $previousBalance < 0 ? abs($previousBalance) : 0;

                $parent = 1;
                if (!empty($items)) {
                    foreach ($items as $each) {

                        $debit = ($each->amount > 0) ? round(($each->amount), 4) : 0;
                        $credit = ($each->amount < 0) ? round(abs($each->amount), 4) : 0;

                        $running = $debit - $credit + $previousBalance;
                        $closingBalance += ($debit - $credit);
                        $total_debit += $debit;
                        $total_credit += $credit;
                        $previousBalance = $running;

                        $symbol = ($running > 0) ? 'Dr' : 'Cr';

                        $subledgerName = ($each->subledger_id > 0) ? $each->subledger->subledger_name : '';

                ?>
                        <tr data-id="' . $parent . '" data-parent="">
                            <td><?php echo date("d/m/Y", strtotime($each->parent->voucher_date)); ?></td>
                            <td><?php echo $vouchreformat; ?></td>
                            <td><?php echo $each->ledger->ledger_acc_no; ?></td>
                            <td><?php echo $each->ledger->ledger_acc_name; ?></td>
                            <td><?php echo $subledgerName; ?></td>
                    <td><?php echo $each->warehouse->warehouse_name; ?></td>
                            <td style="text-align:right !important;"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat((($debit !== '') ? $debit : 0));  ?></td>
                            <td style="text-align:right !important;"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat((($credit !== '') ? $credit : 0)); ?></td>
                            <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat((abs($running))) . " " . $symbol; ?></td>
                            <td><small><?php echo $each->narration; ?></small></td>
                        </tr>
                    <?php $parent = $child;
                    }
                    $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr'; ?>

                    <tr>
                        <td colspan="6" class="text-right"><b>Total</b></td>
                        <td class="text-right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_debit)); ?></b></td>
                        <td class="text-right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_credit));  ?></b></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td colspan="6" class="text-right"><b>Closing Balance</b></td>
                        <td colspan="3" class="text-right"><b><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($closingBalance)). ' ' . $symbol; ?></b></td>
                        <td></td>
                    </tr>
                <?php } ?>

            </tbody>
        </table>


        <?php $this->renderPartial("//common/footer");?>
</body>

</html>