<!DOCTYPE html>
<html>

<head>
    <title>
        <?php
        echo "Ledger Report"; ?>
    </title>


    <style type="text/css">
        table {
            font-family: arial, sans-serif !important;
            border-collapse: collapse !important;
            width: 100% !important;
        }

        td,
        th {
            border: 1px solid #dddddd !important;
            text-align: left !important;
            padding: 8px !important;
        }
    </style>
</head>

<body>

    <div class="container my-md-2 py-2" style="width:100%;float: right;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--   header -->
        <?php
        $this->renderPartial('//common/header'); ?>
        <!--   header -->
    </div>
    <div style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--add New Template-->
        <div class="">
            <div class="col-12">
                <div class="input-block">
                    <b><?php echo 'Ledger Report'; ?></b>
                </div>
                <br> <br> <br>
                <?php $date_name = ($date_field == 'posted_date') ? 'Posted' :  'Voucher'; ?>

                <table class="table" style="font-size: 10px;">
                    <tr>
                        <td><b><?php echo $date_name; ?> From</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($from_date)); ?>
                        </td>

                        <td><b><?php echo $date_name; ?> To</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($to_date)); ?>
                        </td>

                        <td><b>Currency</b></td>
                        <td>
                            <?php
                            $modelMasCurrency =  new MasCurrency();
                            $modelMasCurrency = $modelMasCurrency->findByPk($currency);
                            echo $modelMasCurrency->currency_code; ?>
                        </td>
                    </tr>
                    <tr>

                        <td><b>Ledger</b></td>
                        <td>
                            <?php
                            $modelAccLedger =  new AccLedger();
                            $modelAccLedger = $modelAccLedger->findByPk($ledger_id);
                            echo $modelAccLedger->ledger_acc_name; ?>

                        </td>

                        <td><b>Subledger</b></td>
                        <td>
                            <?php
                            $modelAccSubledger =  new AccSubledger();
                            $modelAccSubledger = $modelAccSubledger->findByPk($subledger);
                            echo $modelAccSubledger->subledger_name; ?>




                        </td>
                        <?php /* ?>
                        <td><b>Outlet</b></td>
                        <td>
                            <?php
                            if ((int)$outlet_id == 0) {
                                echo 'All Outlet';
                            } else {
                                $modelMasOutlet = new MasOutlet();
                                $modelMasOutlet = $modelMasOutlet->findBypk((int)$outlet_id);
                                echo $modelMasOutlet->outlet_name;
                            }
                            ?>
                        </td>
                        <?php */ ?>
                    </tr>
                </table>
            </div>

        </div>
        <br>



        <?php

        $modelMasCurrency =  new MasCurrency();

        $baseUrl = Yii::app()->baseUrl;
        $cur = MasCurrency::model()->findByPk(1);
        $exchange_rate = $cur->exchange_rate;


        $condition_new = 'H.is_posted="Y" AND I.amount != 0 AND DATE(H.' . $date_field . ') >= "' . $from_date . '" AND DATE(H.' . $date_field . ')<= "' . $to_date . '"';


        $condition_for_opening = 'H.is_posted="Y" AND DATE(H.' . $date_field . ') < "' . $from_date . '"';



        if ($ledger_id > 0) {
            $condition_new .= ' AND I.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition_new .= ' AND I.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }
        if ($outlet_id > 0) {
            $condition_new .= " AND I.outlet_id = '" . $outlet_id . "'";
            $condition_for_opening .= ' AND I.outlet_id=' . $outlet_id;
        }

        // -------------------------------


        $cur = MasCurrency::model()->findByPk($currency);
        $exchange_rate = $cur->exchange_rate;

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*H.exchange_rate)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id!=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();




        $openingBalance = $openingBalance1 + ($openingBalance2 / $exchange_rate);


        $previousBalance = $openingBalance;



        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        if ($previousBalance > 0) {
            $dbt_previousBalance = $previousBalance;
        }
        if ($previousBalance < 0) {
            $cr_previousBalance = $previousBalance;
        }


        $query = 'SELECT
            VI.acc_voucher_id,
            CONCAT(VT.code, "/", V.voucher_no) AS fullvoucher,
            VI.ledger_id,
            L.ledger_acc_name,
            VI.subledger_id,
            S.subledger_name,
            VI.debit,
            VI.credit,
            VI.amount,
            VI.exchange_rate,
            VI.currency_id,
            VI.narration,
            VI.warehouse_id,
            V.voucher_date,
            V.posted_date,
            V.transaction_number,
            V.voucher_no,
            W.warehouse_name,
            VT.code
        FROM
            erp_acc_voucher_items VI
        LEFT JOIN erp_acc_voucher V ON
            V.id = VI.acc_voucher_id
        LEFT JOIN erp_mas_inv_warehouse W ON
            W.id = VI.warehouse_id
        LEFT JOIN erp_acc_voucher_type VT ON
            VT.id = V.voucher_type
        LEFT JOIN erp_acc_ledger L ON
            L.id = VI.ledger_id
        LEFT JOIN erp_acc_subledger S ON
            S.id = VI.subledger_id
        WHERE
            acc_voucher_id IN(
            SELECT DISTINCT
                (I.acc_voucher_id)
            FROM
                erp_acc_voucher_items I
            LEFT JOIN erp_acc_voucher H ON
                H.id = I.acc_voucher_id
            WHERE ' . $condition_new . ' 
        )
        ORDER BY
            VI.acc_voucher_id,
            VI.id
        DESC';

        $items = Yii::app()->db->createCommand($query)->queryAll();
        // --------------------------------


        ?>
        <table class="table table-hover table-fixed table-bordere" id="tb_table" style="font-size: 11px;">
            <!-- <table class="table-tree"> -->
            <thead>
                <tr class="to tol1">
                    <th style="width:5%">#</th>
                    <th style="width:10%">Voucher Date</th>
                    <th style="width:10%">Posted Date</th>
                    <th style="width:9%">VO #</th>
                    <th style="width:9%">Trans #</th>
                    <th style="width:15%">Ledger</th>
                    <th style="width:15%">Subledger</th>
                    <th style="width:9%;text-align:right !important;" class="text-right">Debit</th>
                    <th style="width:9%;text-align:right !important;" class="text-right">Credit</th>
                    <th style="width:9%;text-align:right !important;" class="text-right">Balance</th>
                    <th style="width:15%">Narration</th>
                </tr>
            </thead>
            <tbody>
                <tr style=" background: #c3c8d1">

                    <td colspan="7" style="text-align:right "><b>Opening Balance</b></td>
                    <td style="text-align:right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($dbt_previousBalance); ?></td>
                    <td style="text-align:right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($cr_previousBalance)); ?></td>
                    <td style="text-align:right"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($previousBalance)) . ' ' . $symbol; ?></td>
                    <td></td>

                </tr>
                <?php
                $parent = 1;
                $total_debit = $total_credit = $closingBalance = 0;
                foreach ($items as $key => $each) {

                    $debit = $each['debit'];
                    $credit = $each['credit'];


                    $debit = ($each['amount'] > 0) ? round(($each['amount'] * $each['exchange_rate']), 4) : 0;
                    $credit = ($each['amount'] < 0) ? round(abs($each['amount'] * $each['exchange_rate']), 4) : 0;

                    $debit = ($currency == $each['currency_id']) ? $debit / $each['exchange_rate'] : $debit / $exchange_rate;
                    $credit = ($currency ==  $each['currency_id']) ? $credit / $each['exchange_rate'] : $credit / $exchange_rate;


                    $running = $debit - $credit + $previousBalance;
                    $previousBalance = $running;
                    $symbol = ($running > 0) ? 'Dr' : 'Cr';


                    $total_debit += $debit;
                    $total_credit += $credit;


                    // --------------------------------------------------------------------------


                    $subledgerName = ($each['subledger_id'] > 0) ? $each['subledger_name'] : '';
                    $style = "background-color:none;";
                    if ($ledger_id == $each['ledger_id']) {
                        $style = "background-color:#7ff67f63;";
                    }
                ?>
                    <tr style="<?php echo $style ?>">
                        <td><?php echo $key + 1; ?></td>


                        <td>

                            <?php echo ($each['voucher_date'] == '0000-00-00' ||  $each['voucher_date'] == '30/11/-0001') ? "-" : date('d/m/Y', strtotime($each['voucher_date'])); ?>
                        </td>

                        <td><?php echo ($each['posted_date'] == '0000-00-00 00:00:00' ||  $each['posted_date'] == '30/11/-0001') ? "-" : date('d/m/Y', strtotime($each['posted_date'])); ?> </td>


                        <td><?php echo  $each['fullvoucher']; ?></td>
                        <td style="text-align:right !important;"><?php echo $each['transaction_number']; ?></td>
                        <td><?php echo $each['ledger_acc_name']; ?></td>
                        <td><?php echo $subledgerName; ?></td>
                        <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debit);  ?></td>
                        <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit));  ?></td>
                        <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($running)) . " " . $symbol; ?></td>
                        <td><small><?php echo $each['narration'] . ' - ' . $each['warehouse_name']; ?></small></td>
                    </tr>


                <?php

                }
                $closingBalance = abs($total_debit + $dbt_previousBalance) - (abs($total_credit) + abs($cr_previousBalance));
                $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
                ?>
                <tr>
                    <td colspan="7" style="text-align:right"><b>Total</b></td>
                    <td style="text-align:right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_debit + $dbt_previousBalance)); ?></b></td>
                    <td style="text-align:right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_credit) + abs($cr_previousBalance)); ?></b></td>

                    <td></td>
                    <td></td>
                </tr>
                <tr style=" background: #c3c8d1">
                    <td colspan="7" style="text-align:right ;"><b>Closing Balance</b></td>
                    <td colspan="3" style="text-align:right "><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($closingBalance))  . ' ' . $symbol; ?></b></td>

                    <td></td>

                </tr>
            </tbody>
        </table>



        <htmlpagefooter name="myfooter">

            <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
                <?php
                date_default_timezone_set("Asia/Dubai");
                echo date('d/m/Y') . " " . date("h:i:sa"); ?>
            </div>

            <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
                <div style="text-align:center;width:100%">
                    <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                    <?= Yii::app()->user->footer_line_2 ?>
                </div>
                <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
            </div>
        </htmlpagefooter>
</body>

</html>