<?php


$condition = 'VI.ledger_id="' . $ledger_id . '" AND V.is_posted = "Y"';

if ($ledger_main_acc == 'A' || $ledger_main_acc == 'L') {
    $condition .= ' AND V.voucher_date <= "' . $to_date . '"';
} else {
    $condition .= ' AND V.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
}


if ((int)$outlet_id>0) {
    $condition .= " AND  VI.outlet_id = '" . $outlet_id . "'";
}

if ((int)$department_id>0) {
    $condition .= " AND  VI.department_id = '" . $department_id . "'";
}

if ((int)$warehouse_id>0) {
    $condition .= " AND  VI.warehouse_id = '" . $warehouse_id . "'";
}




$glSummaryquery = 'CREATE OR REPLACE VIEW {{acc_view_gl_summary}} AS SELECT
  SL.id AS subledger_id,
  SL.reference_id AS subledger_no,
  IFNULL(SL.subledger_name, "No Subledger") AS subledger_name,
  ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*V.exchange_rate ELSE 0 END ), 4) AS debit,
  ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*V.exchange_rate) ELSE 0 END ), 4) AS credit,
  ROUND(SUM(VI.amount*V.exchange_rate), 4) AS balance,
  L.id AS ledger_id,VI.subledger_id AS voucher_sub_id,
  L.ledger_main_acc AS ledger_main_acc
FROM {{acc_voucher_items}} VI
LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
LEFT JOIN {{acc_ledger}} L ON L.id = VI.ledger_id
LEFT JOIN {{acc_subledger}} SL ON SL.id = VI.subledger_id
WHERE ' . $condition . '
GROUP BY  VI.ledger_id, VI.subledger_id';
Yii::app()->db->createCommand($glSummaryquery)->execute();


$summaryItems = Yii::app()->db->createCommand('SELECT debit,credit,ledger_main_acc,ledger_id,subledger_id,subledger_name,subledger_no FROM {{acc_view_gl_summary}} WHERE balance != 0 ORDER BY subledger_name')->queryAll();

?>
<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
    <thead>
        <tr>
            <th style="width:10%">#</th>
            <th style="width:40%">Particular</th>
            <th style="width:16%;text-align:right !important;" class="text-right">Debit</th>
            <th style="width:16%;text-align:right !important;" class="text-right">Credit</th>
            <th style="width:17%;text-align:right !important;" class="text-right">Balance</th>
        </tr>
    </thead>
    <tbody>

        <?php
        $modelMasCurrency =  new MasCurrency();
        $totalDebit = $totalCredit =  $totalBalance = 0;

        foreach ($summaryItems as $each) {

            // -----------------------------------------------------------------------

            $debit = $each['debit'];
            $credit = $each['credit'];

            $totalDebit += $debit;
            $totalCredit += $credit;

            if ($each['ledger_main_acc'] == 'A' || $each['ledger_main_acc'] == 'L') {
                $count = Yii::app()->db->createCommand("SELECT count(*) FROM {{acc_voucher_items}} as ledger INNER JOIN {{acc_voucher}} head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $each['ledger_id'] . "'  AND ledger.subledger_id='" . $each['subledger_id'] . "' AND  head.is_posted ='Y'  AND head.voucher_date<='" . $to_date . "'")->queryScalar();
            } else {
                $count = Yii::app()->db->createCommand("SELECT count(*) FROM {{acc_voucher_items}} as ledger INNER JOIN {{acc_voucher}} head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $each['ledger_id'] . "'  AND ledger.subledger_id='" . $each['subledger_id'] . "' AND head.is_posted ='Y' AND head.voucher_date>='" . $from_date . "' AND head.voucher_date<='" . $to_date . "'")->queryScalar();
            }

            if ($frm == 'profitloss') {
                $function_name = $count < 300 ? 'Load_pl_gl_report' : 'load_pl_gl_summary_tab_excel';
            } else if ($frm == 'balance' || $frm == 'balance_det') {
                $function_name = $count < 300 ? 'Load_balance_gl_report' : 'load_balance_gl_summary_tab_excel';
            } else {
                $function_name = $count < 300 ? 'Load_tb_gl_report' : 'load_gl_summary_tab_excel';
            }

            if ($count < 300) {
                $subledgerName = '<a href="#" onclick="js:' . $function_name . '(' . $each['ledger_id']  . ', 0, ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';
            } else {
                $subledgerName = '<a href="#" onclick="js:' . $function_name . '(' . $each['ledger_id']  . ',' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';
            }

            // --------------------------------------------------------------------------

            $diff_balance = $debit - $credit;
            $symbol =  ($diff_balance > 0) ? 'Dr' : 'Cr';
            $totalBalance += $diff_balance;
        ?>
            <tr>
                <td><?php echo $each['subledger_no']; ?></td>
                <td><?php echo $subledgerName ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debit);  ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($credit);  ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($diff_balance)).' '.$symbol; ?></td>

            </tr>

        <?php } 
         $symbol =  ($totalBalance > 0) ? 'Dr' : 'Cr';
        ?>

        <tr>
            <td colspan="2" style="text-align:right !important;"><b>Total</b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($totalDebit); ?></b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($totalCredit); ?></b></td>
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($totalBalance)).' '.$symbol; ?></b></td>

        </tr>
        <?php
        $balance = $totalDebit - $totalCredit;
        $debitBalance = ($balance > 0) ? $balance : 0;
        $creditBalance = ($balance <= 0) ? abs($balance) : 0;
        $symbol =  ($balance > 0) ? 'Dr' : 'Cr';
        ?>
        <tr style=" background: #c3c8d1">
            <td colspan="4" style="text-align:right !important;"><b>Balance</b></td>
            <!-- <td style="text-align:right !important;"><b><?php //echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debitBalance);  ?></b></td> -->
            <!-- <td style="text-align:right !important;"><b><?php //echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($creditBalance);  ?></b></td> -->
            <td style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($balance)).' '. $symbol; ?></b></td>

        </tr>
    </tbody>
</table>