<!------------------------------------------------------------------------------------------------------- ---->
<!--//VAT on Sales (Outwards)//-->
<!------------------------------------------------------------------------------------------------------- ---->

<?php

$baseUrl = Yii::app()->baseUrl;
$modelAccLedger = new AccLedger();
$baseCurrency = $modelAccLedger->baseCurrencycode();


// --------------------------------------------------------------


$sql_comm = "SELECT 
                    sum(item_amount) as  amount,
                    sum(grand_total) as grand_total,
                    sum(item_tax_vat_amount) as  tax_vat_amount,
                    sum(item_deduction_amount) as deduction_amount ,
                    sum(item_net_amount) as net_amount ,
                    invoice_date,customer_name,invoice_id,invoice_no
                    FROM view_commission_sales_report   
                    WHERE  invoice_date >='" . $from_date . "' AND invoice_date <='" . $to_date . "'
                    GROUP BY created_by ";
$invoice_list = Yii::app()->db->createCommand($sql_comm)->queryAll();

// -----------credit-note----------------------------------

$sql_comm_cn = "SELECT 
                    sum(item_rate) as  item_rate,
                    sum(item_net_amount+item_tax_vat_amount) as net_amount,
                    sum(item_tax_vat_percentage) as  item_tax_vat_percentage,
                    sum(item_tax_vat_amount) as tax_vat_amount ,
                     sum(total_tax_amount) as total_tax_amount,
                    sum(paid_card_amount) as paid_card_amount, 
                    sum(commision_amount) AS commision_amount ,
                    sum(credited_amount) as credited_amount,
                    warehouse_id,warehouse_name,credited_date,customer_name,invoice_id,creditnote_no,creditnote_id,invoice_no
                    FROM view_commission_creditnote_report   
                    WHERE  credited_date >='" . $from_date . "' AND credited_date <='" . $to_date . "'
                     GROUP BY created_by ";
$creditnote_list = Yii::app()->db->createCommand($sql_comm_cn)->queryAll();

// ----------------------------------------------------------------
?>

<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
    <thead>
        <tr>
            <th class="turnover" colspan="9">VAT on Sales (Outwards)</th>
        </tr>
        <tr>
            <th style="width:5%">Sl.No</th>
            <th style="width:5%">Date</th>
            <th style="width:8%">Inv.No</th>
            <th style="width:8%">Inv Ref</th>
            <th style="width:20%">Customer</th>
            <th style="width:20%">TRN</th>
            <th style="width:8%;">Amount</th>
            <th style="width:5%;">VAT (<?php echo $baseCurrency; ?>)</th>
            <th style="width:10%;">Net Amount</th>
        </tr>
    </thead>
    <tbody>

        <?php
        $i = $total_vat_grand = $total_net_amount = $total_amount_without_vat_cr=$total_amount_without_vat=0;
        foreach ($invoice_list as $i => $list) {  ?>
            <tr>
                <td>
                    <?php echo $i + 1; ?>
                </td>
                <td><?php echo  date("d/m/Y", strtotime($list['invoice_date'])); ?></td>
                <td><?php echo 'SI' . '/' . $list['invoice_no']; ?></td>
                <td>-</td>
                <td><?php echo $list['customer_name']; ?></td>
                <td>-</td>


                <td style="text-align:right !important;">
                    <?php
                    $amount_without_vat = $list['amount'] - $list['deduction_amount'] - $list['tax_vat_amount'];
                    echo Yii::app()->numberFormatter->formatCurrency($amount_without_vat, "");
                    $total_amount_without_vat += $amount_without_vat
                    ?>
                </td>
                <td style="text-align:right !important;">
                    <?php
                    echo Yii::app()->numberFormatter->formatCurrency($list['tax_vat_amount'], "");
                    $total_vat_grand += $list['tax_vat_amount'];
                    ?>
                </td>

                <td style="text-align:right !important;">
                    <?php
                    $net_amount = $list['amount'] - $list['deduction_amount'];
                    echo Yii::app()->numberFormatter->formatCurrency($net_amount, "");
                    $total_net_amount +=  $net_amount;
                    ?>
                </td>
            </tr>
        <?php
        } ?>

        <?php $i++;
        $total_amount_cr = $total_vat_grand_cr = 0;
        foreach ($creditnote_list as $creditnote) {
            $i++; ?>
            <tr title="Credit Note">
                <td>
                    <?php echo $i; ?>
                </td>
                <td><?php echo  date("d/m/Y", strtotime($creditnote['credited_date'])); ?></td>
                <td><?php echo 'CN' . '/' . $creditnote['invoice_no']; ?></td>
                <td>-</td>
                <td><?php echo $creditnote['customer_name']; ?></td>
                <td>-</td>
                <td style="text-align:right !important;">
                    <?php
                    $amount_without_vat_cr = -1 * ($creditnote['net_amount']) - -1 * ($creditnote['tax_vat_amount']);
                    echo $amount_without_vat_cr;
                    $total_amount_without_vat_cr += $amount_without_vat_cr;
                    ?>
                </td>
                <td style="text-align:right !important;">
                    <?php
                    echo -1 * ($creditnote['total_tax_amount']);
                    $total_vat_grand_cr += -1 * ($creditnote['total_tax_amount']);
                    ?>
                </td>
                <td style="text-align:right !important;">
                    <?php
                 
                    echo -1 * ($creditnote['net_amount']);
                    $total_amount_cr += -1 * ($creditnote['net_amount']);
                    ?>
                </td>
            </tr>
        <?php } ?>
        <tr>
            <td colspan="6" style="text-align:right !important;"><b>Total VAT (<?php echo $baseCurrency; ?>)</b></td>
             <td style="text-align:right !important;"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($total_amount_without_vat+$total_amount_without_vat_cr, " "); ?></b></td>
            <td style="text-align:right !important;"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($total_vat_grand + $total_vat_grand_cr, " "); ?></b></td>
            <td style="text-align:right !important;"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($total_net_amount + $total_amount_cr, " "); ?></b></td>
        </tr>
    </tbody>
</table>
