<!--
chart of accounts
Balance Sheet report
Date 03-10-2022
updated- date 15-12-2022
author -Jisha V2
main setup
-->

<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }
    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }
    .to {
        background: rgb(31 103 178);
        color: White;
    }
    .tol1 {
        font-size: 16px !important;
    }
    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }
    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }
    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }
    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }
    .level-5 {
        padding-left: 267px !important;
    }
    .l1 {
        font-size: 17px !important;
    }
    .l2 {
        font-size: 16px !important;
    }
    .l3 {
        font-size: 15px !important;
    }
    .l4 {
        font-size: 14px !important;
    }
    .l5 {
        font-size: 14px !important;
    }
    .txt-right {
        text-align: right !important;
    }
</style>
<?php
/* taking all ledger List In  Balance Sheet  ----start---- */    
$sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger  FROM  `erp_acc_ledger` ORDER BY `erp_acc_ledger`.`ledger_acc_no`  ASC";
if ($level > 0) {
    $sql = "SELECT id,level,root,ledger_main_acc,is_parent,ledger_acc_name,ledger_acc_no,have_subledger  FROM  `erp_acc_ledger` 
                WHERE ledger_main_acc IN ('A','L','NP') AND
                level<=" . $level . "
                ORDER BY `erp_acc_ledger`.`ledger_acc_no`  ASC";
}
$arr_ledgers = Yii::app()->db->createCommand($sql)->queryAll();
/* taking all ledger List In  Balance Sheet ----end---- */    
?>
<table class="table-tree html_table">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Debit</th>
            <th>Credit</th>
        </tr>
    </thead>
    <?php
    /* filter conditions  ----start---- */
    $condition = ' AND is_posted="Y" ';
    // if ($from_date != '') {
    //     $from_date = str_replace('/', '-', $from_date);
    //     $from_date = date('Y-m-d', strtotime($from_date));
    // }
    
    $from_date='202-06-01';
   
    if ($to_date != '') {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
    }
    
      if ((int)$company>0) {
        $condition .= " AND company_id = '{$company}'";
    }
  
    if ((int)$salesgroup>0) {
        $condition .= " AND salegroup_id = '{$salesgroup}'";
    }
    if ((int)$brand>0) {
        $condition .= " AND  brand_id = '" . $brand . "'";
    }
  
    if ((int)$department_id>0) {
        $condition .= " AND department_id = '{$department_id}'";
    }
    if ((int)$warehouse_id>0) {
        $condition .= " AND warehouse_id = '{$warehouse_id}'";
    }
    if ((int)$outlet_id>0) {
        $condition .= " AND outlet_id = '{$outlet_id}'";
    }
    
    $condition .= ' AND voucher_date <="' . $to_date . '"';
    /* filter conditions  ----end---- */
    //profit in profit and loss on date before from date --start
    $sql_net_profit = "SELECT SUM(debit+credit) AS amount 
        FROM view_account_voucher_items  
        WHERE  ledger_main_acc IN ('I','E') AND is_posted='Y'  AND voucher_date <=' " . $to_date . "'";
    $net_profit = Yii::app()->db->createCommand($sql_net_profit)->queryScalar();
    //profit in profit and loss on date before from date --end
    //net profit ledger --start
    $modelnet_profit_ledger = new AccLedger();
    $modelnet_profit_ledger = $modelnet_profit_ledger->find(array('condition' => 'ledger_main_acc="NP"'));
    //accumulate profit ledger --end
    
    foreach ($arr_ledgers as $eachledger) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;
        //ledger_main_acc=net profit
        if ($eachledger['ledger_main_acc'] == 'NP') {
            if ($net_profit > 0) {
                $debit = $net_profit;
                $style_tr = ' levelnetloss';
            } else {
                $credit = $net_profit;
                $style_tr = ' levelnet';
            }
        } else {
            $condition1 = "level>= :level AND root LIKE :root";
            $params = [':level' => $eachledger['level'], ':root' => $eachledger['root'] . '%'];
            
            $sqlVI = "SELECT IFNULL(SUM(debit+credit),0) As amount FROM view_account_voucher_items WHERE " . $condition1 . $condition;
            // Prepare the statement and bind the parameters
            $command = Yii::app()->db->createCommand($sqlVI);
            $command->bindValues($params);
            
            // Execute the query and fetch the result
            $netamount = $command->queryScalar();
            
            if ($netamount > 0) {
                $debit = $netamount;
            } else {
                $credit = $netamount;
            }
        }
        /* Total Sum needs only level 1 sum*/
        if ($eachledger['level'] == '1') {
            /*For showing Totals at end --start*/
            $sum_debit += $debit;
            $sum_credit += $credit;
            /*For showing Totals at end --end*/            
        }
        ?>
          <?php
            if ($company < 0 || $company=='') {
                $company = 0;
            }
            if ($eachledger['is_parent'] == 'N') {

            if ($eachledger['ledger_main_acc'] == 'A' || $eachledger['ledger_main_acc'] == 'L') {
                $count = Yii::app()->db->createCommand("SELECT count(*) FROM erp_acc_voucher_items as ledger INNER JOIN erp_acc_voucher head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $eachledger['id'] . "' AND head.is_posted ='Y'  AND head.voucher_date<='" . $to_date . "'")->queryScalar();
            } else {
                $count = Yii::app()->db->createCommand("SELECT count(*) FROM erp_acc_voucher_items as ledger INNER JOIN erp_acc_voucher head ON head.id=ledger.acc_voucher_id WHERE ledger.ledger_id='" .  $eachledger['id'] . "' AND head.is_posted ='Y' AND head.voucher_date>='" . $from_date . "' AND head.voucher_date<='" . $to_date . "'")->queryScalar();
            }
            if ($eachledger['have_subledger'] == 'Y') {
                $link = 'js:load_balance_summary_pl(' . $eachledger['id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
            } else {
                if ($count < 300) {
                    $link = 'js:Load_balance_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
    
                    $link = 'js:load_balance_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }
              
              
                $accountName = '<a href="#" onclick="' . $link . '">' . $eachledger['ledger_acc_name'] . '</a>';
            } else {
                $link = '';
                $accountName = '' . $eachledger['ledger_acc_name'] . '';
            }
        if($type!='NZ'||abs($debit)>0||abs($credit)>0||$eachledger['level']==1){ ?>
        <tr class="l<?php echo $eachledger['level'].$style_tr; ?> level<?php echo $eachledger['level']; ?>">
            <td class="l1"><?php echo $eachledger['ledger_acc_no']; ?></td>
            <td class="level-<?php echo $eachledger['level']; ?> l<?php echo $eachledger['level']; ?>"><b><?php echo $accountName; ?></b></td>
            <td  class="txt-right l<?php echo $eachledger['level']; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($debit), ""); ?></b></td>
            <td  class="txt-right l<?php echo $eachledger['level']; ?>"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($credit), ""); ?></b></td>
        </tr>
    <?php }
    } ?>
    <tr>
        <td></td><td></td><td></td><td></td>
    </tr>
    <tr class="to tol1"><td></td><td><b>Total</b></td>
        <td  class="txt-right  "><?php echo Yii::app()->numberFormatter->formatCurrency($sum_debit, ""); ?></td>
        <td  class="txt-right "><?php echo Yii::app()->numberFormatter->formatCurrency(abs($sum_credit), ""); ?></td>
    </tr>
</table>