<!--
chart of accounts
Auditclose report
Date 24-03-2025
author -Sebi
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }

    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }

    .to {
        background: rgb(31 103 178);
        color: White;
    }

    .tol1 {
        font-size: 16px !important;
    }

    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }

    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }

    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }

    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }

    .level-5 {
        padding-left: 267px !important;
    }

    .l1 {
        font-size: 17px !important;
    }

    .l2 {
        font-size: 16px !important;
    }

    .l3 {
        font-size: 15px !important;
    }

    .l4 {
        font-size: 14px !important;
    }

    .l5 {
        font-size: 14px !important;
    }

    .txt-right {
        text-align: right !important;
    }
</style>
<table class="table-tree">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Account Name</th>
            <th>Debit</th>
            <th>Credit11</th>
        </tr>
    </thead>
    <?php
    $modelMasCurrency =  new MasCurrency();
    $modelaccumulated_profit_ledger = new AccLedger();
    $modelaccumulated_profit_ledger = $modelaccumulated_profit_ledger->find(array('condition' => 'ledger_main_acc="AP"'));
    
    foreach ($auditCloseResults as $k => $eachAuditClose) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;
        
        if ($eachAuditClose['amount'] > 0) {
            $debit = $eachAuditClose['amount'];
        } else {
            $credit = $eachAuditClose['amount'];
        }

        if ($eachAuditClose['level'] == '1') {
            $sum_debit += $debit;
            $sum_credit += $credit;
        }

        $accountName = '' . $eachAuditClose['ledger_acc_name'] . '';
        if (($type != 'NZ' || abs($debit) > 0 || abs($credit) > 0 || $eachAuditClose['level'] == 1) && $eachAuditClose['ledger_acc_no']) { ?>
            <tr class="l<?php echo $eachAuditClose['level'] . $style_tr; ?> level<?php echo $eachAuditClose['level']; ?>">
                <td class="l1"><?php echo $eachAuditClose['ledger_acc_no']; ?></td>
                <td class="level-<?php echo $eachAuditClose['level']; ?> l<?php echo $eachAuditClose['level']; ?>"><b><?php echo $accountName; ?></b></td>
                <td class="txt-right l<?php echo $eachAuditClose['level']; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($debit));  ?></b></td>
                <td class="txt-right l<?php echo $eachAuditClose['level']; ?>"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit)); ?></b></td>
            </tr>
        <?php }
    }
    ?>
    <tr>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
    </tr>
    <tr class="to tol1">
        <td></td>
        <td><b>Total</b></td>
        <td class="txt-right  "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($sum_debit);  ?></td>
        <td class="txt-right "><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($sum_credit)); ?></td>
    </tr>
</table>






