
<!--
chart of accounts
Aging Sheet report
Date 03-10-2022
updated- date 28-12-2022
author -indhu
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }

    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }

    .to {
        background: rgb(31 103 178);
        color: White;
    }

    .tol1 {
        font-size: 16px !important;
    }

    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }

    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }

    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }

    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }

    .level-5 {
        padding-left: 267px !important;
    }

    .l1 {
        font-size: 17px !important;
    }

    .l2 {
        font-size: 16px !important;
    }

    .l3 {
        font-size: 15px !important;
    }

    .l4 {
        font-size: 14px !important;
    }

    .l5 {
        font-size: 14px !important;
    }

    .txt-right {
        text-align: right !important;
    }
</style>
<?php

function generateUrl($ledger_id, $subledger_id, $tail, $mode)
{
    return 'loadVouchers(' . $ledger_id . ', ' . (int) $subledger_id . ', \'' . $tail . '\', ' . $mode . ');';
}

$dates_array = array(
    '0_to_30' => array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date),
    '31_to_60' => array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days'))),
    '61_to_90' => array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days'))),
    '91_to_120' => array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days'))),
    'greaterthan_120' => array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days'))),
);



foreach ($dates_array as $key => $each_date_pair) {


    // ------------------------create- or-update- view- view_acc_ageing_--------------------------------------------------------------------------------------------
   
   
    $condition = 'V.is_posted =  "Y"';
    if ($subledger_id > 0) {
        $condition .= " AND  VI.subledger_id = '" . (int) $subledger_id . "'";
    }
    
    if ($lead_owner_id > 0) {
        $condition .= " AND  V.lead_owner = '" . (int) $lead_owner_id . "'";
    }
    
    
    $condition .= " AND  VI.ledger_id = '" . (int) $ledger . "'";

    //$condition .= ' AND V.voucher_date <="' . $from_date . '"';
    
    $condition .= ' AND V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '"';
   
    $query = 'CREATE OR REPLACE VIEW {{view_acc_ageing_' . $key . '}} AS SELECT
    VI.ledger_id AS ledger_id,
    VI.subledger_id AS subledger_id,
    IFNULL(S.subledger_name, "No Subledger") AS subledger,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    CONCAT(VT.code,"/",V.voucher_no) AS voucher_no,
    ROUND((VI.amount*VI.exchange_rate), 4) AS total_amount,
    IFNULL(ROUND( SUM(AI.amount), 4), 0) AS allocated,
   
    ROUND((VI.amount*VI.exchange_rate), 4) + IFNULL(ROUND( SUM(AI.amount), 4), 0)  AS amount
    
    FROM {{acc_voucher_items}} VI 
    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
    LEFT JOIN {{acc_subledger}} S ON S.id = VI.subledger_id
    LEFT JOIN {{acc_voucher_type}} VT ON VT.id=V.voucher_type
    WHERE  ' . $condition . '  GROUP BY VI.id, VI.subledger_id';

   
    $selectQuery = 'SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM(0_30_receivable) AS 0_30_receivable,
                        SUM(0_30_unallocated) AS 0_30_unallocated,
                        SUM(31_60_receivable) AS 31_60_receivable,
                        SUM(31_60_unallocated) AS 31_60_unallocated,
                        SUM(61_90_receivable) AS 61_90_receivable,
                        SUM(61_90_unallocated) AS 61_90_unallocated,
                        SUM(91_120_receivable) AS 91_120_receivable,
                        SUM(91_120_unallocated) AS 91_120_unallocated,
                        SUM(greater_120_receivable) AS greater_120_receivable,
                        SUM(greater_120_unallocated) AS greater_120_unallocated
                    FROM ( SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 0_30_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_0_to_30}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 31_60_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_31_to_60}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 61_90_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_61_to_90}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 91_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{view_acc_ageing_91_to_120}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS greater_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS greater_120_unallocated
                    FROM {{view_acc_ageing_greaterthan_120}} GROUP BY subledger_id ) AS A GROUP BY A.subledger_id ORDER BY A.subledger ASC';

    //    -------------------------------------------        
    Yii::app()->db->createCommand($query)->execute();
    //    -------------------------------------------        

}
$aging_report = Yii::app()->db->createCommand($selectQuery)->queryAll();

?>
<table class="table table-hover table-fixed table-bordered html_table"  style="font-size:13px;" id="gl_table">
    <thead>
        <tr>
            <th>#</th>
            <th>Subledger</th>
            <th>Type</th>
            <th>0-30</th>
            <th>31-60</th>
            <th>61-90</th>
            <th>91-120</th>
            <th> > 120</th>
            <th>Total</th>
             <th>Net Balance</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $modelMasCurrency =  new MasCurrency();
        $grand_total = 0;
        $one = 0;
        $two = 0;
        $three = 0;
        $four = 0;
        $five = 0;
        $labelOne = ($category == 'RECEIVABLE') ? 'Receivable' : 'Unallocated';
        $labelTwo = ($category == 'RECEIVABLE') ? 'Unallocated' : 'Payable';
        $z = 1;
        foreach ($aging_report as $i => $each) {
            
          

            $total_receivable = $each['0_30_receivable'] + $each['31_60_receivable'] + $each['61_90_receivable'] + $each['91_120_receivable'] + $each['greater_120_receivable'];
            $total_unallocated = $each['0_30_unallocated'] + $each['31_60_unallocated'] + $each['61_90_unallocated'] + $each['91_120_unallocated'] + $each['greater_120_unallocated'];

            $one_receivable += $each['0_30_receivable'];
            $two_receivable += $each['31_60_receivable'];
            $three_receivable += $each['61_90_receivable'];
            $four_receivable += $each['91_120_receivable'];
            $five_receivable += $each['greater_120_receivable'];
            $grand_total_receivable += $total_receivable;

            $one_unallocated += $each['0_30_unallocated'];
            $two_unallocated += $each['31_60_unallocated'];
            $three_unallocated += $each['61_90_unallocated'];
            $four_unallocated += $each['91_120_unallocated'];
            $five_unallocated += $each['greater_120_unallocated'];
            $grand_total_unallocated += $total_unallocated;
            //if ($total_receivable > 0 || $total_unallocated > 0) {
        ?>

                <tr>
                    <td rowspan="2" title="No."><?php echo $z; ?></td>
                    <td rowspan="2" title="Subledger"><?php echo  $each['subledger']; ?></td>
                    <td title="Type"><?php echo $labelOne; ?></td>
                    <td style="text-align:right !important;" title="0-30"><a href="#" onclick="<?php echo generateUrl($each['ledger_id'], $each['subledger_id'], '0_to_30', 1); ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['0_30_receivable']);  ?></a></td>
                    <td style="text-align:right !important;" title="30-60"><a href="#" onclick="<?php echo  generateUrl($each['ledger_id'], $each['subledger_id'], '31_to_60', 1); ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['31_60_receivable']);  ?></a></td>
                    <td style="text-align:right !important;" title="60-90"><a href="#" onclick="<?php echo generateUrl($each['ledger_id'], $each['subledger_id'], '61_to_90', 1); ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['61_90_receivable']); ?></a></td>
                    <td style="text-align:right !important;" title="90-120"><a href="#" onclick="<?php echo generateUrl($each['ledger_id'], $each['subledger_id'], '91_to_120', 1); ?>"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['91_120_receivable']);?></a></td>
                    <td style="text-align:right !important;" title=">120"><a href="#" onclick="<?php echo  generateUrl($each['ledger_id'], $each['subledger_id'], 'greaterthan_120', 1); ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['greater_120_receivable']); ?></a></td>
                    <td style="text-align:right !important;" title="Total"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($total_receivable);  ?></td>
                    <td rowspan="2" style="text-align:right !important;" title="Total"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_receivable-$total_unallocated));  ?></td>

                </tr>

                <tr>
                    <td title="Type"><?php echo $labelTwo; ?></td>
                    <td style="text-align:right !important;" title="0-30"><a href="#" onclick="<?php echo generateUrl($each['ledger_id'], $each['subledger_id'], '0_to_30', 0); ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['0_30_unallocated']); ?></a></td>
                    <td style="text-align:right !important;" title="30-60"><a href="#" onclick="<?php echo generateUrl($each['ledger_id'], $each['subledger_id'], '31_to_60', 0); ?>"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['31_60_unallocated']);  ?></a></td>
                    <td style="text-align:right !important;" title="60-90"><a href="#" onclick="<?php echo generateUrl($each['ledger_id'], $each['subledger_id'], '61_to_90', 0); ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['61_90_unallocated']);?></a></td>
                    <td style="text-align:right !important;" title="90-120"><a href="#" onclick="<?php echo  generateUrl($each['ledger_id'], $each['subledger_id'], '91_to_120', 0); ?>"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['91_120_unallocated']);  ?></a></td>
                    <td style="text-align:right !important;" title=">120"><a href="#" onclick="<?php echo generateUrl($each['ledger_id'], $each['subledger_id'], 'greaterthan_120', 0); ?>"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['greater_120_unallocated']);  ?></a></td>
                    <td style="text-align:right !important;" title="Total"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($total_unallocated);  ?></td>

                </tr>
            
                
        <?php
            //}
            $z++;
        }

        $modelAccLedger = new AccLedger;
        $baseCurrency =   $modelAccLedger->baseCurrencycode();


        ?>

        <tr>
            <td colspan="2" rowspan="2" style="text-align:right !important;"><b>Total</b></td>
            <td title="Type"><?php echo  $labelOne; ?></td>
            <td title="0-30" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($one_receivable) . " " . $baseCurrency; ?></b></td>
            <td title="30-60" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($two_receivable). " " . $baseCurrency; ?></b></td>
            <td title="60-90" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($three_receivable) . " " . $baseCurrency; ?></b></td>
            <td title="90-120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($four_receivable) . " " . $baseCurrency; ?></b></td>
            <td title=">120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($five_receivable) . " " . $baseCurrency;  ?></b></td>
            <td title="Total" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($grand_total_receivable). " " . $baseCurrency; ?></b></td>
            <td rowspan="2"  title="Total" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($grand_total_receivable-$grand_total_unallocated)). " " . $baseCurrency; ?></b></td>

        </tr>

        <tr>
            <td title="Type"><?php echo $labelTwo; ?></td>
            <td title="0-30" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($one_unallocated) . " " . $baseCurrency; ?></b></td>
            <td title="30-60" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($two_unallocated). " " . $baseCurrency; ?></b></td>
            <td title="60-90" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($three_unallocated) . " " . $baseCurrency; ?></b></td>
            <td title="90-120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($four_unallocated) . " " . $baseCurrency; ?></b></td>
            <td title=">120" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($five_unallocated) . " " . $baseCurrency; ?></b></td>
            <td title="Total" style="text-align:right !important;"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($grand_total_unallocated). " " . $baseCurrency; ?></b></td>
        </tr>


    </tbody>
</table>