<!--
 chart of accounts 
 Ledger List
 date 21-09-2022
 author -Nisha 
 main setup
 Tables - erp_acc_ledger
  -->
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("getNextaccount", "function getNextaccount(parent_id){
        jQuery.ajax({
            'type': 'post',
            'dataType': 'json',
            'data' : {'parent_id' : parent_id},
            'url': '" . Yii::app()->createUrl('accounts/accounts/getaccountno') . "',
            'success': function(data) { 
                $('#AccLedger_root').val(data.account_no);
                getaccountnumber();
                $('#AccLedger_root').addClass('filled');
            }
        });
    }", CClientScript::POS_HEAD);
$cs->registerScript("getaccountnumber", "function getaccountnumber(parent_id){
        var root =$('#AccLedger_root').val();
        var pref =$('#prefix_va').val();
        if(pref.length==1){
            pref ='0'+pref;
        }
        if(root.length==4){
            bal_acnt ='0000';
        }else{
            bal_acnt ='000000';
        }
        acct =root+pref+bal_acnt;
        acct = acct.substr(0,9); 
        $('#AccLedger_ledger_acc_no').val(acct);
        $('#AccLedger_ledger_acc_no').addClass('filled');
    

    }", CClientScript::POS_HEAD);
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'ledger-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<ul class="clearfix form-ul material">
    <li class="col-sm-5">
        <?php
        $fledger = new AccLedger();
        //    $fitems=new FinanceVoucherItems();
        echo $form->dropdownlist($model, 'ledger_parent_acc', $fledger->getParents(), array('class' => 'tooltipster', 'data-label' => 'Parent *', 'data-search' => true, 'onChange' => 'getNextaccount(this.value)', 'prompt' => '-select-'));
        ?>
    </li>
    <li class="col-sm-2">

        <?php
        if ($model->ledger_parent_acc > 0) {
            $parentModel = AccLedger::model()->findByPk($model->ledger_parent_acc);
            if ($parentModel['is_parent'] == 'Y' && $parentModel['ledger_parent_acc'] != '0') {
                $level = $parentModel['level'];
                $level =  ($level * 2) - 1;
                $model->root = substr($parentModel->ledger_acc_no, 0, $level);
            } else {
                $model->root = substr($parentModel->ledger_acc_no, 0, 1);
            }
        }

        echo $form->textfield($model, 'root', array('class' => 'tooltipster', 'data-label' => 'Root A/C No.', 'readonly' => true)); ?>
        <?php echo $form->hiddenfield($model, 'id'); ?>
    </li>
    <li class="col-sm-2">
        <?php
        $prefix_va = 0;
        if ($model->id > 0) {
            $level = (($model->level - 1) * 2) - 1;

            $prefix_va = substr($model->ledger_acc_no, $level, 2);
        }



        echo Chtml::textfield('prefix_va', $prefix_va, array('class' => 'tooltipster', 'data-label' => 'A/C No.', 'maxlength' => 2, 'onKeyup' => 'getaccountnumber(this.value)')); ?>
    </li>
    <li class="col-sm-2">
        <?php echo $form->textfield($model, 'ledger_acc_no', array('class' => 'tooltipster', 'data-label' => 'Ledger A/C No.', 'maxlength' => 10, 'readonly' => true)); ?>
    </li>
    <li class="col-sm-5">
        <?php  // echo $form->dropdownlist($model, 'ledger_acc_name', $fledger->getParentsforacnt(), array('class'=>'tooltipster', 'data-label' => 'Account Name *', 'data-search' => true,  'prompt' => '-select-')); 
        ?>

        <?php echo $form->textfield($model, 'ledger_acc_name', array('class' => 'tooltipster', 'data-label' => 'Account Name *')); ?>
    </li>

    <li class="col-sm-2">
        <?php echo $form->dropdownlist($model, 'is_parent', array('N' => 'No', 'Y' => 'Yes'), array('class' => 'tooltipster', 'data-label' => 'Parent A/C *')); ?>
    </li>
    <li class="col-sm-2" style="display:none">

        <?php
        if ($model->id > 0) {
            echo $form->dropdownlist($model, 'system_generated', array('N' => 'No', 'Y' => 'Yes'), array('class' => 'tooltipster', 'data-label' => 'System Generated *', 'disabled' => true));
            echo $form->hiddenfield($model, 'system_generated');
        } else {
            echo $form->dropdownlist($model, 'system_generated', array('N' => 'No', 'Y' => 'Yes'), array('class' => 'tooltipster', 'data-label' => 'System Generated *'));
        }
        ?>
    </li>
    </li>
    <li class="col-sm-2">
        <?php echo $form->dropdownlist($model, 'have_subledger', array('N' => 'No', 'Y' => 'Yes'), array('class' => 'tooltipster', 'data-label' => 'Sublegder *', 'onChange' => 'if(this.value=="N"){ $("#sledger_type").hide(); }else{ $("#sledger_type").show(); }')); ?>
    </li>
 



    <li class="col-sm-3" style="display:<?php echo ($model->have_subledger != 'N' && $model->subledger_types != '') ? 'block' : 'none'; ?>" id="sledger_type">
        <?php
        $ftype = new AccSubledgerType();
        $sublegertype_ids =  array();
        if ($model->subledger_types != NULL) {
            $sublegertype = explode(",", $model->subledger_types);
            foreach ($sublegertype as $eachValue) {
                $sublegertype_ids[$eachValue] = array('selected' => 'selected');
            }
        }
        ?>
        <?php

        echo $form->dropdownlist($model, 'subledger_types', $ftype->getSublegdertypes(true), array('class' => 'tooltipster', 'data-label' => 'Subledger Types *', 'data-search' => true, 'multiple' => true, 'options' => $sublegertype_ids)); ?>
    </li>


    <li class="col-sm-3">   
        <?php echo $form->dropdownlist($model, 'classification', array( 'NORMAL' => 'Normal', 'VAT' => 'VAT A/C', 'RECEIVABLE' => 'Receivable', 'PAYABLE' => 'Payable', 'CASH' => 'Cash', 'BANK' => 'Bank', 'CHEQUE' => 'Cheque','PRODUCT_SERVICE' => 'Product/Service'), array('class'=>'tooltipster', 'data-label' => 'Classification *')); ?>
    </li>

    <li class="col-sm-3">   
        <?php 
        $modelMasCurrency = new MasCurrency();
        echo $form->dropdownlist($model, 'currency_id', $modelMasCurrency->getCurrency(), array('class'=>'tooltipster', 'data-label' => 'Currency','prompt'=>'Select')); ?>
    </li>

</ul>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="cust_close" data-dismiss="modal">Close</button>
    <?php

    echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('accounts/accounts/saveledger'), array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                            $("#loader").hide();
                            $("#ledger-form .ledger-btn").prop("disabled", false);                      
                            $("#ledger-form .ledger-btn").addClass("btn-theme").removeClass("btn_loding");
                            if(data.status=="success"){  
                                t8.success("Done!");
                                $(".x.close").click();
                                reloadTable("#acc_ledgers");
                            }else{ 
                                $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                                }); 
                            } 
                        }',
        'beforeSend' => 'function(){
                            $("#loader").show();
                               $("#ledger-form .ledger-btn").prop("disabled", true);                      
                               $("#ledger-form .ledger-btn").addClass("btn_loding").removeClass("btn-theme"); 
                        }',
    ), array('id' => 'mybtn' . rand(), 'class' => 'ledger-btn btn btn-theme'));

    ?>
</div>
<?php $this->endWidget(); ?>
<script>
    // $(document).ready(function() { 
    // var acnt  =$('#AccLedger_ledger_acc_no').val();
    // if(acnt > 0)
    // {
    //    var pref = $('#AccLedger_root').val();
    //    if(pref.length == 4) 
    //     {
    //         var res = acnt.substr(4,2);
    //     }
    //     else{
    //      var res = acnt.substr(2,2); 

    //     }
    //     $('#prefix_va').val(res);
    // }
    // });
</script>