<!--
 chart of accounts 
 Ledger List
 date 21-09-2022
 author -Nisha 
 main setup
 Tables - erp_acc_ledger
  -->
<?php

$cs = Yii::app()->getClientScript();
$cs->registerScript(
    "loadledger",
    '$(document).ready(function() {
                    var table_id ="#acc_ledgers";
                    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.parent_account = $("#parent_account").val();
                        data.classification = $("#classification").val();
                        return data;
                    }).DataTable({
                    scrollY         : "450px",
                    pageLength      : 100,
                    ajax: {
                        url: "' . Yii::app()->createUrl('accounts/accounts/getledgers') . '",
                        type: "POST",
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
                    processing: true,
                });
                $(".dataTables_scrollFoot").hide();
            });',
    CClientScript::POS_HEAD
);
/*$cs->registerScript("deleteAccount",  "function deleteAccount(id){
                var r = confirm('Are you sure to delete this?');
                    if(r==true)
                    {
                        jQuery.ajax({
                          'type'  : 'post',
                          'data'  : 'id=' + id,
                          'url'  : $('#liveSite').val()+'index.php?r=accounts/accounts/deleteledger',
                          'cache': false,
                          'success':function(data){
                            if(data=='fail'){
                                alert('Error while Delete', 'Alert');
                            }else {
                                reloadTable('#acc_ledgers');
                                t8.success('Deleted!');
                            }
                           }
                        });
                    }
            };", CClientScript::POS_HEAD);*/


$cs->registerScript("deleteAccount",  "
    function deleteAccount(id) {
        var r = confirm('Are you sure you want to delete this?');
        if (r == true) {
        
         jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/accounts/deleteledger') . "',
                    'cache': false,
                    'success': function(data) {
                 
                       if(data.status=='success'){
                            t8.success('Deleted Success Fully');
                            reloadTable('#acc_ledgers');
                        }else{
                          var errorMessage = '';
                        $.each(data, function(key, val) {
                            errorMessage += val + '\\n'; // Use \\n for line breaks
                            
                        });
                        alert(errorMessage); // Display error messages in a dialog box
                    }
                    
                    },
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
                });
        }
    };
", CClientScript::POS_HEAD);



?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-file"></i> -->
         Ledgers
        <div class="pull-right" style="display:flex;">
            <?php
            $array_classification  = array('NORMAL' => 'Normal', 'VAT' => 'VAT A/C', 'RECEIVABLE' => 'Receivable', 'PAYABLE' => 'Payable', 'CASH' => 'Cash', 'BANK' => 'Bank', 'CHEQUE' => 'Cheque', 'PRODUCT_SERVICE' => 'Product/Service');
            ?>
            <?php echo CHtml::dropdownList('classification', '', $array_classification, array('class' => 'form-control', 'onChange' => 'reloadTable("#acc_ledgers")', 'prompt' => '-Select Classification-'));  ?>

            <?php
            $fledger = new AccLedger();
            ?>
            <?php echo CHtml::dropdownList('parent_account', '', $fledger->getParents(), array('class' => 'form-control', 'onChange' => 'reloadTable("#acc_ledgers")', 'prompt' => '-select-'));  ?>
            <?php if (Yii::app()->user->authorised_user == 1) : ?>
            <?php endif; ?>

            <!--------------------------------------------------------------------->
            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_ledgers_add"])) { ?>
                <a class="ad-btn"  onclick="loadPopupModal('accounts/accounts/createledger','New Ledger','lg')">                 
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
            <!--------------------------------------------------------------------->
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="acc_ledgers" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Account Number</th>
                        <th>Description</th>
                        <th>Subledger</th>
                        <th>Is Parent</th>
                        <th>Group</th>
                        <th>Parent Account</th>
                        <th>Level</th>
                        <th>Actions</th>

                    </tr>
                </thead>
            </table>
        </div>
    </div>

</section>