<?php

/**
 * This is the model class for table "{{acc_voucher_items}}".
 *
 * The followings are the available columns in table '{{acc_voucher_items}}':
 * @property integer $id
 * @property integer $acc_voucher_id
 * @property integer $ledger_id
 * @property integer $subledger_id
 * @property integer $file_id
 * @property string $year
 * @property integer $company_id
 * @property integer $branch_id
 * @property integer $project_id
 * @property integer $salegroup_id
 * @property integer $department_id
 * @property integer $employee_id
 * @property integer $costcenter_id
 * @property integer $inventory_item_type
 * @property integer $product_id
 * @property string $part_number
 * @property string $product_name
 * @property integer $brand_id
 * @property integer $generic_id
 * @property string $quantity
 * @property integer $unit_id
 * @property string $unit_factor
 * @property string $rate
 * @property integer $currency_id
 * @property string $exchange_rate
 * @property string $amount
 * @property string $tax
 * @property string $net_amount
 * @property string $current_cost
 * @property string $last_cost
 * @property string $balance_qty
 * @property string $inventory_value
 * @property string $discount_percentage
 * @property string $discount_amount
 * @property string $rounding
 * @property integer $warehouse_id
 * @property string $foc
 * @property string $narration
 * @property string $credit
 * @property string $debit
 * @property integer $checked
 * @property integer $payment_term_id
 * @property string $allocate_ids
 * @property string $allocated_amount
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 *@property string $opening_cheque_cleared
 * @property string $cheque_bounced
 * @property string $reconciled
 * @property string $reconciled_date
 */
class AccVoucherItems extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public $user_id;
   
     
    public function tableName()
    {
        return '{{acc_voucher_items}}';
    }
    public $ledger_name;
	public $subledger_name;
    public $product_name;
    public $reference_no;
   
    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
    array('acc_voucher_id,ledger_id', 'required'),
    array('acc_voucher_id, ledger_id,outlet_id,warehouse_id, subledger_id, file_id, company_id, branch_id, project_id, salegroup_id, department_id, employee_id, costcenter_id, inventory_item_type, product_id, brand_id, generic_id, unit_id, currency_id, checked, payment_term_id, created_by,no_bounced,updated_by', 'numerical', 'integerOnly'=>true),
            array('year', 'length', 'max'=>4),
            array('part_number, product_name, foc, allocate_ids', 'length', 'max'=>255),
            array('quantity, rate, amount, tax, net_amount, current_cost, last_cost, balance_qty, inventory_value, discount_amount, rounding, credit, debit, allocated_amount', 'length', 'max'=>15),
            array('unit_factor, exchange_rate', 'length', 'max'=>10),
            array('discount_percentage', 'length', 'max'=>50),
            array('opening_cheque_cleared, cheque_bounced, reconciled', 'length', 'max' => 1),

            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, acc_voucher_id,outlet_id,ledger_id, subledger_id, file_id,no_bounced,reconciled_date,opening_cheque_cleared, cheque_bounced,reconciled,year, company_id, branch_id, project_id, salegroup_id, department_id, employee_id, costcenter_id, inventory_item_type, product_id, part_number, product_name, brand_id, generic_id, quantity, unit_id, unit_factor, rate, currency_id, exchange_rate, amount, tax, net_amount, current_cost, last_cost, balance_qty, inventory_value, discount_percentage, discount_amount, rounding, warehouse_id, foc, narration, credit, debit, checked, payment_term_id, allocate_ids, allocated_amount, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'ledger' => array(self::BELONGS_TO, 'AccLedger', 'ledger_id'),
		//	'warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),

			'subledger' => array(self::BELONGS_TO, 'AccSubledger', 'subledger_id'),
			'parent' => array(self::BELONGS_TO, 'AccVoucher', 'acc_voucher_id'),
           'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            // 'product' => array(self::BELONGS_TO, 'MasService', 'product_id'),
            // 'brand' => array(self::BELONGS_TO, 'ProductClass', 'brand_id'),
            'brand' => array(self::BELONGS_TO, 'MasInvBrand', 'brand_id'),
            'category' => array(self::BELONGS_TO, 'MasGeneric', 'generic_id'),
            //'costcenter' => array(self::BELONGS_TO, 'MasCostCenter', 'costcenter_id'),
            'outlet' => array(self::BELONGS_TO, 'MasOutlet', 'outlet_id'),
             'warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
            'costcenter' => array(self::BELONGS_TO, 'MasProjectClassification', 'costcenter_id'),
            'contract' => array(self::BELONGS_TO, 'FmPlannedMaintenance', 'contract_id'),
            'department' => array(self::BELONGS_TO, 'MasDepartment', 'department_id'),
            'paymentmode' => array(self::BELONGS_TO, 'AccPaymentMode', 'payment_mode_id'),
		);
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'acc_voucher_id' => 'Acc Voucher',
            'ledger_id' => 'Ledger',
            'subledger_id' => 'Subledger',
            'file_id' => 'File',
            'year' => 'Year',
            'company_id' => 'Company',
            'acc_voucher_id' => 'Acc Voucher',
            'outlet_id' => 'Outlet',
            'project_id' => 'Project',
            'salegroup_id' => 'Salegroup',
            'department_id' => 'Department',
            'employee_id' => 'Employee',
            'costcenter_id' => 'Cost center',
            'inventory_item_type' => '1 - stock item, 2- service item, 3- raw material, 4 - Machinery',
            'product_id' => 'Product',
            'part_number' => 'Part Number',
            'product_name' => 'Product Name',
            'brand_id' => 'Brand',
            'generic_id' => 'Generic',
            'quantity' => 'Quantity',
            'unit_id' => 'Unit',
            'unit_factor' => 'Unit Factor',
            'rate' => 'Rate',
            'currency_id' => 'Currency',
            'exchange_rate' => 'Exchange Rate',
            'amount' => 'Amount',
            'tax' => 'Tax',
            'net_amount' => 'Net Amount',
            'current_cost' => 'Current Cost',
            'last_cost' => 'Last Cost',
            'balance_qty' => 'Balance Qty',
            'inventory_value' => 'Inventory Value',
            'discount_percentage' => 'Discount Percentage',
            'discount_amount' => 'Discount Amount',
            'rounding' => 'Rounding',
            'warehouse_id' => 'Warehouse',  
            'foc' => 'Foc',
            'narration' => 'Narration',
            'credit' => 'Credit',
            'debit' => 'Debit',
            'checked' => 'Checked',
            'payment_term_id' => 'Payment Term',
            'allocate_ids' => 'Allocate Ids',
            'allocated_amount' => 'total allocated amount in base cureency',
            'created_by' => 'Created By',
            'created_datetime' => 'Created Datetime',
            'updated_by' => 'Updated By',
            'updated_datetime' => 'Updated Datetime',
               'opening_cheque_cleared' => 'Opening Cheque Cleared',
            'cheque_bounced' => 'Cheque Bounced',
            'reconciled' => 'Reconciled',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('acc_voucher_id',$this->acc_voucher_id);
        $criteria->compare('ledger_id',$this->ledger_id);
        $criteria->compare('subledger_id',$this->subledger_id);
        $criteria->compare('file_id',$this->file_id);
        $criteria->compare('year',$this->year,true);
        $criteria->compare('company_id',$this->company_id);
        $criteria->compare('branch_id',$this->branch_id);
        $criteria->compare('project_id',$this->project_id);
        $criteria->compare('salegroup_id',$this->salegroup_id);
        $criteria->compare('department_id',$this->department_id);
        $criteria->compare('employee_id',$this->employee_id);
        $criteria->compare('costcenter_id',$this->costcenter_id);
        $criteria->compare('inventory_item_type',$this->inventory_item_type);
        $criteria->compare('product_id',$this->product_id);
        $criteria->compare('part_number',$this->part_number,true);
        $criteria->compare('product_name',$this->product_name,true);
        $criteria->compare('brand_id',$this->brand_id);
        $criteria->compare('generic_id',$this->generic_id);
        $criteria->compare('quantity',$this->quantity,true);
        $criteria->compare('unit_id',$this->unit_id);
        $criteria->compare('unit_factor',$this->unit_factor,true);
        $criteria->compare('rate',$this->rate,true);
        $criteria->compare('currency_id',$this->currency_id);
        $criteria->compare('exchange_rate',$this->exchange_rate,true);
        $criteria->compare('amount',$this->amount,true);
        $criteria->compare('tax',$this->tax,true);
                $criteria->compare('no_bounced', $this->no_bounced);

        $criteria->compare('net_amount',$this->net_amount,true);
        $criteria->compare('current_cost',$this->current_cost,true);
        $criteria->compare('last_cost',$this->last_cost,true);
        $criteria->compare('balance_qty',$this->balance_qty,true);
        $criteria->compare('inventory_value',$this->inventory_value,true);
        $criteria->compare('discount_percentage',$this->discount_percentage,true);
        $criteria->compare('discount_amount',$this->discount_amount,true);
        $criteria->compare('rounding',$this->rounding,true);
        $criteria->compare('warehouse_id',$this->warehouse_id);
        $criteria->compare('foc',$this->foc,true);
        $criteria->compare('narration',$this->narration,true);
        $criteria->compare('credit',$this->credit,true);
        $criteria->compare('debit',$this->debit,true);
        $criteria->compare('checked',$this->checked);
        $criteria->compare('payment_term_id',$this->payment_term_id);
        $criteria->compare('allocate_ids',$this->allocate_ids,true);
        $criteria->compare('allocated_amount',$this->allocated_amount,true);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('created_datetime',$this->created_datetime,true);
        $criteria->compare('updated_by',$this->updated_by);
        $criteria->compare('updated_datetime',$this->updated_datetime,true);
         $criteria->compare('opening_cheque_cleared', $this->opening_cheque_cleared, true);
        $criteria->compare('cheque_bounced', $this->cheque_bounced, true);
        $criteria->compare('reconciled', $this->reconciled, true);
        $criteria->compare('reconciled_date', $this->reconciled_date, true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccVoucherItems the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    
     public static function no_of_subledger_entries($id=0){
		$count = self::model()->count(array('condition' => 'subledger_id='.$id));
		return (int) $count;
	}
}