<?php
/* Subledgers Type
 
 date 21-09-2022
 author -Indhu 
 main setup
 Tables - acc_subledger_type
 Controller - SubledgertypeController */

/**

 * This is the model class for table "{{acc_subledger_type}}".

 *

 * The followings are the available columns in table '{{acc_subledger_type}}':

 * @property integer $id
 * @property string $description
 * @property string $is_editable
 * @property string $start_serial
 * @property string $last_serial
 * @property string $system_generated
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */

class AccSubledgerType extends CActiveRecord
{

	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{acc_subledger_type}}';
	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('description,start_serial', 'required'),
			array('start_serial', 'unique'),
			array('created_by, updated_by', 'numerical', 'integerOnly' => true),
			array('description', 'length', 'max' => 200),
			array('is_editable, system_generated', 'length', 'max' => 1),
			array('start_serial, last_serial', 'length', 'max' => 20),
			// The following rule is used by search().

			// @todo Please remove those attributes that should not be searched.

			array('id, description, is_editable, start_serial, last_serial, system_generated, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on' => 'search'),

		);
	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array();
	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id' => 'ID',
			'description' => 'Description',
			'is_editable' => 'Is Editable',
			'start_serial' => 'Start Serial',
			'last_serial' => 'Last Serial',
			'system_generated' => 'System Generated',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
		);
	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 *

	 * Typical usecase:

	 * - Initialize the model fields with values from filter form.

	 * - Execute this method to get CActiveDataProvider instance which will filter

	 * models according to data in model fields.

	 * - Pass data provider to CGridView, CListView or any similar widget.

	 *

	 * @return CActiveDataProvider the data provider that can return the models

	 * based on the search/filter conditions.

	 */

	public function search()

	{

		// @todo Please modify the following code to remove attributes that should not be searched.



		$criteria = new CDbCriteria;



		$criteria->compare('id', $this->id);
		$criteria->compare('description', $this->description, true);
		$criteria->compare('is_editable', $this->is_editable, true);
		$criteria->compare('start_serial', $this->start_serial, true);
		$criteria->compare('last_serial', $this->last_serial, true);
		$criteria->compare('system_generated', $this->system_generated, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_datetime', $this->created_datetime, true);
		$criteria->compare('updated_by', $this->updated_by);
		$criteria->compare('updated_datetime', $this->updated_datetime, true);


		return new CActiveDataProvider($this, array(

			'criteria' => $criteria,

		));
	}



	/**

	 * Returns the static model of the specified AR class.

	 * Please note that you should have this exact method in all your CActiveRecord descendants!

	 * @param string $className active record class name.

	 * @return AccSubledgerType the static model class

	 */

	public static function model($className = __CLASS__)

	{
		return parent::model($className);
	}

	public static function getSublegdertypes()
	{
		$condition = '1=1';
		$model = self::model()->findAll(array('condition' => $condition, 'order' => 'description'));
		return CHtml::listData($model, 'id', 'description');
	}


	public static function getSublegdertypesCode()
	{
		$condition = '1=1';
		$model = self::model()->findAll(array('condition' => $condition, 'order' => 'description'));
		return CHtml::listData($model, 'type', 'description');
	}


	/******
	 * ---------------jisha ---- 14/11/2022
	----get subledger type id from type---
	*********/
	public static function getIdFromType($type)
	{
		$condition = 'type="'.$type.'"';
		$model = self::model()->find(array('condition' => $condition, 'order' => 'id desc'));
		return (int)$model->id;
	}

	
}
