<?php


/**

 * This is the model class for table "{{acc_ledger}}".

 *

 * The followings are the available columns in table '{{acc_ledger}}':

 * @property integer $id
 * @property integer $currency_id
 * @property string $ledger_acc_no
 * @property string $ledger_acc_name
 * @property string $ledger_acc_type
 * @property string $ledger_main_acc
 * @property string $ledger_parent_acc
 * @property string $root
 * @property integer $level
 * @property string $is_parent
 * @property string $have_subledger
 * @property string $subledger_types
 * @property string $system_generated
 * @property string $is_editable
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */

class AccLedger extends CActiveRecord
{

  const InventoryLedger           = 132;
  const OpeningClosingStockLedger = 240;
  const SalesLedger               = 229;
  const DebtorsLedger             = 136;
  const VATonSalesLedger          = 348;
  const SalesDiscountLedger       = 231;
  const RoundOffLedger            = 349;

	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{acc_ledger}}';
	}

 

	/**

	 * @return array validation rules for model attributes.

	 */
	public $credit;
	public $debit;
	public $balance;
	public $balanceactual;
	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('ledger_acc_no,system_generated,ledger_acc_name, ledger_parent_acc, root, level, is_parent, have_subledger,classification', 'required'),
			array('level,currency_id,created_by, updated_by', 'numerical', 'integerOnly' => true),
			array('ledger_acc_no, ledger_parent_acc, root', 'length', 'max' => 20),
			array('ledger_acc_name, subledger_types', 'length', 'max' => 200),
			array('ledger_acc_no', 'unique'),
			array('subledger_types', 'required', 'on' => 'havesublegder'),
			array('ledger_acc_type, ledger_main_acc, is_parent, have_subledger, system_generated, is_editable', 'length', 'max' => 1),
			// The following rule is used by search().

			// @todo Please remove those attributes that should not be searched.

			array('id,currency_id,ledger_acc_no,classification,ledger_acc_name, ledger_acc_type, ledger_main_acc, ledger_parent_acc, root, level, is_parent, have_subledger, subledger_types, system_generated, is_editable, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on' => 'search'),

		);
	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array();
	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'id' => 'ID',
			'ledger_acc_no' => 'Ledger Acc No',
			'ledger_acc_name' => 'Ledger Acc Name',
			'ledger_acc_type' => 'Ledger Acc Type',
			'ledger_main_acc' => 'Ledger Main Acc',
			'ledger_parent_acc' => 'Ledger Parent Acc',
			'root' => 'Root',
			'level' => 'Level',
			'is_parent' => 'Is Parent',
			'have_subledger' => 'Have Subledger',
			'subledger_types' => 'Subledger Types',
			'system_generated' => 'System Generated',
			'is_editable' => 'Is Editable',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
		);
	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 *

	 * Typical usecase:

	 * - Initialize the model fields with values from filter form.

	 * - Execute this method to get CActiveDataProvider instance which will filter

	 * models according to data in model fields.

	 * - Pass data provider to CGridView, CListView or any similar widget.

	 *

	 * @return CActiveDataProvider the data provider that can return the models

	 * based on the search/filter conditions.

	 */

	public function search()

	{

		// @todo Please modify the following code to remove attributes that should not be searched.



		$criteria = new CDbCriteria;



		$criteria->compare('id', $this->id);
		$criteria->compare('ledger_acc_no', $this->ledger_acc_no, true);
		$criteria->compare('ledger_acc_name', $this->ledger_acc_name, true);
		$criteria->compare('ledger_acc_type', $this->ledger_acc_type, true);
		$criteria->compare('ledger_main_acc', $this->ledger_main_acc, true);
		$criteria->compare('ledger_parent_acc', $this->ledger_parent_acc, true);
		$criteria->compare('root', $this->root, true);
		$criteria->compare('level', $this->level);
		$criteria->compare('is_parent', $this->is_parent, true);
		$criteria->compare('have_subledger', $this->have_subledger, true);
		$criteria->compare('subledger_types', $this->subledger_types, true);
		$criteria->compare('system_generated', $this->system_generated, true);
		$criteria->compare('is_editable', $this->is_editable, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('created_datetime', $this->created_datetime, true);
		$criteria->compare('updated_by', $this->updated_by);
		$criteria->compare('updated_datetime', $this->updated_datetime, true);


		return new CActiveDataProvider($this, array(

			'criteria' => $criteria,

		));
	}



	/**

	 * Returns the static model of the specified AR class.

	 * Please note that you should have this exact method in all your CActiveRecord descendants!

	 * @param string $className active record class name.

	 * @return AccLedger the static model class

	 */

	public static function model($className = __CLASS__)

	{

		return parent::model($className);
	}



	public static function getParent($id)
	{
		return ($id > 0) ? self::model()->findBypk($id)->ledger_acc_name : 'N/A';
	}

	public static function getParents()
	{
		return CHtml::listData(self::model()->findAll(array('condition' => 'is_parent="Y"', 'order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');
	}
	public static function getParentsforacnt()
	{
		return CHtml::listData(self::model()->findAll(array('condition' => 'is_parent="Y"', 'order' => 'ledger_acc_name ASC')), 'ledger_acc_name', 'ledger_acc_name');
	}

	public static function getLedgers()
	{
		return CHtml::listData(self::model()->findAll(array('order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');
	}
	public static function setup_levels()
	{
		$parentAccount = self::model()->findAll(array('condition' => 'level=1'));
		foreach ($parentAccount as $each) {
			$haveChild = true;
			$parenIds = $each->id;
			$level = 2;
			while ($haveChild) {
				$count_of_children = 0;
				if ($parenIds != '')
					$count_of_children = self::model()->count(array('condition' => 'ledger_parent_acc IN(' . $parenIds . ')'));
				if ($count_of_children > 0) {
					Yii::app()->db->createCommand('UPDATE {{acc_ledger}} SET level=' . $level . ' WHERE ledger_parent_acc IN(' . $parenIds . ')')->execute();
					$accounIds  = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(id) AS ids FROM {{acc_ledger}} WHERE ledger_parent_acc IN(' . $parenIds . ')')->queryAll();
					$parenIds = $accounIds[0]['ids'];
					$level++;
				} else
					$haveChild = false;
			}
		}
	}
	public static function getChilds()
	{
		return CHtml::listData(self::model()->findAll(array('condition' => 'is_parent="N"', 'order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');
	}
	
	public static function getChildsbyCurrency($currency_id=0)
    {
        return CHtml::listData(self::model()->findAll(array(
            'condition' => 'is_parent="N" AND currency_id = :currency_id',
            'params' => array(':currency_id' => $currency_id),
            'order' => 'ledger_acc_name ASC'
        )), 'id', 'ledger_acc_name');
    }


	public function getFulldescription()
	{
		//	return $this->ledger_acc_name.' ('.$this->ledger_acc_no.') ('.$this->main_account_type.')';
		return $this->ledger_acc_name . ' (' . $this->ledger_acc_no . ') ';
	}

	public function getExpense_accounts()
	{
		//	return CHtml::listData(self::model()->findAll( array( 'condition' => 'is_parent="N" AND main_account_type="E"', 'order' => 'ledger_acc_name ASC' ) ), 'id', 'Fulldescription');
		return CHtml::listData(self::model()->findAll(array('condition' => 'is_parent="N" ', 'order' => 'ledger_acc_name ASC')), 'id', 'Fulldescription');
	}

	public static function baseCurrency_id()
	{
		return MasCurrency::model()->find(array('condition' => 'default_usage="Y"'))->id;
	}

	public function baseCurrencycode()
	{
		return MasCurrency::model()->find(array('condition' => 'default_usage="Y"'))->currency_code;
	}
	
	public function baseCurrencyexchange()
	{
		return MasCurrency::model()->find(array('condition' => 'default_usage="Y"'))->exchange_rate;
	}
	
	
	public static function getAllocatable()
	{
		$debtor = AccSystemAccountsMapping::getSystemdefault('debtors'); //debtors
		$creditor = AccSystemAccountsMapping::getSystemdefault('creditors'); //creditors
		return CHtml::listData(self::model()->findAll(array('condition' => 'id IN (' . $debtor . ', ' . $creditor . ')', 'order' => 'ledger_acc_name ASC')), 'id', 'Fulldescription');
	}

	public static function getBankId()
	{
		return self::model()->find(array('condition' => 'is_parent="N" AND classification IN ("BANK")', 'order' => 'ledger_acc_name ASC'))->id;
	}
	
	  public static function getChildswithaccno(){
        $models = self::model()->findAll(array(
            'condition' => 'is_parent="N"',
            'order' => 'ledger_acc_name ASC'
        ));
    
        $data = array();
        foreach ($models as $model) {
            $data[$model->id] = $model->ledger_acc_no . ' - ' . $model->ledger_acc_name;
        }
    
        return $data;
    }
    
        public static function getBankIdlist(){
		 return CHtml::listData(self::model()->findAll( array( 'condition' => 'is_parent="N" AND classification IN ("BANK")', 'order' => 'ledger_acc_name ASC' ) ), 'id', 'ledger_acc_name');
	}
	
		public static function getReceivableChilds()
	{
		return CHtml::listData(self::model()->findAll(array('condition' => 'is_parent="N" AND classification="RECEIVABLE"', 'order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');
	}
	public static function getPayableChilds()
	{
		return CHtml::listData(self::model()->findAll(array('condition' => 'is_parent="N" AND classification="PAYABLE"', 'order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');
	}
	
		public static function getProductChilds()
	{
		return CHtml::listData(self::model()->findAll(array('condition' => 'is_parent="N" AND classification="PRODUCT_SERVICE"', 'order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');
	}
	
}
