<?php

/**
 * This is the model class for table "{{acc_general_settings}}".
 *
 * The followings are the available columns in table '{{acc_general_settings}}':
 * @property integer $id
 * @property string $tax_type
 * @property string $have_sales_receipt
 * @property string $allow_multiple_voucher
 * @property string $allow_multi_receipt
 * @property string $allow_deliverynote
 * @property string $costcenter_1
 * @property string $costcenter_2
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class AccGeneralSettings extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{acc_general_settings}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('costcenter_1, costcenter_2, updated_by, updated_date_time', 'required'),
			array('updated_by', 'numerical', 'integerOnly'=>true),
			array('tax_type', 'length', 'max'=>3),
			array('have_sales_receipt, allow_multiple_voucher, allow_multi_receipt, allow_deliverynote', 'length', 'max'=>1),
			array('costcenter_1, costcenter_2', 'length', 'max'=>10),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, tax_type, have_sales_receipt, allow_multiple_voucher, allow_multi_receipt, allow_deliverynote, costcenter_1, costcenter_2, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'tax_type' => 'IN-inside india,OUT-outside INDIA',
			'have_sales_receipt' => 'Have Sales Receipt',
			'allow_multiple_voucher' => 'Allow Multiple Voucher',
			'allow_multi_receipt' => 'Allow Multi Receipt',
			'allow_deliverynote' => 'Allow Deliverynote',
			'costcenter_1' => 'Costcenter 1',
			'costcenter_2' => 'Costcenter 2',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tax_type',$this->tax_type,true);
		$criteria->compare('have_sales_receipt',$this->have_sales_receipt,true);
		$criteria->compare('allow_multiple_voucher',$this->allow_multiple_voucher,true);
		$criteria->compare('allow_multi_receipt',$this->allow_multi_receipt,true);
		$criteria->compare('allow_deliverynote',$this->allow_deliverynote,true);
		$criteria->compare('costcenter_1',$this->costcenter_1,true);
		$criteria->compare('costcenter_2',$this->costcenter_2,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AccGeneralSettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
