<?php

/*
 chart of accounts
 Voucher Type, Save
 date 21-09-2022
 author -Indhu
 main setup

 Tables    - acc_voucher_type,acc_voucher_type_details- 
 models used   - AccVoucherType,AccVoucherTypeDetails

 */


class VouchertypesController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'RemoveAccVoucherTypeDetails', 'GetMappingAttribute'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


    // public $modelMasCurrency;

    // public function init()
    // {
    //     parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }

    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_voucher_types_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_voucher_types_menu_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
		}
    public function actionGetList()
    {
        $model  = new AccVoucherType();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.code',
            2 => 't.description',
            3 => 't.last_number',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    = 't.description LIKE "%' . $searchString . '%" OR t.code LIKE "%' . $searchString . '%"';
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {
            $div      = '<div class="btn-wrap text-center">';
            if ($eachItem['is_system'] == 'N') {
                // -----------------------------------------------------------------
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_voucher_types_edit"])) {

                    $div .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/vouchertypes/Create&id=' . $eachItem['id'] . '\',\'Edit Voucher Types \',\'xl\')"><i class="fa fa-edit"></i></a>';
                }
                // -----------------------------------------------------------------
            }
            $div     .= '</div>';
            $eachItemData[] = array($eachItem['code'], $eachItem['description'], $eachItem['start_number'], $eachItem['last_number'], $div, $eachItem['is_active'],);
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new AccVoucherType();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model     = $model->findBypk($id);
            $condition = ' voucher_type_id=' . $id;
            $modelAccVoucherTypeDetails     = AccVoucherTypeDetails::model()->findAll(array('condition' => $condition));
            if (empty($modelAccVoucherTypeDetails)) {
                $modelAccVoucherTypeDetails = array(new AccVoucherTypeDetails());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'modelAccVoucherTypeDetails' => $modelAccVoucherTypeDetails));
    }



    public function actionSave()
    {
        $model = new AccVoucherType();
        $validate = true;
        if (isset($_POST['AccVoucherType'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['AccVoucherType']['id'] > 0) {
                $model->updated_by       = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['AccVoucherType']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes        = $_POST['AccVoucherType'];
            $model->pv_rv_pdf         = $_POST['AccVoucherType']['pv_rv_pdf'];
            $model->code              = trim($_POST['AccVoucherType']['code']);
            $model->show_voucher_type = $_POST['AccVoucherType']['show_voucher_type'];
            $model->is_active = $_POST['AccVoucherType']['is_active'];

            $model->is_system         = 'N';
            $validate                 = $model->validate();
            // ------------------------
            $modelVoucherTypeDet = [];


            if (is_array($_POST['AccVoucherTypeDetails'])) {
                foreach ($_POST['AccVoucherTypeDetails'] as $i => $item) {
                    $modelVoucherTypeDet[$i] = new AccVoucherTypeDetails();
                    if (!empty($item['id'])) {
                        // $modelVoucherTypeDet[$i]                   = $modelVoucherTypeDet[$i]->findByPk($item['id']);
                        $modelVoucherTypeDet[$i]->updated_by       = Yii::app()->user->id;
                        $modelVoucherTypeDet[$i]->updated_datetime = date('Y-m-d h:i:s');
                    } else {
                        $modelVoucherTypeDet[$i]->created_by       = Yii::app()->user->id;
                        $modelVoucherTypeDet[$i]->created_datetime = date('Y-m-d h:i:s');
                    }

                    $modelVoucherTypeDet[$i]->voucher_type_id = 0;
                    $modelVoucherTypeDet[$i]->ledger_id       = $item['ledger_id'];
                    $modelVoucherTypeDet[$i]->subledger_id    = $item['subledger_id'];
                    $modelVoucherTypeDet[$i]->default_type    = $item['default_type'];
                    $modelVoucherTypeDet[$i]->narration       = $item['narration'];
                    $modelVoucherTypeDet[$i]->attribute       = $item['attribute'];
                    $modelVoucherTypeDet[$i]->subledger_type  = $item['subledger_type'];
                    $validate                                 = $validate && $modelVoucherTypeDet[$i]->validate();
                }
            }

            if ($validate) {
                $model->save();
                AccVoucherTypeDetails::model()->deleteAll('voucher_type_id=:refer_id', array(':refer_id' => $model->id));

                foreach ($modelVoucherTypeDet as $eachModel) {
                    $eachModel->voucher_type_id   = $model->id;
                    $eachModel->voucher_type_code = $model->code;
                    $eachModel->save(false);
                }
                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "voucher type {$model->description}"
                );
                // end audit log

                $jsonData['status'] = 'success';
                $jsonData['id']     = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($modelVoucherTypeDet, '', false), true);
                $error  = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }


    public function actionRemoveAccVoucherTypeDetails()
    {
        //to remove each voucher type details
        $id = $_POST['id'];
        if ($id > 0) {
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionGetMappingAttribute()
    {
        //pass from voucher type create page //to find a ledger of a selected attribute
        $attribute = Yii::app()->request->getParam('attribute');
        $sql = "SELECT map.account_id AS ledger_id FROM {{acc_system_accounts_mapping}}  map WHERE map.attribute LIKE '" . trim($attribute) . "%'";
        $ledger_id          = (int)Yii::app()->db->createCommand($sql)->queryscalar();
        $condition          = 't.id= ' . $ledger_id;
        $modelAccLedger     = new AccLedger();
        $modelAccLedger_det = $modelAccLedger->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
        $data['value']      = $modelAccLedger_det[0]['id'];
        $data['label']      =  $modelAccLedger_det[0]['ledger_acc_name'] . ' : ' . $modelAccLedger_det[0]['ledger_acc_no'];
        echo CJSON::encode($data);
        Yii::app()->end();
    }
}
