<?php


/* 
Voucher master setting
 date 21-09-2022
 author -Indhu 
 main setup
 Tables - acc_voucher_master_setting
 model - AccVoucherMasterSetting 
 */

 

class VouchermastersettingController extends Controller
{
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetList()
    {
        $model = new AccVoucherMasterSetting();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
                2 => 't.serial_no',
            3 => 'vouchertype_det.description',
            4 => 'ledger_det.ledger_acc_name',
            5 => 'subledger_det.subledger_name',
            6 => 't.debit',
            7 => 't.credit',
            8 => 't.narration',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
       
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = 'vouchertype_det.description LIKE "%' . $searchString . '%" 
            OR ledger_det.ledger_acc_name LIKE "%' . $searchString . '%"';
        }

        $count = $model->with('vouchertype_det', 'ledger_det', 'subledger_det')->count(array('condition' => $condition));
        $model = $model->with('vouchertype_det', 'ledger_det', 'subledger_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {

            if($eachItem['debit']=='N'){
                $debit = "No";
            }else if($eachItem['debit']=='Y'){
                $debit = "Yes";
            }else{
                $debit = "_";
            }

            if($eachItem['credit']=='N'){
                $credit = "No";
            }else if($eachItem['credit']=='Y'){
                $credit = "Yes";
            }else{
                $credit = "_";
            }

            $div = '<div class="btn-wrap text-center">';


            $div .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/vouchermastersetting/Create&id=' . $eachItem['id'] . '\',\'Edit Voucher Master Setting \',\'lg\')"><i class="fa fa-edit"></i></a>';

            $div .= '</div>';
            $eachItemData[] = array($m,
              $eachItem['serial_no'],
                $eachItem->vouchertype_det->description,
                $eachItem->ledger_det->ledger_acc_name,
                $eachItem->subledger_det->subledger_name,
                $debit,
                $credit,
                $eachItem['narration'],
                $div);
            $m++;

        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new AccVoucherMasterSetting();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findBypk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model));
    }


    public function actionSave()
    {

        $model = new AccVoucherMasterSetting();
        if (isset($_POST['AccVoucherMasterSetting'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int)@$_POST['AccVoucherMasterSetting']['id'] > 0) {

                $id = (int)@$_POST['AccVoucherMasterSetting']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');

            }
            $model->attributes = $_POST['AccVoucherMasterSetting'];
            $model->narration = $_POST['AccVoucherMasterSetting']['narration'];


            if ($model->save()) {
                echo json_encode(array('status' => 'success'));
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                echo CJSON::encode(array_merge_recursive($error1));

            }
        }

    }

}