<?php



/* chart of accounts 

 trial balance report

date 03-10-2022

author -Indhu 

main setup */





class ReportsController extends Controller

{



  public function accessRules()

  {

    return array(

      array(

        'allow', // allow all users to perform 'index' and 'view' actions

        'actions' => array('login', 'error', 'logout'),

        'users' => array('*'),

      ),

      array(

        'allow', // allow authenticated user to perform 'create' and 'update' actions

        'actions' => array(

          'TrialBalance',

          'Trial_balance_html',

          'TrialBalanceDetailed',

          'Trial_balance_detailed_html',

          'Trial_balance_Excel_ledgerwise',

          'Gl_summary_tab_html',

          'ProfitandLoss',

          'Profit_loss_html',

          'Profit_loss_html_new',
          'Balance_sheet_dashboard', 'Profit_loss_dashboard',
          'Balance',

          'Balance_html',

          'BalanceAcNew',

          'BalanceAcNew_html',

          'Balancenew',

          'Balance_new_html',

          'GeneralLedger',

          'GeneralLedgerNew',

          'Gl_html',

          'Gl_html_new',

          'Gl_report_Excel',

          'GeneralLedgerDetailed',

          'Gl_detailed_html',

          'StatementReport',

          'Statement_html',

          'ConsolidatedStatementreport',

          'ConsolidatedStatement_html',

          'AgingReport',

          'Aging_html',

          'Aging_vouchers_html',

          'SubledgerDetailReport',

          'Subledger_detail_report_html',

          'VatReport',

          'Vat_report_html',

          'Vat_detailed_report_html',

          'vat_report_pdf',

          'vat_report_Excel',

          'Gl_summary_report',

          'Gl_summary_html',

          'Gl_Detailed_sales_onvat_tab_html',

          'vat_Detailed_vat_on_other_income_tab_html',

          'vat_detailed_vat_on_expense_tab_html',

          'vat_detailed_vat_purchase_tab_html',

          'StatementReport_as_on_Date',

          'gl_report_displaychild',

          'Gl_summary_tab_excel',

          'ProfitandLossdetailed',

          'Profit_loss_detailed_html',

          'Balancedetailed',

          'Balance_detailed_html',

          'BalancedetailedNew',

          'Balance_detailed_html_new',

          'Vat_summary_report',

          'Vat_summary_html',

          'VatRegister',

          'Vat_register_html',

          'vat_register_pdf',

          'Vat_register_vat_on_sales_html',

          'Gl_summary_subledger_html_tab',

          'Load_monthlybreakup_sales_report',

          'Load_monthlybreakup_purchase_report',

          'Load_total_expense_report',

          'Load_total_income_report',

          'statement_as_on_html',

          'SatementPdcReport',

          'Statement_pdc_html',

          'Auditclosedetailed',

          'Auditclose_detailed_html',

          'LedgerReport',

          'Ledger_report_html',

          'GetAuditcloseDate',

          'GetAuditcloseDateRange'

        ),

        'expression' => '$user->isMember()',

      ),

      array(

        'deny', // deny all users

        'users' => array('*'),

      ),

    );

  }





  // --------------------------TrialBalance----Report----------------------------------------





  // public $modelMasCurrency;



  // public function init()

  // {

  //   parent::init();

  //   $this->modelMasCurrency = new MasCurrency();

  // }





  public function actionTrialBalance()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_trialbalance_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_trialbalance_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('trial_balance', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}



  public function actionTrial_balance_html()

  {

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $gl_auditclose_id       = $_POST['gl_auditclose_id'];

    $type                  = $_POST['type'];

    $rep_type              = $_POST['rep_type'];

    $acc_report_brand      =  (int) $_POST['acc_report_brand'];

    $department_id         =  (int) $_POST['acc_department_id'];

    $outlet_id             =  (int) $_POST['acc_outlet_id'];

    $warehouse_id          =  (int) $_POST['acc_warehouse_id'];



    $view_tb = 'trial_balance_html';

    if ($rep_type == '2') {

        $view_tb = 'trial_balance_with_opening_closing_html';

    } else if ($rep_type == '3') {

        $view_tb = 'trial_balance_with_auditclose_opening_closing_html';

    }

    

    $trialBalanceDetails = AccAccount::model()->getTrialBalanceDetails($from_date, $to_date, $level, $gl_auditclose_id);


    $this->renderPartial($view_tb, array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'gl_auditclose_id'  => $gl_auditclose_id,

      'level'       => $level,

      'type'         => $type,

      'brand'       => $acc_report_brand,

      'outlet_id'    => $outlet_id,

      'department_id' => $department_id,

      'warehouse_id' => $warehouse_id,

      'trialBalanceDetails' => $trialBalanceDetails

    ));

  }

  

public function actionTrialBalanceDetailed()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_trialbalance_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_trialbalance_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('trial_balance_detailed', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}





public function actionTrial_balance_detailed_html()

{

    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                  = $_POST['level'];

    $gl_auditclose_id       = $_POST['gl_auditclose_id'];

    $type                   = $_POST['type'];

    $rep_type               = $_POST['rep_type'];

    $acc_report_brand       = (int) $_POST['acc_report_brand'];

    $department_id          = (int) $_POST['acc_department_id'];

    $outlet_id              = (int) $_POST['acc_outlet_id'];

    $warehouse_id           = (int) $_POST['acc_warehouse_id'];

    

    $trialBalanceDetailedDetails = AccAccount::model()->getTrialBalanceDetailedDetails($from_date, $to_date, $level, $gl_auditclose_id);

    $view_tb = 'trial_balance_detailed_with_opening_closing_html';

   /*$view_tb = 'trial_balance_detailed_html';

    if ($rep_type == '2') {

        $view_tb = 'trial_balance_detailed_with_opening_closing_html';

    } else if ($rep_type == '3') {

       // $view_tb = 'trial_balance_detailed_with_auditclose_opening_closing_html';

    }*/

    $this->renderPartial($view_tb, array(

        'from_date'         => $from_date,

        'to_date'           => $to_date,

        'gl_auditclose_id'  => $gl_auditclose_id,

        'level'             => $level,

        'type'              => $type,

        'brand'             => $acc_report_brand,

        'outlet_id'         => $outlet_id,

        'department_id'     => $department_id,

        'warehouse_id'      => $warehouse_id,

        'trialBalanceDetailedDetails' => $trialBalanceDetailedDetails

    ));

}



  // --------------------------ProfitandLoss----Report----------------------------------------



 public function actionProfitandLoss()

{

   if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_profitloss_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_profitloss_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('profit_loss', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}







  public function actionProfit_loss_html()

  {



    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $type                  = $_POST['type'];

    $rep_type              = $_POST['rep_type'];

    $acc_report_brand      =  (int) $_POST['acc_report_brand'];

    $department_id         =  (int) $_POST['acc_department_id'];

    $outlet_id             =  (int) $_POST['acc_outlet_id'];

    $warehouse_id          =  (int) $_POST['acc_warehouse_id'];



    $view_pl = 'profit_loss_html';



    $this->renderPartial($view_pl, array(

      'from_date'     => $from_date,

      'to_date'       => $to_date,

      'level'         => $level,

      'type'          => $type,

      'brand'         => $acc_report_brand,

      'outlet_id'     => $outlet_id,

      'department_id' => $department_id,

      'warehouse_id'  => $warehouse_id,



    ));

  }



  public function actionProfit_loss_html_new()

  {

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $gl_auditclose_id       = $_POST['gl_auditclose_id'];

    $acc_report_year       = $_POST['acc_report_year'];

    $acc_report_company    = $_POST['acc_report_company'];

    $acc_report_branch     = $_POST['acc_report_branch'];

    $acc_report_salesgroup = $_POST['acc_report_salesgroup'];

    $acc_report_brand      = $_POST['acc_report_brand'];

    $acc_report_employee   = $_POST['acc_report_employee'];

    $acc_report_costcenter = $_POST['acc_report_costcenter'];

    $acc_report_cate       = $_POST['acc_report_cate'];

    $acc_report_project    = $_POST['acc_report_project'];

    $acc_report_item       = $_POST['acc_report_item'];

    $type          = $_POST['type'];

    $warehouse_id          = $_POST['acc_warehouse_id'];

    $outlet_id             = $_POST['acc_outlet_id'];

    $department_id             = $_POST['acc_department_id'];





    $this->renderPartial('profit_loss_html_new', array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'level'       => $level,

      'gl_auditclose_id'  => $gl_auditclose_id,

      'year'        => $acc_report_year,

      'company'     => $acc_report_company,

      'branch'      => $acc_report_branch,

      'salesgroup'  => $acc_report_salesgroup,

      'brand'       => $acc_report_brand,

      'employee'    => $acc_report_employee,

      'costcenter'  => $acc_report_costcenter,

      'category'    => $acc_report_cate,

      'project'     => $acc_report_project,

      'item'        => $acc_report_item,

      'type'        => $type,

      'warehouse_id' => $warehouse_id,

      'outlet_id'        => $outlet_id,

      'department_id'        => $department_id,



    ));

  }

  // --------------------------Balance----Report----------------------------------------





  public function actionBalance()

  {

    $this->render('balance_report');

  }





  public function actionBalance_html()

  {



    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $type                  = $_POST['type'];

    $rep_type              = $_POST['rep_type'];

    $acc_report_brand      =  (int) $_POST['acc_report_brand'];

    $department_id         =  (int) $_POST['acc_department_id'];

    $outlet_id             =  (int) $_POST['acc_outlet_id'];

    $warehouse_id          =  (int) $_POST['acc_warehouse_id'];

    $view_bl = 'balance_report_html';

    if ($rep_type == 2) {

      $view_bl = 'balance_sheet_html_new';

    }



    $this->renderPartial($view_bl, array(

      'from_date'     => $from_date,

      'to_date'       => $to_date,

      'level'         => $level,

      'type'          => $type,

      'brand'         => $acc_report_brand,

      'outlet_id'     => $outlet_id,

      'department_id' => $department_id,

      'warehouse_id'  => $warehouse_id,



    ));

  }

  

  public function actionGetAuditcloseDate (){

        $gl_auditclose_id = $_POST['auditclose_id'];

        $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);

        echo date("d/m/Y", strtotime("+1 day", strtotime($auditclose->close_date)));

  }

  

  public function actionGetAuditcloseDateRange (){

        $gl_auditclose_id = $_POST['auditclose_id'];

        $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);

        $auditclosePreCloseDate = Yii::app()->db->createCommand("SELECT close_date FROM {{acc_audit_close}} WHERE id != $gl_auditclose_id AND id < $gl_auditclose_id ORDER BY id DESC LIMIT 1")->queryScalar();

        $auditclosePreCloseDate = $auditclosePreCloseDate?date("d/m/Y", strtotime("+1 day", strtotime($auditclosePreCloseDate))):date('d/m/2020');

        $auditcloseDate = date("d/m/Y", strtotime($auditclose->close_date));

        echo json_encode(array('auditcloseFromDate' => $auditclosePreCloseDate, 'auditcloseToDate' =>$auditcloseDate));

  }

  

 public function actionBalanceAcNew()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_balance_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_balance_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('balance_report_ac_new', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}







  public function actionBalanceAcNew_html()

  {



    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $gl_auditclose_id       = $_POST['gl_auditclose_id'];

    $type                  = $_POST['type'];

    $rep_type              = $_POST['rep_type'];

    $acc_report_brand      =  (int) $_POST['acc_report_brand'];

    $department_id         =  (int) $_POST['acc_department_id'];

    $outlet_id             =  (int) $_POST['acc_outlet_id'];

    $warehouse_id          =  (int) $_POST['acc_warehouse_id'];

    $view_bl = 'balance_report_html';

    if ($rep_type == 2) {

      $view_bl = 'balance_sheet_ac_html_new';

    }



    $balanceSheetDetails = AccAccount::model()->getBalanceSheetDetails($to_date, $level, $gl_auditclose_id);

    

    $this->renderPartial($view_bl, array(

      'from_date'     => $from_date,

      'to_date'       => $to_date,

      'level'         => $level,

      'type'          => $type,

      'brand'         => $acc_report_brand,

      'outlet_id'     => $outlet_id,

      'department_id' => $department_id,

      'warehouse_id'  => $warehouse_id,

      'gl_auditclose_id' => $gl_auditclose_id,

      'balanceSheetDetails' => $balanceSheetDetails

    ));

  }

  public function actionBalance_sheet_dashboard()
  {
    $from_date = (count(explode('/', $_POST['from_bs'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_bs']))) : date('Y-m-01');
    $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
    $level = 3;//$_POST['level'];
    $type = $_POST['type_bs'];
    //$view_bl = 'balance_report_html';
    $view_bl = 'balance_sheet_dashboard';
    $balanceSheetDetails = AccAccount::model()->getBalanceSheetDetails($to_date, $level, '');
    $this->renderPartial($view_bl, array(
      'from_date' => $from_date,
      'to_date' => $to_date,
      'level' => $level,
      'type' => $type,
      'balanceSheetDetails' => $balanceSheetDetails
    ));
  }

  public function actionProfit_loss_dashboard()
  {
    $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
    $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
    $level = 2;//$_POST['level'];
    $type = $_POST['type'];
    $this->renderPartial('profit_loss_dashboard', array(
      'from_date' => $from_date,
      'to_date' => $to_date,
      'level' => $level,
      'type' => $type,
    ));
  }

  // --------------------------GeneralLedger----Report----------------------------------------

  

public function actionGeneralLedgerNew()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_generalledger_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_generalledger_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('gl_report_new', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}



  

  public function actionGl_html_new()

  {

    $date_field            = $_POST['date_field'];

    $gl_auditclose_id       = $_POST['gl_auditclose_id'];

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger_id             = (int) $_POST['ledger_id'];

    $subledger             = (int) $_POST['subledger_id'];

    $currency              = (int) $_POST['currency'];

    $acc_report_brand      = (int) $_POST['acc_report_brand'];

    $department_id         = (int) $_POST['acc_department_id'];

    $outlet_id             = (int) $_POST['acc_outlet_id'];

    $warehouse_id          = (int) $_POST['acc_warehouse_id'];



    $view_gl = 'gl_report_html_new';



    $this->renderPartial($view_gl, array(

      'date_field'  => $date_field,

      'gl_auditclose_id'  => $gl_auditclose_id,

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'currency'    => $currency,

      'ledger_id'   => $ledger_id,

      'subledger'   => $subledger,

      'brand'       => $acc_report_brand,

      'outlet_id'     => $outlet_id,

      'department_id' => $department_id,

      'warehouse_id'  => $warehouse_id,

    ));

  }



public function actionGeneralLedger()

{

    // if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["acc_generalledger_report_menu"]) {

    //     $this->render('gl_report');

    // } else {

    //     $this->layout = false;

    //     $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

    //     Yii::app()->end();

    // }

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_generalledger_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_generalledger_report_menu']

        )

    ) {

        $this->render('gl_report');

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}





  public function actionGl_html()

  {

    $date_field            = $_POST['date_field'];

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger_id             = (int) $_POST['ledger_id'];

    $subledger             = (int) $_POST['subledger_id'];

    $currency              = (int) $_POST['currency'];

    $acc_report_brand      = (int) $_POST['acc_report_brand'];

    $department_id         = (int) $_POST['acc_department_id'];

    $outlet_id             = (int) $_POST['acc_outlet_id'];

    $warehouse_id          = (int) $_POST['acc_warehouse_id'];



    $view_gl = 'gl_report_html';



    $this->renderPartial($view_gl, array(

      'date_field'  => $date_field,

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'currency'    => $currency,

      'ledger_id'   => $ledger_id,

      'subledger'   => $subledger,

      'brand'       => $acc_report_brand,

      'outlet_id'     => $outlet_id,

      'department_id' => $department_id,

      'warehouse_id'  => $warehouse_id,

    ));

  }







  // -----------------------------------------------------------------------------------------------------------

  // detailed PDF report of each trial balace ledger

  //------------------------------------------------------------------------------------------------------------









  public function actionTrial_balance_Excel()

  {



    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');

    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

    $level          = (int) $_REQUEST['level'];

    $year           = (int)$_REQUEST['year'];

    $company        = (int) $_REQUEST['company'];

    $branch         = (int) $_REQUEST['branch'];

    $salesgroup     = (int) $_REQUEST['salesgroup'];

    $brand          = (int) $_REQUEST['brand'];

    $employee       = (int) $_REQUEST['employee'];

    $dep            = (int) $_REQUEST['dep'];

    $costcenter     = (int) $_REQUEST['costcenter'];

    $cate           = (int) $_REQUEST['cate'];

    $project        = (int) $_REQUEST['project'];

    $item           = (int) $_REQUEST['item'];

    $type           = $_REQUEST['type'];

    $warehouse_id   = (int) $_REQUEST['acc_warehouse_id'];

    $outlet_id      = (int) $_REQUEST['acc_outlet_id'];

    $department_id  = (int) $_REQUEST['acc_department_id'];



    $param = array(

      'from_date'    => $from_date,

      'to_date'      => $to_date,

      'level'        => $level,

      'year'         => $year,

      'company'      => $company,

      'branch'       => $branch,

      'salesgroup'   => $salesgroup,

      'brand'        => $brand,

      'employee'     => $employee,

      'costcenter'   => $costcenter,

      'category'     => $cate,

      'project'      => $project,

      'item'         => $item,

      'type'         => $type,

      'warehouse_id' => $warehouse_id,

      'outlet_id'    => $outlet_id,

      'department_id' => $department_id,



    );



    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

    $filename = 'trial_balance_Excel.xls';

    header("Content-type: application/vnd.ms-excel");

    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

    $this->renderPartial('application.modules.accounts.views.reports.excel.trial_balance_Excel', $param, false, true);

    Yii::app()->end();

  }

  public function actionTrial_balance_Excel_ledgerwise()

  {



    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');

    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

    $level          = (int) $_REQUEST['level'];

    $year           = (int)$_REQUEST['year'];

    $company        = (int) $_REQUEST['company'];

    $branch         = (int) $_REQUEST['branch'];

    $salesgroup     = (int) $_REQUEST['salesgroup'];

    $brand          = (int) $_REQUEST['brand'];

    $employee       = (int) $_REQUEST['employee'];

    $costcenter     = (int) $_REQUEST['costcenter'];

    $cate           = (int) $_REQUEST['cate'];

    $project        = (int) $_REQUEST['project'];

    $item           = (int) $_REQUEST['item'];

    $type           = $_REQUEST['type'];

    $warehouse_id   = (int) $_REQUEST['acc_warehouse_id'];

    $outlet_id      = (int) $_REQUEST['acc_outlet_id'];

    $department_id  = (int) $_REQUEST['acc_department_id'];



    $param = array(

      'from_date'    => $from_date,

      'to_date'      => $to_date,

      'level'        => $level,

      'year'         => $year,

      'company'      => $company,

      'branch'       => $branch,

      'salesgroup'   => $salesgroup,

      'brand'        => $brand,

      'employee'     => $employee,

      'costcenter'   => $costcenter,

      'category'     => $cate,

      'project'      => $project,

      'item'         => $item,

      'type'         => $type,

      'warehouse_id' => $warehouse_id,

      'outlet_id'    => $outlet_id,

      'department_id' => $department_id,

    );



    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

    $filename = 'trial_balance_Excel.xls';

    header("Content-type: application/vnd.ms-excel");

    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

    $this->renderPartial('application.modules.accounts.views.reports.excel.trial_balance_Excel_ledgerwise', $param, false, true);

    Yii::app()->end();

  }

  // -----------------------------------------------------------------------------------------------------------

  // detailed PDF & Ecel report of each trial balace ledger

  //------------------------------------------------------------------------------------------------------------













  // -----------------------------------------------------------------------------------------------------------

  // detailed PDF & Ecel report of each  balace ledger

  //------------------------------------------------------------------------------------------------------------











  // -----------------------------------------------------------------------------------------------------------

  // detailed PDF & Ecel report of each  General Ledger Report

  //------------------------------------------------------------------------------------------------------------











  public function actionGl_report_Excel()

  {



    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');

    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

    $level          = (int) $_REQUEST['level'];

    $year           = (int)$_REQUEST['year'];

    $company        = (int) $_REQUEST['company'];

    $branch         = (int) $_REQUEST['branch'];

    $salesgroup     = (int) $_REQUEST['salesgroup'];

    $brand          = (int) $_REQUEST['brand'];

    $employee       = (int) $_REQUEST['employee'];

    $costcenter     = (int) $_REQUEST['costcenter'];

    $cate           = (int) $_REQUEST['cate'];

    $project        = (int) $_REQUEST['project'];

    $item           = (int) $_REQUEST['item'];

    $ledger_id      = (int) $_REQUEST['ledger_id'];

    $subledger_id   = (int) $_REQUEST['subledger_id'];

    $currency       = (int) $_REQUEST['currency'];

    $date_field     =  $_REQUEST['date_field'];

    $warehouse_id   = (int) $_REQUEST['acc_warehouse_id'];

    $outlet_id      = (int) $_REQUEST['acc_outlet_id'];

    $department_id  = (int) $_REQUEST['acc_department_id'];



    $param = array(

      'from_date'    => $from_date,

      'to_date'      => $to_date,

      'level'        => $level,

      'year'         => $year,

      'company'      => $company,

      'branch'       => $branch,

      'salesgroup'   => $salesgroup,

      'brand'        => $brand,

      'employee'     => $employee,

      'costcenter'   => $costcenter,

      'category'     => $cate,

      'project'      => $project,

      'item'         => $item,

      'ledger_id'    => $ledger_id,

      'subledger'    => $subledger_id,

      'currency'     => $currency,

      'date_field'   => $date_field,

      'warehouse_id' => $warehouse_id,

      'outlet_id'    => $outlet_id,

      'department_id' => $department_id,

    );



    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

    $filename = 'Gl_report_Excel.xls';

    header("Content-type: application/vnd.ms-excel");

    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

    $this->renderPartial('application.modules.accounts.views.reports.excel.gl_report_Excel', $param, false, true);

    Yii::app()->end();

  }



  // -----------------------------------------------------------------------------------------------------------

  //    Statement Report

  //------------------------------------------------------------------------------------------------------------





// public function actionStatementReport()

// {

//     $type = isset($_GET['type']) ? $_GET['type'] : null;



//     $ledgerArray = array(

//         'customer' => AccSystemAccountsMapping::getSystemdefault('debtors'),

//         'vendor'   => AccSystemAccountsMapping::getSystemdefault('creditors'),

//         'bank'     => AccSystemAccountsMapping::getSystemdefault('creditors')

//     );



//     $hasAccess = false;



//     if ($type === 'customer' &&

//         (Yii::app()->user->authorised_user == 1 ||

//          (int) Yii::app()->user->havePermissionOn['acc_customerstatement_report_menu'])) {

//         $hasAccess = true;



//     } elseif ($type === 'vendor' &&

//         (Yii::app()->user->authorised_user == 1 ||

//          (int) Yii::app()->user->havePermissionOn['acc_vendorstatement_report_menu'])) {

//         $hasAccess = true;



//     } elseif ($type === 'bank') {

//         // Optional: add bank-related permission if needed

//         $hasAccess = true;

//     }



//     if (!$hasAccess || !isset($ledgerArray[$type])) {

//         $this->layout = false;

//         $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

//         Yii::app()->end();

//     }



//     $this->render('statement_report', array(

//         'type' => $type,

//         'ledger_id' => (int) $ledgerArray[$type]

//     ));

// }

public function actionStatementReport()

{

    $type = isset($_GET['type']) ? $_GET['type'] : null;



    $ledgerArray = array(

        'customer' => AccSystemAccountsMapping::getSystemdefault('debtors'),

        'vendor'   => AccSystemAccountsMapping::getSystemdefault('creditors'),

        'bank'     => AccSystemAccountsMapping::getSystemdefault('creditors')

    );



    $hasAccess = false;



    $isMainMenuPermitted = Yii::app()->user->authorised_user == 1 ||

                           !empty(Yii::app()->user->havePermissionOn['accounts_menu_view']);



    if ($type === 'customer' &&

        $isMainMenuPermitted &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_customerstatement_report_menu']))) {

        $hasAccess = true;



    } elseif ($type === 'vendor' &&

        $isMainMenuPermitted &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_vendorstatement_report_menu']))) {

        $hasAccess = true;



    } elseif ($type === 'bank') {

        // Optional: Add permission for bank if required

        $hasAccess = $isMainMenuPermitted;

    }



    if (!$hasAccess || !isset($ledgerArray[$type])) {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    $this->render('statement_report', array(

        'type' => $type,

        'ledger_id' => (int) $ledgerArray[$type]

    ));

}









  public function actionStatement_html()

  {

    $from_date          = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date            = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $subledger_id       = (int) $_POST['subledger_id'];

    $ledger_id          = (int) $_POST['ledger_id'];

    $currency           = (int) $_POST['currency'];

    $type               =  $_POST['type'];

    $cur                = MasCurrency::model()->findByPk($currency);

    $exchange_rate      = (float)$cur->exchange_rate;

    $currency_code      = $cur->currency_code;



    $this->renderPartial('statement_report_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

      'currency'       => $currency,

      'subledger_id'   => $subledger_id,

      'ledger_id'      => $ledger_id,

      'exchange_rate'  => $exchange_rate,

      'currency_code'  => $currency_code,

      'type'           => $type,

    ));

  }

  // -----------------------------------------------------------------------------------------------------------

  //    Aging Report

  //------------------------------------------------------------------------------------------------------------

  public function getCategoryLedger($category)

  {



    $modelAccLegder = new AccLedger();

    return CHtml::listData($modelAccLegder->findAll(array('condition' => 'is_parent="N" AND classification="' . $category . '"', 'order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');

    //return CHtml::listData($modelAccLegder->findAll(array('condition' => 'is_parent="N"', 'order' => 'ledger_acc_name ASC')), 'id', 'ledger_acc_name');



  }







// public function actionAgingReport()

// {

//     $type = isset($_GET['type']) ? (int) $_GET['type'] : null;

//     $category = ($type === 1) ? 'RECEIVABLE' : 'PAYABLE';



//     $hasAccess = false;



//     if ($category === 'RECEIVABLE' &&

//         (Yii::app()->user->authorised_user == 1 ||

//          (int) Yii::app()->user->havePermissionOn['acc_receivableaging_report_menu'])) {

//         $hasAccess = true;



//     } elseif ($category === 'PAYABLE' &&

//         (Yii::app()->user->authorised_user == 1 ||

//          (int) Yii::app()->user->havePermissionOn['acc_payableaging_report_menu'])) {

//         $hasAccess = true;

//     }



//     if (!$hasAccess) {

//         $this->layout = false;

//         $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

//         Yii::app()->end();

//     }



//     $this->render('aging_report', array(

//         'filter_array' => $this->getCategoryLedger($category),

//         'category' => $category

//     ));

// }

public function actionAgingReport()

{

    $type = isset($_GET['type']) ? (int) $_GET['type'] : null;

    $category = ($type === 1) ? 'RECEIVABLE' : 'PAYABLE';



    // Check if user has Reports main menu permission

    $isMainMenuPermitted = Yii::app()->user->authorised_user == 1 ||

                           !empty(Yii::app()->user->havePermissionOn['accounts_menu_view']);



    if (!$isMainMenuPermitted) {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    $hasAccess = false;



    if ($category === 'RECEIVABLE' &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_receivableaging_report_menu']))) {

        $hasAccess = true;



    } elseif ($category === 'PAYABLE' &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_payableaging_report_menu']))) {

        $hasAccess = true;

    }



    if (!$hasAccess) {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    $this->render('aging_report', array(

        'filter_array' => $this->getCategoryLedger($category),

        'category' => $category

    ));

}

  public function actionAging_html()

  {



    $from_date     = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');

    $to_date       = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger        = (int) $_POST['ledger_id'];

    $subledger_id  = (int) $_POST['subledger_id'];

    $brand         = (int) $_POST['brand'];

    $lead_owner_id = (int) $_POST['lead_owner_id'];

    $category     = ($_POST['category'] == 'RECEIVABLE') ? 'RECEIVABLE' : 'PAYABLE';



    $this->renderPartial('aging_html', array(

      'from_date'    => $from_date,

      'to_date'      => $to_date,

      'brand'        => $brand,

      'ledger'       => $ledger,

      'subledger_id' => $subledger_id,

      'category'     => $category,

      'lead_owner_id' => $lead_owner_id,

    ));

  }





  public function actionAging_vouchers_html()

  {

    $ledger = (int) $_POST['ledger_id'];

    $subledger = (int) $_POST['subledger_id'];





    $tail = $_POST['tail'];

    $mode = $_POST['mode'] == 1 ? 1 : 0;

  $modelMasCurrency =  new MasCurrency();

    function generateUrl($parentModel)

    {



      

      $url = '#';

      $code = $parentModel->vtype->code;

      if ($code == 'SI') {

        /* 

                $headModel = $parentModel->vtype->header_table;

                $vat_field = $parentModel->vtype->vat_value;

                $tax = $headModel::model()->findBypk($parentModel->header_table_id)->$vat_field;

                $tax = $headModel::model()->findBypk($parentModel->transaction_id);

                */

        $tax = 1;

        $taxType = ($tax > 0) ? 'tax' : 'taxnil';

        $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $parentModel->transaction_id . "&frm=" . $taxType . "', '_blank');";

      } else if ($code == 'PI') {

        $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $parentModel->transaction_id . "', '_blank');";

      } else if ($code == 'DN') {

        $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $parentModel->transaction_id . "', '_blank');";

      } else if ($code == 'CN') {

        $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $parentModel->transaction_id . "', '_blank');";

      } else {

        $url = "window.open($('#liveSite').val()+'index.php?r=accounts/voucher/PrintvoucherPdf&id=" . $parentModel->id . "', '_blank');";

      }

      return $url;

    }



    $condition = 'ledger_id=' . $ledger . ' AND subledger_id=' . $subledger;

    if ($mode == 1) {

      $condition .= ' AND amount > 0';

    } else {

      $condition .= ' AND amount < 0';

    }



    $items = Yii::app()->db->createCommand('SELECT * FROM {{view_acc_ageing_' . $tail . '}} WHERE ' . $condition . ' ORDER BY voucher_date')->queryAll();

    $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">

                    <thead>

                        <tr>

                            <th>Date</th>

                            <th>Voucher No</th>

                            <th>Ref No</th>

                            <th>Description</th>

                            <th>Total</th>

                            <th>Allocated</th>

                            <th>Balance</th>

                        </tr>

                    <tbody>';

    if (!empty($items)) {

      foreach ($items as $each) {

        $table .= '<tr>

                                <td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>

                                <td><a href="#" onclick="' . generateUrl(AccVoucher::model()->findBypk((int) $each['voucher_id'])) . '">' . $each['voucher_no'] . '</a></td>

                                <td>' . $each['reference_no'] . '</td>

                                <td>' . $each['narration'] . '</td>

                                <td style="text-align:right !important;">' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['total_amount']) . '</td>

                                <td style="text-align:right !important;">' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['allocated'])  . '</td>

                                <td style="text-align:right !important;">' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['amount']) . '</td>

                            </tr>';

      }

    } else {

      $table .= '<tr>

                            <td style="text-align:center !important;" colspan="7"> No data</td>

                      </tr>';

    }



    $table .= '</tbody>

                      </table>';

    echo $table;

  }



  // -----------------------------------------------------------------------------------------------------------

  //    Aging PDF & Excel Report

  //------------------------------------------------------------------------------------------------------------







  // -----------------------------------------------------------------------------------------------------------

  //   general ledger summary tab  Report-from-trial balance, profit & loss, balance sheet report

  //------------------------------------------------------------------------------------------------------------



  public function actionGl_summary_tab_html()

  {

    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger_id              = $_POST['ledger_id'];

    $subledger              = $_POST['subledger_id'];

    $currency               = $_POST['currency'];

    $acc_report_year        = $_POST['acc_report_year'];

    $acc_report_company     = $_POST['acc_report_company'];

    $acc_report_salesgroup  = $_POST['acc_report_salesgroup'];

    $acc_report_brand       = $_POST['acc_report_brand'];

    $acc_report_employee    = $_POST['acc_report_employee'];

    $acc_report_costcenter  = $_POST['acc_report_costcenter'];

    $acc_report_cate        = $_POST['acc_report_cate'];

    $acc_report_project     = $_POST['acc_report_project'];

    $acc_report_item        = $_POST['acc_report_item'];

    $outlet_id              = $_POST['acc_outlet_id'];

    $warehouse_id           = $_POST['acc_warehouse_id'];

    $department_id          = $_POST['acc_department_id'];

    $modelAccLedger         = new AccLedger();

    $ledger_main_acc        = $modelAccLedger->findByPk($ledger_id)->ledger_main_acc;

    $this->renderPartial('gl_summary_tab_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

      'currency'       => $currency,

      'ledger_id'      => $ledger_id,

      'subledger'      => $subledger,

      'year'           => $acc_report_year,

      'company'        => $acc_report_company,

      'salesgroup'     => $acc_report_salesgroup,

      'brand'          => $acc_report_brand,

      'employee'       => $acc_report_employee,

      'costcenter'     => $acc_report_costcenter,

      'category'       => $acc_report_cate,

      'project'        => $acc_report_project,

      'item'           => $acc_report_item,

      'outlet_id'      => $outlet_id,

      'warehouse_id'   => $warehouse_id,

      'department_id'  => $department_id,

      'ledger_main_acc' => $ledger_main_acc,

    ));

  }





  // -----------------------------------------------------------------------------------------------------------

  //  Subledger detail report

  //------------------------------------------------------------------------------------------------------------



public function actionSubledgerDetailReport()

{

  // if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["acc_ledger_report_menu"]) {

  //       $this->render('subledger_detail_report');

  //   } else {

  //       $this->layout = false;

  //       $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

  //       Yii::app()->end();

  //   }

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_ledger_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_ledger_report_menu']

        )

    ) {

        $this->render('subledger_detail_report');

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}







  public function actionSubledger_detail_report_html()

  {



    $from_date     = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date       = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

    $ledger_id     = (int) $_POST['ledger_id'];

    $subledger     = (int) $_POST['subledger_id'];

    $warehouse_id  = (int) $_POST['warehouse_id'];

    $outlet_id  = (int) $_POST['outlet_id'];



    $currency      = 1;

    $cur           = MasCurrency::model()->findByPk(1);

    $exchange_rate = $cur->exchange_rate;

    $currency_code = $cur->currency_code;



    $this->renderPartial('subledger_detail_report_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

      'currency'       => $currency,

      'ledger_id'      => $ledger_id,

      'subledger'      => $subledger,

      'exchange_rate'  => $exchange_rate,

      'currency_code'  => $currency_code,

      'warehouse_id'   => $warehouse_id,

      'outlet_id'     => $outlet_id,



    ));

  }





  // -----------------------------------------------------------------------------------------------------------

  //    Subledger detail  PDF & Excel Report

  //------------------------------------------------------------------------------------------------------------









  // -----------------------------------------------------------------------------------------------------------

  //  VAT  report

  //------------------------------------------------------------------------------------------------------------



  public function actionVatReport()

  {

    $this->render('vat_report');

  }



  public function actionVat_report_html()

  {



    $year = $_POST['year'];

    $month = $_POST['month'];



    // Initialize an array to store the result

    $months_yearArray = array();



    // Loop to get the next three months

    for ($i = 0; $i < 3; $i++) {

      // Add the current month and year to the array

      $formattedDate = sprintf('%02d-%04d', $month, $year);

      $months_yearArray[] = $formattedDate;



      // Move to the next month

      $month++;



      // If the month exceeds 12, increment the year and reset the month to 1

      if ($month > 12) {

        $month = 1;

        $year++;

      }

    }



    $this->renderPartial('vat_report_html', array(



      'months_yearArray'   => $months_yearArray,

    ));

  }





  public function actionVat_report_html_old()

  {



    $from_date  = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date    = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');



    // -----------to find differnce between two dates----------------------

    $year1      = date('Y', strtotime($from_date));

    $year2      = date('Y', strtotime($to_date));

    $month1     = date('m', strtotime($from_date));

    $month2     = date('m', strtotime($to_date));

    $diff_month = ($month2 - $month1);

    $diff_year  = (($year2 - $year1) * 12);

    // ---------------------------------



    if ($diff_month == 2 && $diff_year == 0) {

      // if ($diff_month == 3 && $diff_year == 0) {



      // -----------to array of months between two dates----------------------

      $date1       = $from_date;

      $date2       = $to_date;

      $month_array = [];

      $time        = strtotime($date1);

      $last        = date('m', strtotime($date2));

      do {

        $month         = date('m', $time);

        $total         = date('t', $time);

        $month_array[] = [

          'month' => $month,

          'total' => $total,

        ];

        $time = strtotime('+1 month', $time);

      } while ($month != $last);

      // ---------------------------------

      $this->renderPartial('vat_report_html', array(

        'from_date'     => $from_date,

        'to_date'       => $to_date,

        'month_array'   => $month_array,

        'year'   => $year1,

      ));

    } else {

      echo "failed";

    }

    // ---------------------------------

  }





  public function actionVat_detailed_report_html()

  {



    $from_date  = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date    = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    // -----------to find differnce between two dates----------------------

    $year1      = date('Y', strtotime($from_date));

    $year2      = date('Y', strtotime($to_date));

    $month1     = date('m', strtotime($from_date));

    $month2     = date('m', strtotime($to_date));

    $diff_month = ($month2 - $month1);

    $diff_year  = (($year2 - $year1) * 12);

    // ---------------------------------



    if ($diff_month == 2 && $diff_year == 0) {





      // -----------to array of months between two dates----------------------

      $date1       = $from_date;

      $date2       = $to_date;

      $month_array = [];

      $time        = strtotime($date1);

      $last        = date('m', strtotime($date2));

      do {

        $month         = date('m', $time);

        $total         = date('t', $time);

        $month_array[] = [

          'month' => $month,

          'total' => $total,

        ];

        $time = strtotime('+1 month', $time);

      } while ($month != $last);

      // ---------------------------------

      $this->renderPartial('vat_detailed_report_html', array(

        'from_date'     => $from_date,

        'to_date'       => $to_date,

        'month_array'   => $month_array,

        'year'   => $year1,

      ));

    } else {

      echo "failed";

    }

  }







  public function actionVat_report_pdf()

  {

    $year = $_REQUEST['year'];

    $month = $_REQUEST['month'];



    // Initialize an array to store the result

    $months_yearArray = array();



    // Loop to get the next three months

    for ($i = 0; $i < 3; $i++) {

      // Add the current month and year to the array

      $formattedDate = sprintf('%02d-%04d', $month, $year);

      $months_yearArray[] = $formattedDate;



      // Move to the next month

      $month++;



      // If the month exceeds 12, increment the year and reset the month to 1

      if ($month > 12) {

        $month = 1;

        $year++;

      }

    }





    $mode = 'A4';

    $mpdf = Yii::app()->ePdf->mpdf('', $mode);

    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

    $mpdf->WriteHTML($stylesheet, 1);

    $page_name = 'vat_report_pdf';

    $param = array(

      'months_yearArray'   => $months_yearArray,

    );

    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));

    $mpdf->Output("VatReport" . date("d-m-Y") . ".pdf", 'I');

  }



  public function actionVat_report_pdf_old()

  {

    $from_date     = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');

    $to_date       = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');

    $year         = date('Y', strtotime($from_date));

    // -----------to array of months between two dates----------------------

    $date1       = $from_date;

    $date2       = $to_date;

    $month_array = [];

    $time        = strtotime($date1);

    $last        = date('m', strtotime($date2));

    do {

      $month         = date('m', $time);

      $total         = date('t', $time);

      $month_array[] = [

        'month' => $month,

        'total' => $total,

      ];

      $time = strtotime('+1 month', $time);

    } while ($month != $last);

    // ---------------------------------





    $mode = 'A4';

    $mpdf = Yii::app()->ePdf->mpdf('', $mode);

    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

    $mpdf->WriteHTML($stylesheet, 1);

    $page_name = 'vat_report_pdf';

    $param = array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

      'month_array'    => $month_array,

      'year'           => $year,

    );

    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));

    $mpdf->Output("VatReport" . date("d-m-Y") . ".pdf", 'I');

  }





  public function actionVat_report_Excel()

  {

    $year = $_REQUEST['year'];

    $month = $_REQUEST['month'];



    // Initialize an array to store the result

    $months_yearArray = array();



    // Loop to get the next three months

    for ($i = 0; $i < 3; $i++) {

      // Add the current month and year to the array

      $formattedDate = sprintf('%02d-%04d', $month, $year);

      $months_yearArray[] = $formattedDate;



      // Move to the next month

      $month++;



      // If the month exceeds 12, increment the year and reset the month to 1

      if ($month > 12) {

        $month = 1;

        $year++;

      }

    }

    // ---------------------------------

    $param = array(

      'months_yearArray'   => $months_yearArray,

    );

    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);



    $filename = 'vat_report_excel.xls';

    header("Content-type: application/vnd.ms-excel");

    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

    $this->renderPartial('application.modules.accounts.views.reports.excel.vat_report_excel', $param, false, true);

    Yii::app()->end();

  }





  // -----------------------------------------------------------------------------------------------------------

  //  GL Summary   HTML,PDF,EXCEL reports

  //------------------------------------------------------------------------------------------------------------





public function actionGl_summary_report()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_ledger_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_ledger_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('gl_summary_report', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}



  public function actionGl_summary_html()

  {

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger_id             = $_POST['ledger_id'];



    $this->renderPartial('gl_summary_html', array(

      'from_date'  => $from_date,

      'to_date'    => $to_date,

      'ledger_id'  => $ledger_id,



    ));

  }











  // -----------------------------------------------------------------------------------------------------------

  // StatementReport as on Date

  //------------------------------------------------------------------------------------------------------------



public function actionStatementReport_as_on_Date()

{

    $type = isset($_GET['type']) ? $_GET['type'] : null;



    $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();

    $ledgerArray = array(

        'customer' => $modelAccSystemAccountsMapping->getSystemdefault('debtors'),

        'vendor'   => $modelAccSystemAccountsMapping->getSystemdefault('creditors'),

        'bank'     => $modelAccSystemAccountsMapping->getSystemdefault('creditors')

    );



    $hasAccess = false;



    $isMainMenuPermitted = Yii::app()->user->authorised_user == 1 ||

                           !empty(Yii::app()->user->havePermissionOn['accounts_menu_view']);



    if ($type === 'customer' &&

        $isMainMenuPermitted &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_customerstatement_report_menu']))) {

        $hasAccess = true;



    } elseif ($type === 'vendor' &&

        $isMainMenuPermitted &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_vendorstatement_report_menu']))) {

        $hasAccess = true;



    } elseif ($type === 'bank') {

        // Optional: Add permission for bank if required

        $hasAccess = $isMainMenuPermitted;

    }



    if (!$hasAccess || !isset($ledgerArray[$type])) {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    $this->render('statementreport_as_on_date', array(

        'type' => $type,

        'ledger_id' => (int) $ledgerArray[$type]

    ));

}









  // -----------------------------------------------------------------------------------------------------------

  //  GL REport Cash   HTML,EXCEL reports

  //------------------------------------------------------------------------------------------------------------







  // -----------------------------------------------------------------------------------------------------------

  // ajax call :- to get puls button click details in gl  & general ledger report

  //------------------------------------------------------------------------------------------------------------



  public function actiongl_report_displaychild()

  {

    $acc_voucher_id    = $_POST['voucherid'];

    $item_id           = $_POST['itemid'];

    $condition_child   = '  acc_voucher_id=' . (int) $acc_voucher_id;

    $condition_child  .= ' AND id !=' . (int) $item_id;

    $items_child       = Yii::app()->db->createCommand('SELECT * FROM view_acc_gl_report_parent WHERE  ' . $condition_child . ' ORDER BY  voucher_date')->queryAll();

    echo json_encode($items_child);

  }





  // -----------------------------------------------------------------------------------------------------------

  // balance report date range

  //------------------------------------------------------------------------------------------------------------



  public function actionBalancenew()

  {

    $this->render('balance_report_new');

  }





  public function actionBalance_new_html()

  {

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $acc_report_year       = $_POST['acc_report_year'];

    $acc_report_company    = $_POST['acc_report_company'];

    $acc_report_branch     = $_POST['acc_report_branch'];

    $acc_report_salesgroup = $_POST['acc_report_salesgroup'];

    $acc_report_brand      = $_POST['acc_report_brand'];

    $acc_report_employee   = $_POST['acc_report_employee'];

    $acc_report_dep        = $_POST['acc_report_dep'];

    $acc_report_costcenter = $_POST['acc_report_costcenter'];

    $acc_report_cate       = $_POST['acc_report_cate'];

    $acc_report_project    = $_POST['acc_report_project'];

    $acc_report_item       = $_POST['acc_report_item'];



    $this->renderPartial('balance_report_new_html', array(

      'from_date'  => $from_date,

      'to_date'    => $to_date,

      'level'      => $level,

      'year'       => $acc_report_year,

      'company'    => $acc_report_company,

      'branch'     => $acc_report_branch,

      'salesgroup' => $acc_report_salesgroup,

      'brand'      => $acc_report_brand,

      'employee'   => $acc_report_employee,

      'department' => $acc_report_dep,

      'costcenter' => $acc_report_costcenter,

      'category'   => $acc_report_cate,

      'project'    => $acc_report_project,

      'item'       => $acc_report_item,

    ));

  }





  // -----------------------------------------------------------------------------------------------------------

  // trial balance gl excel report when search item count greater than 300

  //------------------------------------------------------------------------------------------------------------





  public function actionGl_summary_tab_excel()

  {



    $from_date       = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');

    $to_date         = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

    $ledger_id       = (int) $_REQUEST['ledger'];

    $modelAccLedger  = new AccLedger();

    $ledger_main_acc = $modelAccLedger->findByPk($ledger_id)->ledger_main_acc;

    $company_id      = (int) $_REQUEST['company_id'];

    $salegroup_id    = (int) $_REQUEST['salegroup_id'];

    $brand_id        = (int) $_REQUEST['brand_id'];

    $type            =  $_REQUEST['type'];

    $subledger       = (int) $_REQUEST['subledger_id'];

    $outlet_id       = (int) $_REQUEST['acc_outlet_id'];

    $warehouse_id    = (int) $_REQUEST['acc_warehouse_id'];

    $department_id    = (int) $_REQUEST['acc_department_id'];



    $param = array(

      'from_date'       => $from_date,

      'to_date'         => $to_date,

      'ledger_id'       => $ledger_id,

      'subledger'       => $subledger,

      'ledger_main_acc' => $ledger_main_acc,

      'company'         => $company_id,

      'salesgroup'      => $salegroup_id,

      'brand'           => $brand_id,

      'type'            => $type,

      'outlet_id'            => $outlet_id,

      'warehouse_id'    => $warehouse_id,

      'department_id'    => $department_id,





    );



    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

    $filename = 'Gl_report_Excel.xls';

    header("Content-type: application/vnd.ms-excel");

    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

    $this->renderPartial('application.modules.accounts.views.reports.excel.gl_summary_tab_excel', $param, false, true);

    Yii::app()->end();

  }



  // -----------------------------------------------------------------------------------------------------------

  // ProfitandLoss Detailed Report

  //------------------------------------------------------------------------------------------------------------





  public function actionProfitandLossdetailed()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_profitloss_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_profitloss_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('profit_loss_detailed', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}







  public function actionProfit_loss_detailed_html()

  {

    set_time_limit(0);

    $from_date   = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date     = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level       = $_POST['level'];

    $type        = $_POST['type'];



    $this->renderPartial('profit_loss_detailed_html', array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'level'       => $level,

      'type'        => $type,

    ));

  }







  // --------------------------Balance--detailed--Report----------------------------------------





  public function actionBalancedetailed()

  {

    //$this->render('balance_detailed_report');

    $this->render('balance_report_new');

  }





  public function actionBalance_detailed_html()

  {

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $type                  = $_POST['type'];

    $this->renderPartial('balance_detailed_report_html', array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'level'       => $level,

      'type'        => $type,



    ));

  }

  

public function actionBalancedetailedNew()

{

    if (

        Yii::app()->user->authorised_user == 1 ||

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 

            isset(Yii::app()->user->havePermissionOn['acc_balance_report_menu']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 

            Yii::app()->user->havePermissionOn['acc_balance_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $auditclode_ranges['all'] = 'Latest';

        $this->render('balance_detailed_report_new', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }

}





  public function actionBalance_detailed_html_new()

  {

    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $level                 = $_POST['level'];

    $type                  = $_POST['type'];

    $gl_auditclose_id       = ($_POST['gl_auditclose_id']>0 && $_POST['gl_auditclose_id']!='all')?$_POST['gl_auditclose_id']:'';

    $balanceSheetDetailedDetails = AccAccount::model()->getBalanceSheetDetailedDetails($from_date, $to_date, $level, $gl_auditclose_id);

    $this->renderPartial('balance_detailed_report_html_new', array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'level'       => $level,

      'type'        => $type,

      'gl_auditclose_id'  => $gl_auditclose_id,

      'balanceSheetDetailedDetails' => $balanceSheetDetailedDetails 

    ));

  }





  // -----------------------------------------------------------------------------------------------------------

  // Vat_summary report

  //------------------------------------------------------------------------------------------------------------





public function actionVat_summary_report()

{

    if (Yii::app()->user->authorised_user == 1 ||

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 

            isset(Yii::app()->user->havePermissionOn['acc_vat_summary_report_menu']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 

            Yii::app()->user->havePermissionOn['acc_vat_summary_report_menu']

        )

    ) {

        $this->render('vat_summary_report');

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); // Prevent further execution

    }

}





  public function actionVat_summary_html()

  {



    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $this->renderPartial('vat_summary_html', array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,



    ));

  }



  // -----------------------------------------------------------------------------------------------------------

  // Vat register report

  //------------------------------------------------------------------------------------------------------------





public function actionVatRegister()

{

    if (Yii::app()->user->authorised_user == 1 ||

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 

            isset(Yii::app()->user->havePermissionOn['acc_vat_register_report_menu']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 

            Yii::app()->user->havePermissionOn['acc_vat_register_report_menu']

        )

    ) {

        $this->render('vat_register_report');

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); // Prevent further execution

    }

}



  public function actionVat_register_html()

  {



    $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $this->renderPartial('vat_register_html', array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,



    ));

  }



  public function actionVat_register_pdf()

  {

    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');

    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

    $mode = 'A4';

    $mpdf = Yii::app()->ePdf->mpdf('', $mode);

    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

    $mpdf->WriteHTML($stylesheet, 1);

    $page_name = 'vat_register_pdf';

    $param = array(

      'from_date'    => $from_date,

      'to_date'      => $to_date,

    );

    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));

    $mpdf->Output("VAT_REGISTER" . date("d-m-Y") . ".pdf", 'I');

  }





  //-------------------------------------------end-----------------------------------------------------------------



  // -----------------------------------------------------------------------------------------------------------

  //  Gl summary html tab  Report-from-trial balance, profit & loss, balance sheet report

  //------------------------------------------------------------------------------------------------------------



  public function actionGl_summary_subledger_html_tab()

  {

    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger_id              = $_POST['ledger_id'];

    $frm                    = $_POST['frm'];

    $warehouse_id           = $_POST['acc_warehouse_id'];

    $department_id          = $_POST['acc_department_id'];

    $outlet_id              = $_POST['acc_outlet_id'];



    $modelAccLedger         = new AccLedger();

    $ledger_main_acc        = $modelAccLedger->findByPk($ledger_id)->ledger_main_acc;



    $this->renderPartial('gl_summary_subledger_html_tab', array(

      'from_date'       => $from_date,

      'to_date'         => $to_date,

      'ledger_id'       => $ledger_id,

      'frm'             => $frm,

      'outlet_id'             => $outlet_id,

      'department_id'             => $department_id,

      'warehouse_id'             => $warehouse_id,

      'ledger_main_acc' => $ledger_main_acc,

    ));

  }





  public function actionVat_register_vat_on_sales_html()

  {



    $from_date  = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date    = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');





    $this->renderPartial('vat_register_vat_on_sales_html', array(

      'from_date'     => $from_date,

      'to_date'       => $to_date,

    ));

  }







  public function actionGl_Detailed_sales_onvat_tab_html()

  {

    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');



    $this->renderPartial('gl_Detailed_sales_onvat_tab_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }



  public function actionvat_Detailed_vat_on_other_income_tab_html()

  {

    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');





    $this->renderPartial('vat_Detailed_vat_on_other_income_tab_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }



  public function actionvat_detailed_vat_purchase_tab_html()

  {

    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');





    $this->renderPartial('vat_detailed_vat_purchase_tab_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }



  public function actionvat_detailed_vat_on_expense_tab_html()

  {

    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');





    $this->renderPartial('vat_detailed_vat_on_expense_tab_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }





  public function actionLoad_monthlybreakup_sales_report()

  {

    $from_date              = $_POST['from'];

    $to_date                = $_POST['to'];





    $this->renderPartial('monthlybreakup_sales_report', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }





  public function actionLoad_monthlybreakup_purchase_report()

  {

    $from_date              = $_POST['from'];

    $to_date                = $_POST['to'];



    $this->renderPartial('monthlybreakup_purchase_report', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }



  public function actionLoad_total_expense_report()

  {

    $from_date              = $_POST['from'];

    $to_date                = $_POST['to'];



    $this->renderPartial('total_expense_report', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }



  public function actionLoad_total_income_report()

  {

    $from_date              = $_POST['from'];

    $to_date                = $_POST['to'];



    $this->renderPartial('total_income_report', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

    ));

  }



  public function actionstatement_as_on_html()

  {

    $from_date          = '202-01-01';

    $to_date            = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $subledger_id       = (int) $_POST['subledger_id'];

    $ledger_id          = (int) $_POST['ledger_id'];

    $currency           = (int) $_POST['currency'];

    $type               = $_POST['type'];

    $cur                = MasCurrency::model()->findByPk($currency);

    $exchange_rate      = $cur->exchange_rate;

    $currency_code      = $cur->currency_code;



    $this->renderPartial('statement_as_on_report_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

      'currency'       => $currency,

      'subledger_id'   => $subledger_id,

      'ledger_id'      => $ledger_id,

      'exchange_rate'  => $exchange_rate,

      'currency_code'  => $currency_code,

      'type'           => $type,

    ));

  }







  public function actionGeneralLedgerDetailed()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_generalledger_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_generalledger_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('gl_detailed_report', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}







  public function actionGl_detailed_html()

  {

    $from_date      = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date        = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger_id      = (int) $_POST['ledger_id'];

    $subledger_id   = (int) $_POST['subledger_id'];

    $currency       = (int) $_POST['currency'];

    $date_field     = $_POST['date_field'];

    $acc_order_by   = $_POST['acc_order_by'];

    $amount_type    = $_POST['amount_type'];

    $this->renderPartial('gl_detailed_report_html', array(

      'from_date'    => $from_date,

      'to_date'      => $to_date,

      'ledger_id'    => $ledger_id,

      'subledger'    => $subledger_id,

      'currency'     => $currency,

      'date_field'   => $date_field,

      'order_by'     => $acc_order_by,

      'amount_type'  => $amount_type

    ));

  }





 public function actionConsolidatedStatementreport()

{

    $type = isset($_GET['type']) ? $_GET['type'] : null;



    $isMainMenuPermitted = Yii::app()->user->authorised_user == 1 ||

                           !empty(Yii::app()->user->havePermissionOn['accounts_menu_view']);



    if (!$isMainMenuPermitted) {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    if ($type === 'customer' && 

        (Yii::app()->user->authorised_user == 1 || 

         !empty(Yii::app()->user->havePermissionOn['acc_customerstatement_report_menu']))) {



        $ledger_id = (int) AccSystemAccountsMapping::getSystemdefault('debtors');



    } elseif ($type === 'vendor' && 

              (Yii::app()->user->authorised_user == 1 || 

               !empty(Yii::app()->user->havePermissionOn['acc_vendorstatement_report_menu']))) {



        $ledger_id = (int) AccSystemAccountsMapping::getSystemdefault('creditors');



    } elseif ($type === 'bank') {

        // Optional: add bank permission check if needed

        $ledger_id = (int) AccSystemAccountsMapping::getSystemdefault('creditors');



    } else {

        // Unauthorized or invalid type

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    $this->render('consolidated_statement_report', array(

        'type' => $type,

        'ledger_id' => $ledger_id,

    ));

}

// public function actionConsolidatedStatementreport()

// {

//     $type = isset($_GET['type']) ? $_GET['type'] : null;



//     if ($type === 'customer' && 

//         (Yii::app()->user->authorised_user == 1 || 

//          (int) Yii::app()->user->havePermissionOn['acc_customerstatement_report_menu'])) {



//         $ledger_id = (int) AccSystemAccountsMapping::getSystemdefault('debtors');



//     } elseif ($type === 'vendor' && 

//               (Yii::app()->user->authorised_user == 1 || 

//                (int) Yii::app()->user->havePermissionOn['acc_vendorstatement_report_menu'])) {



//         $ledger_id = (int) AccSystemAccountsMapping::getSystemdefault('creditors');



//     } elseif ($type === 'bank') {

//         // Optional: add bank permission check if needed

//         $ledger_id = (int) AccSystemAccountsMapping::getSystemdefault('creditors');



//     } else {

//         // Unauthorized or invalid type

//         $this->layout = false;

//         $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

//         Yii::app()->end();

//     }



//     $this->render('consolidated_statement_report', array(

//         'type' => $type,

//         'ledger_id' => $ledger_id,

//     ));

// }



  public function actionConsolidatedStatement_html()

  {



    $from_date          = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date            = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $subledger_id       = (int) $_POST['subledger_id'];

    $ledger_id          = (int) $_POST['ledger_id'];

    $currency           = (int) $_POST['currency'];

    $cur                = MasCurrency::model()->findByPk($currency);

    $exchange_rate      = $cur->exchange_rate;

    $currency_code      = $cur->currency_code;

    $project_id           = (int) $_POST['project_id'];

    $type           =  $_POST['type'];

    $this->renderPartial('consolidated_statement_report_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

      'currency'       => $currency,

      'subledger_id'   => $subledger_id,

      'ledger_id'      => $ledger_id,

      'exchange_rate'  => $exchange_rate,

      'currency_code'  => $currency_code,

      'project_id'     => $project_id,

      'type'           => $type

    ));

  }



// public function actionSatementPdcReport()

// {

//     $type = isset($_GET['type']) ? $_GET['type'] : null;



//     $ledgerArray = array(

//         'customer' => AccSystemAccountsMapping::getSystemdefault('debtors'),

//         'vendor'   => AccSystemAccountsMapping::getSystemdefault('creditors'),

//         'bank'     => AccSystemAccountsMapping::getSystemdefault('creditors')

//     );



//     $hasAccess = false;



//     if ($type === 'customer' &&

//         (Yii::app()->user->authorised_user == 1 ||

//          (int) Yii::app()->user->havePermissionOn['acc_customerstatement_report_menu'])) {

//         $hasAccess = true;



//     } elseif ($type === 'vendor' &&

//         (Yii::app()->user->authorised_user == 1 ||

//          (int) Yii::app()->user->havePermissionOn['acc_vendorstatement_report_menu'])) {

//         $hasAccess = true;



//     } elseif ($type === 'bank') {

//         // Allow access for bank by default or add a permission if needed

//         $hasAccess = true;

//     }



//     if (!$hasAccess || !isset($ledgerArray[$type])) {

//         $this->layout = false;

//         $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

//         Yii::app()->end();

//     }



//     $this->render('statement_pdc_report', array(

//         'type' => $type,

//         'ledger_id' => (int) $ledgerArray[$type]

//     ));

// }

public function actionSatementPdcReport()

{

    $type = isset($_GET['type']) ? $_GET['type'] : null;



    $ledgerArray = array(

        'customer' => AccSystemAccountsMapping::getSystemdefault('debtors'),

        'vendor'   => AccSystemAccountsMapping::getSystemdefault('creditors'),

        'bank'     => AccSystemAccountsMapping::getSystemdefault('creditors')

    );



    // Check main menu permission

    $isMainMenuPermitted = Yii::app()->user->authorised_user == 1 ||

                           !empty(Yii::app()->user->havePermissionOn['accounts_menu_view']);



    if (!$isMainMenuPermitted) {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    $hasAccess = false;



    if ($type === 'customer' &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_customerstatement_report_menu']))) {

        $hasAccess = true;



    } elseif ($type === 'vendor' &&

        (Yii::app()->user->authorised_user == 1 ||

         !empty(Yii::app()->user->havePermissionOn['acc_vendorstatement_report_menu']))) {

        $hasAccess = true;



    } elseif ($type === 'bank') {

        // Allow access for bank by default or based on future permission

        $hasAccess = true;

    }



    if (!$hasAccess || !isset($ledgerArray[$type])) {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }



    $this->render('statement_pdc_report', array(

        'type' => $type,

        'ledger_id' => (int) $ledgerArray[$type]

    ));

}





  public function actionStatement_pdc_html()

  {





    $from_date          = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date            = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $subledger_id       = (int) $_POST['subledger_id'];

    $ledger_id          = (int) $_POST['ledger_id'];

    $currency           = (int) $_POST['currency'];

    $cur                = MasCurrency::model()->findByPk($currency);

    $exchange_rate      = $cur->exchange_rate;

    $currency_code      = $cur->currency_code;



    $this->renderPartial('statement_pdc_report_html', array(

      'from_date'      => $from_date,

      'to_date'        => $to_date,

      'currency'       => $currency,

      'subledger_id'   => $subledger_id,

      'ledger_id'      => $ledger_id,

      'exchange_rate'  => $exchange_rate,

      'currency_code'  => $currency_code,

    ));

  }



  // --------------------------Audit Close--detailed--Report----------------------------------------





public function actionAuditclosedetailed()

{

    if (

        Yii::app()->user->authorised_user == 1 || 

        (

            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) &&

            Yii::app()->user->havePermissionOn['accounts_menu_view'] &&

            isset(Yii::app()->user->havePermissionOn['acc_trialbalance_report_menu']) &&

            Yii::app()->user->havePermissionOn['acc_trialbalance_report_menu']

        )

    ) {

        $auditclode_ranges = AccAuditClose::model()->getAllClosedDateRangesHtml('FINAL', 'name');

        $this->render('auditclose_detailed_report', array('auditclose_ranges' => $auditclode_ranges));

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end(); 

    }

}







  public function actionAuditclose_detailed_html()

  {

    $acc_auditclose_date_id = $_POST['ac_id'];

    $auditclose = AccAuditClose::model()->findByPk($acc_auditclose_date_id);

    $auditCloseLedgerResults = AccAuditCloseDetails::model()->getAllLedgerWithAuditCloseDetails($acc_auditclose_date_id);

    $this->renderPartial('auditclose_detailed_report_html', array(

      'auditclose'   => $auditclose,

      'auditCloseResults' => $auditCloseLedgerResults

    ));

  }



public function actionLedgerReport()

{

    if (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["acc_ledger_report_menu"]) {

        $this->render('ledger_report');

    } else {

        $this->layout = false;

        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');

        Yii::app()->end();

    }

}



  public function actionLedger_report_html()

  {



    $from_date              = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');

    $to_date                = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

    $ledger_id              = $_POST['ledger_id'];

    $warehouse_id              = $_POST['warehouse_id'];

    $subledger              = $_POST['subledger_id'];

    $currency               = $_POST['currency'];

    $acc_report_year        = $_POST['acc_report_year'];

    $acc_report_company     = $_POST['acc_report_company'];

    $acc_report_branch      = $_POST['acc_report_branch'];

    $acc_report_salesgroup  = $_POST['acc_report_salesgroup'];

    $acc_report_brand       = $_POST['acc_report_brand'];

    $acc_report_employee    = $_POST['acc_report_employee'];

    $acc_report_dep         = $_POST['acc_report_dep'];

    $acc_report_costcenter  = $_POST['acc_report_costcenter'];

    $acc_report_cate        = $_POST['acc_report_cate'];

    $acc_report_project     = $_POST['acc_report_project'];

    $acc_report_item        = $_POST['acc_report_item'];

    $date_field             = $_POST['date_field'];

    $outlet_id             = $_POST['acc_outlet_id'];

    $this->renderPartial('ledger_report_html', array(

      'from_date'   => $from_date,

      'to_date'     => $to_date,

      'currency'    => $currency,

      'ledger_id'   => $ledger_id,

      'subledger'   => $subledger,

      'year'        => $acc_report_year,

      'company'     => $acc_report_company,

      'branch'      => $acc_report_branch,

      'salesgroup'  => $acc_report_salesgroup,

      'brand'       => $acc_report_brand,

      'employee'    => $acc_report_employee,

      'department'  => $acc_report_dep,

      'costcenter'  => $acc_report_costcenter,

      'category'    => $acc_report_cate,

      'project'     => $acc_report_project,

      'item'        => $acc_report_item,

      'warehouse_id' => $warehouse_id,

      'date_field'  => $date_field,

      'outlet_id'  => $outlet_id

    ));

  }



  // ----------------------------end---------------------------------------------------------

}

