<?php
/*master for sales group 
created by nisha on 27-09-2022
tables used - mas_acc_year 
 */
class MasaccbranchController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','GetbranchList','Savebranch','Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionCreate()
    {
        $model=new MasAccBranch();
        $id = (int) Yii::app()->request->getParam('id');
        $from =  Yii::app()->request->getParam('from');
        if($id>0){
            $model=$model->findByPk($id);
        }
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model,'from' =>$from), false, true);
    }

    public function actionGetbranchList()
        {
            
                $model=new MasAccBranch();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 =>'branch_name',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (branch_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $rowData[]=array($m,
                        $row['branch_name'],
                        array('id' => $row['id'], 'branch_name'=>$row['branch_name'],'status' => $row->isActive),
                        $row['isDefault']);
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    public function actionSavebranch()
    {
    $model = new MasAccBranch();
        if (isset($_POST['MasAccBranch']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime =date('Y-m-d h:i:s');
            if ((int) @$_POST['MasAccBranch']['id'] > 0)
            {   $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
                $id= (int) @$_POST['MasAccBranch']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
             if($_POST['MasAccBranch']['isDefault'] == "Y"){
                	MasAccBranch::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            	}
            $model->attributes=$_POST['MasAccBranch'];
            $model->isDefault=$_POST['MasAccBranch']['isDefault'];
            if($model->validate())
               
            {
                 $model->save();
                  // inserting to audit log
            /*      AuditLog::saveAuditLogs(
                    'SALES_GROUPS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with name: - {$model->group_name}  "
                );*/
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['branch-form'];
                $jsonData['from'] = $_POST['from'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }
 
 
   public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasAccBranch();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
   
}