<?php
/*
 allocation
 date 21-11-2022
 author -Jisha

 main setup
 Main Tables - erp_acc_allocation_items,erp_acc_allocation
 Main models used - AccAllocation
 */


class AllocationController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index', 'CreateSalesAllocation', 'CreatePurchaseAllocation', 'CreateReceiptAllocation', 'CreatePaymentAllocation', 'CreateCreditNoteAllocation', 'CreateDebitNoteAllocation',
                    'Getallocationdata_for_receipt', 'Saveallocation', 'PrintAllocationHistoryPdf', 'DeleteAllocation', 'CreateAllocation',
                    // ------------------------------------------------------
                    'Allocationlist', 'Getallocationlist',
                    // -------------------------------------------------------
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    // public $modelMasCurrency;

    // public function init()
    // {
    //     parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }




    public function actionCreateAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $type                           = $_GET['type'];
        if (!empty($type) && (int)$voucher_id > 0) {
            $modelVoucher                   = new AccVoucher();
            $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
            $customer_id                    = $modelVoucher->customer_vendor_id;
            $modAccSubledgerType            = new AccSubledgerType();
            $modAccSubledger                = new AccSubledger();
            $modelAccSystemAccountsMapping  = new AccSystemAccountsMapping();
            $modelVI                        = new AccVoucherItems();

            if ($type == 'SI') {
                $ledger_id                      = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
                $subledger_type_id              = $modAccSubledgerType->getIdFromType('C');
                $subledger_id                   = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);
                
                
                $sqlacc ='SELECT ledger_id  FROM erp_acc_voucher_items I
                LEFT JOIN erp_acc_ledger L ON L.id = I.ledger_id 
                WHERE `acc_voucher_id` = "'.(int)$modelVoucher->id.'" AND L.classification="RECEIVABLE"';
                $command_acc = Yii::app()->db->createCommand($sqlacc);
                $acc_detls = $command_acc->queryRow();  
                $ledger_id  = ((int)$acc_detls['ledger_id']>0)?$acc_detls['ledger_id']:$ledger_id;  
                $modelAccLedger = new AccLedger();
                $ledger_array = $modelAccLedger->getReceivableChilds();
        
            } else if ($type == 'CN') {
                $ledger_id                      = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
                $subledger_type_id              = $modAccSubledgerType->getIdFromType('C');
                $subledger_id                   = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);
                
                
                $sqlacc ='SELECT ledger_id  FROM erp_acc_voucher_items I
                LEFT JOIN erp_acc_ledger L ON L.id = I.ledger_id 
                WHERE `acc_voucher_id` = "'.(int)$modelVoucher->id.'" AND L.classification="RECEIVABLE"';
                $command_acc = Yii::app()->db->createCommand($sqlacc);
                $acc_detls = $command_acc->queryRow();  
                $ledger_id  = ((int)$acc_detls['ledger_id']>0)?$acc_detls['ledger_id']:$ledger_id;  
                $modelAccLedger = new AccLedger();
                $ledger_array = $modelAccLedger->getReceivableChilds();
                
                
            } else if ($type == 'PI') {
                $ledger_id                      = $modelAccSystemAccountsMapping->getSystemdefault('creditors');
                $subledger_type_id              = $modAccSubledgerType->getIdFromType('V');
                $subledger_id                   = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);
                
                
                $sqlacc ='SELECT ledger_id  FROM erp_acc_voucher_items I
                LEFT JOIN erp_acc_ledger L ON L.id = I.ledger_id 
                WHERE `acc_voucher_id` = "'.(int)$modelVoucher->id.'" AND L.classification="PAYABLE"';
                $command_acc = Yii::app()->db->createCommand($sqlacc);
                $acc_detls = $command_acc->queryRow();  
                $ledger_id  = ((int)$acc_detls['ledger_id']>0)?$acc_detls['ledger_id']:$ledger_id;  
                $modelAccLedger = new AccLedger();
                $ledger_array = $modelAccLedger->getPayableChilds();
                
            } else if ($type == 'DN') {
                $ledger_id                      = $modelAccSystemAccountsMapping->getSystemdefault('creditors');
                $subledger_type_id              = $modAccSubledgerType->getIdFromType('V');
                $subledger_id                   = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);
                
                
                 $sqlacc ='SELECT ledger_id  FROM erp_acc_voucher_items I
                LEFT JOIN erp_acc_ledger L ON L.id = I.ledger_id 
                WHERE `acc_voucher_id` = "'.(int)$modelVoucher->id.'" AND L.classification="PAYABLE"';
                $command_acc = Yii::app()->db->createCommand($sqlacc);
                $acc_detls = $command_acc->queryRow();  
                $ledger_id  = ((int)$acc_detls['ledger_id']>0)?$acc_detls['ledger_id']:$ledger_id;  
                $modelAccLedger = new AccLedger();
                $ledger_array = $modelAccLedger->getPayableChilds();
                
            } else if ($type == 'RV') {
                $ledger_id                      = $modelAccSystemAccountsMapping->getSystemdefault('debtors');
                $subledger_id                   = $modelVI->find(array('condition' => 'acc_voucher_id= ' . (int)$modelVoucher->id . ' AND ledger_id= ' . $ledger_id))->subledger_id;
                
                  $sqlacc ='SELECT ledger_id  FROM erp_acc_voucher_items I
                LEFT JOIN erp_acc_ledger L ON L.id = I.ledger_id 
                WHERE `acc_voucher_id` = "'.(int)$modelVoucher->id.'" AND L.classification="RECEIVABLE"';
                $command_acc = Yii::app()->db->createCommand($sqlacc);
                $acc_detls = $command_acc->queryRow();  
                $ledger_id  = ((int)$acc_detls['ledger_id']>0)?$acc_detls['ledger_id']:$ledger_id;  
                $modelAccLedger = new AccLedger();
                $ledger_array = $modelAccLedger->getReceivableChilds();
                
            } else if ($type == 'PV') {
                $ledger_id                      = $modelAccSystemAccountsMapping->getSystemdefault('creditors');
                $subledger_id                   = $modelVI->find(array('condition' => 'acc_voucher_id= ' . (int)$modelVoucher->id . ' AND ledger_id= ' . $ledger_id))->subledger_id;
                
                 $sqlacc ='SELECT ledger_id  FROM erp_acc_voucher_items I
                LEFT JOIN erp_acc_ledger L ON L.id = I.ledger_id 
                WHERE `acc_voucher_id` = "'.(int)$modelVoucher->id.'" AND L.classification="PAYABLE"';
                $command_acc = Yii::app()->db->createCommand($sqlacc);
                $acc_detls = $command_acc->queryRow();  
                $ledger_id  = ((int)$acc_detls['ledger_id']>0)?$acc_detls['ledger_id']:$ledger_id;  
                $modelAccLedger = new AccLedger();
                $ledger_array = $modelAccLedger->getPayableChilds();
                
            }
            $model->ledger_id                   = $ledger_id;
            $model->subledger_id                = $subledger_id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id,'ledger_array'=>$ledger_array));
    }

    //for allocate sales

    public function actionCreateSalesAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $customer_id                    = $modelVoucher->customer_vendor_id;
        $modAccSubledgerType            = new AccSubledgerType();
        $subledger_type_id              = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger                = new AccSubledger();
        $model->ledger_id               = AccSystemAccountsMapping::getSystemdefault('debtors');
        $model->subledger_id            = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }
    //for allocate purchase
    public function actionCreatePurchaseAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $vendor_id                      = $modelVoucher->customer_vendor_id;
        $modAccSubledgerType            = new AccSubledgerType();
        $subledger_type_id              = $modAccSubledgerType->getIdFromType('V');
        $modAccSubledger                = new AccSubledger();
        $model->ledger_id               = AccSystemAccountsMapping::getSystemdefault('creditors');
        $model->subledger_id            = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $vendor_id);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }
    //for allocate receipt --changed by jisha on 23-3-23
    public function actionCreateReceiptAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $ledger_id                      = AccSystemAccountsMapping::getSystemdefault('debtors');
        $modelVI                        = new AccVoucherItems();
        $subledger_id                   = $modelVI->find(array('condition' => 'acc_voucher_id= ' . (int)$modelVoucher->id . ' AND ledger_id= ' . $ledger_id))->subledger_id;
        $model->ledger_id               = (int)$ledger_id;
        $model->subledger_id            = (int)$subledger_id;

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }
    //for allocate payment --changed by jisha on 23-3-23
    public function actionCreatePaymentAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $ledger_id                      = AccSystemAccountsMapping::getSystemdefault('creditors');
        $modelVI                        = new AccVoucherItems();
        $subledger_id                   = $modelVI->find(array('condition' => 'acc_voucher_id= ' . (int)$modelVoucher->id . ' AND ledger_id= ' . $ledger_id))->subledger_id;
        $model->ledger_id               = $ledger_id;
        $model->subledger_id            = (int)$subledger_id;

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }

    //for allocate receipt
    /*public function actionCreateReceiptAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $customer_id                    = $modelVoucher->customer_vendor_id;
        $modAccSubledgerType            = new AccSubledgerType();
        $subledger_type_id              = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger                = new AccSubledger();
        $model->ledger_id               = AccSystemAccountsMapping::getSystemdefault('debtors');
        $model->subledger_id            = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }
    public function actionCreatePaymentAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $ledger_id                      = AccSystemAccountsMapping::getSystemdefault('creditors');
        $modelVI                        = new AccVoucherItems();
        $subledger_id                        = $modelVI->find(array('condition' => 'acc_voucher_id= ' . (int)$modelVoucher->id . ' AND ledger_id= ' . $ledger_id))->subledger_id;
        $vendor_id                      = $modelVoucher->customer_vendor_id;
        //$modAccSubledgerType            = new AccSubledgerType();
        //$subledger_type_id              = $modAccSubledgerType->getIdFromType('V');
        //$modAccSubledger                = new AccSubledger();
        $model->ledger_id               = $ledger_id;
        $model->subledger_id            = (int)$subledger_id;

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }*/
    public function actionCreateCreditNoteAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $customer_id                    = $modelVoucher->customer_vendor_id;
        $modAccSubledgerType            = new AccSubledgerType();
        $subledger_type_id              = $modAccSubledgerType->getIdFromType('C');
        $modAccSubledger                = new AccSubledger();
        $model->ledger_id               = AccSystemAccountsMapping::getSystemdefault('debtors');
        $model->subledger_id            = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }
    public function actionCreateDebitNoteAllocation()
    {
        $model                          =  new AccAllocation();
        $voucher_id                     = (int)$_GET['id'];
        $modelVoucher                   = new AccVoucher();
        $modelVoucher                   = $modelVoucher->findByPK((int)$voucher_id);
        $vendor_id                      = $modelVoucher->customer_vendor_id;
        $modAccSubledgerType            = new AccSubledgerType();
        $subledger_type_id              = $modAccSubledgerType->getIdFromType('V');
        $modAccSubledger                = new AccSubledger();
        $model->ledger_id               = AccSystemAccountsMapping::getSystemdefault('creditors');
        $model->subledger_id            = (int)$modAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $vendor_id);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'voucher_id' => $voucher_id));
    }

    public function actionGetallocationdata_for_receipt()
    {
        $ledger = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $allocationDebit = 'CREATE OR REPLACE VIEW view_finance_allocated_debit AS SELECT
								V.id AS voucher_id,
								VI.id AS voucher_item_id,
								V.voucher_no, VI.amount,
								IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
								(VI.amount) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
							FROM erp_finance_voucher_items VI
							LEFT JOIN erp_finance_voucher_head V ON V.id = VI.header_id
							LEFT JOIN erp_finance_allocation_items AI ON AI.voucher_item_id = VI.id
							WHERE V.is_posted ="Y" AND VI.amount > 0 AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
							GROUP BY VI.id';

        Yii::app()->db->createCommand($allocationDebit)->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM view_finance_allocated_debit WHERE balance > 0')->queryAll();

        $tables = array();
        $tables['debit'] = '';

        if ($debitAllocatables[0]['value'] != '') {
            $allItems = FinanceVoucherItems::model()->findAll(array('condition' => 'id IN (' . $debitAllocatables[0]['value'] . ')'));
            foreach ($allItems as $i => $each) {
                $balance = Yii::app()->db->createCommand('SELECT balance AS balance FROM view_finance_allocated_debit WHERE voucher_item_id=' . $each->id)->queryScalar();
                $tables['debit'] .= '<tr>
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id); calculateValue();')) . '</td>
										<td>' . $each->parent->fullvoucher . '</td>
										<td>' . $each->parent->vtype->description . '-' . $each->parent->transaction_no . '</td>
										<td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
										<td>' . $balance . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each->header_id) .
                    CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each->id) .
                    CHtml::hiddenfield('Debit[' . $i . '][balance]', $balance) .
                    CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
            }

            $tables['debit'] .= '<tr>
									<td colspan="5" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
        } else {
            $tables['debit'] .= '<tr>
									<td colspan="6" class="text-center"><b>No Data</b></td>
								</tr>';
        }

        echo json_encode($tables);
    }


    public function actionSaveallocation()
    {

        $creditTotal = (float) $_POST['total_credit'];
        $debitTotal = (float) $_POST['total_debit'];
        if (($debitTotal > 0 && $creditTotal > 0) && $creditTotal == $debitTotal) {

            $model = new AccAllocation;
            $model->attributes = $_POST['AccAllocation'];
            $model->amount = $creditTotal;
            $model->allocation_date = date('Y-m-d');
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');

            $totalDebit = $totalCredit = 0;
            $debitArray = $creditArray = array();
            $k = 0;
            $l = 0;
            foreach ($_POST['Debit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $debitArray[$k] = new AccAllocationItems;
                    $debitArray[$k]->allocation_id = 0;
                    $debitArray[$k]->voucher_id = $each['voucher_id'];
                    $debitArray[$k]->voucher_item_id = $each['voucher_item_id'];
                    $debitArray[$k]->amount = $each['amount'];
                    $totalDebit += (float)$each['amount'];
                    $k++;
                }
            }
            foreach ($_POST['Credit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $creditArray[$l] = new AccAllocationItems;
                    $creditArray[$l]->allocation_id = 0;
                    $creditArray[$l]->voucher_id = $each['voucher_id'];
                    $creditArray[$l]->voucher_item_id = $each['voucher_item_id'];
                    $creditArray[$l]->amount = -1 * $each['amount'];
                    $totalCredit += (float)$each['amount'];
                    $l++;
                }
            }
            $epsilon = 0.01;
            if (abs($totalCredit - $totalDebit) < $epsilon) {
                if ($model->validate()) {
                    echo json_encode(array('status' => 'success'));
                    $model->amount = $totalCredit;
                    $model->save();
                    foreach ($debitArray as $each) {
                        $modelVoucher = new AccVoucher();
                        $modelVoucher = $modelVoucher->findByPK((int)$each->voucher_id);
                        $modAccVoucherItems = new AccVoucherItems();
                        $modAccVoucherItems = $modAccVoucherItems->findByPK($each->voucher_item_id);
                        $each->allocation_id = $model->id;
                        $each->allocation_date = $model->allocation_date;
                        $each->ledger_id = $modAccVoucherItems->ledger_id;
                        $each->subledger_id = $modAccVoucherItems->subledger_id;
                        $each->voucher_type = $modelVoucher->voucher_type;
                        $each->customer_vendor_id = $modelVoucher->customer_vendor_id;
                        $each->created_by        = $model->created_by;
                        $each->created_date_time = $model->created_date_time;

                        $each->save(false);
                        $modAccVoucherItems->allocated_amount = $modAccVoucherItems->allocated_amount + (float)$each['amount'];
                        if (!empty($modAccVoucherItems->allocate_ids)) {
                            $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $each->id;
                        } else {
                            $modAccVoucherItems->allocate_ids = $each->id;
                        }
                        $modAccVoucherItems->save(false);
                        AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                    }
                    foreach ($creditArray as $each) {
                        $modelVoucher = new AccVoucher();
                        $modelVoucher = $modelVoucher->findByPK((int)$each->voucher_id);
                        $modAccVoucherItems = new AccVoucherItems();
                        $modAccVoucherItems = $modAccVoucherItems->findByPK($each->voucher_item_id);
                        $each->allocation_id = $model->id;
                        $each->allocation_date = $model->allocation_date;
                        $each->ledger_id = $modAccVoucherItems->ledger_id;
                        $each->subledger_id = $modAccVoucherItems->subledger_id;
                        $each->voucher_type = $modelVoucher->voucher_type;
                        $each->customer_vendor_id = $modelVoucher->customer_vendor_id;
                        $each->created_by        = $model->created_by;
                        $each->created_date_time = $model->created_date_time;
                        $each->save(false);
                        $modAccVoucherItems->allocated_amount = $modAccVoucherItems->allocated_amount + (float)$each['amount'];
                        if (!empty($modAccVoucherItems->allocate_ids)) {
                            $modAccVoucherItems->allocate_ids = $modAccVoucherItems->allocate_ids . ' , ' . $each->id;
                        } else {
                            $modAccVoucherItems->allocate_ids = $each->id;
                        }
                        $modAccVoucherItems->save(false);
                        AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                    }
                    /*if(isset($_GET['type'])&& $_GET['type']=='f'){
                        Yii::app()->db->createCommand('Update `temp_subledger_status` SET flag_update = "Y" WHERE subledger_id='.$model['subledger_id'])->execute();
                    }*/
                } else {
                    echo CActiveForm::validate($model, '', false);
                }
            } else {
                echo json_encode(array('Totals are not matching!'));
            }
        } else {
            echo json_encode(array('Totals are not matching!'));
        }
    }


    public function actionSaveallocation17_01_2024()
    {

        $creditTotal = (float) $_POST['total_credit'];
        $debitTotal = (float) $_POST['total_debit'];
        if (($debitTotal > 0 && $creditTotal > 0) && $creditTotal == $debitTotal) {

            $model = new AccAllocation;
            $model->attributes = $_POST['AccAllocation'];
            $model->amount = $creditTotal;
            $model->allocation_date = date('Y-m-d');
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');

            $totalDebit = $totalCredit = 0;
            $debitArray = $creditArray = array();
            foreach ($_POST['Debit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $debitArray[$i] = new AccAllocationItems;
                    $debitArray[$i]->allocation_id = 0;
                    $debitArray[$i]->voucher_id = $each['voucher_id'];
                    $debitArray[$i]->voucher_item_id = $each['voucher_item_id'];
                    $debitArray[$i]->amount = $each['amount'];
                    $totalDebit += (float)$each['amount'];
                }
            }
            foreach ($_POST['Credit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $creditArray[$i] = new AccAllocationItems;
                    $creditArray[$i]->allocation_id = 0;
                    $creditArray[$i]->voucher_id = $each['voucher_id'];
                    $creditArray[$i]->voucher_item_id = $each['voucher_item_id'];
                    $creditArray[$i]->amount = -1 * $each['amount'];
                    $totalCredit += (float)$each['amount'];
                }
            }
            $epsilon = 0.01;
            if (abs($totalCredit - $totalDebit) < $epsilon) {
                if ($model->validate()) {
                    echo json_encode(array('status' => 'success'));
                    $model->amount = $totalCredit;
                    $model->save();
                    foreach ($debitArray as $each) {
                        $each->allocation_id = $model->id;
                        $each->allocation_date = $model->allocation_date;
                        $each->ledger_id = $model->ledger_id;
                        $each->subledger_id = $model->subledger_id;
                        //$each->voucher_type=$model->voucher_type;
                        $each->save(false);
                        $modAccVoucherItems = new AccVoucherItems();
                        $modAccVoucherItems = $modAccVoucherItems->findByPK($each->voucher_item_id);
                        $modAccVoucherItems->allocated_amount = $modAccVoucherItems->allocated_amount + (float)$each['amount'];
                        $modAccVoucherItems->save(false);
                        AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                    }
                    foreach ($creditArray as $each) {
                        $each->allocation_id = $model->id;
                        $each->allocation_date = $model->allocation_date;
                        $each->ledger_id = $model->ledger_id;
                        $each->subledger_id = $model->subledger_id;
                        $each->save(false);
                        $modAccVoucherItems = new AccVoucherItems();
                        $modAccVoucherItems = $modAccVoucherItems->findByPK($each->voucher_item_id);
                        $modAccVoucherItems->allocated_amount = $modAccVoucherItems->allocated_amount + (float)$each['amount'];
                        $modAccVoucherItems->save(false);
                        AccVoucher::model()->updateBypk($each->voucher_id, array('is_allocated' => 'Y'));
                    }
                } else {
                    echo CActiveForm::validate($model, '', false);
                }
            } else {
                echo json_encode(array('Totals are not matching!'));
            }
        } else {
            echo json_encode(array('Totals are not matching!'));
        }
    }

    public function actionPrintAllocationHistoryPdf()
    {
        $id         = Yii::app()->request->getParam('id');

        $mPDF1      = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name  = "allocation_history_list_pdf";
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.accounts.views.pdf.' . $page_name, array('id' => $id, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("Allocation_" . $id .  ".pdf", 'I');
    }


    //corrected by jisha on 23-3-23
    public function actionDeleteAllocation()
    {
        $id = $_POST['id'];
        $flag = 0;
        if ($id > 0) {
            // ------------
            $modelAccAllocation           = new AccAllocation();
            $modelAccAllocationItems      = new AccAllocationItems();
            $modelAccVoucher = new AccVoucher();
            $modelAccVoucherItem = new AccVoucherItems();
            // ------------
            $modelItem = $modelAccAllocationItems->findAll(array('condition' => 'allocation_id=' . $id));
            $voucher_id_array = array();
            $voucher_item_id_array = array();
            if (!empty($modelItem)) {
                foreach ($modelItem as $each) {
                    // ---------------
                    array_push($voucher_id_array, $each->voucher_id);
                    array_push($voucher_item_id_array, $each->voucher_item_id);

                    // ---------------
                    $condition       = 'allocation_id	 =' . $each->allocation_id;
                    $modelAccAllocationItems->deleteAll(array('condition' => $condition));
                    $modelAccAllocation->deleteByPk($each->allocation_id);
                }
                foreach ($voucher_id_array as $voucher) {
                    $list = $modelAccAllocationItems->findAll(array('condition' => 'voucher_id="' . $voucher . '" '));
                    if (count($list) == 0 || count($list) == '') {
                        $modelAccVoucher->updatebypk($voucher, array('is_allocated' => 'N')); //update allocated no
                    }
                }
                if (!empty($voucher_item_id_array)) {
                    foreach ($voucher_item_id_array as $voucheritem) {
                        $amount = Yii::app()->db->createCommand("select IFNULL(SUM(amount),0) AS amount  from {{acc_allocation_items}} where voucher_item_id='" . (int)$voucheritem . "' ")->queryScalar();
                        $modelAccVoucherItem->updatebypk((int)$voucheritem, array('allocated_amount' => $amount)); //update allocated amount
                    }
                }
                if ($flag = 1) {
                    $jsonData['status']    = 'success';
                    echo CJSON::encode($jsonData);
                }
            } else {
                $jsonData['status']        = 'error';
                $jsonData[]                = 'Failed';
                echo CJSON::encode($jsonData);
            }
        } else {
            $jsonData['status']        = 'error';
            $jsonData[]                = 'Failed';
            echo CJSON::encode($jsonData);
        }
    }

    // allocation index page
    public function actionAllocationlist()
        {
           if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_allocation_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_allocation_menu_view']
        )
    ) {
        $this->render('allocation_index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
		}

    public function actionGetallocationlist()
    {
        $modelMasCurrency = new MasCurrency();
        $model = new AccAllocation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $searchString = trim($_POST['search']['value']);
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.allocation_date',
            2 => 'ledger_det.ledger_acc_name',
            3 => 'subledger_det.subledger_name',
            4 => 't.amount',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $condition = 't.allocation_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

        if ($searchString != "") {
            $condition .= ' AND ( t.id LIKE "%' . $searchString . '%" OR ledger_det.ledger_acc_name LIKE "%' . $searchString . '%" OR subledger_det.subledger_name LIKE "%' . $searchString . '%" )';
        }

        $count = $model->with('ledger_det', 'subledger_det')->count(array('condition' => $condition));
        $model = $model->with('ledger_det', 'subledger_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {

            $div = '<div class="btn-wrap text-center">';
            // -----------------------------------------------------------------
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_allocation_delete"])) {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Delete Allocation" onclick="deleteAllocation(' . $eachItem['id'] . ')"><i class="fa fa-remove"></i></button>';
            }
            // -----------------------------------------------------------------
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_allocation_print"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=accounts/allocation/PrintAllocationHistoryPdf&id=' . $eachItem['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            }
            // -----------------------------------------------------------------
            $div .= '</div>';

            $eachItemData[] = array($eachItem['id'], date('d/m/Y', strtotime($eachItem['allocation_date'])), $eachItem['ledger_det']['ledger_acc_name'], $eachItem['subledger_det']['subledger_name'], $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['amount']), $div);
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }
}
