<?php $cs = Yii::app()->getClientScript(); ?>

<script type="text/javascript">
    $(document).ready(function() {
        var table_id = "#acc_vouchers";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.invoice_type = $("#invoice_type").val();
            data.voucher_date_from = $("#voucher_date_from").val();
            data.voucher_date_to = $("#voucher_date_to").val();
            data.voucher_type = $("#voucher_type").val();
            data.post_status = $("#post_status").val();
            data.import = $("#import").val();
            data.warehouse_id = $("#warehouse_id").val();
            data.outlet_id = $("#outlet_id").val();
            data.department_id = $("#department_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 100,
            processing: true,
            columns: [{
                    className: "sl col-max-1"
                },
                {
                    className: "sl col-max-1"
                },
                {
                    className: "sl col-max-1"
                },
                {
                    className: "sl col-max-1"
                },
                {
                    className: "sl col-max-3"
                },
                {
                    className: ""
                },
                {
                    className: "sl col-max-1"
                },
                {
                    className: "sl col-max-1"
                },

                {
                    className: "sl col-max-1 text-right"
                }
            ],
            columnDefs: [{
                    targets: [9, 6],
                    visible: false
                },
                {
                    targets: [],
                    sortable: false
                }
            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('accounts/voucher/GetList'); ?>",
                type: "POST",
                cache: false
            },
            serverSide: true,
            order: [
                [9, 'desc']
            ],
            fixedColumns: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            fnCreatedRow: function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                if (aData[9].posted == "Y") {
                    //  $("td", nRow).css("background-color", "#d2f8d2");
                }

                if (aData[9].posted == "N") {
                    $("td", nRow).css("background-color", "rgb(255 224 218 / 50%)");
                }

                $('#acc_vouchers tbody').on('mouseover', 'tr', function() {
                    $.contextMenu('destroy');
                });


                $('#acc_vouchers tbody').on('click', 'tr', function() {
                    var data = table.row(this).data();
                    var id = data[9].id;
                    var posted = data[9].posted;
                    var is_allocated = data[9].is_allocated;
                    var pv_rv_pdf = data[9].pv_rv_pdf;
                    var voucher_type_code = data[9].voucher_type_code;
                    var imported = data[9].imported;
                    var temp_det_status = data[9].temp_det_status;

                    $.contextMenu({
                        selector: '.context-menu',
                        callback: function(key, options) {
                            var action_id = key;
                            var data = table.row(this).data();
                            var file_id = data[1];
                            var id = data[9].id;
                            var voucher_no = data[9].voucher_no;
                            var voucher_no_code = data[9].voucher_no_code;
                            var voucher_type_code = data[9].voucher_type_code;



                            if (action_id == "Edit") {
                                loadPopupModal("accounts/voucher/Create&id=" + id, "Edit Voucher - " + voucher_no_code, "xl");
                            } else if (action_id == "View") {
                                loadPopupModal("accounts/voucher/Create&frm=view&id=" + id, "View Voucher - " + voucher_no_code, "xl");
                            } else if (action_id == "UnpostVoucher") {
                                updatevoucher(id, 0);
                            } else if (action_id == "PostVoucher") {
                                updatevoucher(id, 1);
                            } else if (action_id == "Delete") {
                                deleteAccount(id, voucher_no);
                            } else if (action_id == "print") {
                                window.open($('#liveSite').val() + "/index.php?r=accounts/voucher/PrintvoucherPdf&id=" + id, "_blank");
                            } else if (action_id == "Newprint") {
                                window.open($('#liveSite').val() + "/index.php?r=accounts/voucher/PrintPaymentReciptvoucherPdf&id=" + id, "_blank");
                            } else if (action_id == "chequeprint") {
                                window.open($('#liveSite').val() + "/index.php?r=cheque/default/Paymentchequeprint&id=" + id, "_blank");
                            } else if (action_id == "Allocate") {
                                loadPopupModal("accounts/allocation/CreateAllocation&id=" + id + "&type=" + voucher_type_code, "Allocation", "xl");
                            } else if (action_id == "Copy") {
                                loadPopupModal("accounts/voucher/Create&frm=copynewvoucher&id=" + id, "Copy Voucher - " + voucher_no_code, "xl");
                            } else if (action_id == "DocUpload") {
                                loadPopupModal("document/UploadERPDocument&frm=ACC&file_id=" + id, "Upload Document - " + voucher_no_code, "xl");
                            }

                        },
                        items: {
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_edit"])) { ?>

                                "Edit": {
                                    name: "Edit",
                                    icon: "fa-edit",
                                    disabled: function(key, opt) {
                                        if (is_allocated == 'Y' || posted == 'Y') {
                                            return !this.data('EditDisabled');
                                        }
                                    }
                                },
                            <?php } ?>
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_edit"])) { ?>

                                "View": {
                                    name: "View",
                                    icon: "fa-eye",
                                    disabled: function(key, opt) {
                                        //return !this.data('EditDisabled');
                                    }
                                },
                            <?php } ?>
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_unpost"])) { ?>

                                "UnpostVoucher": {
                                    name: "Unpost Voucher",
                                    icon: "fa-remove",
                                    disabled: function(key, opt) {
                                        if (is_allocated == 'Y' || posted == 'N') {
                                            return !this.data('UnpostVoucherDisabled');
                                        }
                                    }
                                },
                            <?php } ?>
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_post"])) { ?>

                                "PostVoucher": {
                                    name: "Post Voucher",
                                    icon: "fa-send",
                                    disabled: function(key, opt) {
                                        if (is_allocated == 'Y' || posted == 'Y') {
                                            return !this.data('PostVoucherDisabled');
                                        }
                                    }
                                },
                            <?php } ?>
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_delete"])) { ?>

                                "Delete": {
                                    name: "Delete Voucher",
                                    icon: "fa-trash-o",
                                    disabled: function(key, opt) {
                                        if (is_allocated == 'Y' || posted == 'Y') {
                                            return !this.data('DeleteDisabled');
                                        }
                                    }
                                },
                            <?php } ?>
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_allocation_menu_view"])) { ?>

                                "Allocate": {
                                    name: "Allocation",
                                    icon: "fa-code-fork",
                                    disabled: function(key, opt) {
                                        /*  if (voucher_type_code !== 'SI') {
                                             return !this.data('AllocationDisabled');
                                         } */
                                    }

                                },
                            <?php } ?>
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_copy_voucher"])) { ?>

                                "Copy": {
                                    name: "Copy Voucher",
                                    icon: "fa-copy",
                                    disabled: function(key, opt) {
                                        if (imported == 'Y') {
                                            return !this.data('CopyDisabled');
                                        }
                                    }
                                },
                            <?php } ?>
                            <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_voucher_uploaddoc"])) { ?>

                                "DocUpload": {
                                    name: "Upload Doucument",
                                    icon: "fa-upload",
                                    disabled: function(key, opt) {
                                        // return !this.data('DocUploadDisabled');                                    
                                    }
                                },
                            <?php } ?> "fold-print": {
                                "name": "Print",
                                "icon": "fa-print",
                                "items": {
                                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_print"])) { ?>

                                        "print": {
                                            name: "print",
                                            icon: "fa-print",
                                        },
                                    <?php } ?>
                                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_print"])) { ?>

                                        "Newprint": {
                                            name: "Voucher print",
                                            icon: "fa-print",
                                            disabled: function(key, opt) {
                                                if (pv_rv_pdf == 'N') {
                                                    return !this.data('NewprintDisabled');
                                                }
                                            }
                                        },
                                    <?php } ?>
                                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_print_cheque"])) { ?>

                                        "chequeprint": {
                                            name: "Cheque Print",
                                            icon: "fa-print",
                                            disabled: function(key, opt) {
                                                // if (voucher_type_code !== 'PV' || temp_det_status == 'N') {
                                                if (voucher_type_code !== 'PV') {
                                                    return !this.data('chequeprintDisabled');
                                                }
                                            }
                                        },
                                    <?php } ?>
                                }
                            },
                        }
                    });
                });
            }
        });
    });
</script>

<?php

$cs->registerScript("updatevoucher", "function updatevoucher(id,type) {
    var type1 = type;
    if(type1==1){
        var typex= 'Posting';
     }else{
         var typex= 'Un Posting';
     }

    jConfirm('', 'Confirm  '+typex+' ?', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    
                    'data'  : {'id' : id, 'type' : type},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/voucher/updatevoucher') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Done!');  
                            reloadTable('#acc_vouchers'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error(val); 
                            }); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD);



$cs->registerScript("deleteAccount", "function deleteAccount(id) {
        
  

    jConfirm('', 'Delete Voucher ?', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'data'  : {'id' : id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/voucher/DeleteVoucher') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data=='fail'){
                            t8.error('Error while Delete!');
                        }else{
                            t8.success('Deleted!');  
                            reloadTable('#acc_vouchers'); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD);


$cs->registerScript("deleteAccount1",  "function deleteAccount1(id){
                var r = confirm('Are you sure to delete this?');
                    if(r==true)
                    {
                        jQuery.ajax({
                          'type'  : 'post',
                       
                          'data'  : 'id=' + id,
                          'url'  : $('#liveSite').val()+'index.php?r=accounts/voucher/DeleteVoucher',
                          'cache': false,
                          'success':function(data){
                            if(data=='fail'){
                               
                                t8.error('Error while Delete!');
                            }
                            else {
                                reloadTable('#acc_vouchers');
                                t8.success('Deleted!');
                            }
                           }
                        });
                    }
            };", CClientScript::POS_HEAD);

$cs->registerScript("CheckBalnce",  "function CheckBalnce(id){
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('accounts/voucher/Gettotalcheck') . "',
                'data' : {'currency' : 'check'},
                'success': function(data) {
                    if(data == 'fail')
                    {
                      //  t8.error('Please check the GL table.</br> Amounts not matching!');
                    }
                }

            });
            };", CClientScript::POS_HEAD);

?>

<script>
    function Search() {
        reloadTable($("#acc_vouchers"));
    }
</script>

<section class="panel">


    <header class="panel-heading clearfix panel-theame">
        <!------------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_add"])) { ?>
            <a class="ad-btn" style="position: relative;top: 5px;"  onclick="loadPopupModal('accounts/voucher/Create','New Voucher','xl')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
        <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php //if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_payment_menu_view"])) { 
        ?>
        <button class="btn btn-sm btn-theme" title="Add new payment" style="margin-top: -4px;" onclick="loadPopupModal('accounts/voucher/add_payment','New Payment','xl')">
            <!-- <i class="fa fa-file"> -->

        </i>Payment</button>
        <?php //} 
        ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php //if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_receipt_menu_view"])) { 
        ?>
        <button class="btn btn-sm btn-theme" title="Add new receipt" style="margin-top: -4px;" onclick="loadPopupModal('accounts/voucher/add_receipt','New Receipt','xl')">
            <!-- <i class="fa fa-file"> -->

        </i>Receipt</button>
        <?php //} 
        ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_commission_menu_view"])) { ?>
            <!--<button class="btn btn-sm btn-theme" title="Add new Commission" onclick="loadPopupModal('accounts/voucher/add_commission','Commission','xl')"><i class="fa fa-file"></i>Commission</button>-->
        <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_import_menu_view"])) { ?>
            <button class="btn btn-sm btn-theme" title="Import Vouchers" onclick="loadPopupModal('accounts/voucher/importvouchers','Import','xl')">
                <!-- <i class="fa fa-download"></i> -->
             Import</button>
        <?php } ?>
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_import_menu_view"])) { ?>
            <button class="btn btn-sm btn-theme" title="Import Vouchers" onclick="loadPopupModal('accounts/voucher/importvouchers&from=BulkPostunpost','Import','xl')">
                <!-- <i class="fa fa-send"></i> -->
            Bulk Post & Unpost</button>
        <?php } ?>
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_import_menu_view"])) { ?>
            <button class="btn btn-sm btn-theme" title="Upload Vouchers" onclick="loadPopupModal('accounts/voucher/uploadvouchers&inventory_item_type=1','Upload Vouchers','lg')">Upload Vouchers</button>
        <?php } ?>
        
        <!-- ----------------------------------------------------------------------------------- -->

        <div class="pull-right" style="display:flex;">
            <div class="col-lg-5">
            <?php
            $startDate = date("d/m/Y");
            $endDate = date("d/m/Y");
            ?>
            <?php echo CHtml::textField('voucher_date_from', $startDate, array('class' => 'form-control datepicker', 'prompt' => 'Date From')); ?>
            </div>
            <!----------------------------------->
              <div class="col-lg-5">
            <?php echo CHtml::textField('voucher_date_to', $endDate, array('class' => 'form-control datepicker', 'prompt' => 'Date To')); ?>
            </div>
            <!------------------------------------>
             <div class="col-lg-5">
            <?php
            $modelAccVoucherType = new AccVoucherType();
            $modelAccVoucherType_array = $modelAccVoucherType->getVouchertypes();
            echo CHtml::dropdownlist('voucher_type', '', $modelAccVoucherType_array, array('class' => 'form-control', 'prompt' => '--All Type--')); ?>
            </div>
            <!------------------------------------>


            <?php

            /* $costcenter_1 = $costcenter_2 = 'N';
            $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
            if ($tableExists) {
                $acc_settings = Yii::app()->db->createCommand("SELECT costcenter_1,costcenter_2 FROM {{acc_general_settings}}")->queryRow();
                $costcenter_1 = $acc_settings['costcenter_1'];
                $costcenter_2 = $acc_settings['costcenter_2'];
            }


            if ($costcenter_1 == 'DEPARTMENT') {
                $fieldname = 'department_id';
                $prompt = '--All Department--';
                $modelMasDepartment = new MasDepartment();
                $array =  $modelMasDepartment->getDepartment();
            }

            if ($costcenter_1 == 'OUTLET') {
                $fieldname = 'outlet_id';
                $prompt = '--All Outlet--';
                $modelMasOutlet = new MasOutlet();
                $array =  $modelMasOutlet->getOutlet();
            }

            if ($costcenter_1 == 'BRANCH') {
                $fieldname = 'warehouse_id';
                $prompt = '--All Branch--';
                $modelMasInventoryWarehouse = new MasInventoryWarehouse();
                $array =  $modelMasInventoryWarehouse->getWarehouse();
            } */

            //   echo CHtml::dropdownlist($fieldname, '', $array, array('class' => 'form-control', 'prompt' => $prompt));
            ?>&#8201;

            <!------------------------------------>
            <button class="btn btn-sm btn-theme" id="add_popup" onclick="reloadTable('#acc_vouchers');">LOAD</button>&#8201;
            <!------------------------------------>

            <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=accounts/voucher/VouchersExcel&from='+$('#voucher_date_from').val()+'&to='+$('#voucher_date_to').val()+'&voucher_type='+$('#voucher_type').val()+'&warehouse_id='+$('#warehouse_id').val()+'&outlet_id='+$('#acc_outlet_id').val(), '_blank');">Export Excel</a>

        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="acc_vouchers" style="font-size:13px;">
                <thead>

                    <tr>
                        <td colspan="7"></td>
                        <td style="width: 100px">
                            <?php
                            $array_status = array('Y' => 'Yes', 'N' => 'No');
                            $voucherArray = ["onchange" => "Search()", 'style' => 'width:100px', 'empty' => '-Import-'];
                            echo CHtml::dropDownList("import", "", $array_status, $voucherArray);
                            ?>
                        </td>
                        <td colspan="3"></td>

                        <!-- <td style="width: 100px">
                            <?php
                            //    $array_status = array('Y' => 'Posted', 'N' => 'UnPosted');
                            //     $voucherArray = ["onchange" => "Search()", 'style' => 'width:150px', 'empty' => '-Status-'];
                            //     echo CHtml::dropDownList("post_status", "", $array_status, $voucherArray); 
                            ?>
                        </td> -->
                    </tr>


                    <tr>
                        <th>Voucher No</th>
                        <th>File</th>
                        <th>Txn No</th>
                        <th>Ref</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Costcenter</th>
                        <th>Imported</th>
                        <th>Amount</th>
                    </tr>
                </thead>

            </table>
        </div>
        <div class="color-indicator">
            <span style="display: inline-block;width:30px;height:30px;background:rgb(255 224 218 / 50%); box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> <b>Unposted</b></span>
        </div>
    </div>
</section>