<script>
    $(document).ready(function() {
        var table_id = "#table_post";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.from_date = $("#from_date").val();
            data.to_date = $("#to_date").val();
            data.status = $("#status").val();
            data.updateField = $("#updateField").val();
            data.dateField = $("#dateField").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            order: [
                [3, "desc"]
            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('accounts/voucher/GetImportGoodsissueList') ?>",
                type: "POST",
                cache: false,
            },
            columnDefs: [{
                "bSortable": false,
                "aTargets": [0]
            }, ],
            "rowCallback": function(row, data) {


            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
        });

        $('#table_post tbody').on('click', 'tr', function() {
            $.contextMenu('destroy');
            var data = table.row(this).data();
            $.contextMenu({
                selector: '.context-menu',
                callback: function(key, options) {
                    var action_id = key;
                    var data = table.row(this).data();
                    var id = data[1];

                    var row_index = table.row(this).index();

                    if (action_id == "selectcheckbox") {
                        selectcheckbox(row_index, id);
                    } else if (action_id == "print") {
                        printgoodsissue(id)
                    }
                },
                items: {
                    "selectcheckbox": {
                        name: "Select/Deselect",
                        icon: "fa-check",
                        disabled: function(key, opt) {
                            // this references the trigger element
                            /*  if (completed == 'C') {
                                 return !this.data('selectcheckboxenquiryDisabled');
                             } */
                        }
                    },

                    "print": {
                        name: "Print",
                        icon: "fa-print"
                    },



                }
            });


        });



    });
</script>


<?php


$cs = Yii::app()->getClientScript();

$cs->registerScript("printgoodsissue", "function printgoodsissue(id){
    window.open('index.php?r=issues/PrintPDF&id='+id);
}", CClientScript::POS_HEAD);


$cs->registerScript("selectcheckbox", "function selectcheckbox(index,id){
    
    var field_id='Invoice_'+index+'';
    var isChecked = $('#'+field_id+'').is(':checked'); 
    if (isChecked) {
        $('input[id=Invoice_'+index+']').prop('checked',false);
    }else {
        $('input[id=Invoice_'+index+']').prop('checked', true);
    }

}", CClientScript::POS_HEAD);




$modelAccVoucherType   = new AccVoucherType;
$model_vouchertype     = $modelAccVoucherType->findBypk($voucher);
$itemModel             = $model_vouchertype->header_table;
$dateField             = $model_vouchertype->date_field;
$updateField           = 'posted';
$voucherReference      = $model_vouchertype->voucher_reference;
$code                  = $model_vouchertype->code;
$status                = ($status == 'NEW') ? 'N' : 'Y';

?>
<input type="hidden" id="from_date" value="<?php echo  $from_date ?>">
<input type="hidden" id="to_date" value="<?php echo  $to_date ?>">
<input type="hidden" id="status" value="<?php echo  $status ?>">
<input type="hidden" id="updateField" value="<?php echo $updateField ?>">
<input type="hidden" id="dateField" value="<?php echo $dateField ?>">
<?php echo CHtml::hiddenField('import_from', 'goods_issue', array()); ?>

<input type="hidden" id="array_ids">
<section class="panel" >
    <header class="panel-heading clearfix panel-theame">
        <i class="material-icons">list</i> Goods Issue

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="table_post" style="font-size:13px;">
                <thead>
                    <tr>
                        <th class="text-center"><?php echo CHtml::CheckBox('checkAll', false, array('class' => 'checkall', 'id' => 'all', 'onclick' => ' $("#table_post input:checkbox").prop("checked", $(this).prop("checked"));')); ?> </th>


                        <th>Issue No</th>

                        <th>Reference</th>

                        <th>Issue Date</th>

                        <th>Customer</th>

                        <th>Grand Total</th>

                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>


</div>